	$(function(){
	 	getVendorData();	
	});
 
 function getVendorData(){
		var urls =base_url+"service/retrieve_vendor_data/get_vendor_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_dataTableVendor_token : $('#csrf_dataTableVendor_token').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.supplier_code,arr.supplier_name,arr.reg_contact_name,arr.reg_add1,arr.reg_add2,arr.reg_add3,arr.reg_pin,arr.reg_www,arr.reg_email,arr.reg_ph1,arr.reg_ph2,arr.reg_ph3,arr.st_contact_name, arr.st_add1,arr.st_add2,arr.st_add3,arr.st_pin,arr.st_www, arr.st_email, arr.st_ph1,arr.st_ph2,arr.st_ph3];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Vendor Code','Vendor Name','Reg. Contact Name','Reg. Address1','Reg. Address2','Reg Address3','Reg Pin','Website','Reg Email','Reg Phone1','Reg Phone2','Reg Phone3', 'State Officer Contact Name', 'State Address1','State Address2','State Address3','State Pincode','State website','State Email','State Phone1','State Phone2','State Phone3']};
	        }
	    });
		var dataTableVendor = $('#dataTableVendor').dataTable({
			"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-md-1 btn_add'><'col-xs-1'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Vendor',
					header:true,
					title: 'Vendor',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_dataTableVendor_token = $("#csrf_dataTableVendor_token").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "vendor name","sClass":"alignLeft"},
				{"sName": "vendor_code","sClass":"alignLeft"},
				{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info  btn-circle tooltipTable' onclick='btnVendorView(event)' title='View Details'><i class='fa fa-eye'></i></button>\
					<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btn_edit_vendor_data(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}
		});
		$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnAdd()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
 	}
 	function btnAdd(){
		window.location.href = base_url+"add-vendor-data";
	}
 	function form_reset(){
		$('#form_add_vendor').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Submit");
		$("#form_add_vendor input[name='op_type']").val("INSERT_VENDOR_DETAILS_DATA");
	}
	
	$('#form_add_vendor').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$("#btn_submit_admin_department").html("<i class='fa fa-spinner fa-spin'></i>Loading");
			var formData = new FormData(document.getElementById("form_add_vendor"));
			var urls =base_url+"service/operation_vendor";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$('#form_add_vendor').data('bootstrapValidator').resetForm(true);
		                	toastr.success(obj.msg);
		                	//window.location.href = base_url+"vendor";
		                	location.reload();
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
		fields: {
	        txtVendorCode: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
            txtVendorName: {							
	            validators:{
                    notEmpty:{message:'Enter Vendor Name'},
                    stringLength:{max:50,message: 'The Vendor Name must be less than 50 characters long'}
                }
			},
	        txtContactName: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	         txtAddressOne: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtPinCode: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
                        regexp: /^\d{6}$/,
                        message: 'The Pincode must contain 6 digits'
                    }
	            }
	        },
	        txtWww: {							
	            validators: {
	                uri: {
                        message: 'The website address is not valid'
                    }
	            }
	        },
	        txtEmail: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtPhoneOne: {							
	            validators: {
	            	notEmpty: {message: 'Required'},
					regexp: {
                    	regexp: /^\d{10}$/,
                    	message: 'Sorry,Invalid input!!!'
                	},
	        		stringLength: 
				    {
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
	        },
	        txtPhoneTwo: {							
	            validators: {
					regexp: {
                    	regexp: /^\d{10}$/,
                    	message: 'Sorry,Invalid input!!!'
                	},
	        		stringLength: {
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
	        },
	        txtStateContactName: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
            txtStateAddressOne: {
                validators:{
                  notEmpty:{message:'Enter some information'},
                  stringLength:{max:50,message: 'The information must be less than 200 characters long'}
              	}
            },
	       	txtStatePinCode: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
                        regexp: /^\d{6}$/,
                        message: 'The Pincode must contain 6 digits'
                    }
	            }
	        },
		        
		    txtStateWww: {							
		        validators: {
		            uri: {
                        message: 'The website address is not valid'
                    }
		        }
		    },
		        
	        txtStateEmail: {							
	           validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
		    txtStatePhoneOne: {							
		       validators: {
		        	notEmpty: {
	        			message: 'Required'
	        		},
					regexp: {
	                	regexp: /^\d{10}$/,
	                	message: 'Sorry,Invalid input!!!'
	            	},
		        	stringLength: {
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
		    },
			txtStatePhoneTwo: {							
		       	validators: {
					regexp: {
	                	regexp: /^\d{10}$/,
	                	message: 'Sorry,Invalid input!!!'
	            	},
	        		stringLength: 
				    {
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
		    }
		}
	});
    
   $("#checkboxState").click(function(){
	    var contact = $("#txtContactName").val();
	    var txtAddressOne = $("#txtAddressOne").val();
	    var txtAddressTwo = $("#txtAddressTwo").val();
	    var txtAddressThree = $("#txtAddressThree").val();
	    var txtPinCode = $("#txtPinCode").val();
	    var txtWww = $("#txtWww").val();
	    var txtEmail = $("#txtEmail").val();
	    var txtPhoneOne = $("#txtPhoneOne").val();
	    var txtPhoneTwo = $("#txtPhoneTwo").val();
	    var txtPhoneThree = $("#txtPhoneThree").val();
	   	if($(this).prop('checked') == true){
	   		$("#txtStateContactName").val(contact).attr('readonly', true);
		    $("#txtStateAddressOne").val(txtAddressOne).attr('readonly', true);
		    $("#txtStateAddressTwo").val(txtAddressTwo).attr('readonly', true);
		    $("#txtStateAddressThree").val(txtAddressThree).attr('readonly', true);
		    $("#txtStatePinCode").val(txtPinCode).attr('readonly', true);
		    $("#txtStateWww").val(txtWww).attr('readonly', true);
		    $("#txtStateEmail").val(txtEmail).attr('readonly', true);
		    $("#txtStatePhoneOne").val(txtPhoneOne).attr('readonly', true);
		    $("#txtStatePhoneTwo").val(txtPhoneTwo).attr('readonly', true);
		    $("#txtStatePhoneThree").val(txtPhoneThree).attr('readonly', true);
	   	}else{
			$("#txtStateContactName").attr('readonly', false);
		    $("#txtStateAddressOne").attr('readonly', false);
		    $("#txtStateAddressTwo").attr('readonly', false);
		    $("#txtStateAddressThree").attr('readonly', false);
		    $("#txtStatePinCode").attr('readonly', false);
		    $("#txtStateWww").attr('readonly', false);
		    $("#txtStateEmail").attr('readonly', false);
		    $("#txtStatePhoneOne").attr('readonly', false);
		    $("#txtStatePhoneTwo").attr('readonly', false);
		    $("#txtStatePhoneThree").attr('readonly', false);
		}
	});
    
    function btn_edit_vendor_data(event){
		var oTable = $('#dataTableVendor').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.location.href = base_url+"edit-vendor-data/"+encodeURIComponent(btoa(oTable.fnGetData(row)['supplier_code']));
    }
	function btnVendorView(event){
		var oTable = $('#dataTableVendor').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$.ajax({
			url : base_url+"service/view_vendor_details",
			method : 'POST',
			data:{op_type:'get_vendor_view_details',vendor_id:oTable.fnGetData(row)['supplier_code']},
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewVendorDetails").html("");
						$("#viewVendorDetails").append(obj.data);
	                	$("#view_vendor_details").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}