	/*
	 * Author: Debashish Jyotish
	 * Date: 24/01/2018
	 * Description : This is used for user creation (manage_user.php).
	 * 
	 **/
	var urls =base_url+"/service/get_manage_user_data/get_userdata";
		var user_table = $('#user_table').dataTable({
			"processing": false, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollX":true,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":
			{
				"url": urls,
				"type": "POST",
				"data": function (data){
		    		data.menu_role = $('#cmbMenuRole').val();
		    		data.csrf_user_token = $('#csrf_user_token').val();
		    	}
			},
			"sDom":"<'row'<'col-xs-4 btn_user_modal'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row'<'col-xs-5' i>>><'col-xs-6'p>>",
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "user_code","bVisible":false,"sClass":"alignCenter"},
				{"sName": "user_name","sClass":"alignCenter"},
				{"sName": "display_name","sClass":"alignCenter"},
				{"sName": "email","sClass":"alignLeft"},
				{"sName": "phone_number","sClass":"alignCenter"},
				{"sName": "password","bVisible":false,"sClass":"alignCenter"},
				{"sName": "prof_img","bVisible":false,"sClass":"alignCenter","mRender": function( data, type, full ) {
		       		return "<img src='"+base_url+data+"' width='30'>";
		       	}},
				{ "sName": "status","sWidth": "5%","sClass" : "alignCenter",
		            "mRender": function( data, type, full ) 
		            {
		                return '<img src="'+base_url+'public/custom/photos/'+data+'.png" />';
		            }  
		        },
				{"sName": "button",data:null,"sWidth": "15%","sDefaultContent":"<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='editUserData(event);' title='Edit' ><i class='fa fa-pencil-square-o'></i></button>\
					<button type='button' class='btn btn-primary btn-circle tooltipTable' align='center' id='btn_reset' onclick='resetpassword(event);' title='Reset Password' ><i class='fa fa-undo'></i></button>"
		       	}
			],
			//"columnDefs": [{"targets": [ 5,7 ],"orderable": false}], 
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json) {
		     	$('.tooltipTable').tooltipster({
		         	theme: 'tooltipster-punk',
		      		animation: 'grow',
		        	delay: 200, 
		         	touchDevices: false,
		         	trigger: 'hover'
	      		});          
		  	}
		});
		$("div.btn_user_modal").html('<button class="btn btn-info tooltips btn-circle" title="Add" id="add_mng_user"><i class="fa fa-plus" aria-hidden="true"></i></button>');
		
		$('#frm_user').bootstrapValidator({
			message: 'This value is not valid',
		    feedbackIcons: 
		    {
		        valid: 'glyphicon glyphicon-ok',
		        invalid: 'glyphicon glyphicon-remove',
		        validating: 'glyphicon glyphicon-refresh'
		    },
			submitButtons: 'button[type="submit"]',
			
			submitHandler: function(validator, form, submitButton) 
			{
				$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
				txtUserName = $('#txtUserName').val();
				txtpassword = 'password';
				var encSaltSHAPass = encryptShaPassCode(txtUserName,txtpassword);
				var formData = new FormData(document.getElementById("frm_user"));
					formData.append('secreatecode', encSaltSHAPass);
				urls =base_url+"service/operation_userdata";
				$.ajax({
					url : urls,
					method : 'POST',
					data:formData,
					cache: false,
			        contentType: false,
			        processData: false,
					success : function(response)
					{
						try {
			                var obj = JSON.parse(response);
			                if (obj.status == false) {
			                	$('#errorlog').html('');
			                	$('#errorlog').hide();
			                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
			                    sweetAlert("USER",obj.msg, "error");
			                }else if(obj.status === 'validationerror'){
			                	$('#errorlog').html(obj.msg);
			                	$('#errorlog').show();
			                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
			                } else {
			                	sweetAlert("USER",obj.msg, "success");
			                	$('#errorlog').html('');
			                	$('#errorlog').hide();
			            		user_table = $('#user_table').DataTable();
								user_table.draw();
								user_table.clear();
								$('#frm_user').data('bootstrapValidator').resetForm(true);//Reseting user form
								$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
								$("#spanuser").html("Add User");
								$('#hiduser_name').val('');
								$("#frm_user input[name='op_type']").val("add_user");
								$('#manage_user_modal').modal('hide'); 
			                }
			            } catch (e) {
			                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
			            }
					},error: function(err){
						toastr.error("unable to save");
					}
				});
			},
			//live: 'enabled',
		    fields:
		    {
		        txtUserName: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        },
		        txtDisplayName: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        },
		        txtEmailId: {							//form input type name
		            validators: {
		                emailAddress: {
		                    message: 'The value is not a valid email address'
		                }
		            }
		        },
		        txtPhoneNumber: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Mobile Number Required'
		                },
		                regexp: {
	                        regexp: /^[1-9][0-9]{0,9}$/,
	                        message: "Invalid Mobile Number"
	            		}
		            }
		        },
		        user_status: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        }
			}	
		});
	
	
	$("#add_mng_user").click(function(){
		$("#spanuser")[0].innerHTML ="Add User";
		$('#frm_user').data('bootstrapValidator').resetForm(true); //to reset the form
	    $('#manage_user_modal').modal('show');
	});
	
	
	function editUserData(event){//on edit click assign the value to text field
		$('#manage_user_modal').modal('show');
		$("#btn_submit")[0].innerHTML ="<i class='fa fa-edit'></i> Update";
		$("#spanuser")[0].innerHTML ="Edit User";
	    $("#frm_user input[name='op_type']").val("edit_user");
	    var oTable = $('#user_table').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
	    var user_code = oTable.fnGetData(row)['user_code'];
	    var user_name = oTable.fnGetData(row)['user_name'];           
	    var user_display_name = oTable.fnGetData(row)['user_display_name'];
	    var email = oTable.fnGetData(row)['email'];
	    var phone_number = oTable.fnGetData(row)['phone_number'];
	    var prof_img = oTable.fnGetData(row)['prof_img'];
	    var status = oTable.fnGetData(row)['record_status'];
	    $('#hiduser_code').val(user_code);
	    $('#txtUserName').val(user_name);
	    $('#hiduser_name').val(user_name);
	    $('#txtDisplayName').val(user_display_name);
	    $('#txtEmailId').val(email);
	    $('#txtPhoneNumber').val(phone_number);
	    $('#fileimage').val(prof_img);  
	    $('#user_status').val(status); 
	}
	

	function resetpassword(event){
		$("#frm_user input[name='op_type']").val("sa_reset_password");
		var oTable = $('#user_table').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var formData = new FormData(document.getElementById("frm_user"));
		txtpassword = 'password';
		var encSaltSHAPass = encryptShaPassCode(oTable.fnGetData(row)['user_name'],txtpassword);
		formData.append('secreatecode', encSaltSHAPass);
		formData.append('hiduser_code', oTable.fnGetData(row)['user_code']);
		formData.append('email',  oTable.fnGetData(row)['email']);
		formData.append('user_name',  oTable.fnGetData(row)['user_name']);
		formData.append('user_display_name',  oTable.fnGetData(row)['user_display_name']);
		$('#btn_reset').html('<i class="fa fa-gear fa-spin"></i>');
	    $.ajax({
			url : base_url + "service/sa_reset_password",
			method : 'POST',
			data:formData,
			cache: false,
	        contentType: false,
	        processData: false,
	        success: function (response) {
	            try {
	                var obj = JSON.parse(response);
	                if (!obj.status) {
	                	$('#btn_reset').html('<i class="fa fa-undo"></i>');
	                    sweetAlert("USER",obj.msg, "error");
	                } else {
	                	$('#btn_reset').html('<i class="fa fa-undo"></i>');
	                	sweetAlert("USER",obj.msg, "success");
	                }
	            } catch (e) {
	                sweetAlert("Sorry","We are unable to Process !", "error");
	            }
	        }, error: function (err) {
	            toastr.error(err);
	        }
		});
	}

	//for form reset button click to reset the form
	function form_reset(){
		$('#hiduser_name').val('');
		$('#frm_user').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
		$("#spanuser").html("Add User");
		$("#frm_user input[name='op_type']").val("add_user");
	}