	$("#btn_filter_reset").click(function(){
		$("#cmb_project_category").val('');
		dataTableCategoryScheme = $('#dataTableCategoryScheme').DataTable();
		dataTableCategoryScheme.draw();
		dataTableCategoryScheme.clear();
	});
	$('#btn_search').click(function() {
	   	var dataTableCategoryScheme = $('#dataTableCategoryScheme').DataTable();
		dataTableCategoryScheme.draw();
		dataTableCategoryScheme.clear();
	});
	var urls =base_url+"service/get_category_scheme_list/get_category_scheme_list";
	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
        if ( this.context.length ) {
        	var dataArr = [];
            var jsonResult = $.ajax({
                url: urls,
                type:'POST',
                data:{page:"ALL",csrf_category_scheme_token : $('#csrf_category_scheme_token').val(),category_code: $("#cmb_project_category").val()},
                success: function (result) {
                    res = jQuery.parseJSON(result);
                    $.each(res.aaData,function(i,arr){
                    		var objArr = [i+1,arr.category_name,arr.scheme_code,arr.scheme_name,arr.value,arr.dept_name];
                    	dataArr.push(objArr);
                    });
                },
                async: false
            });
            return {body: dataArr, header: ['#','Project Category','Project Code','Project Name','Type','Administer Department']};
        }
    });
	var scheme = $('#dataTableCategoryScheme').DataTable({
	 	"processing": true, //Feature control the processing indicator.
	    "serverSide": true, //Feature control DataTables' server-side processing mode.
	    "bDestroy": true,
	    "paging":   true,
	    "info":     true,
	    "autoWidth": false,
	    "responsive":true,
	   	"searching":true,
	   	"bLengthChange": true,
	   	"sDom":"<'row'<'col-md-1 btn_add'><'col-xs-1'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		"buttons": [
			{
				text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
				extend: 'excel',
				filename:'Project',
				header:true,
				title: 'Project',
				extension: '.xls'
			}
		],
		"ajax": {
		    "url": urls,
		    "type": "POST",
		    "data": function(data) {
		       	data.csrf_category_scheme_token = $("#csrf_category_scheme_token").val();
		       	data.category_code = $("#cmb_project_category").val();
		       	data.page ='';
		    }
		},
		"columns": [
			{"sName": "sl_no","sClass":"alignCenter"},
			{"sName": "category_name","sWidth": "10%","sClass":"alignLeft"},
			{"sName": "scheme_code","sClass":"alignLeft"},
			{"sName": "scheme_name","sClass":"alignLeft"},
			{"sName": "type","sClass":"alignLeft"},
			{"sName": "admin_department","sClass":"alignLeft"},
			{"sName": "button",data:null,"sWidth": "10%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-success  btn-circle tooltipTable' onclick='btnSchemeView(event)' title='View Details'><i class='fa fa-eye'></i></button>\
				<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnSchemeEdit(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
			
		], 
		"fnDrawCallback": function(oSettings, json) {
		 	$('.tooltipTable').tooltipster({
		     	theme: 'tooltipster-punk',
		  		animation: 'grow',
		    	delay: 200, 
		     	touchDevices: false,
		     	trigger: 'hover'
			});          
		}	       
	});
	 $("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnAddScheme()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
 	
 	function btnAddScheme(){
 		window.location.href = base_url+"add-scheme";
 	}
	 function btnSchemeView(event){
	 	var oTable = $('#dataTableCategoryScheme').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var pk_scheme_code = oTable.fnGetData(row)['pk_scheme_code'];
		view_scheme_details(pk_scheme_code);
	 }
	 
	 
	 function view_scheme_details(pk_scheme_code){
	 	var urls =base_url+"service/view_scheme_details/"+pk_scheme_code;
		$.ajax({
			url : urls,
			method : 'POST',
			cache: false,
	        contentType: false,
	        processData: false,
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewScheme").html("");
	                	$("#viewScheme").append(obj.data);
	                	$("#table_installation").html("");
	                	$("#table_installation").append(obj.data1);
	                	$("#table_scheme_upload").html("");
						$("#table_scheme_upload").append(obj.data2);
	                	$("#view_scheme_modal").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	 }
	 function btnSchemeEdit(event){
	 	var oTable = $('#dataTableCategoryScheme').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var pk_scheme_code = oTable.fnGetData(row)['pk_scheme_code'];
		window.location.href = base_url+"edit-scheme-data/"+encodeURIComponent(btoa(pk_scheme_code));
	 }