	$(function(){
		var urls =base_url+"service/get_closed_ticket/get_all_closed_ticket";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_closed_ticket : $('#csrf_closed_ticket').val(),scheme_id : $("#cmb_scheme").val(),vendor_id : $("#cmb_vendor").val(),ticket_type : $("#cmb_ticket_type").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.customer_name,arr.ticket_id,arr.description,arr.scheme_name,arr.supplier_name,arr.technician_id,arr.district_name,arr.block_name,arr.address,arr.mc];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Customer Name','Ticket No','Month','Scheme Name','Supplier Name','Technician','District Name','Block Name','Address','MC']};
	        }
	    });
	 	var generated_ticket = $('#dataTableRejectedClosed').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 300,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Reject/Closed Ticket',
					header:true,
					title: 'Reject/Closed Ticket',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_closed_ticket = $("#csrf_closed_ticket").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.vendor_id = $("#cmb_vendor").val();
			       	data.ticket_type = $("#cmb_ticket_type").val();
			       	data.ticket_status = $("#cmb_ticket_status").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "customer_name","sClass":"alignLeft"},
				{"sName": "ticket_id","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "month","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "scheme_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "supplier_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "technician_id","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "district_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "block_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "address","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "mc","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "status","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "button",data:null,"sClass" : "alignCenter","mRender": function( data,type,full){
					str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnViewScheduleRequest(event)'><i class='fa fa-eye'></i></button>";
					return str;
					}
				}
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
		get_ticket_type();
	});
	
	function btnViewScheduleRequest(event){
		var oTable = $('#dataTableRejectedClosed').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		window.open(base_url+"view-schedule-request/"+encodeURIComponent(btoa(ticket_id)), '_blank');
	}
	/*$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		
	});*/
	
	function get_ticket_type(){
        $.ajax({
			url: base_url+"service/get_all_ticket",
			type:"POST",
			data:{op_type:'get_gencode_desc',gen_code_group:'TICKET_TYPE'},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].gen_code+"' >"+res1[i].description+"</option>";
				}
				$('#cmb_ticket_type').html("");  
				$('#cmb_ticket_type').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});		
	}
	
	$('#btn_search_closed_ticket').click(function(){
		dataTableTransaction = $('#dataTableRejectedClosed').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	
	
	$("#btn_reset").click(function(){
		$("#cmb_scheme").val('');
		$("#cmb_vendor").val('');
		$("#cmb_ticket_type").val('');
		dataTableTransaction = $('#dataTableRejectedClosed').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});