	$( document ).ready(function() {
    	var urls =base_url+"service/get_vendor_tech_map_data/vendor_tech_mapped_data";
		var dtblVillage = $('#dataTablevendorTechMap').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollY": 400,
		   	"scrollX": true,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_vendorMap_token = $('#csrf_vendorMap').val();
			    }
			},
			"sDom":"<'row'<'col-xs-2 btn_vendor_tech_modal'><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "supplier_code","sClass":"alignCenter","bVisible": false},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "tech_cnt","sClass":"alignCenter"},
				{"sName": "cnt","sClass":"alignCenter"},
				{
					"sName": "button",data:null,"sWidth": "15%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='viewVendorTechDetails(event);' title='View' ><i class='fa fa-external-link'></i></button>"
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		  	
		});
		$("div.btn_vendor_tech_modal").html('<button class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnVendorTechMap()";><i class="fa fa-plus" aria-hidden="true"></i></button>');
		$('a[data-toggle="tab"]').on('shown.bs.tab', function(e){
	    	$($.fn.dataTable.tables(true)).DataTable().columns.adjust();
		});
	});
	
	function btnVendorTechMap(){
		$('#cmb_transaction_tech').val('').trigger("change");
		$('#form_vendor_tech_map').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_vendorTechMap_modal").modal({backdrop: 'static', keyboard: false});
	}
	
	
	$('#cmb_schemes_tech').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor_tech').html("");  
				$('#cmb_vendor_tech').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		getTechnicianList();
	});
	$('#cmb_vendor_tech').change(function(){
		getTechnicianList();
		get_transaction_data();
		});
	
	function getTechnicianList(){
		$.ajax({
			url: base_url + "service/get_technician_data",
	        method: 'POST',
	        data: {op_type:'get_technician_data',vendor_id:$('#cmb_vendor_tech').val()},
	        success: function (response) {
	        	var res1 = JSON.parse(response); 
	        	try {
		          	if (res1) {
		          		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].phone_no+"' >"+res1[i].name+"("+res1[i].phone_no+")</option>";
						}
						$('#cmb_technician_tech').html("");  
						$('#cmb_technician_tech').append(options);
		            }else{
	                	toastr.error('Sorry Faild Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	           
	        }, error: function (err) {
	        	toastr.error("Sorry",err, "error");
	        }
		});
	}	
		
	function get_transaction_data(){
		$.ajax({
			url: base_url + "service/get_vendor_transaction_details",
	        method: 'POST',
	        data: {op_type:'fetch_transaction_data',selectedVendor:$('#cmb_vendor_tech').val(),selectedScheme:$('#cmb_schemes_tech').val()},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].id+"' >"+res1[i].name1+" "+res1[i].name2+" "+res1[i].name3+" ,"+res1[i].customer_address+" </option>";
						}
						$('#cmb_transaction_tech').html("");  
						$('#cmb_transaction_tech').select2("");  
						$('#cmb_transaction_tech').append(options);
	                }else{
	                	toastr.error('Sorry Faild Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	toastr.error("Sorry",err, "error");
	        }
		});
	}
	
	
	
		
	// on click of add/update button it will validate then submit 	
	$('#form_vendor_tech_map').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        valid: 'glyphicon',
	        invalid: 'glyphicon',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_vendor_tech_map"));
			urls =base_url+"service/operation_vendor_tech_map";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                    toastr.error("Failed to Insert");
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                } else {
		                	toastr.success("Data mapped successfully");
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		            		dtblVendorTaskDetails = $('#dataTablevendorTechMap').DataTable();
							dtblVendorTaskDetails.draw();
							dtblVendorTaskDetails.clear();
							$('#add_vendorTechMap_modal').modal('hide');
							$('#form_vendor_tech_map').data('bootstrapValidator').resetForm(true);//Reseting user form
							$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
							$("#form_vendor_tech_map input[name='op_type']").val("ADD_VENDOR_TECH_MAP");
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !');
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
		//live: 'enabled',
	    fields:{
	        cmb_schemes_tech: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor_tech: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_technician_tech: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
		}	
	});
	/*
		The below function is used for showing technician details against vendor.
		Created By : Ashutosh Mishra
		Created On : 11-05-2019
	
	*/
	function viewVendorTechDetails(event){
	    var oTable = $('#dataTablevendorTechMap').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
	    var supplier_code = oTable.fnGetData(row)['supplier_code'];
	   	window.location.href = 'vendor-against-technician-details/'+encodeURIComponent(btoa(supplier_code));
	}
	//Ends here 
	//for form reset button click to reset the form
	function form_reset(){
		$('#form_village').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
		$("#spanVillage").html("Add Village");
		$("#form_village input[name='op_type']").val("add_village_master");
	}
	/*Upload Country Data*/