	$(function () {
		var urls =base_url+"service/get_all_transaction_details/get_all_transaction_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_trans_token : $('#csrf_trans_token').val(),cmb_scheme:$("#cmb_scheme").val(),cmb_vendor:$('#cmb_vendor').val(),cmb_installType:$("#cmb_installType").val(),cmb_district:$("#cmb_district").val(),cmb_village:$("#cmb_village").val(),view_install:'VI'},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.scheme_name,arr.sanction_order_no,arr.finance_source,arr.supplier_name,arr.instal_cls_name,arr.work_order,arr.date_of_installation,arr.power_plant,arr.India,arr.state_name,arr.district_name,arr.block_name,arr.gp_name,arr.village_name,arr.plot_no,arr.habitation,arr.landmark,arr.pincode,arr.census_code,arr.tr_gps_code,arr.dc_val,arr.mc_val,arr.scheduled_week,arr.consumer_id,arr.customer_name,arr.father_name,arr.cast_cat,arr.phone1,arr.mobile1,arr.mobile2,arr.cu_email,arr.gender,arr.aadhar_no,arr.aadhar_no,arr.acs,arr.parent_customer_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Scheme','Sanction Letter No','Finance Source','Vendor Name','Installation Class','Work Order/Purchase Order','Date of Installation','Power Plant','Country','State','District','CD Block','Gram Panchayat','Revenue Village','Plot No','Area','Landmark','Pincode','Census Code','GPS Code','District Cluster','Maintenance Cluster','Scheduled Week','Customer Id','Customer Name','Name of Father/Spouse','Caste/Category','Landline','Mobile1','Mobile2','Email','Gender','Aadhar Card No','Alternate Id No','ACS','Parent Customer']};
	        }
	    });
		var dataTableTransaction = $('#dataTableTransaction').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollY": 400,
		   	"scrollX": true,
			"responsive":false,
			"searching":true,
			"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Transaction List',
					header:true,
					title: 'Transaction List',
					extension: '.xlsx'
				}
			],
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_trans_token 	= $('#csrf_trans_token').val();
			    	data.cmb_scheme 		= $('#cmb_scheme').val();
			    	data.cmb_vendor 		= $('#cmb_vendor').val();
			    	data.cmb_installType 	= $('#cmb_installType').val();
			    	data.cmb_district 		= $('#cmb_district').val();
			    	data.cmb_village 		= $('#cmb_village').val();
			    	data.view_install 		= 'VI';
			    	data.page 		        = '';
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter","sWidth": "5%"},
				{"sName": "customer_name","sClass":"alignLeft","sWidth": "25%"},
				{"sName": "consumer_id","sClass":"alignLeft","sWidth": "10%"},
				{"sName": "customer_address","sClass":"alignLeft","sWidth": "35%"},
				{"sName": "transaction_status_flag","sClass":"alignCenter","sWidth": "8%"},
				{"sName": "button","sClass" : "alignCenter","mRender": function( data,type,full){
						str = "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>&nbsp;";
						if(full.transaction_status_flag == 'Oreda Approved'){
							str += "<button type='button' class='btn btn-success btn-circle tooltipTable tooltipstered' align='center' onclick='btnEditTransactionData(event);' title='Edit Transaction' ><i class='fa fa-pencil-square-o'></i></button>&nbsp;";
						}
						return str;
		       		}
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	});
	/*$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});*/
	
	$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installType').html("");  
				$('#cmb_installType').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#cmb_district').change(function(){
	 	var district_code = $(this).val();
	 	$.ajax({
			url: base_url+"service/get_filter_village_data",
			type:"POST",
			data:{op_type:'get_filter_village_data',district_code:district_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_village_code+"' >"+res[i].village_name+"</option>";
				}
				$('#cmb_village').html("");  
				$('#cmb_village').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#btn_search').click(function(){
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	function btnTransactionReport(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"transaction-report/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id']+'#'+oTable.fnGetData(row)['tr_customer_id'])));
	}
	
	$("#btn_reset").click(function(){
		$("#cmb_vendor").val('');
		$("#cmb_scheme").val('');
		$("#cmb_installType").val('');
		$("#cmb_district").val('');
		$("#cmb_village").val('');
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	
	function btnEditTransactionData(event){
	 	var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"edit-view-installations/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id'])));
	}