	$(function () {
		var urls =base_url+"service/get_all_transaction_details/all_transaction_details";
		var dataTableTransaction = $('#dataTableTransaction').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollY": 400,
		   	"scrollX": true,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_trans_token = $('#csrf_trans_token').val();
			    	data.cmb_scheme = $('#cmb_scheme').val();
			    	data.cmb_vendor = $('#cmb_vendor').val();
			    	data.cmb_installType = $('#cmb_installType').val();
			    	data.cmb_district = $('#cmb_district').val();
			    	data.cmb_village = $('#cmb_village').val();
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter","sWidth": "5%"},
				{"sName": "customer_name","sClass":"alignCenter","sWidth": "15%"},
				{"sName": "consumer_id","sClass":"alignCenter","sWidth": "8%"},
				{"sName": "customer_address","sClass":"alignCenter","sWidth": "25%"},
				{"sName": "transaction_status_flag","sClass":"alignCenter","sWidth": "8%"},
				{
					"sName": "button",data:null,"sWidth": "18%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>"
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	});
	
	$('#cmb_scheme').change(function(){
	 	var scheme_id = $(this).val();
	 	vendor_data(scheme_id);
	 	install_data(scheme_id);
	});
	function vendor_data(scheme_id){
		$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	function install_data(scheme_id){
		$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installType').html("");  
				$('#cmb_installType').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	$('#cmb_district').change(function(){
	 	var district_code = $(this).val();
	 	$.ajax({
			url: base_url+"service/get_filter_village_data",
			type:"POST",
			data:{op_type:'get_filter_village_data',district_code:district_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_village_code+"' >"+res[i].village_name+"</option>";
				}
				$('#cmb_village').html("");  
				$('#cmb_village').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#btn_search').click(function(){
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	function btnTransView(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var trans_id = oTable.fnGetData(row)['id'];
		window.open(base_url+"view-transaction-details/"+encodeURIComponent(btoa(trans_id)));
	}
	function btnApprovalProcess(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var trans_id = oTable.fnGetData(row)['id'];
		$('#hidtrans_id').val(trans_id);
		$('#approval_info_modal').modal('show');
	}