	$(function () {
		//iCheck for checkbox and radio inputs
	    $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
	      checkboxClass: 'icheckbox_minimal-blue',
	      radioClass: 'iradio_minimal-blue'
	    });
	    var transaction_id = $("#hidden_tranaction_id").val();
	    if(transaction_id != ""){
			$.ajax({
				url: base_url+"service/get_trans_header_data",
				type:"POST",
				data:{opType:'get_header_data',trans_id:transaction_id},
				success:function(response){
					var dta = JSON.parse(response);
					$("#cmb_scheme").val(dta.tr_scheme_id);
					$("#hidcust_id").val(dta.cid);
					sanction_data(dta.tr_scheme_id,dta.sanction_no);
					$("#cmb_finance_source").val(dta.finance_source);
					vendor_data(dta.tr_scheme_id,dta.tr_supplier_id);
	 				installationDetails(dta.tr_scheme_id,dta.tr_instal_id)
					$("#txt_dateInstallation").val(dta.date_of_installation);
					if(dta.power_plant == 1){
						$("#cmb_parentcustomer").prop("disabled", true);
						$('#checkbox_powerplant').iCheck('check');
					}else{
						$("#cmb_parentcustomer").prop("disabled", false);
						$('#checkbox_powerplant').iCheck('uncheck');
					}
					get_dist_dropdown(dta.tr_scheme_id,dta.tr_supplier_id,dta.district);
					get_block_dropdown(dta.tr_scheme_id,dta.tr_supplier_id,dta.district,dta.cd_block);
					get_gp_dropdown(dta.tr_scheme_id,dta.tr_supplier_id,dta.cd_block,dta.gp);
					get_village_dropdown(dta.tr_scheme_id,dta.tr_supplier_id,dta.gp,dta.revenue_village);
					$("#txtWorkOrder").val(dta.work_order);
					$("#txt_plotno").val(dta.plot_no);
					$("#txt_area").val(dta.habitation);
					$("#txt_landmark").val(dta.landmark);
					$("#txt_pincode").val(dta.pincode);
					$("#txt_censuscode").val(dta.census_code);
					$("#txt_gpscode").val(dta.tr_gps_code);
					$("#cmb_districtcluster").val(dta.installation_cluster);
					$("#cmb_maintenanceCluster").val(dta.schedule_month);
					$("#cmb_scheduled_week").val(dta.scheduled_week);
					$("#txt_firstName").val(dta.name1);
					$("#txt_MiddleName").val(dta.name2);
					$("#txt_LastName").val(dta.name3);
					$("#cmb_casteCategory").val(dta.caste);
					$("#txt_Landline").val(dta.phone1);
					$("#txt_MobileOne").val(dta.mobile1);
					$("#txt_MobileTwo").val(dta.mobile2);
					$("#txt_email").val(dta.cu_email);
					$("#cmb_gender").val(dta.gender);
					$("#txt_Aadhar").val(dta.aadhar_no);
					$("#txt_Alternate").val(dta.alternate_id);
					$("#cmb_acs").val(dta.acs);
					$("#hidcustomerphoto").val(dta.photo1);
					$("#hididproof").val(dta.id_proof);
					$("#txtTotalCapacity").val(dta.capacity);
					$("#txtUnit").val(dta.unit);
					$("#hidinstallationphoto").val(dta.installation_photo);
					componentsDetails($("#hidden_tranaction_id").val(),dta.tr_instal_id);
					parentCustomer(dta.tr_scheme_id,dta.tr_supplier_id,dta.district,dta.parent_customer_id);
					
				},error:function(){
					toastr.error('Unable to process please contact support');
				}
			});
		}else{
			toastr.error('Transaction Id is Blank');
		}
	    
	});
	
	$('#cmb_scheme').change(function(){
	 	var scheme_id = $(this).val();
	 	sanction_data(scheme_id,'');
	 	vendor_data(scheme_id,'');
	 	installationDetails(scheme_id,'')
	 	parentCustomer(scheme_id,'','','');
	});
	function sanction_data(scheme_id,sanction_no){
		$.ajax({
			url: base_url+"service/get_sanction_data",
			type:"POST",
			data:{op_type:'get_sanction_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					if(sanction_no == res[i].id){
						selected_val ='selected';
						
					}else{
						selected_val='';
					}
					options = options + "<option value='"+res[i].id+"' "+selected_val+" >"+res[i].sanction_order_no+"</option>";
				}
				$('#cmb_sanctionletter').html("");  
				$('#cmb_sanctionletter').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	function vendor_data(scheme_id,sup_id){
		$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					if(sup_id == res[i].supplier_code){
						select_val ='selected';
						
					}else{
						select_val='';
					}
					options = options + "<option value='"+res[i].supplier_code+"' "+select_val+">"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendorname').html("");  
				$('#cmb_vendorname').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	function installationDetails(scheme_id,instal_id){
		$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					if(instal_id == res[i].id){
						selectVal ='selected';
					}else{
						selectVal='';
					}
					options = options + "<option value='"+res[i].id+"' "+selectVal+">"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installationClass').html("");  
				$('#cmb_installationClass').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	//componentsDetails(14,25059);
	function componentsDetails(trans_id,ins_id){
    	$.ajax({
			url: base_url+"service/get_components_data",
			type:"POST",
			data:{op_type:'get_attribute_details',installation_id:ins_id,trans_id:trans_id,div:''},
			success:function(response){
				try{
		            var obj = JSON.parse(response);
		            if(obj.status = true){
		            	$('#divComponentsDetails').html("");
						$('#divComponentsDetails').append(obj.data);
					}
				}catch (e){
					toastr.error('Unable to Process.Please Try Again !');
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	
	$("#cmb_vendorname").change(function(){
		var scheme_id = $('#cmb_scheme').val();
		var vendor_id = $(this).val();
    	get_dist_dropdown(scheme_id,vendor_id,'');
    	parentCustomer(scheme_id,vendor_id,'','');
	});
	function get_dist_dropdown(si,vi,dist_code){
		$.ajax({
			url: base_url+"service/get_dist_vendorwise",
			type:"POST",
			data:{op_type:'get_dist_vendorwise',scheme_id : si,vendor_id:vi},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					if(dist_code == res1[i].district_code){
						selectValue ='selected';
					}else{
						selectValue='';
					}
					options = options + "<option value='"+res1[i].district_code+"' "+selectValue+">"+res1[i].district_name+"</option>";
				}
				$('#cmb_district').html("");
				$('#cmb_district').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$("#cmb_district").change(function(){
		var scheme_id = $('#cmb_scheme').val();
		var vendor_id = $('#cmb_vendorname').val();
		var dist_code = $(this).val();
    	get_block_dropdown(scheme_id,vendor_id,dist_code,'');
    	parentCustomer(scheme_id,vendor_id,dist_code,'');
	});
	function get_block_dropdown(scheme_id,vendor_id,dist_code,selVal){
		$.ajax({
			url: base_url+"service/get_block_dropdown",
			type:"POST",
			data:{op_type:'get_block_vendorwise',vendor_id : vendor_id,scheme_id:scheme_id,dist_code:dist_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					if(selVal==res1[i].block_code){
						selected='selected';
					}else{
						selected='';
					}
					options = options + "<option value='"+res1[i].block_code+"' "+selected+">"+res1[i].block_name+"</option>";
				}
				$('#cmb_cdblock').html("");
				$('#cmb_cdblock').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$("#cmb_cdblock").change(function(){
		var b_scheme_id = $('#cmb_scheme').val();
		var b_vendor_id = $('#cmb_vendorname').val();
		var block_code  = $(this).val();
    	get_gp_dropdown(b_scheme_id,b_vendor_id,block_code,'');
	});
	function get_gp_dropdown(b_scheme_id,b_vendor_id,block_code,selBval){
		$.ajax({
			url: base_url+"service/get_gp_dropdown",
			type:"POST",
			data:{op_type:'get_gp_vendorwise',vendor_id : b_vendor_id,scheme_id:b_scheme_id,block_code:block_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					if(selBval==res1[i].pk_gp_code){
						selected='selected';
					}else{
						selected='';
					}
					options = options + "<option value='"+res1[i].pk_gp_code+"' "+selected+">"+res1[i].gp_name+"</option>";
				}
				$('#cmb_grampanchayat').html("");
				$('#cmb_grampanchayat').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$("#cmb_grampanchayat").change(function(){
		var g_scheme_id = $('#cmb_scheme').val();
		var g_vendor_id = $('#cmb_vendorname').val();
		var gp_code  = $(this).val();
    	get_village_dropdown(g_scheme_id,g_vendor_id,gp_code,'');
	});
	function get_village_dropdown(g_scheme_id,g_vendor_id,gp_code,selGval){
		$.ajax({
			url: base_url+"service/get_village_dropdown",
			type:"POST",
			data:{op_type:'get_village_vendorwise',vendor_id : g_vendor_id,scheme_id:g_scheme_id,gp_code:gp_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					if(selGval==res1[i].pk_village_code){
						selected='selected';
					}else{
						selected='';
					}
					options = options + "<option value='"+res1[i].pk_village_code+"' "+selected+">"+res1[i].village_name+"</option>";
				}
				$('#cmb_revenuevillage').html("");
				$('#cmb_revenuevillage').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$("#cmb_revenuevillage").change(function(){
		$('#txtWorkOrder').val('');
    	$('#txt_censuscode').val($('#cmb_revenuevillage').val());
    	$.ajax({
			url: base_url+"service/get_work_order_data",
			type:"POST",
			data:{op_type:'get_work_order',scheme_id : $('#cmb_scheme').val(),vendor_id:$('#cmb_vendorname').val(),village_code:$(this).val()},
			success:function(response){
				var resd = JSON.parse(response); 
				$('#txtWorkOrder').val(resd.work_order);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	
	$('#form_update_transaction').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_update_transaction"));
			formData.append('tranaction_id', $("#hidden_tranaction_id").val());
			urls =base_url+"service/operation_transaction";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                    sweetAlert("Transaction",obj.msg, "error");
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
							componentsDetails(obj.trans_id,$("#cmb_installationClass").val());
		                	$("#hidden_tranaction_id").val(obj.trans_id);
							$("#btnUpdateTransaction").html("<i class='fa fa-paper-plane'></i> Update");
							$("#form_update_transaction input[name='op_type']").val("UPDATE_TRANSACTION");
							$('#myTab a[href="#tabComponents"]').tab('show');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert(e);
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:{
	        cmb_scheme: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendorname: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_installationClass: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        
	        cmb_district: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_cdblock: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_grampanchayat: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_scheduled_week: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_firstName: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_LastName: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_MobileOne: {
	            validators: {
	                regexp: {
                        regexp: /^[1-9][0-9]{0,9}$/,
                        message: "Invalid Mobile Number"
            		}
	            }
	        },
	        file_customerphoto: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        file_idproof: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        file_installationphoto: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        }	
		}	
	});
	
	/*Add Attributes*/
	$(document).on('click', '#btnAddAttribute', function (event) {
		var trans_details_id = $('#hid_trans_details_id_'+$(this).val()).val();
		$.ajax({
			url: base_url+"service/get_attribute_details",
			type:"POST",
			data:{op_type:'get_attribute_details',component_id:$(this).val(),trans_details_id:trans_details_id},
			success:function(response){
				var result = JSON.parse(response);
				try {
					if(result.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$('#title_header').html("Add Attributes");
						$("#form_attribute_details input[name='oper_type']").val("ADD_ATTRIBUTE_DETAILS");
						$('#btn_submit').html("<i class='fa fa-paper-plane'></i> Submit");
						$('#attribute_data').html("");  
						$('#attribute_data').append(result.data);
						$("#attributeModalDetails").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.error(result.msg);
					}
				} catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	//componentsDetails(25050,14);
	/*Add Attributes*/
	$(document).on('click', '#btn_submit', function (event) {
		var formData = new FormData(document.getElementById("form_attribute_details"));
		$.ajax({
			url: base_url+"service/op_attribute_details",
			type:"POST",
			data:formData,
			cache: false,
	        contentType: false,
	        processData: false,
			success:function(response){
				var result = JSON.parse(response);
				try {
					if(result.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$('#attribute_data').html("");
						$('#attribute_data').append(result.data);
						$("#attributeModalDetails").modal('hide');
						toastr.success(result.msg);
					}else{
						toastr.error("No Attributes Available");
					}
				}catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	
	function editAttributeData(trans_details_id,sl_no){
		$.ajax({
			url: base_url+"service/get_edit_attribute_details",
			type:"POST",
			data:{op_type:'get_all_attribute_details',sl_no:sl_no,trans_details_id:trans_details_id},
			success:function(response){
				var Obj = JSON.parse(response);
				try {
					if(Obj.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$("#form_attribute_details input[name='oper_type']").val("EDIT_ATTRIBUTE_DETAILS");
						$('#btn_submit').html("<i class='fa fa-paper-plane'></i> Update");  
						$('#title_header').html("Edit Attributes"); 
						$('#attribute_data').html(""); 
						$('#attribute_data').append(Obj.data);
						$("#attributeModalDetails").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.error(Obj.msg);
					}
				} catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	$(document).on('click', '#btnFinalSubmit', function (event) {
		window.location.href = base_url+"manage-installations";
	});
	$('#checkbox_powerplant').on('ifClicked', function(event){
		if(this.checked){
			$("#cmb_parentcustomer").prop("disabled", false);
    	}else{
    		$("#cmb_parentcustomer").val('');
			$("#cmb_parentcustomer").prop("disabled", true);
    	}
	});
	
	function parentCustomer(project_id,vendor_id,dist_id,prid){
		if(project_id !='' && vendor_id != '' && dist_id !=''){
			$.ajax({
				url: base_url+"service/get_parent_customer_dropdown",
				type:"POST",
				data:{op_type:'get_parent_customer',vendor_id : vendor_id,scheme_id:project_id,dist_id:dist_id},
				success:function(response){
					var options = "<option value=''>Select</option>";
					var res1 = JSON.parse(response); 
					for (var i = 0; i < res1.length; i++) {
						if(prid==res1[i].id){
							selected='selected';
						}else{
							selected='';
						}
						options = options + "<option value='"+res1[i].id+"' "+selected+">"+res1[i].customer_name+"</option>";
					}
					$('#cmb_parentcustomer').html("");
					$('#cmb_parentcustomer').append(options);
				},error:function(){
					toastr.error('Unable to process please contact support');
				}
	 		});
		}
	}