 	$(function(){
	 	getTecnicianData();	
	});
 
 	function getTecnicianData(){
		var urls =base_url+"service/retrieve_technician_data/get_technician_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_technician_table_token : $('#csrf_technician_table_token').val(),cmb_vendor : $('#cmb_vendor_search').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.name,arr.phone_no,arr.mail_id,arr.address];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Name','Phone No','Email','Address']};
	        }
	    });
		var dataTableTechnicianMaster = $('#dataTableTechnicianMaster').dataTable({
			"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
		   	"sDom":"<'row'<'col-md-1 btn_add'><'col-xs-1'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Technician Master',
					header:true,
					title: 'Technician Master',
					extension: '.xls'
				}
			],
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_technician_table_token = $('#csrf_technician_table_token').val();
			    	data.cmb_vendor = $('#cmb_vendor_search').val();
			    	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "name","sWidth": "15%","sClass":"alignLeft"},
 				{"sName": "phone_no","sWidth": "10%","sClass":"alignCenter"},
 				{"sName": "email_id","sWidth": "20%","sClass":"alignLeft"},
 				{"sName": "address","sClass":"alignLeft"},
 				{"sName": "status","sWidth" : "10%","sClass":"alignment",
				 "mRender": function( data, type, full){
						if(full.status == 1){
							return "<button type='button' class='btn btn-info' btn-circle tooltipTable align='center' onclick='change_status(event);'>Active</button>"
						}else{
							return "<button type='button' class='btn btn-danger' btn-circle tooltipTable align='center' onclick='change_status(event);'>Inactive</button>"
						}
	            	}  
 				},
				{"sName": "button",data:null,"sWidth": "10%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-warning btn-circle tooltipTable' align='center' onclick='btn_edit_technician_data(event);' title='Edit'><i class='fa fa-pencil-square-o'></i></button>"}
			],
			"fnDrawCallback": function(oSettings, json){
			    $('.tooltipTable').tooltipster({
				    theme: 'tooltipster-punk',
				    animation: 'grow',
				    delay: 200, 
				    touchDevices: false,
				    trigger: 'hover'
			    });          
			}
		});
		$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  data-toggle="modal" data-target="#add_technician_modal" id="btnTechModal" data-backdrop="static" data-keyboard="false"  ><i class="fa fa-plus" aria-hidden="true"></i></button>');
 	}
 	
 	
	$('#form_add_technician_master').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$("#btn_submit_admin_department").html("<i class='fa fa-spinner fa-spin'></i>Loading");
			var formData = new FormData(document.getElementById("form_add_technician_master"));
			urls =base_url+"service/operation_technician";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	dataTableTechnicianMaster = $('#dataTableTechnicianMaster').DataTable();
		                	dataTableTechnicianMaster.draw();
		                	dataTableTechnicianMaster.clear();
		                	$('#add_technician_modal').modal('hide');
							$('#form_add_technician_master').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					alert(err);
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        cmb_vendor: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
           txtTechnicianName: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtAddress: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtPhoneNo: {							
	           validators: {
	            	notEmpty: {message: 'Required'},
					regexp: {
                    	regexp: /^\d{10}$/,
                    	message: 'Invalid Phone Number!!!'
                	},
			        stringLength: 
				    {
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
	        }
	    }
    });
    
    $("#btnTechModal").click(function(){
    	$('#txtPhoneNo').attr('readonly', false);
    	$("#spanTechnician")[0].innerHTML = "Add Technician";
		$("#form_add_technician_master input[name='op_type']").val("INSERT_TECHNICIAN_DATA");
		$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_add_technician_master').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#operation_component_modal").modal({backdrop: 'static',keyboard: false});
	});
    function btn_edit_technician_data(event){
    	$('#form_add_technician_master').data('bootstrapValidator').resetForm(true);
	    $("#get_technician_details").val('');
	    $("#spanTechnician")[0].innerHTML ="Edit Technician";
	    $("#form_add_technician_master input[name='op_type']").val("UPDATE_TECHNICIAN_DATA");
	    $("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i>Update");
		var oTable = $('#dataTableTechnicianMaster').dataTable();
		//alert();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var cmb_vendor           = oTable.fnGetData(row)['supp_code'];
		var txtTechnicianName    = oTable.fnGetData(row)['name'];
		var txtPhoneNo     	     = oTable.fnGetData(row)['phone_no'];
		var txtEmailId     	     = oTable.fnGetData(row)['mail_id'];
		var txtAddress     	     = oTable.fnGetData(row)['address'];
		$("#txtTechnicianName").val(txtTechnicianName);
		$("#cmb_vendor").val(cmb_vendor);
		$("#txtPhoneNo").val(txtPhoneNo);
		$('#txtPhoneNo').attr('readonly', true);
		$("#txtEmailId").val(txtEmailId);
		$("#txtAddress").val(txtAddress);
		$("#add_technician_modal").modal({backdrop: 'static',keyboard: false});
    }
   
    
   
   	function change_status(event){
		var oTable = $('#dataTableTechnicianMaster').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var tech_id = oTable.fnGetData(row)['id'];
		var tech_status = oTable.fnGetData(row)['status'];
		
		var urls = base_url+"service/get_technician_status";
		$.ajax({
			url: urls,
			type:"POST",
			data:{tech_status:tech_status,tech_id:tech_id,op_type:'update_technician_status'},
			success:function(response){
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	var dataTableTechnician = $('#dataTableTechnicianMaster').DataTable();
						dataTableTechnician.draw();// ReLoad the Datatable
						dataTableTechnician.clear();
					}else{
						toastr.warning(obj.msg);
					}
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	
	$('#cmb_vendor_search').change(function(){
		var dataTableTechnician = $('#dataTableTechnicianMaster').DataTable();
		dataTableTechnician.draw();// ReLoad the Datatable
		dataTableTechnician.clear();
	});
	
	
	