$(document).ready(function() {
	 	getAmcValidation();
	 	//report_detail(x='',y='',z='');
	 	$('#dbtlAMCExpiryValidation').DataTable({
	 		//"sDom":"<'row'<'col-xs-4'l><'col-xs-4'i><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",	
	 	});
	});
	
 	function getAmcValidation(){
		var urls =base_url+"service/get_amc_validation/get_amc_validation";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_amc_validation_token : $('#csrf_amc_validation_token').val(),scheme_id : $("#cmb_scheme").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.consumer_id,arr.scheme_name,arr.STATUS,arr.valid_from,arr.valid_till];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Installation Id','Project','CMC Status','Valid From','Valid Till']};
	        }
	    });
		var amc_validation = $('#dbtlAmcValidation').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		   	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			//"sDom":"<'row'<'col-xs-4'l><'col-xs-4'i><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Amc Validation',
					header:true,
					title: 'Amc Validation',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_amc_validation_token = $("#csrf_amc_validation_token").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "installation_id","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "scheme","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "amc_status","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "valid_from","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "valid_till","sWidth": "10%","sClass":"alignLeft"},
			    {"sName": "amc_status","sWidth" : "10%","sClass":"alignment",
				"mRender": function( data, type, full){
					if(full.STATUS == "valid"){
						return "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnAmcEdit(event)' title='renewal' disabled><i class='fa fa-pencil'>&nbsp;&nbsp;Renewal</i></button>"
					}else{
						return "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnAmcEdit(event)' title='renewal'><i class='fa fa-pencil'>&nbsp;&nbsp;Renewal</i></button>"
					}
				} 
				},
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	           
		});
	}
	$('#btn_search_amc').click(function(){
		amc_validation = $('#dbtlAmcValidation').DataTable();
		amc_validation.draw();
		amc_validation.clear();
	});
	$('#btn_reset').click(function(){
		$("#cmb_scheme").val('');
		amc_validation = $('#dbtlAmcValidation').DataTable();
		amc_validation.draw();
		amc_validation.clear();
	});
	
	$('#form_add_amc').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_admin_department").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_amc"));
			urls =base_url+"service/operation_amc_renew";//add_admin_department
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
		                	dataTableAmc = $('#dbtlAmcValidation').DataTable();
							dataTableAmc.draw();
							dataTableAmc.clear();
							$('#amc_renew').modal('hide');
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                	$('#file_amcdoc').val('');
							$('#form_add_amc').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtConsumerId: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtLetterNo: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        file_amcdoc: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtvalidfrom: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	         txtvalidtill: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function getAmcHistory(){
		var cust_id = $('#txtConsumerId').val();
    	var str ="";
		var urls =base_url+"service/get_amc_history/get_amc_history";
		var amc_validation = $('#dbtlAmcHistory').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			//"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_amc_history_token = $("#csrf_amc_history_token").val();
			       	data.custom_no = cust_id;
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "installation_id","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "amc_status","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "valid_from","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "valid_till","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "amc_letter_no","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "id","sWidth": "10%","sClass":"alignCenter",render: function ( data, type, row ) {
					url = data;
					url = url.split("/");
					str ='<a href=" '+base_url+data+'">'+url[4]+'</a>'
                    return str;
					}
	            }
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	           
		});
	}
	
	function btnAmcEdit(event){
		var oTable = $('#dbtlAmcValidation').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
			
		$("#txtConsumerId").val(oTable.fnGetData(row)['consumer_id']);
		getAmcHistory();
		$("#amc_renew").modal({backdrop: 'static',keyboard: false});
	}
	
	$('#txtvalidfrom').datepicker({
	    format: 'dd-mm-yyyy',
		todayHighlight: true,
		autoclose: true
	});
	
	$('#txtvalidtill').datepicker({
	    format: 'dd-mm-yyyy',
		todayHighlight: true,
		autoclose: true
	});
	/*************** AMC  Report Details ************************/
	function report_detail(scheme_code,pk_scheme_code,year){
		var split = year.split("_");
		var qmnth = split[0];
		var qyear = split[1];
		var heading = "CMC Expiry Details of "+scheme_code+" for "+qmnth+" of FY "+qyear+"";
		
		var urls =base_url+"service/view_amc_expiry_detail/get_amc_expiry_report_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_amc_report_details_token : $('#csrf_amc_report_details_token').val(),scheme_code : scheme_code,pk_scheme_code : pk_scheme_code,year : year},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.consumer_id,arr.customer_address,arr.tr_status,arr.supplier_name,arr.valid_till];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Asset Id','Asset Address','Asset Working Status','Vendor','CMC Expiry Date']};
	        }
	    });
		var dtblAMCReportDetails = $('#dtblAMCReportDetails').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			//"sDom":"<'row'<'col-xs-4'i><'col-xs-4'l><'col-xs-1'B><'col-xs-3'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			    	data.csrf_amc_report_details_token = $('#csrf_amc_report_details_token').val();
			       	data.pk_scheme_code = pk_scheme_code;
			       	data.year = year;
			       	data.page = '';
			    }
			},
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'CMC Expiry Report',
					header:true,
					title: heading,
					extension: '.xls'
				}
			],
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "consumer_id","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "address","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "tr_status","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "supplier_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "valid_till","sWidth": "10%","sClass":"alignCenter"},
			]        
		});
		$("#spanHeading").html("");
		$("#spanHeading").append(heading);
		
		$("#expiry_report_detail_modal").modal({backdrop: 'static',keyboard: false});
	}
	/**********Modify By : Subhashree Jena ***************/
	var dtblAMCReportDetails = $('#dbtlCMCExpiryReport').DataTable({
	 	"processing": true, //Feature control the processing indicator.
	    "serverSide": true, //Feature control DataTables' server-side processing mode.
	    "bDestroy": true,
	    "paging":   true,
	    "info":     true,
	    "autoWidth": false,
	    "responsive":true,
	   	"searching":true,
	   	"bLengthChange": true,
		"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		"ajax": {
		    "url": base_url+"service/view_cmc_expiry_report/get_amc_expiry",
		    "type": "POST",
		    "data": function(data) {
		    	data.csrf_cmc_report_token = $('#csrf_cmc_report_token').val();
		    }
		},
		"buttons": [
			{
				text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
				extend: 'excel',
				filename:'CMC Expiry Report',
				header:true,
				title: 'CMC Expiry Report',
				extension: '.xls'
			}
		],
		"columns": [
			{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
			{"sName": "project_name","sWidth": "10%","sClass":"alignLeft"},
			{"sName": "w1","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.w1!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr1+'\')">'+full.w1+'</a>'
					}
            	}
			},
			{"sName": "w2","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.w2!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr2+'\')">'+full.w2+'</a>'
					}
            	}
			},
			{"sName": "w3","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.w3!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr3+'\')">'+full.w3+'</a>'
					}
            	}
			},
			{"sName": "w4","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.w4!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr4+'\')">'+full.w4+'</a>'
					}
            	}
			},
			{"sName": "q1","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.q1!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr5+'\')">'+full.q1+'</a>'
					}
            	}
			},
			{"sName": "q2","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.q2!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr6+'\')">'+full.q2+'</a>'
					}
            	}
			},
			{"sName": "q3","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.q3!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr7+'\')">'+full.q3+'</a>'
					}
            	}
			},
			{"sName": "q4","sWidth": "10%","sClass":"alignRight",
				"mRender": function( data, type, full){
					if(full.q4!=''){
						return '<a href="javascript:void(0)" onclick="report_detail(\'' +full.scheme_code+ '\',\''+full.pk_scheme_code+ '\',\''+full.fy_qr8+'\')">'+full.q4+'</a>'
					}
            	}
			}
		]        
	});
	