	$(function(){
	 	get_installation_list();
	 	var table_id = $('#table_id').DataTable({
			"sDom":"<'row'<'col-xs-4 btn_add'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-9' <'row'<'col-xs-5' i>>><'col-xs-3'p>>",
		});
		$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add" onclick="add_table_row()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');	
	});
	
	function add_table_row(){
		re_assign();
		get_source_finance(sl_no);
		$('#table_id').DataTable().row.add([
		    '<span class="serial_no">'+sl_no+'</span>', 
		   	'<div class="col-md-2"><div class="form-group"><input type="text" class="form-control" id="txt_sanction'+sl_no+'" name="txt_sanction[]" onblur=validate_sanction('+sl_no+') autocomplete="off"></div></div>', 
		   	'<div class="col-md-2"><div class="form-group"><input type="text" class="form-control custom-all-date" id="txt_sanction_date'+sl_no+'" name="txt_sanction_date[]" autocomplete="off" readonly></div></div>', 
		   	'<div class="col-md-1"><div class="form-group"><input type="text" class="form-control yearpicker" id="txt_financial'+sl_no+'" name="txt_financial[]"  autocomplete="off" readonly></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><select class="form-control" name="cmb_sourceFinance[]" id="cmb_sourceFinance'+sl_no+'" ><option>Select</option></select></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_amount'+sl_no+'" name="txt_amount[]" onblur=validate_amount('+sl_no+') autocomplete="off"></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_install'+sl_no+'" name="txt_install[]" onblur=validate_install('+sl_no+') autocomplete="off"></div></div>', 
		    '<div class="col-md-3"><div class="form-group"><input type="file" name="file_documents[]" id="file_documents'+sl_no+'" class="filestyle" accept=".doc, .docx,.pdf"></div></div>', 
		    '<button type="button" class="btn btn-danger" id="remove_tableRow"><i class="fa fa-trash" ></i>' 
		]).draw();
		var dt = sl_no;
		var toDate = $('.yearpicker').datepicker({
    		format: "yyyy",
    		minViewMode: 2,
  			autoclose : true
    	}).on('hide',function(date){
  			$("#txt_financial"+dt).val(date.target.value + "-" +(parseInt(date.target.value) + parseInt(1)).toString().substr(-2));
		});
		$('.custom-all-date').datepicker({
		    format: 'dd-mm-yyyy',
			todayHighlight: true,
			autoclose: true
		});
		re_assign();
      	sl_no++;
   	}
   
   //Remove Refund Data from table
	$('#table_id tbody').on( 'click', '#remove_tableRow', function () {
		var table_row =  $('#table_id').dataTable();
		var aPos = table_row.fnGetPosition( $(this).closest('tr').get(0));
		// Delete the row
		table_row.fnDeleteRow(aPos);
		re_assign();
	});
	
	function re_assign(){
		var renum = 1;
		$("tr td .serial_no").each(function(){
		  	$(this).text(renum);
		  	renum++;
		});
		sl_no = renum;
	}
    
    function validate_sanction(sl_no){
    	var txt_sanction = $("#txt_sanction"+sl_no).val();
    	if(txt_sanction == ''){
			toastr.error("Please enter Sanction Letter No.");
		}
		
	}
    
    function validate_amount(sl_no){
		var txt_amount = $("#txt_amount"+sl_no).val();
		var re = new RegExp("^([a-z0-9]{5,})$");
		
		if(re.test(txt_amount)){
			swal("Please enter valid Amount !");
		}
		if(txt_amount == ''){
			swal("Please enter amount");
		}
	}
	
	function validate_install(sl_no){
		var txt_amount = $("#txt_install"+sl_no).val();
		var re = new RegExp("^([a-z0-9]{5,})$");
		
		if(re.test(txt_amount)){
			swal("Please enter valid Installation !");
		}
		if(txt_amount == ''){
			swal("Please enter Installation");
		}
	}
    
    function get_installation_list(){
		$.ajax({
			url: base_url+"service/get_all_installation",
			type:"POST",
			data:{op_type:'get_installation_class'},
			success:function(response){
				//console.log(response);
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].id+"' >"+res1[i].instal_cls_name+"</option>";
				}
				$('#cmb_installation').html("");  
				$('#cmb_installation').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
 	
	}
   
   function get_source_finance(sl_no){
   		$.ajax({
   			url:base_url+"service/get_all_source_finance",
   			type:"POST",
   			data:{op_type:'get_source_finance'},
   			success:function(response){
				var options ="<option value=''>Select</option>";
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].lookup_id+"' >"+res1[i].value+"</option>";
				}
				$('#cmb_sourceFinance'+sl_no).html("");  
				$('#cmb_sourceFinance'+sl_no).append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
   		});
   	}
   	
   	$('#form_add_scheme').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_scheme").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_scheme"));
			urls =base_url+"service/operation_scheme";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_scheme").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_scheme").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
							toastr.success(obj.msg);
							window.location.href = base_url+"category-wise-scheme-list";
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtShortCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!.#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	        txtSchemeName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!.#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	        cmbType: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbAdministerDept: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbSchemeCategory: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_installation: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtSchemeDescription: {				
	            validators: {
	                regexp: {
		                regexp: /^[^*+|\:<>[\]{}`\\!#%';@$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        }
	    }	
	});