	$(function(){
	 	getGeneratedTicket();	
	});
 	function getGeneratedTicket(){
	 	var urls =base_url+"service/get_generated_ticket/get_all_generated_ticket";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_generated_ticket : $('#csrf_generated_ticket').val(),scheme_id : $("#cmb_scheme").val(),vendor_id : $("#cmb_vendor").val(),ticket_type : $("#cmb_ticket_type").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.scheme_name,arr.supplier_name,arr.technician_id,arr.district_name,arr.block_name,arr.address,arr.mc];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket No','Consumer','Consumer Address','Issue_date','No of Days Open']};
	        }
	    });

 		var generated_ticket = $('#dataTableGeneratedTicket').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Generated Ticket',
					header:true,
					title: 'Generated Ticket',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_generated_ticket = $("#csrf_generated_ticket").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.vendor_id = $("#cmb_vendor").val();
			       	data.ticket_type = $("#cmb_ticket_type").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "scheme_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "supplier_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "technician_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "district_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "block_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "address","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "mc","sWidth": "20%","sClass":"alignCenter"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	}
	$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		get_ticket_type();
	});
	var vcd = $('#hdf_v_code').val();
	$('#cmb_scheme_list').change(function(){
	 	$.ajax({
	 		
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "";
				if(vcd!='VENDOR'){
					 options = "<option value=''>Select</option>";
				}
				else
				{
					 options = "";
				}
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					var options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor_list').html("");  
				$('#cmb_vendor_list').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		technician_data();
	});
	
	$('#cmb_vendor_list').change(function(){
		technician_data();
	});
	
	function technician_data(){
	 	$.ajax({
			url: base_url+"service/get_technician_data",
			type:"POST",
			data:{op_type:'get_technician_data',vendor_id:$('#cmb_vendor_list').val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].phone_no+"' >"+res[i].name+"("+res[i].phone_no+")</option>";
				}
				$('#cmb_technician').html("");  
				$('#cmb_technician').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	$('#cmb_scheme_list').change(function(){
		get_ticket_list();
	});
	
	function get_ticket_list(){
		$.ajax({
			url: base_url+"service/get_all_ticket",
			type:"POST",
			data:{op_type:'get_ticket_list',scheme_id:$("#cmb_scheme_list").val(),vendor_id:$("#cmb_vendor_list").val()},
			success:function(response){
				//console.log(response);
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].ticket_id+"' >"+res1[i].ticket_id+"</option>";
				}
				$('#cmb_ticket_list').html("");  
				$('#cmb_ticket_list').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$('#btn_search_generated_ticket').click(function(){
		dataTableTransaction = $('#dataTableGeneratedTicket').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	
	/***Form Validation Technician Mapping***/
    $('#form_map_technician').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_map").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_map_technician"));
			urls =base_url+"service/operation_technician_mapping";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
		                } else {
		                	generated_ticket = $('#dataTableGeneratedTicket').DataTable();
		                	generated_ticket.draw();
		                	generated_ticket.clear();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
							$('#form_map_technician').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#cmb_ticket_list').html("");
							$('#cmb_ticket_list').select2("");
							$('#map_technician_modal').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        cmb_scheme_list: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor_list: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_technician: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	$("#btn_reset").click(function(){
		$("#cmb_scheme").val('');
		$("#cmb_vendor").val('');
		$("#cmb_ticket_type").val('');
		dataTableGeneratedTicket = $('#dataTableGeneratedTicket').DataTable();
		dataTableGeneratedTicket.draw();
		dataTableGeneratedTicket.clear();
	});
	$("#btn_send").click(function(){
		$('#suc_msg').html("");
		$('#image_right').hide();
		$('#image_wrong').hide();
		$('#error_msg').html("");
		$('#image_loader').show();
  		$("#SmsMailModal").modal('show');
		$.ajax({
			url: base_url+"service/schedule_mail",
			type:"POST",
			data:{op_type:'send_schedule_mail'},
			success:function(response){
				try{
		            var obj = JSON.parse(response);
	                if (obj.status == true) {
	                	$('#image_loader').hide();
						$('#image_right').show();
						$('#suc_msg').html(obj.msg);
	                }else{
						$('#image_loader').hide();
						$('#image_wrong').show();
						$('#error_msg').html(obj.msg);
	                   	toastr.warning(obj.msg);
	                }
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});