	$(function(){
	 	getGeneratedTicket();	
	});
 	function getGeneratedTicket(){
	 	var urls =base_url+"service/get_generated_ticket/get_all_generated_ticket";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_generated_ticket : $('#csrf_generated_ticket').val(),scheme_id : $("#cmb_scheme").val(),vendor_id : $("#cmb_vendor").val(),ticket_type : $("#cmb_ticket_type").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.description,arr.scheme_name,arr.supplier_name,arr.technician_id,arr.district_name,arr.block_name,arr.address,arr.mc];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket No','Month','Scheme Name','Supplier Name','Technician','District Name','Block Name','Address','MC']};
	        }
	    });

 		var generated_ticket = $('#dataTableGeneratedTicket').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":false,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Generated Ticket',
					header:true,
					title: 'Generated Ticket',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_generated_ticket = $("#csrf_generated_ticket").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.vendor_id = $("#cmb_vendor").val();
			       	data.ticket_type = $("#cmb_ticket_type").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "ticket_id","sClass":"alignLeft"},
				{"sName": "month","sClass":"alignLeft"},
				{"sName": "scheme_name","sClass":"alignLeft"},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "technician_id","sClass":"alignLeft"},
				{"sName": "district_name","sClass":"alignLeft"},
				{"sName": "block_name","sClass":"alignLeft"},
				{"sName": "address","sClass":"alignLeft"},
				{"sName": "mc","sClass":"alignLeft"},
				{"sName": "button",data:null,"sWidth": "20%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info' onclick='btnTicketForm(event)' ><i class='fa fa-pencil' aria-hidden='true'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
		if(role_code=='TECHNICIAN'){
			generated_ticket.column(9).visible(true);
		}else{
			generated_ticket.column(9).visible(false);
		}
	}
	/*$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		get_ticket_type();
	});*/
	var vcd = $('#hdf_v_code').val();
	$('#cmb_scheme_list').change(function(){
	 	$.ajax({
	 		
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "";
				if(vcd!='VENDOR'){
					 options = "<option value=''>Select</option>";
				}
				else
				{
					 options = "";
				}
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					var options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor_list').html("");  
				$('#cmb_vendor_list').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		technician_data();
	});
	
	$('#cmb_vendor_list').change(function(){
		technician_data();
	});
	
	function technician_data(){
	 	$.ajax({
			url: base_url+"service/get_technician_data",
			type:"POST",
			data:{op_type:'get_technician_data',vendor_id:$('#cmb_vendor_list').val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].phone_no+"' >"+res[i].name+"("+res[i].phone_no+")</option>";
				}
				$('#cmb_technician').html("");  
				$('#cmb_technician').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	$('#cmb_scheme_list').change(function(){
		get_ticket_list();
	});
	
	function get_ticket_list(){
		$.ajax({
			url: base_url+"service/get_all_ticket",
			type:"POST",
			data:{op_type:'get_ticket_list',scheme_id:$("#cmb_scheme_list").val(),vendor_id:$("#cmb_vendor_list").val()},
			success:function(response){
				//console.log(response);
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].ticket_id+"' >"+res1[i].ticket_id+"</option>";
				}
				$('#cmb_ticket_list').html("");  
				$('#cmb_ticket_list').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	$('#btn_search_generated_ticket').click(function(){
		dataTableTransaction = $('#dataTableGeneratedTicket').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	
	/***Form Validation Technician Mapping***/
    $('#form_map_technician').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_map").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_map_technician"));
			urls =base_url+"service/operation_technician_mapping";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
		                } else {
		                	generated_ticket = $('#dataTableGeneratedTicket').DataTable();
		                	generated_ticket.draw();
		                	generated_ticket.clear();
		                	$("#btn_map").html("<i class='fa fa-paper-plane'></i> Map");
							$('#form_map_technician').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#cmb_ticket_list').html("");
							$('#cmb_ticket_list').select2("");
							$('#map_technician_modal').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        cmb_scheme_list: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor_list: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_technician: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	$("#btn_reset").click(function(){
		$("#cmb_scheme").val('');
		$("#cmb_vendor").val('');
		$("#cmb_ticket_type").val('');
		dataTableGeneratedTicket = $('#dataTableGeneratedTicket').DataTable();
		dataTableGeneratedTicket.draw();
		dataTableGeneratedTicket.clear();
	});
	$("#btn_send").click(function(){
		swal({
		  	title: 'Are you sure?',
		  	text: "Send Mail",
		  	type: 'info',
		  	showCancelButton: true,
		  	confirmButtonColor: '#3085d6',
		  	cancelButtonColor: '#d33',
		  	confirmButtonText: 'Yes, Send it!'
		}).then(function() {
		  	$('#suc_msg').html("");
			$('#image_right').hide();
			$('#image_wrong').hide();
			$('#error_msg').html("");
			$('#image_loader').show();
	  		$("#SmsMailModal").modal('show');
			$.ajax({
				url: base_url+"service/schedule_mail",
				type:"POST",
				data:{op_type:'send_schedule_mail'},
				success:function(response){
					try{
			            var obj = JSON.parse(response);
		                if (obj.status == true) {
		                	$('#image_loader').hide();
							$('#image_right').show();
							$('#suc_msg').html(obj.msg);
		                }else{
							$('#image_loader').hide();
							$('#image_wrong').show();
							$('#error_msg').html(obj.msg);
		                   	toastr.warning(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error:function(){
					toastr.error('Unable to process please contact support');
				}
	 		});
		})
	});
	
	function btnTicketForm(event){
		var oTable = $('#dataTableGeneratedTicket').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		window.location.href = base_url+"resolution-form/"+encodeURIComponent(btoa(ticket_id));
		$('#ticket_no').val(ticket_id);  
	}
	
	$('#Resolution_form').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$('#btn_submit_status').attr('disabled','disabled');
			var formData = new FormData(document.getElementById("Resolution_form"));
			urls =base_url+"service/operation_sm_resolution_form";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$('#ResolutionModal').modal('hide');
							$('#Resolution_form').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					alert(err);
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        check_reason: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
           evidence_pic: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        txt_witness_name: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_witness_number: {							
	           validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_remarks: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }
    });
    