	$(function(){
	 	getManageRequest();	
	});
 	function getManageRequest(){
	 	var urls =base_url+"service/get_manage_request/get_all_manage_request";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_manage_request : $('#csrf_manage_request').val(),cmb_vendor:$("#cmb_vendor").val(),cmb_scheme:$("#cmb_scheme").val(),cmb_district:$("#cmb_district").val(),cmb_ticket_status:$("#cmb_ticket_status").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.consumer_id,arr.customer_name,arr.customer_address,arr.scheme_name,arr.supplier_name,arr.actual_issue_date,arr.no_of_days_open,arr.ticket_status];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket No','Consumer No','Consumer','Consumer Address','Scheme Name','Vendor Name','Issue Date','No of Days Open','Ticket Status']};
	        }
	    });
	 	var manage_request = $('#dataTableManageRequest').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": false,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Manage Request',
					header:true,
					title: 'Manage Request',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_manage_request = $("#csrf_manage_request").val();
			       	data.cmb_vendor 		 = $("#cmb_vendor").val();
			       	data.cmb_scheme 		 = $("#cmb_scheme").val();
			       	data.cmb_district 		 = $("#cmb_district").val();
			       	data.cmb_ticket_status 	 = $("#cmb_ticket_status").val();
			       	data.page 				 = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "customer_name","sWidth": "20%","sClass":"alignLeft"},
				{"sName": "customer_address","sWidth": "28%","sClass":"alignLeft"},
				{"sName": "technician_id","sWidth": "5%","sClass":"alignLeft"},
				{"sName": "actual_issue_date","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "no_of_days_open","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_status","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "button","sClass" : "alignCenter","sWidth": "15%","mRender": function( data,type,full){
						switch(role_code){
							case 'CRCADMIN':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnManageRequest(event)' title='Manage Request Action'><i class='fa fa-external-link'></i></button>";
							break;
							case 'VENDOR':
								str = "<button type='button' class='btn btn-success btn-circle tooltipTable' onclick='btntechnicianMap(event)' title='Technician Mapping'><i class='fa fa-map'></i></button>\
								<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnManageRequest(event)' title='Manage Request Action'><i class='fa fa-external-link'></i></button>";
							break;
							case 'OCE':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODR':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODH':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODA':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'OTO':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'CRCAGENT':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnManageRequest(event)' title='Manage Request Action'><i class='fa fa-external-link'></i></button>";
							break;
							case 'TECHNICIAN':
								str = "<button type='button' class='btn btn-info' onclick='btnTicketForm(event)' ><i class='fa fa-pencil' aria-hidden='true'></i></button>";
							break;
						}
						return str;
					}
				}
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	}
    $("input[name$='check_reason']").click(function() {
        var check_value = document.querySelector('input[name="check_reason"]:checked').value;
        if(check_value == 1){
			$("div.desc").hide();
			$('input[name$="sub_check_reason"]').prop('checked', false);
			$('#CM_Resolution_form').bootstrapValidator('resetForm', true);
		}else{
			$("div.desc").show();
			
		}
    });
    
    $("input[name$='sub_check_reason']").click(function() {
    	$("div.desc").show();
    });
	$('#btn_search').click(function(){
		dataTableManageRequest = $('#dataTableManageRequest').DataTable();
		dataTableManageRequest.draw();
		dataTableManageRequest.clear();
	});
	$('#btn_reset').click(function(){
		$('#cmb_vendor').val('');
		$('#cmb_scheme').val('');
		$('#cmb_district').val('');
		dataTableManageRequest = $('#dataTableManageRequest').DataTable();
		dataTableManageRequest.draw();
		dataTableManageRequest.clear();
	});
    function btnManageRequest(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var managerequest_id = oTable.fnGetData(row)['id'];
		var transaction_id 	 = oTable.fnGetData(row)['req_by'];
		var ticket_id 	 = oTable.fnGetData(row)['ticket_id'];
		//window.location.href = base_url+"edit-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id));
		window.open(base_url+"edit-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id)), '_blank');
	}
	function btntechnicianView(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var managerequest_id = oTable.fnGetData(row)['id'];
		var transaction_id 	 = oTable.fnGetData(row)['req_by'];
		var ticket_id 	 = oTable.fnGetData(row)['ticket_id'];
		window.location.href = base_url+"view-support-report/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id));
	}
	function btntechnicianMap(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		$("#ticket").val(ticket_id);
		$("#technician_mapping").modal('show');
	}

	$('#form_add_technician').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_technician").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_technician"));
			urls =base_url+"service/operation_ticket_technician";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_add_technician').data('bootstrapValidator').resetForm(true);//Reseting user form
							dataTableManageRequest = $('#dataTableManageRequest').DataTable();
							dataTableManageRequest.draw();
							dataTableManageRequest.clear();
							$('#technician_mapping').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        cmb_technician: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});

	function btnTicketForm(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		window.location.href = base_url+"raiseticket-resolution-form/"+encodeURIComponent(btoa(ticket_id));
		$('#ticket_no').val(ticket_id);  
	}
	
	$('#CM_Resolution_form').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$('#btn_cm_submit_status').attr('disabled','disabled');
			var formData = new FormData(document.getElementById("CM_Resolution_form"));
			urls =base_url+"service/operation_cm_resolution_form";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$('#ResolutionModal').modal('hide');
							$('#CM_Resolution_form').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                	window.location.href = base_url+"manage-request";
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					//alert(err);
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        check_reason: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        sub_check_reason: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
           evidence_pic: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        txt_witness_name: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_witness_number: {							
	           validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_remarks: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }
    });