	$(function(){
	 	var urls =base_url+"service/get_list_of_open_cases/get_list_of_open_cases";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_open_case_token : $('#csrf_open_case_token').val(),scheme_id : $("#cmb_scheme").val(),dept_id : $("#cmb_department").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.dept_name,arr.scheme_name,arr.supplier_name,arr.consumer_id,arr.customer_address,arr.actual_issue_date,arr.ticket_id,arr.no_of_days_open];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Department','Project','Vendor','Consumer ID','Address','Issue_date','Ticket Id','Age']};
	        }
	    });

 		var dbtblOpenCaselist = $('#dbtblOpenCaselist').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":false,
		   	"searching":true,
		   	"bSort":false,
		 	"bLengthChange": true,
		 	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'List of Open Case',
					header:true,
					title: 'List of Open Case(Vendor, Project)',
					extension: '.xlsx'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_open_case_token = $("#csrf_open_case_token").val();
			       	data.dept_id = $("#cmb_department").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "dept_name","sClass":"alignLeft"},
				{"sName": "scheme_name","sClass":"alignLeft"},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "consumer_id","sClass":"alignLeft"},
				{"sName": "customer_address","sClass":"alignLeft"},
				{"sName": "actual_issue_date","sClass":"alignCenter"},
				{"sName": "ticket_id","sClass":"alignCenter"},
				{"sName": "no_of_days_open","sClass":"alignRight"},
			]
		});	
	});
	
	$('#cmb_department').change(function(){
		var urls = base_url + "service/get_all_scheme";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {dept_code:$(this).val(),op_type:'get_all_scheme_list'},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].scheme_code+"' >"+res1[i].scheme_name+"</option>";
						}
						$('#cmb_scheme').html("");  
						$('#cmb_scheme').append(options);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	});
	$('#btn_search').click(function(){
		dbtblOpenCaselist = $('#dbtblOpenCaselist').DataTable();
		dbtblOpenCaselist.draw();
		dbtblOpenCaselist.clear();
	});
	$('#btn_filter_reset').click(function(){
		$('#cmb_department').val('');
		$('#cmb_scheme').val('');
		dbtblOpenCaselist = $('#dbtblOpenCaselist').DataTable();
		dbtblOpenCaselist.draw();
		dbtblOpenCaselist.clear();
	});
	