	$(function(){
	 	var urls =base_url+"service/get_dist_abstract_open/get_dist_abstract_open_data";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_district_abstract_open_token : $('#csrf_district_abstract_open_token').val(),dist_code : $("#cmb_district").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.district_name,arr.supplier_name,arr.req_sub_group,arr.open_case];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','District','Vendor','Project','No of Open Cases']};
	        }
	    });

 		var dbtblDistAbstractOpen = $('#dbtblDistAbstractOpen').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":false,
		   	"searching":true,
		   	"bSort":false,
		 	"bLengthChange": true,
		 	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'List of Open Case',
					header:true,
					title: 'District Abstract Of Open Cases(District,vendor,Project)',
					extension: '.xlsx'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_district_abstract_open_token = $("#csrf_district_abstract_open_token").val();
			       	data.dist_code = $("#cmb_district").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "district_name","sClass":"alignLeft"},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "req_sub_group","sClass":"alignLeft"},
				{"sName": "open_case","sClass":"alignRight"},
			]
		});	
	});
	$('#btn_search').click(function(){
		dbtblDistAbstractOpen = $('#dbtblDistAbstractOpen').DataTable();
		dbtblDistAbstractOpen.draw();
		dbtblDistAbstractOpen.clear();
	});
	$('#btn_filter_reset').click(function(){
		$('#cmb_district').val('');
		dbtblDistAbstractOpen = $('#dbtblDistAbstractOpen').DataTable();
		dbtblDistAbstractOpen.draw();
		dbtblDistAbstractOpen.clear();
	});
	
	
	