	$(function () {
		//iCheck for checkbox and radio inputs
	    $('input[type="checkbox"].minimal, input[type="radio"].minimal').iCheck({
	      checkboxClass: 'icheckbox_minimal-blue',
	      radioClass: 'iradio_minimal-blue'
	    });
	});
	
	$('#cmb_scheme').change(function(){
	 	var scheme_id = $(this).val();
	 	sanction_data(scheme_id);
	 	vendor_data(scheme_id);
	 	installationDetails(scheme_id)
	});
	function sanction_data(scheme_id){
		$.ajax({
			url: base_url+"service/get_sanction_data",
			type:"POST",
			data:{op_type:'get_sanction_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].sanction_order_no+"</option>";
				}
				$('#cmb_sanctionletter').html("");  
				$('#cmb_sanctionletter').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	function vendor_data(scheme_id){
		$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendorname').html("");  
				$('#cmb_vendorname').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	function installationDetails(scheme_id){
		$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installationClass').html("");  
				$('#cmb_installationClass').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	//componentsDetails(14,25059);
	function componentsDetails(trans_id,ins_id){
    	$.ajax({
			url: base_url+"service/get_components_data",
			type:"POST",
			data:{op_type:'get_attribute_details',installation_id:ins_id,trans_id:trans_id},
			success:function(response){
				try{
		            var obj = JSON.parse(response);
		            if(obj.status = true){
		            	$('#divComponentsDetails').html("");
						$('#divComponentsDetails').append(obj.data);
					}
				}catch (e){
					toastr.error('Unable to Process.Please Try Again !');
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	
	$("#cmb_vendorname").change(function(){
    	$.ajax({
			url: base_url+"service/get_dist_vendorwise",
			type:"POST",
			data:{op_type:'get_dist_vendorwise',scheme_id : $('#cmb_scheme').val(),vendor_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].district_code+"'>"+res1[i].district_name+"</option>";
				}
				$('#cmb_district').html("");
				$('#cmb_district').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
    	
	});
	$("#cmb_district").change(function(){
    	$.ajax({
			url: base_url+"service/get_block_dropdown",
			type:"POST",
			data:{op_type:'get_block_vendorwise',vendor_id : $('#cmb_vendorname').val(),scheme_id:$('#cmb_scheme').val(),dist_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].block_code+"'>"+res1[i].block_name+"</option>";
				}
				$('#cmb_cdblock').html("");
				$('#cmb_cdblock').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	
	$("#cmb_cdblock").change(function(){
    	$.ajax({
			url: base_url+"service/get_gp_dropdown",
			type:"POST",
			data:{op_type:'get_gp_vendorwise',vendor_id : $('#cmb_vendorname').val(),scheme_id:$('#cmb_scheme').val(),block_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].pk_gp_code+"'>"+res1[i].gp_name+"</option>";
				}
				$('#cmb_grampanchayat').html("");
				$('#cmb_grampanchayat').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	
	$("#cmb_grampanchayat").change(function(){
    	$.ajax({
			url: base_url+"service/get_village_dropdown",
			type:"POST",
			data:{op_type:'get_village_vendorwise',vendor_id : $('#cmb_vendorname').val(),scheme_id:$('#cmb_scheme').val(),gp_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].pk_village_code+"'>"+res1[i].village_name+"</option>";
				}
				$('#cmb_revenuevillage').html("");
				$('#cmb_revenuevillage').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	
	$("#cmb_revenuevillage").change(function(){
		$('#txtWorkOrder').val('');
    	$('#txt_censuscode').val($('#cmb_revenuevillage').val());
    	$.ajax({
			url: base_url+"service/get_work_order_data",
			type:"POST",
			data:{op_type:'get_work_order',scheme_id : $('#cmb_scheme').val(),vendor_id:$('#cmb_vendorname').val(),village_code:$(this).val()},
			success:function(response){
				var resd = JSON.parse(response); 
				$('#txtWorkOrder').val(resd.work_order);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	});
	
	$('#form_add_transaction').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_add_transaction"));
			urls =base_url+"service/operation_transaction";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                    sweetAlert("Transaction",obj.msg, "error");
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
							componentsDetails(obj.trans_id,$("#cmb_installationClass").val());
		                	$("#hidden_tranaction_id").val(obj.trans_id);
							$("#btnAddTransaction").html("<i class='fa fa-paper-plane'></i> Submit");
							$("#form_add_transaction input[name='op_type']").val("ADD_TRANSACTION");
							$('#myTab a[href="#tabComponents"]').tab('show');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert(e);
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:{
	        cmb_scheme: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendorname: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_installationClass: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        
	        cmb_district: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_cdblock: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_grampanchayat: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_scheduled_week: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_firstName: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_LastName: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_MobileOne: {
	            validators: {
	                regexp: {
                        regexp: /^[1-9][0-9]{0,9}$/,
                        message: "Invalid Mobile Number"
            		}
	            }
	        },
	        file_customerphoto: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        file_idproof: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        },
	        file_installationphoto: {
	            validators: {
			        file: {
                        extension: 'jpeg,jpg,png',
                        type: 'image/jpeg,image/png',
                        maxSize: 2097152,
                        message: 'The selected file is not valid'
                    }
	            }
	        }	
		}	
	});
	
	/*Add Attributes*/
	$(document).on('click', '#btnAddAttribute', function (event) {
		var trans_details_id = $('#hid_trans_details_id_'+$(this).val()).val();
		$.ajax({
			url: base_url+"service/get_attribute_details",
			type:"POST",
			data:{op_type:'get_attribute_details',component_id:$(this).val(),trans_details_id:trans_details_id},
			success:function(response){
				var result = JSON.parse(response);
				try {
					if(result.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$('#title_header').html("Add Attributes");
						$("#form_attribute_details input[name='oper_type']").val("ADD_ATTRIBUTE_DETAILS");
						$('#btn_submit').html("<i class='fa fa-paper-plane'></i> Submit");
						$('#attribute_data').html("");  
						$('#attribute_data').append(result.data);
						$("#attributeModalDetails").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.error(result.msg);
					}
				} catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	//componentsDetails(25050,14);
	/*Add Attributes*/
	$(document).on('click', '#btn_submit', function (event) {
		var formData = new FormData(document.getElementById("form_attribute_details"));
		$.ajax({
			url: base_url+"service/op_attribute_details",
			type:"POST",
			data:formData,
			cache: false,
	        contentType: false,
	        processData: false,
			success:function(response){
				var result = JSON.parse(response);
				try {
					if(result.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$('#attribute_data').html("");
						$('#attribute_data').append(result.data);
						$("#attributeModalDetails").modal('hide');
						toastr.success(result.msg);
					}else{
						toastr.error("No Attributes Available");
					}
				}catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	
	function editAttributeData(trans_details_id,sl_no){
		$.ajax({
			url: base_url+"service/get_edit_attribute_details",
			type:"POST",
			data:{op_type:'get_all_attribute_details',sl_no:sl_no,trans_details_id:trans_details_id},
			success:function(response){
				var Obj = JSON.parse(response);
				try {
					if(Obj.status == true){
						componentsDetails($("#hidden_tranaction_id").val(),$("#cmb_installationClass").val());
						$("#form_attribute_details input[name='oper_type']").val("EDIT_ATTRIBUTE_DETAILS");
						$('#btn_submit').html("<i class='fa fa-paper-plane'></i> Update");  
						$('#title_header').html("Edit Attributes"); 
						$('#attribute_data').html(""); 
						$('#attribute_data').append(Obj.data);
						$("#attributeModalDetails").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.error(Obj.msg);
					}
				} catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	}
	$(document).on('click', '#btnFinalSubmit', function (event) {
		window.location.href = base_url+"manage-installations";
	});
	
	$('#checkbox_powerplant').on('ifClicked', function(event){
		if(this.checked){
			$("#cmb_parentcustomer").prop("disabled", false);
    	}else{
    		$("#cmb_parentcustomer").val('');
			$("#cmb_parentcustomer").prop("disabled", true);
    	}
	});