	var urls =base_url+"service/get_ticket_gen_validation";
	var generated_ticket = $('#dbtlTicketGenValidation').DataTable({
	 	"processing": true, //Feature control the processing indicator.
	    "serverSide": true, //Feature control DataTables' server-side processing mode.
	    "bDestroy": true,
	    "paging":   true,
	    "info":     true,
	    "autoWidth": false,
	    "responsive":true,
	   	"searching":true,
	   	"scrollY": 400,
		"scrollX": true,
	 	"bLengthChange": true,
	 	"sDom":"<'row'<'col-xs-4'i><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
		"ajax": {
		    "url": urls,
		    "type": "POST",
		    "data": function(data) {
		       	data.csrf_ticket_gen_validation_token = $("#csrf_ticket_gen_validation_token").val();
		       	data.Op_Type = 'get_ticket_gen_validation';
		    }
		},
		"columns": [
			{"sName": "sl_no","sClass":"alignCenter"},
			{"sName": "installation_id","sClass":"alignCenter"},
			{"sName": "status","sClass":"alignCenter"},
			{"sName": "Remark","sClass":"alignCenter"},
			{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-primary btn-circle tooltipTable tooltipstered' align='center' onclick='btn_add_validity(event);' title='Add Validity'><i class='fa fa-plus'></i></button>"}
			
		], 
		"fnDrawCallback": function(oSettings, json) {
		 	$('.tooltipTable').tooltipster({
		     	theme: 'tooltipster-punk',
		  		animation: 'grow',
		    	delay: 200, 
		     	touchDevices: false,
		     	trigger: 'hover'
			});          
		}	 
	});
	
	
	function btn_add_validity(event){
		$('#form_ticket_validation_status').data('bootstrapValidator').resetForm(true);
		var oTable = $('#dbtlTicketGenValidation').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$("#hidden_id").val(oTable.fnGetData(row)['tr_customer_id']);
		$("#ticketStatus_modal").modal({backdrop: 'static',keyboard: false});
	}
	
	
	$('#form_ticket_validation_status').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$('#btn_submit_status').attr('disabled','disabled');
			var formData = new FormData(document.getElementById("form_ticket_validation_status"));
			urls =base_url+"service/operation_ticket_validation";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	dbtlTicketGenValidation = $('#dbtlTicketGenValidation').DataTable();
		                	dbtlTicketGenValidation.draw();
		                	dbtlTicketGenValidation.clear();
		                	$('#ticketStatus_modal').modal('hide');
							$('#form_ticket_validation_status').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					alert(err);
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        cmb_ticketStatus: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
           txtRemarks: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }
    });
    