	$(function(){
	 	$('#dtblTicketList').DataTable();
	 	getSmControlPanel();
	});
	
	function getSmControlPanel(){
		var urls =base_url+"service/get_sm_control/get_sm_control";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_smcontrolpanel : $('#csrf_smcontrolpanel').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.month,arr.s_year,arr.supplier,arr.scheme_name,arr.instal_cls_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Month','Year','Supplier','Project','Installation']};
	        }
	    });
		var sm_control_panel = $('#dataTableSmControlPanel').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-md-1 btn_add'><'col-xs-1'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Installations',
					header:true,
					title: 'Installations',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_smcontrolpanel = $("#csrf_smcontrolpanel").val();
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "month","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "s_year","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "total_install","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "button",data:null,"sWidth": "10%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnInstallView(event);' title='View Installation' ><i class='fa fa-eye'></i></button>&nbsp;<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnScheduleReport(event);' title='Schedule Report' ><i class='fa fa-pie-chart'></i></button>"}
			] 
		});
		$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnControlPanel()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
	}
	function btnControlPanel(){
 		window.location.href = base_url+"add-control-panel-installation";
 	}
	
	function btnScheduleReport(event){
		var oTable = $('#dataTableSmControlPanel').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var month_code = oTable.fnGetData(row)['s_month'];
		window.open(base_url+"op-print/schedule_ticket_generation_report/"+month_code);
	}
	
	function btnInstallView(event){
		var oTable = $('#dataTableSmControlPanel').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var month_code = oTable.fnGetData(row)['s_month'];
		view_install_details(month_code);
	 }
	
	function view_install_details(month_code){
	 	var urls =base_url+"service/view_install_details/"+month_code;
		$.ajax({
			url : urls,
			method : 'POST',
			cache: false,
	        contentType: false,
	        processData: false,
			success : function(response){
				var obj = JSON.parse(response);
            	$("#table_install_detail").html("");
            	$("#table_install_detail").append(obj.data);
            	$("#view_ticket_modal").modal({backdrop: 'static',keyboard: false});
			},error: function(err){
				toastr.error("Error No Data Found");
			}
		});
 	}
	
	$('#cmb_vendor').change(function(){
		getSchemeList();
	});
	$('#cmb_schemes').change(function(){
		var vendor = $('#cmb_vendor').val();
		get_installationList(vendor);
	});
	function getSchemeList(){
		var supplier_id = $('#cmb_vendor').val();
		var urls = base_url + "service/get_all_scheme";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {supplier_id:supplier_id,op_type:'get_vendor_against_scheme'},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].pk_scheme_code+"' >"+res1[i].scheme_name+"</option>";
						}
						$('#cmb_schemes').html("");  
						$('#cmb_schemes').append(options);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}getSchemeList();
	
	function get_installationList(vendor){
		var urls = base_url + "service/get_schedule_installation";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {vendor:vendor,scheme:$('#cmb_schemes').val(),op_type:'get_installation_list'},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].id+"' >"+res1[i].instal_cls_name+"</option>";
						}
						$('#cmb_installation_class').html("");  
						$('#cmb_installation_class').append(options);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}
	
	$('#form_schedule_approval').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_schedule_approval"));
			urls =base_url+"service/operation_schedule_controller";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                	$("#cmb_installation_class").val('').trigger("change");
		                	var month = obj.month;
		                	var year = obj.year;
		                	$("#hidden_month").val(obj.month);
		                	$("#hidden_year").val(obj.year);
		                	get_schedule_ticket_count(month,year);
							$('#form_schedule_approval').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtMonth: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtYear: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_schemes: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function get_schedule_ticket_count(month,year){
		var urls = base_url + "service/get_schedule_ticket_count";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {month:month,year:year,op_type:'get_schedule_ticket_count'},
	        success: function (response) {
            	var res = JSON.parse(response); 
            	try {
	              	if (res) {
	              		var table_row = "";
						for (var i = 0; i<res.length; i++) {
							table_row = table_row+"<tr><td><b>"+res[i].gen_code+"</b></td><td>"+res[i].tkt_cnt+"</td></tr>";
						}
						$('#ticket_count').html("");  
						$('#ticket_count').append(table_row);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}
	
	$('#form_ticket_approval').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_ticket_approval"));
			urls =base_url+"service/operation_ticket_approval";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_ticket_approval').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtTicketDate: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtTicketTime: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtComments: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	$("#txtMonth").datepicker({
		    format: "MM",
		    viewMode: "months", 
		    minViewMode: "months",
		    autoclose: true
		}).on('changeDate', function (selected) {
		$('#form_schedule_approval').data('bootstrapValidator').updateStatus('txtMonth', 'NOT_VALIDATED', null).validateField('txtMonth');
	});
	$("#txtYear").datepicker({
		    format: "yyyy",
		    viewMode: "years", 
		    minViewMode: "years",
		    autoclose: true
		}).on('changeDate', function (selected) {
		$('#form_schedule_approval').data('bootstrapValidator').updateStatus('txtYear', 'NOT_VALIDATED', null).validateField('txtYear');
	});
	$("#txtTicketDate").datepicker({
		    format: 'dd-mm-yyyy',
			todayHighlight: true,
			autoclose: true
		}).on('changeDate', function (selected) {
		$('#form_ticket_approval').data('bootstrapValidator').updateStatus('txtTicketDate', 'NOT_VALIDATED', null).validateField('txtTicketDate');
	});
	