$(function(){
	 	getTicketScore();	
	});
 	function getTicketScore(){
	 	var urls = base_url+"service/get_ticket_score/get_all_ticket_score";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_ticket_score : $('#csrf_ticket_score').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.month_name,arr.tkt_type,arr.total_tkt,arr.total_score,arr.total_close_tkt,arr.total_close_score,arr.total_open_ticket,arr.total_open_score,arr.net_score,];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Month','Ticket Type','Total Ticket','Total Score','Total Close Ticket','Close Ticket Score','Total Open Ticket','Open Ticket Score','Net Score']};
	        }
	    });

 	var dtbleTicketScore = $('#dtbleTicketScore').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Ticket Score',
					header:true,
					title: 'Ticket Score',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_ticket_score = $("#csrf_ticket_score").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "month_name","sWidth": "10%","sClass":"alignLeft"},
				{"sName": "tkt_type","sWidth": "20%","sClass":"alignLeft"},
				{"sName": "total_tkt","sWidth": "20%","sClass":"alignRight"},
				{"sName": "total_score","sWidth": "20%","sClass":"alignRight"},
				{"sName": "total_close_tkt","sWidth": "20%","sClass":"alignRight"},
				{"sName": "total_close_score","sWidth": "20%","sClass":"alignRight"},
				{"sName": "total_open_ticket","sWidth": "20%","sClass":"alignRight"},
				{"sName": "total_open_score","sWidth": "20%","sClass":"alignRight"},
				{"sName": "net_score","sWidth": "20%","sClass":"alignRight"}
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	}