$(function(){
	 	getTicketReport();	
	});
 	function getTicketReport(){
	 	var urls = base_url+"service/get_ticket_report/get_all_ticket_report";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_ticket_report : $('#csrf_ticket_report').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.year,arr.month,arr.total_tickets];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Year','Month','Total No Of Tickets']};
	        }
	    });

 	var dataTableTicketReport = $('#dataTableTicketReport').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Ticket Report',
					header:true,
					title: 'Ticket Report',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_ticket_report = $("#csrf_ticket_report").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "year","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "month","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "total_tickets","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "button",data:null,"sWidth": "20%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info' ><i class='fa fa-file ' aria-hidden='true'></i></button>"}
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	}