	$(function () {
    	$("#compose-textarea").wysihtml5();
  	});
  	function customer_search(){
  		var urls =base_url+"service/get_customer_data/all_customer_data";
		var customer_table = $('#dataTableCustomer').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_customer_token = $('#csrf_customer_token').val();
			    	data.dept_code 			 = $('#cmb_department').val();
			    	data.scheme_code 		 = $('#cmb_scheme').val();
			    	data.vendor_code 		 = $('#cmb_vendor').val();
			    	data.dist_code 			 = $('#cmb_district').val();
			    	data.village_code 		 = $('#cmb_village').val();
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "customer_name","sClass":"alignCenter"},
				{"sName": "customer_address","sClass":"alignCenter"},
				{"sName": "supplier_name","sClass":"alignCenter"},
				{"sName": "village_name","sClass":"alignCenter"},
				{
					"sName": "button",data:null,"sWidth": "5%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-success btn-circle tooltipTable tooltipstered' align='center' onclick='btnAddCustomer(event);' title='Add Customer Search' ><i class='fa fa-plus-square'></i></button>"
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
		$('#customer_search_modal').modal({backdrop: 'static',keyboard: false});
	}
	
	
	$('#cmb_department').change(function(){
	 	$.ajax({
			url: base_url+"service/get_all_scheme",
			type:"POST",
			data:{op_type:'get_all_scheme_list',dept_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_scheme_code+"' >"+res[i].scheme_name+"</option>";
				}
				$('#cmb_scheme').html("");  
				$('#cmb_scheme').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#cmb_district').change(function(){
	 	$.ajax({
			url: base_url+"service/get_filter_village_data",
			type:"POST",
			data:{op_type:'get_filter_village_data',district_code:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_village_code+"' >"+res[i].village_name+"</option>";
				}
				$('#cmb_village').html("");  
				$('#cmb_village').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#btn_customer_search').click(function(){
		customer_table = $('#dataTableCustomer').DataTable();
		customer_table.draw();
		customer_table.clear();
	});
	
	function btnAddCustomer(event){
    	var oTable = $('#dataTableCustomer').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidden_consumer_id').val(oTable.fnGetData(row)['customer_id']);
		$('#hidden_scheme_code').val(oTable.fnGetData(row)['scheme_code']);
		$('#supplier_id').val(oTable.fnGetData(row)['supplier_id']);
		$('#supplier_name').val(oTable.fnGetData(row)['supplier_name']);
		$('#txtcustomer').val(oTable.fnGetData(row)['customer_name']);
		$('#form_customer_request').data('bootstrapValidator').updateStatus('txtcustomer','VALID',null);
		//alert("Block"+oTable.fnGetData(row)['customer_block']+"Gp:"+oTable.fnGetData(row)['gp_name']+"Habitation:"+oTable.fnGetData(row)['habitation']+"Land mark"+oTable.fnGetData(row)['landmark']);
		$('#installation').val(oTable.fnGetData(row)['installation_id']);
		$('#district').val(oTable.fnGetData(row)['district_name']);
		$('#block').val(oTable.fnGetData(row)['customer_block']);
		$('#gp').val(oTable.fnGetData(row)['gp_name']);
		$('#village').val(oTable.fnGetData(row)['village_name']);
		$('#habitation').val(oTable.fnGetData(row)['habitation']);
		$('#landmark').val(oTable.fnGetData(row)['landmark']);
		$('#installation_type').val(oTable.fnGetData(row)['installation_type']);
		$('#dept_code').val(oTable.fnGetData(row)['admin_dept_code']);
		$('#customer_address').val(oTable.fnGetData(row)['customer_address']);
		$('#hidden_supplier_phone').val(oTable.fnGetData(row)['supplier_mob']);
		get_issue_list();
		$("#customer_search_modal").modal('hide');
	}
	function get_issue_list(){
        $.ajax({
			url: base_url+"service/get_all_issue",
			type:"POST",
			data:{op_type:'get_gencode_desc',gen_code_group:'RRI'},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].gen_code+"' >"+res1[i].description+"</option>";
				}
				$('#cmb_issue').html("");  
				$('#cmb_issue').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});		
	}
	
	$('#form_customer_request').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator,form,submitButton){
			var body = "";
			var ticket_no 			= $('#newticket').val();
			var complaint_name 		= $('#txt_complaintname').val();
			var mobile_no 			= $('#txt_mobileno').val();
			var customer_name 		= $('#txtcustomer').val();
			var installation 		= $('#installation').val();
			var customer_district 	= $('#district').val();
			var customer_block 		= $('#block').val();
			var customer_gp 		= $('#gp').val();
			var customer_village 	= $('#village').val();
			var customer_habitation = $('#habitation').val();
			var customer_landmark 	= $('#landmark').val();
			var supplier_name 		= $('#supplier_name').val();
			var consumer_id 		= $('#hidden_consumer_id').val();
			var scheme_code 		= $('#hidden_scheme_code').val();
			$('#request_issue').val($('#cmb_issue').val());
			$('#doi').val($('#txtDOI').val());
			$('#tfb').val($('#txtTFB').val());
			$('#emailId').val($('#txt_emailId').val());
			$('#remarks').val($('#txt_remark').val());
			$('#customer_name').val(customer_name);
			$('#customer_mobile_no').val(mobile_no);
			$('#complaint_name').val(complaint_name);
			$('#consumer_id').val(consumer_id);
			$('#scheme_code').val(scheme_code);
			$('#supplier_phone').val($('#hidden_supplier_phone').val());
			var today = new Date();
	   		var current_date = today.getDate()+'-'+(today.getMonth()+1)+'-'+today.getFullYear();
			var current_time = today.getHours() + ":" + today.getMinutes() + ":" + today.getSeconds();
			$('#txtsubject').val(ticket_no+'-New Service Request Registered.');
			
			var cmp_path = base_url+'public/upload/logo/oredalogo.jpg';
			body = "<p><img class='img-rounded img-thumbnail' src="+cmp_path+"></p>\
				<p>Ticket Number: "+ticket_no+"</p>\
				<p>Date: "+current_date+"</br>\
				Time: "+current_time+"</p>\
				<p>Complaint Name: "+complaint_name+"</br>\
				Mobile No: "+mobile_no+"</br>\
				</p>\
				<p>Customer Details:<br>\
				Installation ID: "+installation+"</br>\
				Name: "+customer_name+"</br>\
				District: "+customer_district+"</br>\
				Block: "+customer_block+"</br>\
				GP: "+customer_gp+"</br>\
				Village: "+customer_village+"</br>\
				Habitation: "+customer_habitation+"</br>\
				Landmark: "+customer_landmark+" </br></p>\
				<p>To</br>\
				Authorized Officer,</br>\
				"+supplier_name+"</br></p>\
				<p>Dear Sir,</p>\
				<p>A request to service has been made at the OREDA CRC and a ticket has been raised. As per the OREDA R&M Guidelines 2018, you are to deploy your technician to resolve the case in 7 days time.</p>\
				<p>Kindly take up this matter immediately and inform us about the resolution through a return mail in this thread.</p>\
				<p>With regards,</p>\
				<p>Team Leader</br>OREDA, CRC</br>1800-345-7135</p>";
			
			$('.wysihtml5-sandbox').contents().find('.wysihtml5-editor').html(body);
			get_email();
			$('#btn_submit').attr("disabled", false);
		},
	    fields:{
	        txtcustomer: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_issue: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_complaintname: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_mobileno: {							
	           	validators: {
	            	notEmpty: {message: 'Required'},
					regexp: {
                    	regexp: /^\d{10}$/,
                    	message: 'Invalid Phone Number!!!'
                	},
			        stringLength:{
					    max: 10,
					    message: 'Contact No. must consists of 10 digits'
					}
				}
	        }
	    }	
	});
	
	function get_email(){
		$.ajax({
			url: base_url+"service/get_all_email",
			type:"POST",
			data:{op_type:'get_email',supplier_code:$('#supplier_id').val()},
			success:function(response){
				var obj = JSON.parse(response);
				$('#txtto').val(obj[0].st_email);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});		
	}
	$('#form_add_mail').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_mail"));
			urls =base_url+"service/operation_mail";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#mailerrorlog').html('');
		                	$('#mailerrorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Send");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#mailerrorlog').html(obj.msg);
		                	$('#mailerrorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Send");
		                } else {
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Send");
		                	$("#btn_submit").attr("disabled", true);
							$('#form_add_mail').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#form_customer_request').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('.wysihtml5-sandbox').contents().find('.wysihtml5-editor').html('');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:{
	        txtto: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtsubject: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});