	$(function(){
	 	var urls =base_url+"service/get_supplier_analysis/get_supplier_analysis_data";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_supplier_analysis_token : $('#csrf_supplier_analysis_token').val(),},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.supplier_name,arr.no_inst,arr.p_ins];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Vendor','No of Installation','% Installation']};
	        }
	    });

 		var dbtblSupplierAnalysis = $('#dbtblSupplierAnalysis').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":false,
		   	"searching":true,
		 	"bLengthChange": true,
		 	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Vendor Analysis',
					header:true,
					title: 'Vendor Analysis',
					extension: '.xlsx'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_supplier_analysis_token = $("#csrf_supplier_analysis_token").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "tr_supplier_id","sClass":"alignCenter","visible":false},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "no_inst","sClass":"alignRight"},
				{"sName": "p_ins","sClass":"alignRight"},
			]
		});	
	});
	