 	$(function(){
	 	var urls =base_url+"service/get_cm_supplier_performance_two/cm_supplier_performance_two";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_cm_supplier_performance_token : $('#csrf_cm_supplier_performance_token').val(),supplier_id : $("#cmbSupplier").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.supplier_name,arr.scheme_name,arr.installation_count,arr.tot_tkt,arr.tkt_closed,arr.d_diff,arr.avg_cls,arr.tkt_turn_over];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Vendor','Project','No. Of Installations','Total Request Received','Total Closed','No. Of Days To Closed','Avg Days To Close','Ticket Turnover']};
	        }
	    });

 		var dbtblSupplierPerformanace = $('#dbtblSupplierPerformanace').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":false,
		   	"searching":true,
		 	"bLengthChange": true,
		 	"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Closed Corrective Maintenance Request Analysis - II(Vendor Performance)',
					header:true,
					title: 'Closed Corrective Maintenance Request Analysis - II(Vendor Performance)',
					extension: '.xlsx'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_cm_supplier_performance_token = $("#csrf_cm_supplier_performance_token").val();
			       	data.supplier_id = $("#cmbSupplier").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "scheme_name","sClass":"alignLeft"},
				{"sName": "supplier_name","sClass":"alignLeft"},
				{"sName": "installation_count","sClass":"alignRight"},
				{"sName": "tot_tkt","sClass":"alignRight","visible": false},
				{"sName": "tkt_closed","sClass":"alignRight"},
				{"sName": "d_diff","sClass":"alignRight"},
				{"sName": "avg_cls","sClass":"alignRight"},
				{"sName": "tkt_turn_over","sClass":"alignRight"},
			]
		});	
	});
	$('#btn_search').click(function(){
		dbtblSupplierPerformanace = $('#dbtblSupplierPerformanace').DataTable();
		dbtblSupplierPerformanace.draw();
		dbtblSupplierPerformanace.clear();
	});
	$('#btn_filter_reset').click(function(){
		$('#cmbSupplier').val('');
		dbtblSupplierPerformanace = $('#dbtblSupplierPerformanace').DataTable();
		dbtblSupplierPerformanace.draw();
		dbtblSupplierPerformanace.clear();
	});
	