	$(function () {
		var urls =base_url+"service/get_all_transaction_details/get_all_transaction_details";
		var dataTableTransaction = $('#dataTableTransaction').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollX":false,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_trans_token 	= $('#csrf_trans_token').val();
			    	data.cmb_scheme 		= $('#cmb_scheme').val();
			    	data.cmb_vendor 		= $('#cmb_vendor').val();
			    	data.cmb_installType 	= $('#cmb_installType').val();
			    	data.cmb_district 		= $('#cmb_district').val();
			    	data.cmb_village 		= $('#cmb_village').val();
			    	data.view_install 		= '';
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter","sWidth": "5%"},
				{"sName": "customer_name","sClass":"alignCenter","sWidth": "15%"},
				{"sName": "consumer_id","sClass":"alignCenter","sWidth": "8%"},
				{"sName": "customer_address","sClass":"alignCenter","sWidth": "25%"},
				{"sName": "transaction_status_flag","sClass":"alignCenter","sWidth": "8%"},
				{"sName": "button","sClass" : "alignCenter","mRender": function( data,type,full){
			            switch(role_code){
							case 'VENDOR':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ADEPT':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'OCE':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODR':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'OTO':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODA':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'CRCADMIN':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;";
								if(full.transaction_status_flag  == 'submitted' || full.transaction_status_flag  == 'install'){
									str += "<button type='button' class='btn btn-success btn-circle tooltipTable tooltipstered' align='center' onclick='btnEditTransactionData(event);' title='Edit Transaction' ><i class='fa fa-pencil-square-o'></i></button>&nbsp;";
								}
								if(full.transaction_status_flag == 'submitted'){
									str += "<button type='button' class='btn btn-primary btn-circle tooltipTable tooltipstered' align='center' onclick='btnApprovalProcess(event);' title='Approval Process' ><i class='fa fa-check'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>&nbsp;";
								if(full.transaction_status  != 'cancelled'){
									str +="<button type='button' class='btn btn-danger btn-circle tooltipTable tooltipstered' align='center' onclick='btnDelete(event);' title='Transaction Record Delete' ><i class='fa fa-trash'></i></button>";
								}	
							break;
							case 'CRCAGENT':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODH':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;";
								if(full.transaction_status_flag  == 'Admin Approved'){
									str += "<button type='button' class='btn bg-purple tooltipTable tooltipstered' align='center' onclick='btnDhApprovalProcess(event);' title='Approval Process' ><i class='fa fa-check'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
						}
						return str;
		            }  
		        }
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	});
	$('#cmb_vendor').change(function(){
		var urls = base_url + "service/get_all_scheme";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {op_type:'get_vendor_against_scheme',supplier_id:$(this).val()},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if(res1){
	              		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].pk_scheme_code+"' >"+res1[i].scheme_name+"</option>";
						}
						$('#cmb_scheme').html("");  
						$('#cmb_scheme').append(options);
	                }else{
	                	toastr.error('Sorry Faild Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	});
	
	$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installType').html("");  
				$('#cmb_installType').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#cmb_district').change(function(){
	 	var district_code = $(this).val();
	 	$.ajax({
			url: base_url+"service/get_filter_village_data",
			type:"POST",
			data:{op_type:'get_filter_village_data',district_code:district_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_village_code+"' >"+res[i].village_name+"</option>";
				}
				$('#cmb_village').html("");  
				$('#cmb_village').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#btn_search').click(function(){
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	function btnTransView(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var trans_id = oTable.fnGetData(row)['id'];
		window.open(base_url+"view-transaction-details/"+encodeURIComponent(btoa(trans_id)));
	}
	function btnApprovalProcess(event){
		$('#txt_remarks').val('');
		$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidtrans_id').val(oTable.fnGetData(row)['id']);
		$('#approval_info_modal').modal({backdrop: 'static',keyboard: false});
	}
	function btnDhApprovalProcess(event){
		$('#txt_remarks').val('');
		$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
		$('#op_type').val('add_dh_approval_information');//Reseting user form
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidtrans_id').val(oTable.fnGetData(row)['id']);
		$('#approval_info_modal').modal({backdrop: 'static',keyboard: false});
	}
	$('#form_approval_information').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        valid: 'glyphicon',
	        invalid: 'glyphicon',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_approval_information"));
			$.ajax({
				url : base_url+"service/operation_approval_process",
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                } else {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		            		dataTableTransaction = $('#dataTableTransaction').DataTable();
							dataTableTransaction.draw();
							dataTableTransaction.clear();
							$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#approval_info_modal').modal('hide');
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !');
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:{
	        cmb_approval_status: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
		}	
	});
	
	function btnTransactionReport(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"transaction-report/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id'])));
	}
	
	function btnEditTransactionData(event){
	 	var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"edit-installations/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id'])));
	}
	
	$("#btn_filter_reset").click(function(){
		$("#cmb_vendor").val('');
		$("#cmb_scheme").val('');
		$("#cmb_installType").val('');
		$("#cmb_district").val('');
		$("#cmb_village").val('');
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});