	$(function(){
	 	$('#dtblTicketList').DataTable();
	 	getSmControlPanel();
	});
	
	function getSmControlPanel(){
		var urls =base_url+"service/get_sm_control/get_sm_control";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_smcontrolpanel : $('#csrf_smcontrolpanel').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.month,arr.s_year,arr.supplier,arr.scheme_name,arr.instal_cls_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Month','Year','Supplier','Scheme','Installation']};
	        }
	    });
		var sm_control_panel = $('#dataTableSmControlPanel').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Installations',
					header:true,
					title: 'Installations',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_smcontrolpanel = $("#csrf_smcontrolpanel").val();
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "month","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "s_year","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "supplier","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "scheme_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "instal_cls_name","sWidth": "20%","sClass":"alignCenter"}
			] 
		});
	}
	function btnControlPanel(){
 		window.location.href = base_url+"add-control-panel-installation";
 	}
	
	$('#cmb_vendor').change(function(){
		getSchemeList();
	});
	$('#cmb_schemes').change(function(){
		var vendor = $('#cmb_vendor').val();
		get_installationList(vendor);
	});
	function getSchemeList(){
		var supplier_id = $('#cmb_vendor').val();
		var urls = base_url + "service/get_all_scheme";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {supplier_id:supplier_id,op_type:'get_vendor_against_scheme'},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "<option value=''>Select</option>";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].pk_scheme_code+"' >"+res1[i].scheme_name+"</option>";
						}
						$('#cmb_schemes').html("");  
						$('#cmb_schemes').append(options);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}getSchemeList();
	
	function get_installationList(vendor){
		var urls = base_url + "service/get_schedule_installation";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {vendor:vendor,scheme:$('#cmb_schemes').val(),op_type:'get_installation_list'},
	        success: function (response) {
            	var res1 = JSON.parse(response); 
            	try {
	              	if (res1) {
	              		var options = "";
						for (var i = 0; i < res1.length; i++) {
							options = options + "<option value='"+res1[i].id+"' >"+res1[i].instal_cls_name+"</option>";
						}
						$('#cmb_installation_class').html("");  
						$('#cmb_installation_class').append(options);
	                }else{
	                	toastr.error('Sorry Failed Data');
	                }
	            } catch (e) {
	                toastr.error("Sorry","We are unable to Process !");
	            }
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}
	
	$('#form_schedule_approval').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_schedule_approval"));
			urls =base_url+"service/operation_schedule_controller";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                	$("#cmb_installation_class").val('').trigger("change");
		                	var month = obj.month;
		                	var year = obj.year;
		                	$("#hidden_month").val(obj.month);
		                	$("#hidden_year").val(obj.year);
		                	get_schedule_ticket_count(month,year);
							$('#form_schedule_approval').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtMonth: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtYear: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_schemes: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function get_schedule_ticket_count(month,year){
		var urls = base_url + "service/get_schedule_ticket_count";
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: {month:month,year:year,op_type:'get_schedule_ticket_count'},
	        success: function (response) {
            	var res = JSON.parse(response); 
            	var table_row = "";
            	//console.log(res);
            	for (var i = 0; i < res.length; i++) {
						table_row = "<tr><td><b>'"+res[i].gen_code+"'</b></td><td>'"+res[i].tkt_cnt+"'</td></tr>";
					}
                $('#ticket_count').html("");  
				$('#ticket_count').append(table_row);
	        }, error: function (err) {
	        	swal("Sorry",err, "error");
	        }
		});
	}
	
	$('#form_ticket_approval').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_ticket_approval"));
			urls =base_url+"service/operation_ticket_approval";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_ticket_approval').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtTicketDate: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtTicketTime: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtComments: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	