$(document).ready(function() {
	 	getAmcValidation();
	});
 	function getAmcValidation(){
		var urls =base_url+"service/get_amc_validation/get_amc_validation";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_admindepartmentToken : $('#csrf_amc_validation_token').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.admin_dept_code,arr.dept_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Dept Code','Admin Department Name']};
	        }
	    });
		var amc_validation = $('#dbtlAmcValidation').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Amc Validation',
					header:true,
					title: 'Amc Validation',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_amc_validation_token = $("#csrf_amc_validation_token").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "installation_id","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "scheme","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "amc_status","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "valid_from","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "valid_till","sWidth": "10%","sClass":"alignCenter"},
			    {"sName": "amc_status","sWidth" : "10%","sClass":"alignment",
				"mRender": function( data, type, full){
					if(full.STATUS == "valid"){
						return "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnAmcEdit(event)' title='renewal' disabled><i class='fa fa-pencil'>&nbsp;&nbsp;Renewal</i></button>"
					}else{
						return "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnAmcEdit(event)' title='renewal'><i class='fa fa-pencil'>&nbsp;&nbsp;Renewal</i></button>"
					}
				} 
				},
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	           
		});
	}
	
	$('#form_add_amc').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_admin_department").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_amc"));
			urls =base_url+"service/operation_amc_renew";//add_admin_department
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
		                	dataTableAmc = $('#dbtlAmcValidation').DataTable();
							dataTableAmc.draw();
							dataTableAmc.clear();
							$('#amc_renew').modal('hide');
		                	$("#btn_submit_amc_renew").html("<i class='fa fa-paper-plane'></i> Submit");
		                	$('#file_amcdoc').val('');
							$('#form_add_amc').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtConsumerId: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtLetterNo: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        file_amcdoc: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtvalidfrom: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	         txtvalidtill: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function getAmcHistory(){
		var cust_id = $('#txtConsumerId').val();
    	var str ="";
		var urls =base_url+"service/get_amc_history/get_amc_history";
		var amc_validation = $('#dbtlAmcHistory').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_amc_history_token = $("#csrf_amc_history_token").val();
			       	data.custom_no = cust_id;
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "installation_id","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "amc_status","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "valid_from","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "valid_till","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "amc_letter_no","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "id","sWidth": "10%","sClass":"alignCenter",render: function ( data, type, row ) {
					url = data;
					url = url.split("/");
					str ='<a href=" '+base_url+data+'">'+url[4]+'</a>'
                    return str;
					}
	            }
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	           
		});
	}
	
	function btnAmcEdit(event){
		var oTable = $('#dbtlAmcValidation').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
			
		$("#txtConsumerId").val(oTable.fnGetData(row)['consumer_id']);
		getAmcHistory();
		$("#amc_renew").modal({backdrop: 'static',keyboard: false});
	}
	
	$('#txtvalidfrom').datepicker({
	    format: 'dd-mm-yyyy',
		todayHighlight: true,
		autoclose: true
	});
	
	$('#txtvalidtill').datepicker({
	    format: 'dd-mm-yyyy',
		todayHighlight: true,
		autoclose: true
	});
	
	
	
	