	var urls =base_url+"service/get_all_scheme_category/get_all_scheme_category";
    var scheme = $('#datableSchemeCategory').DataTable({
	 	"processing": true, //Feature control the processing indicator.
	    "serverSide": true, //Feature control DataTables' server-side processing mode.
	    "bDestroy": true,
	    "paging":   true,
	    "info":     true,
	    "autoWidth": false,
	    "responsive":true,
	   	"searching":true,
	   	"bLengthChange": true,
	   	"sDom":"<'row'<'col-xs-4 btn_add'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row'<'col-xs-5' i>>><'col-xs-6'p>>",
	 	//"dom": 'Bfrtip',
		"ajax": {
		    "url": urls,
		    "type": "POST",
		    "data": function(data) {
		       	data.csrf_dtbleSchemeCategory_token = $("#csrf_dtbleSchemeCategory_token").val();
		    }
		},
		"columns": [
			{"sName": "sl_no","sClass":"alignCenter"},
			{"sName": "category_code","sClass":"alignCenter","visible":false},
			{"sName": "category_name","sClass":"alignCenter"},
			{"sName": "category_short_code","sClass":"alignCenter"},
			{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnSchemeCategoryEdit(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
			
		], 
		"fnDrawCallback": function(oSettings, json) {
		 	$('.tooltipTable').tooltipster({
		     	theme: 'tooltipster-punk',
		  		animation: 'grow',
		    	delay: 200, 
		     	touchDevices: false,
		     	trigger: 'hover'
			});          
		}	       
	});
	
	$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add"  id="btn_scheme_category" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
	
	
	
	$('#form_add_scheme_category').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_admin_department").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_scheme_category"));
			urls =base_url+"service/operation_scheme_category";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
		                	datableSchemeCategory = $('#datableSchemeCategory').DataTable();
							datableSchemeCategory.draw();
							datableSchemeCategory.clear();
							$('#add_table_row').modal('hide');
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_add_scheme_category').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtCategoryName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!.#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	         txtCategoryShortCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!.#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	    }	
	});
	
	function btnSchemeCategoryEdit(event){
		$('#txtCategoryCode').attr('readonly',true);
		$("#spanSchemeCategory")[0].innerHTML = "Edit Scheme Category";
		$("#form_add_scheme_category input[name='op_type']").val("UPDATE_SCHEME_CATEGORY");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Update");
		$('#form_add_scheme_category').data('bootstrapValidator').resetForm(true);
		var oTable = $('#datableSchemeCategory').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$("#txtCategoryName").val(oTable.fnGetData(row)['category_name']);
		$("#txtCategoryShortCode").val(oTable.fnGetData(row)['category_short_code']);
		$("#hid_schemeCategory_id").val(oTable.fnGetData(row)['category_code']);
		$("#add_table_row").modal({backdrop: 'static',keyboard: false});
	}
	
	$("#btn_scheme_category").click(function(){
		$('#txtCategoryCode').attr('readonly',false);
		$("#spanSchemeCategory").html('Add Scheme Category');
		$("#form_add_scheme_category input[name='op_type']").val("INSERT_SCHEME_CATEGORY");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_add_scheme_category').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_table_row").modal({backdrop: 'static',keyboard: false});
	});