	$(function(){
	 	get_installation_list();
	 	var scheme_id = $('#hid_scheme_header_id').val();
		selectInstallationClass(scheme_id);
		viewSchemeUploadDetails();
	});
	
	$('#form_add_scheme').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_scheme").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_scheme"));
			urls =base_url+"service/operation_scheme";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_scheme").html("<i class='fa fa-paper-plane'></i> Update");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_scheme").html("<i class='fa fa-paper-plane'></i> Update");
		                } else {
		                	$("#btn_submit_scheme").html("<i class='fa fa-paper-plane'></i> Update");
							$('#form_add_scheme').data('bootstrapValidator').resetForm(true);//Reseting user form
							window.location.href = base_url+"category-wise-scheme-list";
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtShortCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	        txtSchemeName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
		                regexp: /^[^*+|\":<>[\]{}`\\!#%';@&$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        },
	        cmbType: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbAdministerDept: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbSchemeCategory: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_installation: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtSchemeDescription: {				
	            validators: {
	                regexp: {
		                regexp: /^[^*+|\:<>[\]{}`\\!#%';@$]+$/,
		                message: 'Special Character Not Allowed'
		            }
	            }
	        }
	    }	
	});
	
	function get_installation_list(){
		$.ajax({
			url: base_url+"service/get_all_installation",
			type:"POST",
			data:{op_type:'get_installation_class'},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].id+"'>"+res1[i].instal_cls_name+"</option>";
				}
				$('#cmb_installation').html("");  
				$('#cmb_installation').append(options);
				
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	function selectInstallationClass(scheme_id){
		$.ajax({
			url: base_url+"service/getSelectInstallationClass",
			type:"POST",
			data:{op_type:'get_scheme_installation',scheme_header_id:scheme_id},
			success:function(response){
				var res = JSON.parse(response); 
				var selected_value_array = new Array();
				for(var i=0;i<res.length;i++){
					selected_value_array.push(res[i].installation_class_id);
				}
				$("#cmb_installation").val(selected_value_array);
				$("#cmb_installation").select2(selected_value_array);
				
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	
	var scheme = $('#table_id').DataTable({
		"sDom":"<'row'<'col-xs-4 btn_add'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-9' <'row'<'col-xs-5' i>>><'col-xs-3'p>>",
	});
	$("div.btn_add").html('<button type="button" class="btn btn-info tooltipTable btn-circle" title="Add" id="add_table_row" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
   	$("#add_table_row").click(function(){
		re_assign();
		get_source_finance(sl_no);
		$('#table_id').DataTable().row.add([
		    '<span class="serial_no">'+sl_no+'</span>', 
		   	'<div class="col-md-2"><div class="form-group"><input type="text" class="form-control" id="txt_sanction'+sl_no+'" name="txt_sanction[]" onblur="validate_sanction('+sl_no+')" autocomplete="off"></div></div>', 
		   	'<div class="col-md-2"><div class="form-group"><input type="text" class="form-control custom-all-date" id="txt_sanction_date'+sl_no+'" name="txt_sanction_date[]"  autocomplete="off" readonly></div></div>', 
		   	'<div class="col-md-1"><div class="form-group"><input type="text" class="form-control yearpicker" id="txt_financial'+sl_no+'" name="txt_financial[]"  autocomplete="off" readonly></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><select class="form-control" name="cmb_sourceFinance[]" id="cmb_sourceFinance'+sl_no+'" ><option>Select</option></select></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_amount'+sl_no+'" name="txt_amount[]" onblur="validate_amount('+sl_no+')" autocomplete="off"></div></div>', 
		   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_install'+sl_no+'" name="txt_install[]" onblur="validate_installation('+sl_no+')" autocomplete="off"></div></div>', 
		    '<div class="col-md-3"><div class="form-group"><input type="hidden" value="" name="hidden_scheme_upload_id[]"><input type="file" name="file_documents[]" id="file_documents'+sl_no+'" class="filestyle" accept=".doc, .docx,.pdf"></div></div>', 
		    '<button type="button" class="btn btn-danger" id="remove_tableRow" ><i class="fa fa-trash" ></i>' 
		]).draw();
		var dt = sl_no;
		var toDate = $('.yearpicker').datepicker({
    		format: "yyyy",
    		minViewMode: 2,
  			autoclose : true
    	}).on('hide',function(date){
  			$("#txt_financial"+dt).val(date.target.value + "-" +(parseInt(date.target.value) + parseInt(1)).toString().substr(-2));
		});
		$('.custom-all-date').datepicker({
		    format: 'dd-mm-yyyy',
			todayHighlight: true,
			autoclose: true
		});
		re_assign();
      	sl_no++;
   });
   
   //Remove Refund Data from table
	$('#table_id tbody').on( 'click', '#remove_tableRow', function () {
		var table_row =  $('#table_id').dataTable();
		var aPos = table_row.fnGetPosition( $(this).closest('tr').get(0));
		// Delete the row
		table_row.fnDeleteRow(aPos);
		re_assign();
	});
	
	function re_assign(){
		var renum = 1;
		$("tr td .serial_no").each(function(){
		  	$(this).text(renum);
		  	renum++;
		});
		sl_no = renum;
	}
    
    function validate_sanction(sl_no){
    	var txt_sanction = $("#txt_sanction"+sl_no).val();
    	if(txt_sanction == ''){
			toastr.error("Please enter Sanction Letter No.");
		}
		
	}
    
    function validate_amount(sl_no){
		var txt_amount = $("#txt_amount"+sl_no).val();
		var re = new RegExp("^([a-z0-9]{5,})$");
		
		if(re.test(txt_amount)){
			swal("Please enter valid data !");
		}
		if(txt_amount == ''){
			swal("Please enter amount");
		}
	}
	
	function validate_installation(sl_no){
		var txt_amount = $("#txt_install"+sl_no).val();
		var re = new RegExp("^([a-z0-9]{5,})$");
		
		if(re.test(txt_amount)){
			swal("Please enter valid installation !");
		}
		if(txt_amount == ''){
			swal("Please enter installation");
		}
	}
	
	function viewSchemeUploadDetails(){
		var hid_scheme_header_id = $("#hid_scheme_header_id").val();
		var url = base_url+"service/get_scheme_upload_details";
		var sl_no = 1;
	   	$.ajax({
			url : url,
			method : 'POST',
			data:{scheme_header_id : hid_scheme_header_id,op_type:'get_scheme_upload'},
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                re_assign();
	                for(var k =0;k < obj.length; k++ ){
						re_assign();
						var finance = obj[k].finance_source_val;
						var file_doc= '';
						var base_file_doc = '';
						if(obj[k].files !=''){
							file_doc = obj[k].files;
							var split_file_doc= file_doc.split('/');
							base_file_doc = split_file_doc.pop();
						}
						get_source_finance(sl_no,finance);
						$('#table_id').DataTable().row.add([
						    '<span class="serial_no">'+sl_no+'</span>', 
						   	'<div class="col-md-6"><div class="form-group"><input type="text" class="form-control" id="txt_sanction'+sl_no+'" name="txt_sanction[]" onblur=validate_sanction('+sl_no+') value="'+obj[k].sanction_order_no+'" autocomplete="off"></div></div>', 
						   	'<div class="col-md-2"><div class="form-group"><input type="text" class="form-control custom-all-date" id="txt_sanction_date'+sl_no+'" name="txt_sanction_date[]" autocomplete="off" value='+obj[k].sanction_letter_date+' readonly></div></div>', 
						   	'<div class="col-md-1"><div class="form-group"><input type="text" class="form-control yearpicker" id="txt_financial'+sl_no+'" name="txt_financial[]" value="'+obj[k].financial_year+'" autocomplete="off" readonly></div></div>', 
						   	'<div class="col-md-3"><div class="form-group"><select class="form-control" name="cmb_sourceFinance[]" id="cmb_sourceFinance'+sl_no+'" ><option value="">Select</option></select></div></div>', 
						   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_amount'+sl_no+'" name="txt_amount[]" onblur=validate_amount('+sl_no+') value="'+obj[k].amount+'" autocomplete="off"></div></div>', 
						   	'<div class="col-md-3"><div class="form-group"><input type="text" class="form-control" id="txt_install'+sl_no+'" name="txt_install[]" onblur=validate_installation('+sl_no+') value="'+obj[k].installation+'" autocomplete="off"></div></div>', 
						    '<div class="col-md-3"><div class="form-group"><input type="hidden" value="'+obj[k].pk_scheme_upload+'" name="hidden_scheme_upload_id[]"><input type="hidden" value="'+obj[k].files+'" name="hid_file_name[]" readonly><input type="file" name="file_documents[]" id="file_documents'+sl_no+'" value="" class="filestyle" accept=".doc, .docx,.pdf" ><p>'+base_file_doc+'</p></div></div>', 
						    '<button type="button" class="btn btn-danger" id="remove_edittableRow" onclick="btn_deleteRow('+obj[k].pk_scheme_upload+')"><i class="fa fa-trash" ></i>' 
						]).draw();
						var dt =sl_no;
						var toDate = $('.yearpicker').datepicker({
				    		format: "yyyy",
				    		minViewMode: 2,
				  			autoclose : true
				    	}).on('hide',function(date){
				  			$("#txt_financial"+dt).val(date.target.value + "-" +(parseInt(date.target.value) + parseInt(1)).toString().substr(-2));
						});
						$('.custom-all-date').datepicker({
						    format: 'dd-mm-yyyy',
							todayHighlight: true,
							autoclose: true
						});
						re_assign();
				      	sl_no++;
					}
	            } catch (e) {
	                toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	
	function btn_deleteRow (pk_scheme_upload) {
		var urls = base_url + "service/delete_scheme_upload";
		var formData = {pk_scheme_upload:pk_scheme_upload,op_type:"delete_scheme_upload"};
		$.ajax({
			url: urls,
	        method: 'POST',
	        data: formData,
	        success: function (response) {
	            try {
	                var obj = JSON.parse(response);
	                console.log(obj);
	                if (obj == true) {
	                	setTimeout(function() {
					        swal({
					            title: 'Deleted!',
					            text: "Successfully!",
					            type: "success"
					        }, function() {
					            location.reload();
					        });
					    }, 1000);
	                }else{
	                	sweetAlert("Sansaction Letter",obj.msg, "error");
	                }
	            } catch (e) {
	                sweetAlert("Sorry","We are unable to Process !", "error");
	            }
	        }, error: function (err) {
	            toastr.error(err);
	        }
		});
	}
	
	function get_source_finance(sl_no,finance){
		//alert(finance);
   		$.ajax({
   			url:base_url+"service/get_all_source_finance",
   			type:"POST",
   			data:{op_type:'get_source_finance'},
   			success:function(response){
				var options ="<option value=''>Select</option>";
				var res1 = JSON.parse(response);
				for (var i = 0; i < res1.length; i++) {
					if(finance == res1[i].lookup_id){
						selected = "selected";	
					}else{
						selected ="";
					}
					options = options + "<option value='"+res1[i].lookup_id+"' "+selected+">"+res1[i].value+"</option>";
				}
				$('#cmb_sourceFinance'+sl_no).html("");  
				$('#cmb_sourceFinance'+sl_no).append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
   		});
   	}