	$(function(){
	 	getResolveTicket();	
	 	get_ticket_type();
	});
 	function getResolveTicket(){
	 	var urls =base_url+"service/get_resolve_ticket/get_all_resolve_ticket";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_resolve_ticket : $('#csrf_resolve_ticket').val(),scheme_id : $("#cmb_scheme").val(),vendor_id : $("#cmb_vendor").val(),ticket_type : $("#cmb_ticket_type").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.scheme_name,arr.supplier_name,arr.technician_id,arr.district_name,arr.block_name,arr.address,arr.mc];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket Id','Scheme Name','Vendor name','Technician Phone','District Name','Block Name','Address','MC']};
	        }
	    });

 		var resolve_ticket = $('#dataTableResolveTicket').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Resolve Ticket',
					header:true,
					title: 'Resolve Ticket',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_resolve_ticket = $("#csrf_resolve_ticket").val();
			       	data.scheme_id = $("#cmb_scheme").val();
			       	data.vendor_id = $("#cmb_vendor").val();
			       	data.ticket_type = $("#cmb_ticket_type").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "scheme_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "supplier_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "technician_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "district_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "block_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "address","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "mc","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "button",data:null,"sWidth": "20%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info' onclick='btnTicketView(event)' ><i class='fa fa-pencil' aria-hidden='true'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
		if(role_code == 'CRCADMIN' || role_code == 'CRCAGENT'){
			resolve_ticket.column(9).visible( true );
		}else{
			resolve_ticket.column(9).visible( false );
		}
	}
	
	function btnTicketView(event){
		var oTable = $('#dataTableResolveTicket').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		view_ticketDetails(ticket_id);
		get_status_list();
	}
	
	function view_ticketDetails(ticket_id){
		var urls =base_url+"service/view_ticket_details/"+ticket_id;
		$.ajax({
			url : urls,
			method : 'POST',
			cache: false,
	        contentType: false,
	        processData: false,
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewTicketDetails").html("");
						$("#viewTicketDetails").append(obj.data);
	                	$("#status_modal").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	
	function get_status_list(){
        $.ajax({
			url: base_url+"service/get_all_status",
			type:"POST",
			data:{op_type:'get_gencode_desc',gen_code_group:'TICKET_STATUS'},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].gen_code+"' >"+res1[i].description+"</option>";
				}
				$('#cmb_status').html("");  
				$('#cmb_status').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});		
	}
	
	/*$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		
	});*/
	
	function get_ticket_type(){
        $.ajax({
			url: base_url+"service/get_all_ticket",
			type:"POST",
			data:{op_type:'get_gencode_desc',gen_code_group:'TICKET_TYPE'},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].gen_code+"' >"+res1[i].description+"</option>";
				}
				$('#cmb_ticket_type').html("");  
				$('#cmb_ticket_type').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});		
	}
	
	$('#btn_search_resolve_ticket').click(function(){
		dataTableTransaction = $('#dataTableResolveTicket').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	
	/***Form Validation Ticket Status***/
    $('#form_ticket_status').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_update_status").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_ticket_status"));
			urls =base_url+"service/operation_ticket_status";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_update_staus").html("<i class='fa fa-paper-plane'></i> Map");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_update_staus").html("<i class='fa fa-paper-plane'></i> Map");
		                } else {
		                	resolve_ticket = $('#dataTableResolveTicket').DataTable();
		                	resolve_ticket.draw();
		                	resolve_ticket.clear();
		                	$("#btn_update_staus").html("<i class='fa fa-paper-plane'></i> Map");
							$('#form_ticket_status').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#status_modal').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        cmb_status: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	$("#btn_reset").click(function(){
		$("#cmb_scheme").val('');
		$("#cmb_vendor").val('');
		$("#cmb_ticket_type").val('');
		dataTableTransaction = $('#dataTableResolveTicket').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});