	$(function(){
	 	getManageRequest();	
	});
 	function getManageRequest(){
	 	var urls =base_url+"service/get_manage_request/get_all_manage_request";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_manage_request : $('#csrf_manage_request').val(),cmb_vendor:$("#cmb_vendor").val(),cmb_scheme:$("#cmb_scheme").val(),cmb_district:$("#cmb_district").val(),cmb_ticket_status:$("#cmb_ticket_status").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.customer_name,arr.customer_address,arr.issue_date,arr.no_of_days_open,arr.ticket_status];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket No','Consumer','Consumer Address','Issue_date','No of Days Open','Ticket Status']};
	        }
	    });
	 	var manage_request = $('#dataTableManageRequest').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": false,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Manage Request',
					header:true,
					title: 'Manage Request',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_manage_request = $("#csrf_manage_request").val();
			       	data.cmb_vendor 		 = $("#cmb_vendor").val();
			       	data.cmb_scheme 		 = $("#cmb_scheme").val();
			       	data.cmb_district 		 = $("#cmb_district").val();
			       	data.cmb_ticket_status 	 = $("#cmb_ticket_status").val();
			       	data.page 				 = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "customer_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "customer_address","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "technician_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "actual_issue_date","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "no_of_days_open","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "ticket_status","sWidth": "10%","sClass":"alignCenter"},
				{"sName": "button","sClass" : "alignCenter","mRender": function( data,type,full){
						switch(role_code){
							case 'CRCADMIN':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnManageRequest(event)' title='Manage Request Action'><i class='fa fa-external-link'></i></button>";
							break;
							case 'VENDOR':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianMap(event)' title='Technician Mapping'><i class='fa fa-map'></i></button>";
							break;
							case 'OCE':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODR':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODH':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'ODA':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'OTO':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btntechnicianView(event)' title='Report View'><i class='fa fa-eye'></i></button>";
							break;
							case 'CRCAGENT':
								str = "<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnManageRequest(event)' title='Manage Request Action'><i class='fa fa-external-link'></i></button>";
							break;
							case 'TECHNICIAN':
								str = "";
							break;
						}
						return str;
					}
				}
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	}
	$('#btn_search').click(function(){
		dataTableManageRequest = $('#dataTableManageRequest').DataTable();
		dataTableManageRequest.draw();
		dataTableManageRequest.clear();
	});
	$('#btn_reset').click(function(){
		$('#cmb_vendor').val('');
		$('#cmb_scheme').val('');
		$('#cmb_district').val('');
		dataTableManageRequest = $('#dataTableManageRequest').DataTable();
		dataTableManageRequest.draw();
		dataTableManageRequest.clear();
	});
    function btnManageRequest(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var managerequest_id = oTable.fnGetData(row)['id'];
		var transaction_id 	 = oTable.fnGetData(row)['req_by'];
		var ticket_id 	 = oTable.fnGetData(row)['ticket_id'];
		//window.location.href = base_url+"edit-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id));
		window.open(base_url+"edit-manage-request/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id+'/'+ticket_id)), '_blank');
	}
	function btntechnicianView(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var managerequest_id = oTable.fnGetData(row)['id'];
		var transaction_id 	 = oTable.fnGetData(row)['req_by'];
		var ticket_id 	 = oTable.fnGetData(row)['ticket_id'];
		window.location.href = base_url+"view-support-report/"+encodeURIComponent(btoa(managerequest_id+'/'+transaction_id));
	}
	function btntechnicianMap(event){
		var oTable = $('#dataTableManageRequest').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var ticket_id = oTable.fnGetData(row)['ticket_id'];
		$("#ticket").val(ticket_id);
		$("#technician_mapping").modal('show');
	}

	$('#form_add_technician').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_technician").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_technician"));
			urls =base_url+"service/operation_ticket_technician";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
		                }else{
		                	$("#btn_submit_technician").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_add_technician').data('bootstrapValidator').resetForm(true);//Reseting user form
							dataTableManageRequest = $('#dataTableManageRequest').DataTable();
							dataTableManageRequest.draw();
							dataTableManageRequest.clear();
							$('#technician_mapping').modal('hide');
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        cmb_technician: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});