	$(function(){
	 	var urls =base_url+"service/get_closed_suspended/get_all_closed_suspended";
	 	jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_closeSuspend_token : $('#csrf_closeSuspend_token').val(),cmb_vendor:$("#cmb_vendor").val(),cmb_scheme :$("#cmb_scheme").val(),cmb_ticket_status:$("#cmb_ticket_status").val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.ticket_id,arr.customer_name,arr.customer_address,arr.scheme_name,arr.supplier_name,arr.close_date,arr.no_of_days_open];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Ticket No','Consumer','Consumer Address','Scheme Name','Vendor Name','Close Date','No of Days Open']};
	        }
	    });
	 	var manage_request = $('#dataTableCloseSuspend').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"scrollY": 400,
		   	"scrollX": true,
		 	"bLengthChange": true,
		   	"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
		 	
		 	//"dom": 'Bfrtip',
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Closed Or Suspended Tickets ',
					header:true,
					title: 'Closed/Suspended Tickets',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_closeSuspend_token = $("#csrf_closeSuspend_token").val();
			       	data.cmb_vendor 			 = $("#cmb_vendor").val();
			       	data.cmb_scheme 			 = $("#cmb_scheme").val();
			       	data.cmb_ticket_status 		 = $("#cmb_ticket_status").val();
			       	data.page 					 = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "ticket_id","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "customer_name","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "customer_address","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "close_date","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "no_of_days_open","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "ticket_status","sWidth": "10%","sClass":"alignCenter"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	 
		});
	});
 	
	$('#btn_search').click(function(){
		manage_request = $('#dataTableCloseSuspend').DataTable();
		manage_request.draw();
		manage_request.clear();
	});
	$('#btn_reset').click(function(){
		$("#cmb_vendor").val('');
		$("#cmb_scheme").val('');
		$("#cmb_ticket_status").val('');
		manage_request = $('#dataTableCloseSuspend').DataTable();
		manage_request.draw();
		manage_request.clear();
	});