 	$(function(){
	 	getInstallationClass();
	 	get_component_list();	
	});
 
 	function getInstallationClass(){
		var urls =base_url+"service/get_installation/get_installation";
		var installation_class = $('#dataTableInstallation').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-xs-4 btn_add'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row'<'col-xs-5' i>>><'col-xs-6'p>>",
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_installationToken = $("#csrf_installationToken").val();
			       	data.page ='';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "class_name","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "short_name","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "type","sWidth": "30%","sClass":"alignCenter"},
				{"sName": "button",data:null,"sWidth": "20%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-success  btn-circle tooltipTable' onclick='btnInstallationView(event)' title='View Details'><i class='fa fa-eye'></i></button>\
					<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnInstallationEdit(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	       
		});
		$("div.btn_add").html('<button class="btn btn-primary tooltipTable btn-circle" title="Add"  title="Add"  onclick="btnInstallationClass()" data-backdrop="static" data-keyboard="false" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
	}
   
  	
	
   
    /***Form Validation Installation Class***/
    $('#form_add_installation_class').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_add_installation_class"));
			urls =base_url+"service/operation_installation_class";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
		                	dataTableInstallation = $('#dataTableInstallation').DataTable();
							dataTableInstallation.draw();
							dataTableInstallation.clear();
							$('#add_installation_modal').modal('hide');
	
		                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_add_installation_class').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtClassName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtDescription: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtShortName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmbType: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }	
	});
	
	function get_component_list(){
		$.ajax({
			url: base_url+"service/get_all_component",
			type:"POST",
			data:{op_type:'get_component_list'},
			success:function(response){
				//console.log(response);
				var options = "";
				var res1 = JSON.parse(response); 
				for (var i = 0; i < res1.length; i++) {
					options = options + "<option value='"+res1[i].id+"' >"+res1[i].component_name+"</option>";
				}
				$('#cmb_component').html("");  
				$('#cmb_component').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	function btnInstallationView(event){
		var oTable = $('#dataTableInstallation').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var installtion_id = oTable.fnGetData(row)['id'];
		installationView(installtion_id);
	}
	function installationView(installtion_id){
		var urls =base_url+"service/view_installation_details";
		$.ajax({
			url : urls,
			method : 'POST',
			data : {installtion_id:installtion_id},
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewInstallationDetails").html("");
						$("#viewInstallationDetails").append(obj.data);
						$("#table_component").html("");
						$("#table_component").append(obj.data1);
	                	$("#view_installation_class").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	
	function btnInstallationEdit(event){
		$("#spanInstallation")[0].innerHTML = "Edit Installation";
		$('#form_add_installation_class').data('bootstrapValidator').resetForm(true);
		$("#form_add_installation_class input[name='op_type']").val("UPDATE_INSTALLATION_CLASS");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Update");
		var oTable = $('#dataTableInstallation').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$("#hid_installation_id").val(oTable.fnGetData(row)['id']);
		$("#txtClassName").val(oTable.fnGetData(row)['instal_cls_name']);
		$("#txtDescription").val(oTable.fnGetData(row)['description']);
		$("#txtShortName").val(oTable.fnGetData(row)['short_name']);
		$("#cmbType").val(oTable.fnGetData(row)['type']);
		getComponentList(oTable.fnGetData(row)['id']);
		$("#add_installation_modal").modal({backdrop: 'static',keyboard: false});
	}
	
	function btnInstallationClass(){
		$('#cmb_component').val('').trigger("change");
		//$("#cmb_component option").removeAttr("selected");
		$("#spanInstallation")[0].innerHTML = "Add Installation";
		$("#form_add_installation_class input[name='op_type']").val("ADD_INSTALLATION_CLASS");
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_add_installation_class').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_installation_modal").modal({backdrop: 'static',keyboard: false});
	}
	
	function form_reset(){
		$('#cmb_component').val('').trigger("change");
		$('#form_add_installation_class').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add Block");
		$("#spanInstallation")[0].innerHTML = "Add Installation";
		$("#form_add_installation_class input[name='op_type']").val("ADD_INSTALLATION_CLASS");
	}
	
	/*function installation_modal(){
		$("#cmb_component").html('');
		$("#spanInstallation").html('Add Installation');
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_add_installation_class').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_installation_modal").modal({backdrop: 'static',keyboard: false});
	}	
	*/
	function getComponentList(installation_id){
		$.ajax({
			url: base_url+"service/getComponentList",
			type:"POST",
			data:{op_type:'get_component',installation_header_id:installation_id},
			success:function(response){
				var res_data = JSON.parse(response); 
				var selected_value_array = new Array();
				for(var i=0;i<res_data.length;i++){
					selected_value_array.push(res_data[i].component_id);
				}
				$("#cmb_component").val(selected_value_array);
				$("#cmb_component").select2(selected_value_array);
				
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
 		});
	}
	
	