 	$(document).ready(function() {
	 	getAdminDepartment();
	});
 	function getAdminDepartment(){
		var urls =base_url+"service/get_admin_department/get_admin_department";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_admindepartmentToken : $('#csrf_admindepartmentToken').val()},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.admin_dept_code,arr.dept_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Dept Code','Admin Department Name']};
	        }
	    });
		var admin_department = $('#dataTableAdmin').DataTable({
		 	"processing": true, //Feature control the processing indicator.
		    "serverSide": true, //Feature control DataTables' server-side processing mode.
		    "bDestroy": true,
		    "paging":   true,
		    "info":     true,
		    "autoWidth": false,
		    "responsive":true,
		   	"searching":true,
		   	"bLengthChange": true,
			"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Admin Department',
					header:true,
					title: 'Admin Department',
					extension: '.xls'
				}
			],
			"ajax": {
			    "url": urls,
			    "type": "POST",
			    "data": function(data) {
			       	data.csrf_admindepartmentToken = $("#csrf_admindepartmentToken").val();
			       	data.page = '';
			    }
			},
			"columns": [
				{"sName": "sl_no","sWidth": "5%","sClass":"alignCenter"},
				{"sName": "department_code","sWidth": "20%","sClass":"alignCenter"},
				{"sName": "department_name","sWidth": "50%","sClass":"alignCenter"},
				{"sName": "button",data:null,"sWidth": "10%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-success btn-circle tooltipTable' onclick='btndepartmentView(event)' title='View Details'><i class='fa fa-eye'></i></button>\
					<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='btnDepartmentEdit(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
				
			], 
			"fnDrawCallback": function(oSettings, json) {
			 	$('.tooltipTable').tooltipster({
			     	theme: 'tooltipster-punk',
			  		animation: 'grow',
			    	delay: 200, 
			     	touchDevices: false,
			     	trigger: 'hover'
				});          
			}	           
		});
	}
    
    $('#form_admin_department').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        //invalid: 'glyphicon glyphicon-remove',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator,form,submitButton){
			$("#btn_submit_admin_department").html('<i class="fa fa-gear fa-spin"></i> Loading...');
			var formData = new FormData(document.getElementById("form_admin_department"));
			urls =base_url+"service/operation_admin_department";//add_admin_department
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Submit");
		                   	toastr.warning(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                	$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Submit");
		                } else {
		                	dataTableAdmin = $('#dataTableAdmin').DataTable();
							dataTableAdmin.draw();
							dataTableAdmin.clear();
							$('#add_admin_department_modal').modal('hide');
		                	$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Submit");
							$('#form_admin_department').data('bootstrapValidator').resetForm(true);//Reseting user form
							toastr.success(obj.msg);
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:
	    {
	        txtDepartmentCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtDepartmentName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtContactName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtAddressOne: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtPinCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                numeric: {
	                    message: 'Only numbers allowed'
	                },
	                regexp: {
                        regexp: /^\d{6}$/,
                        message: 'Pincode must contain 6 digits'
                    }
	            }
	        },
	        txtEmail: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                emailAddress: {
	                    message: 'The value is not a valid email address'
	                }
	            }
	        },
	        txtPhoneOne: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
                        regexp: /^[1-9][0-9]{0,9}$/,
                        message: "Invalid Mobile Number"
            		}
	            }
	        },
	        txtStateContactName: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtStateAddressOne: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txtStatePinCode: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                numeric: {
	                    message: 'Only numbers allowed'
	                }
	            }
	        }, 
	        txtStateEmail: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                emailAddress: {
	                    message: 'The value is not a valid email address'
	                }
	            }
	        },
	        txtStatePhoneOne: {				
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                },
	                regexp: {
                        regexp: /^[1-9][0-9]{0,9}$/,
                        message: "Invalid Mobile Number"
            		}
	            }
	        }
	    }	
	});
	
	$("#checkboxState").click(function(){
	    var contact = $("#txtContactName").val();
	    var txtAddressOne = $("#txtAddressOne").val();
	    var txtAddressTwo = $("#txtAddressTwo").val();
	    var txtAddressThree = $("#txtAddressThree").val();
	    var txtPinCode = $("#txtPinCode").val();
	    var txtWww = $("#txtWww").val();
	    var txtEmail = $("#txtEmail").val();
	    var txtPhoneOne = $("#txtPhoneOne").val();
	    var txtPhoneTwo = $("#txtPhoneTwo").val();
	    var txtPhoneThree = $("#txtPhoneThree").val();
	   	if($(this).prop('checked') == true){
	   		$("#txtStateContactName").val(contact);
		    $("#txtStateAddressOne").val(txtAddressOne);
		    $("#txtStateAddressTwo").val(txtAddressTwo);
		    $("#txtStateAddressThree").val(txtAddressThree);
		    $("#txtStatePinCode").val(txtPinCode);
		    $("#txtStateWww").val(txtWww);
		    $("#txtStateEmail").val(txtEmail);
		    $("#txtStatePhoneOne").val(txtPhoneOne);
		    $("#txtStatePhoneTwo").val(txtPhoneTwo);
		    $("#txtStatePhoneThree").val(txtPhoneThree);
	   	}else{
			$("#txtStateContactName").val('');
		    $("#txtStateAddressOne").val('');
		    $("#txtStateAddressTwo").val('');
		    $("#txtStateAddressThree").val('');
		    $("#txtStatePinCode").val('');
		    $("#txtStateWww").val('');
		    $("#txtStateEmail").val('');
		    $("#txtStatePhoneOne").val('');
		    $("#txtStatePhoneTwo").val('');
		    $("#txtStatePhoneThree").val('');
		}
	    
	});
	
	function btndepartmentView(event){
		var oTable = $('#dataTableAdmin').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var deparment_id = oTable.fnGetData(row)['pk_dept_code'];
		view_adminDepartment(deparment_id);
	}
	
	function view_adminDepartment(department_id){
		var urls =base_url+"service/view_admindepartemnt_details/"+department_id;
		$.ajax({
			url : urls,
			method : 'POST',
			cache: false,
	        contentType: false,
	        processData: false,
			success : function(response){
				try {
	                var obj = JSON.parse(response);
	                if(obj.status == true){
	                	$("#viewAdminDetails").html("");
						$("#viewAdminDetails").append(obj.data);
	                	$("#view_admin_department").modal({backdrop: 'static',keyboard: false});
					}else{
						toastr.warning(obj.data);
					}
	            } catch (e) {
	                toastr.error("Sorry",'Unable to Save.Please Try Again !', "error");
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	
	function btnDepartmentEdit(event){
		$('#form_admin_department').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#txtWww").val('');
		$("#txtStateWww").val('');
		$("#spanAdminDepartment")[0].innerHTML = "Edit Admin Department";
		$("#form_admin_department input[name='op_type']").val("UPDATE_ADMIN_DEPARTMENT");
		$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Update");
		
		var oTable = $('#dataTableAdmin').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
			
		$("#hidadmin_id").val(oTable.fnGetData(row)['pk_dept_code']);
		$("#txtDepartmentCode").val(oTable.fnGetData(row)['admin_dept_code']);
		$("#txtDepartmentName").val(oTable.fnGetData(row)['dept_name']);
		
		$("#txtContactName").val(oTable.fnGetData(row)['reg_contact_name']);
	    $("#txtAddressOne").val(oTable.fnGetData(row)['reg_add1']);
	    $("#txtAddressTwo").val(oTable.fnGetData(row)['reg_add2']);
	    $("#txtAddressThree").val(oTable.fnGetData(row)['reg_add3']);
	    $("#txtPinCode").val(oTable.fnGetData(row)['reg_pin']);
	    $("#txtWww").val(oTable.fnGetData(row)['reg_www']);
	    $("#txtEmail").val(oTable.fnGetData(row)['reg_email']);
	    $("#txtPhoneOne").val(oTable.fnGetData(row)['reg_ph1']);
	    $("#txtPhoneTwo").val(oTable.fnGetData(row)['reg_ph2']);
	    $("#txtPhoneThree").val(oTable.fnGetData(row)['reg_ph3']);
	   
	    $("#txtStateContactName").val(oTable.fnGetData(row)['st_contact_name']);
	    $("#txtStateAddressOne").val(oTable.fnGetData(row)['st_add1']);
	    $("#txtStateAddressTwo").val(oTable.fnGetData(row)['st_add2']);
	    $("#txtStateAddressThree").val(oTable.fnGetData(row)['st_add3']);
	    $("#txtStatePinCode").val(oTable.fnGetData(row)['st_pin']);
	    $("#txtStateWww").val(oTable.fnGetData(row)['st_www']);
	    $("#txtStateEmail").val(oTable.fnGetData(row)['st_email']);
	    $("#txtStatePhoneOne").val(oTable.fnGetData(row)['st_ph1']);
	    $("#txtStatePhoneTwo").val(oTable.fnGetData(row)['st_ph2']);
	    $("#txtStatePhoneThree").val(oTable.fnGetData(row)['st_ph3']);
		$("#add_admin_department_modal").modal({backdrop: 'static',keyboard: false});
	}
	
	$("#btnAdminDepartment").click(function(){
		$("#txtWww").val('');
		$("#txtStateWww").val('');
		$("#txtAddressTwo").val('');
		$("#txtAddressThree").val('');
		$("#txtPhoneTwo").val('');
		$("#txtPhoneThree").val('');
		$("#txtStateAddressTwo").val('');
		$("#txtStateAddressThree").val('');
		$("#txtStatePhoneTwo").val('');
		$("#txtStatePhoneThree").val('');
		$("#spanAdminDepartment").html('Add Admin Department');
		$("#btn_submit_admin_department").html("<i class='fa fa-paper-plane'></i> Submit");
		$('#form_admin_department').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_admin_department_modal").modal({backdrop: 'static',keyboard: false});
	});