 	var urls =base_url+"service/get_attribute_master";
	var dtblAttributeMaster = $('#dtblAttributeMaster').dataTable({
		"processing": true, //Feature control the processing indicator.
	    "serverSide": true, //Feature control DataTables' server-side processing mode.
	    "bDestroy": true,
	    "paging":   true,
	    "info":     true,
	    "autoWidth": false,
	    "responsive":true,
	   	"searching":true,
	   	"bLengthChange": true,
	   "sDom":"<'row'<'col-xs-4 btn_attribute_modal'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row'<'col-xs-5' i>>><'col-xs-6'p>>",
	 	//"dom": 'Bfrtip',
		"ajax":{
			"url": urls,
			"type": "POST",
			"data": function (data){
		    	data.csrf_attribute_table_token = $('#csrf_attribute_table_token').val();
		    	data.Op_Type = 'get_attribute_master';
		    }
		},
		"columns": [
			{"sName": "sl_no","sClass":"alignCenter"},
			{"sName": "attribute_code","sClass":"alignCenter"},
			{"sName": "attribute_name","sClass":"alignCenter"},
			{"sName": "serial_no","sClass":"alignCenter"},
			{"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-primary btn-circle tooltipTable tooltipstered' align='center' onclick='btn_edit_attribute_data(event);' title='Edit'><i class='fa fa-pencil-square-o'></i></button>"}
		],
		"fnDrawCallback": function(oSettings, json){
		    $('.tooltipTable').tooltipster({
			    theme: 'tooltipster-punk',
			    animation: 'grow',
			    delay: 200, 
			    touchDevices: false,
			    trigger: 'hover'
		    });          
		}
	});
 	
 	$("div.btn_attribute_modal").html('<button class="btn btn-info tooltipTable btn-circle" title="Add" onclick="form_reset()" ><i class="fa fa-plus" aria-hidden="true"></i></button>');
		
 	
	$('#form_attribute_master').bootstrapValidator({
	    message: 'This value is not valid',
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton) {
			$("#btn_submit_attribute").html("<i class='fa fa-spinner fa-spin'></i>Loading");
			var formData = new FormData(document.getElementById("form_attribute_master"));
			urls =base_url+"service/operation_attribute";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                }else{
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	dtblAttributeMaster = $('#dtblAttributeMaster').DataTable();
		                	dtblAttributeMaster.draw();
		                	dtblAttributeMaster.clear();
		                	$('#attribute_modal').modal('hide');
							$('#form_attribute_master').data('bootstrapValidator').resetForm(true);//Reseting user form
		                	toastr.success(obj.msg);
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					alert(err);
					toastr.error("unable to save");
				}
			});
        },
		fields: {
	        txtAttributeCode: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
           txtAttributeName: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
	    }
    });
    
    function form_reset(){
    	$('#form_attribute_master').data('bootstrapValidator').resetForm(true);//Reseting user form
    	$('#txtAttributeCode').attr('readonly', false);
    	$("#spanAttribute")[0].innerHTML = "Add Attribute";
		$("#btn_submit_attribute").html("<i class='fa fa-paper-plane'></i> Submit");
		$("#form_attribute_master input[name='op_type']").val("ADD_ATTRIBUTE");
		$("#attribute_modal").modal({backdrop: 'static',keyboard: false});
	}
    function btn_edit_attribute_data(event){
    	$('#form_attribute_master').data('bootstrapValidator').resetForm(true);
	    $("#spanAttribute")[0].innerHTML ="Edit Attribute";
	    $("#form_attribute_master input[name='op_type']").val("UPDATE_ATTRIBUTE");
	    $("#btn_submit_attribute").html("<i class='fa fa-paper-plane'></i>Update");
		var oTable = $('#dtblAttributeMaster').dataTable();
		//alert();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var txtAttributeCode           = oTable.fnGetData(row)['attribute_code'];
		var txtAttributeName    = oTable.fnGetData(row)['attribute_name'];
		
		$('#txtAttributeCode').val(txtAttributeCode).attr('readonly', true);
		$("#txtAttributeName").val(txtAttributeName);
		$("#attribute_modal").modal({backdrop: 'static',keyboard: false});
    }
   
    
   