	$( document ).ready(function() {
    	var urls =base_url+"service/get_village_against_vendor_data/village_against_vendor_data";
		var dataTableLinkVendorVillage = $('#dataTableLinkVendorVillage').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollY": 400,
		   	"scrollX": false,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_vendorVillage_token = $('#csrf_vendorVillage').val();
			    }
			},
			"sDom":"<'row'<'col-xs-2 btn_circle_modal'><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "scheme_name","sClass":"alignLeft"},
				{"sName": "supplier_name","sClass":"alignLeft"},
		       	{"sName": "button","sClass" : "alignCenter","sWidth":"15%","mRender": function( data,type,full){
			       		if(role == 'VENDOR'){
							str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='viewVendorVillageData(event);' title='View' ><i class='fa fa-eye'></i></button>";
						}else{
							str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='viewVendorVillageData(event);' title='View' ><i class='fa fa-eye'></i></button>\
							<button type='button' class='btn btn-primary btn-circle tooltipTable tooltipstered' align='center' onclick='editVendorVillageData(event);' title='Edit' ><i class='fa fa-pencil-square-o'></i></button>";
						}
						return str;
		       		}
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		  	
		});
		if(role == 'CRCADMIN' || role == 'CRCAGENT' || role == 'ODA'){
			$("div.btn_circle_modal").html('<button class="btn btn-info tooltipTable btn-circle" title="Add"  onclick="btnVendorVillageMap()";><i class="fa fa-plus" aria-hidden="true"></i></button>');
		}
		
		
		$('a[data-toggle="tab"]').on('shown.bs.tab', function(e){
	    	$($.fn.dataTable.tables(true)).DataTable().columns.adjust();
		});
		
	});
 
 	
 	function btnVendorVillageMap(){
 		var table = $("#table_id").DataTable().clear().destroy();
		$('#form_link_vendor_village').data('bootstrapValidator').resetForm(true);//Reseting user form
		$("#add_linkVendorVillage_modal").modal({backdrop: 'static', keyboard: false});
	}
 	
 	function viewVendorVillageData(event){
 		var oTable = $('#dataTableLinkVendorVillage').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var supp_code = oTable.fnGetData(row)['supplier_code'];
		var scheme_id = oTable.fnGetData(row)['scheme_id'];
	
		window.location.href = base_url+"vendor-village-view/"+encodeURIComponent(btoa(supp_code))+"/"+encodeURIComponent(btoa(scheme_id));
		
	}
	
	function editVendorVillageData(event){
 		var oTable = $('#dataTableLinkVendorVillage').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var supp_code = oTable.fnGetData(row)['supplier_code'];
		var scheme_id = oTable.fnGetData(row)['scheme_id'];
		window.location.href = base_url+"vendor-village-edit/"+encodeURIComponent(btoa(supp_code))+"/"+encodeURIComponent(btoa(scheme_id));
	}
 
 	function get_district_data(sl_no){
		$.ajax({
			url: base_url+"service/get_dist_dropdown",
			type:"POST",
			data:{op_type:'get_dist_name',state_code : 21},
			success : function(response){
				try{
	                var obj = JSON.parse(response);
	                var options = "<option value=''>Select</option>";
					for (var i = 0; i < obj.length; i++) {
						options = options + "<option value='"+obj[i].district_code+"'>"+obj[i].district_name+"</option>";
					}
					$('#cmb_district'+sl_no+'').html("");  
					$('#cmb_district'+sl_no+'').append(options);
	            } catch (e) {
	            	toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	function getBlock(selected_dist_code,block_sl_no){
		$.ajax({
			url: base_url+"service/get_block_dropdown",
			type:"POST",
			data:{op_type:'get_block_name',dist_code : selected_dist_code},
			success : function(response){
				try{
	                var obj = JSON.parse(response);
	                var options = "<option value=''>Select</option>";
					for (var i = 0; i < obj.length; i++) {
						options = options + "<option value='"+obj[i].block_code+"'>"+obj[i].block_name+"</option>";
					}
					$('#cmb_block'+block_sl_no+'').html("");  
					$('#cmb_block'+block_sl_no+'').append(options);
	            } catch (e) {
	            	toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	
	function getGp(selected_block_code,gp_sl_no){
		$.ajax({
			url: base_url+"service/get_gp_dropdown",
			type:"POST",
			data:{op_type:'get_gp_name',block_code : selected_block_code},
			success : function(response){
				try{
	                var obj = JSON.parse(response);
	                var options = "<option value=''>Select</option>";
					for (var i = 0; i < obj.length; i++) {
						options = options + "<option value='"+obj[i].pk_gp_code+"'>"+obj[i].gp_name+"</option>";
					}
					$('#cmb_grampanchayat'+gp_sl_no+'').html("");  
					$('#cmb_grampanchayat'+gp_sl_no+'').append(options);
	                
	            } catch (e) {
	            	toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
	}
	function getVillage(selected_gp_code,village_sl_no){
		$.ajax({
			url: base_url+"service/get_village_dropdown",
			method : 'POST',
			data:{op_type:'get_village_dropdown',gp_code : selected_gp_code},
			success : function(response){
				try{
	                var obj = JSON.parse(response);
	                var options = "<option value=''>Select</option>";
					for (var i = 0; i < obj.length; i++) {
						options = options + "<option value='"+obj[i].pk_village_code+"'>"+obj[i].village_name+"</option>";
					}
					$('#cmb_village'+village_sl_no+'').html("");  
					$('#cmb_village'+village_sl_no+'').append(options);
	                
	            } catch (e) {
	            	toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
		
	}
	
	//The below function is used for checking duplicate data at the time of selecting village to map against vendor and scheme
	
	function checkDuplicateData(selected_village_code,village_drp_sl_no){
		var selected_vendor_value = $('#cmb_vendor').val();
		var selected_scheme_value = $('#cmb_scheme').val();
		$.ajax({
			url: base_url+"service/check_duplicate_village_data",
			method : 'POST',
			data:{op_type:'get_duplicate_data_status',selected_village_code_value : selected_village_code,selected_scheme :selected_scheme_value,selected_vendor_code:selected_vendor_value },
			success : function(response){
				try{
	                var obj = JSON.parse(response);
	                console.log(obj.length);
	                if(obj.length>0){
						toastr.error("The selected Village is already mapped with the selected scheme and vendor");
						$('#cmb_village'+village_drp_sl_no+'').val(""); 
					}
	              
	            } catch (e){
	            	toastr.error(e);
	            }
			},error: function(err){
				toastr.error("unable to save");
			}
		});
		
	}
 	
 	// Ends Here
	var sl_no = 1;
	
    $("#add_table_row").click(function(){
		re_assign();
		get_district_data(sl_no);
		$('#table_id').DataTable({"destroy": true,"paging":   false,"searching":false, }).row.add([
		    '<span class="serial_no">'+sl_no+'</span>', 
		   	'<div class="col-md-12"><div class="form-group"><select class="form-control" name="cmb_district[]" id="cmb_district'+sl_no+'" onchange="return getBlock(this.value,'+sl_no+');">\
					</select></div></div>', 
		   	'<div class="col-md-12"><div class = "form-group"><select class="form-control" name="cmb_block[]" id="cmb_block'+sl_no+'"  onchange="return getGp(this.value,'+sl_no+');">\
						<option>Select</option>\
					</select></div></div>', 
		   	'<div class="col-md-12"><div class="form-group"><select class="form-control" name="cmb_grampanchayat[]" id="cmb_grampanchayat'+sl_no+'" onchange="return getVillage(this.value,'+sl_no+');">\
						<option>Select</option>\
					</select>\</div></div>', 
		   	'<div class="col-md-12"><div class="form-group"><select class="form-control" name="cmb_village[]" id="cmb_village'+sl_no+'" onchange="return checkDuplicateData(this.value,'+sl_no+');">\
						<option>Select</option>\
					</select></div></div>', 
		    '<button type="button" class="btn btn-danger" id="remove_tableRow" ><i class="fa fa-trash" ></i></button>' 
		]).draw();
		re_assign();
      	sl_no++;
   	});
   
   //Remove Refund Data from table
	$('#table_id tbody').on( 'click', '#remove_tableRow', function () {
		var table_row =  $('#table_id').dataTable();
		var aPos = table_row.fnGetPosition( $(this).closest('tr').get(0));
		// Delete the row
		table_row.fnDeleteRow(aPos);
		re_assign();
	});
	
			
	function re_assign(){
		var renum = 1;
		$("tr td .serial_no").each(function(){
		  	$(this).text(renum);
		  	renum++;
		});
		sl_no = renum;
	}
	
	// on click of add/update button it will validate then submit 	
	$('#form_link_vendor_village').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons:{
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_link_vendor_village"));
			urls =base_url+"service/operation_vendor_against_village";
			$.ajax({
				url : urls,
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response)
				{
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                    toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                } else {
		                	toastr.success(obj.msg);
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
							$('#add_linkVendorVillage_modal').modal('hide');
							$('#form_link_vendor_village').data('bootstrapValidator').resetForm(true);//Reseting user form
							$("#form_link_vendor_village input[name='op_type']").val("ADD_LINK_VENDOR_VILLAGE");
		                }
		            } catch (e) {
		                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
		
	    fields:{
	        cmb_scheme: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        cmb_vendor: {							
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        txt_workOrder: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        },
	        file_document: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
		}	
	});
	
	
	
	
    