	$(function () {
		var urls =base_url+"service/get_all_transaction_details/get_all_transaction_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_trans_token : $('#csrf_trans_token').val(),cmb_scheme:$("#cmb_scheme").val(),cmb_vendor:$('#cmb_vendor').val(),cmb_installType:$("#cmb_installType").val(),cmb_district:$("#cmb_district").val(),cmb_village:$("#cmb_village").val(),view_install:''},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.consumer_id,arr.sanction_order_no,arr.finance_source,arr.supplier_name,arr.instal_cls_name,arr.work_order,arr.date_of_installation,arr.power_plant,arr.capacity,arr.India,arr.state_name,arr.district_name,arr.block_name,arr.gp_name,arr.village_name,arr.plot_no,arr.habitation,arr.landmark,arr.pincode,arr.census_code,arr.tr_gps_code,arr.dc_val,arr.mc_val,arr.scheduled_week,arr.customer_name,arr.father_name,arr.cast_cat,arr.phone1,arr.mobile1,arr.mobile2,arr.cu_email,arr.gender,arr.aadhar_no,arr.alternate_id,arr.acs,arr.parent_customer_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Scheme','Sanction Letter No','Finance Source','Vendor Name','Installation Class','Work Order/Purchase Order','Date of Installation','Power Plant','Capacity','Country','State','District','CD Block','Gram Panchayat','Revenue Village','Plot No','Area','Landmark','Pincode','Census Code','GPS Code','District Cluster','Maintenance Cluster','Scheduled Week','Customer Name','Name of Father/Spouse','Caste/Category','Landline','Mobile1','Mobile2','Email','Gender','Aadhar Card No','Alternate Id No','ACS','Parent Customer']};
	        }
	    });
		var dataTableTransaction = $('#dataTableTransaction').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollX":false,
			"responsive":false,
			"searching":true,
			"scrollY": 400,
		   	"scrollX": false,
			"sDom":"<'row'<'col-xs-2'B><'col-xs-4'i><'col-xs-2'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' >><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Transaction List',
					header:true,
					title: 'Transaction List',
					extension: '.xlsx'
				}
			],
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_trans_token 	= $('#csrf_trans_token').val();
			    	data.cmb_scheme 		= $('#cmb_scheme').val();
			    	data.cmb_vendor 		= $('#cmb_vendor').val();
			    	data.cmb_installType 	= $('#cmb_installType').val();
			    	data.cmb_district 		= $('#cmb_district').val();
			    	data.cmb_village 		= $('#cmb_village').val();
			    	data.view_install 		= '';
			    	data.page 				= '';
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter","sWidth": "10%"},
				{"sName": "customer_name","sClass":"alignLeft","sWidth": "20%"},
				{"sName": "consumer_id","sClass":"alignLeft","sWidth": "15%","visible":false},
				{"sName": "customer_address","sClass":"alignLeft","sWidth": "30%"},
				{"sName": "transaction_status_flag","sClass":"alignLeft","sWidth": "10%"},
				{"sName": "button","sClass" : "alignCenter","mRender": function( data,type,full){
			            switch(role_code){
							case 'VENDOR':
								str = "";
								if(full.tracking_installation ==1){
									str = "<button type='button' class='btn bg-purple tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Recce Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}
								if(full.tracking_installation ==2){
									str = "<button type='button' class='btn bg-orange tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Material at site Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}
								if(full.tracking_installation ==3){
									str = "<button type='button' class='btn bg-maroon  tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Installation Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ADEPT':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'OCE':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODR':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'OTO':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODA':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;\
									<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'CRCADMIN':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;";
								if(full.transaction_status_flag  == 'submitted' || full.transaction_status_flag  == 'install'){
									str += "<button type='button' class='btn btn-success btn-circle tooltipTable tooltipstered' align='center' onclick='btnEditTransactionData(event);' title='Edit Transaction' ><i class='fa fa-pencil-square-o'></i></button>&nbsp;";
								}
								if(full.transaction_status_flag == 'submitted'){
									str += "<button type='button' class='btn btn-primary btn-circle tooltipTable tooltipstered' align='center' onclick='btnApprovalProcess(event);' title='Approval Process' ><i class='fa fa-check'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>&nbsp;";
								if(full.transaction_status  != 'cancelled'){
									str +="<button type='button' class='btn btn-danger btn-circle tooltipTable tooltipstered' align='center' onclick='btnDelete(event);' title='Transaction Record Delete' style='display:none;'><i class='fa fa-trash'></i></button>";
								}
								if(full.tracking_installation ==1){
									str += "<button type='button' class='btn bg-purple tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Recce Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}
								if(full.tracking_installation ==2){
									str += "<button type='button' class='btn bg-orange tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Material at site Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}
								if(full.tracking_installation ==3){
									str += "<button type='button' class='btn bg-navy  tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Installation Status' ><i class='fa fa-map-signs'></i></button>&nbsp;";
								}	
							break;
							case 'CRCAGENT':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;";
								if(full.transaction_status_flag  == 'submitted' || full.transaction_status_flag  == 'install'){
									str += "<button type='button' class='btn btn-success btn-circle tooltipTable tooltipstered' align='center' onclick='btnEditTransactionData(event);' title='Edit Transaction' ><i class='fa fa-pencil-square-o'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>";
							break;
							case 'ODH':
								str = "<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>&nbsp;";
								if(full.transaction_status_flag  == 'Admin Approved'){
									str += "<button type='button' class='btn bg-purple tooltipTable tooltipstered' align='center' onclick='btnDhApprovalProcess(event);' title='Approval Process' ><i class='fa fa-check'></i></button>&nbsp;";
								}
								str += "<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>&nbsp;";
								if(full.tracking_installation ==4){
									str += "<button type='button' class='btn btn-success  tooltipTable tooltipstered' align='center' onclick='btnInstallationStatus(event);' title='Payment Status' ><i class='fa fa-map-signs'></i></button>";
								}
							break;
						}
						return str;
		            }  
		        }
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	});
	$('#cmb_scheme').change(function(){
	 	$.ajax({
			url: base_url+"service/get_vendor_data",
			type:"POST",
			data:{op_type:'get_vendor_data',scheme_id:$(this).val()},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].supplier_code+"' >"+res[i].supplier_name+"</option>";
				}
				$('#cmb_vendor').html("");  
				$('#cmb_vendor').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
		get_install($(this).val());
	});
	
	function get_install(scheme_id){
	 	$.ajax({
			url: base_url+"service/get_install_data",
			type:"POST",
			data:{op_type:'get_install_data',scheme_id:scheme_id},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].id+"' >"+res[i].instal_cls_name+"</option>";
				}
				$('#cmb_installType').html("");  
				$('#cmb_installType').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	};
	$('#cmb_district').change(function(){
	 	var district_code = $(this).val();
	 	$.ajax({
			url: base_url+"service/get_filter_village_data",
			type:"POST",
			data:{op_type:'get_filter_village_data',district_code:district_code},
			success:function(response){
				var options = "<option value=''>Select</option>";
				var res = JSON.parse(response); 
				for (var i = 0; i < res.length; i++) {
					options = options + "<option value='"+res[i].pk_village_code+"' >"+res[i].village_name+"</option>";
				}
				$('#cmb_village').html("");  
				$('#cmb_village').append(options);
			},error:function(){
				toastr.error('Unable to process please contact support');
			}
		});
	});
	$('#btn_search').click(function(){
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	function btnTransView(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var trans_id = oTable.fnGetData(row)['id'];
		window.open(base_url+"view-transaction-details/"+encodeURIComponent(btoa(trans_id)));
	}
	function btnApprovalProcess(event){
		$('#txt_remarks').val('');
		$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidtrans_id').val(oTable.fnGetData(row)['id']);
		$('#approval_info_modal').modal({backdrop: 'static',keyboard: false});
	}
	function btnDhApprovalProcess(event){
		$('#txt_remarks').val('');
		$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
		$('#op_type').val('add_dh_approval_information');//Reseting user form
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidtrans_id').val(oTable.fnGetData(row)['id']);
		$('#approval_info_modal').modal({backdrop: 'static',keyboard: false});
	}
	$('#form_approval_information').bootstrapValidator({
		message: 'This value is not valid',
	    feedbackIcons: 
	    {
	        valid: 'glyphicon',
	        invalid: 'glyphicon',
	        validating: 'glyphicon glyphicon-refresh'
	    },
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_approval_information"));
			$.ajax({
				url : base_url+"service/operation_approval_process",
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                } else {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		            		dataTableTransaction = $('#dataTableTransaction').DataTable();
							dataTableTransaction.draw();
							dataTableTransaction.clear();
							$('#form_approval_information').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#approval_info_modal').modal('hide');
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !');
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		},
	    fields:{
	        cmb_approval_status: {
	            validators: {
	                notEmpty: {
	                    message: 'Required'
	                }
	            }
	        }
		}	
	});
	
	function btnTransactionReport(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"transaction-report/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id']+'#'+oTable.fnGetData(row)['tr_customer_id'])));
	}
	
	function btnEditTransactionData(event){
	 	var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"edit-installations/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id'])));
	}
	
	$("#btn_filter_reset").click(function(){
		$("#cmb_vendor").val('');
		$("#cmb_scheme").val('');
		$("#cmb_installType").val('');
		$("#cmb_district").val('');
		$("#cmb_village").val('');
		dataTableTransaction = $('#dataTableTransaction').DataTable();
		dataTableTransaction.draw();
		dataTableTransaction.clear();
	});
	function btnInstallationStatus(event){
	 	var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		$('#hidtrack_trans_id').val(oTable.fnGetData(row)['id']);
		$('#hidtrack_ins').val(oTable.fnGetData(row)['tracking_installation']);
		switch(oTable.fnGetData(row)['tracking_installation']){
			case '1':
				$('#span_track').html('Racce Complete');
			break;
			case '2':
				$('#span_track').html('Material At Site');
			break;
			case '3':
				$('#span_track').html('Installation Complete');
			break;
			case '4':
				$('#span_track').html('Payment Made');
			break;
		}
		
		$('#installation_track').modal({ backdrop: 'static',keyboard: false});
	}
	$('#form_installation_track').bootstrapValidator({
		submitButtons: 'button[type="submit"]',
		submitHandler: function(validator, form, submitButton){
			var formData = new FormData(document.getElementById("form_installation_track"));
			$.ajax({
				url : base_url+"service/operation_installation_track",
				method : 'POST',
				data:formData,
				cache: false,
		        contentType: false,
		        processData: false,
				success : function(response){
					try {
		                var obj = JSON.parse(response);
		                if (obj.status == false) {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		                	toastr.error(obj.msg);
		                }else if(obj.status === 'validationerror'){
		                	$('#errorlog').html(obj.msg);
		                	$('#errorlog').show();
		                } else {
		                	$('#errorlog').html('');
		                	$('#errorlog').hide();
		            		dataTableTransaction = $('#dataTableTransaction').DataTable();
							dataTableTransaction.draw();
							dataTableTransaction.clear();
							$('#form_installation_track').data('bootstrapValidator').resetForm(true);//Reseting user form
							$('#installation_track').modal('hide');
		                }
		            } catch (e) {
		                toastr.error("Sorry",'Unable to Save.Please Try Again !');
		            }
				},error: function(err){
					toastr.error("unable to save");
				}
			});
		}
	});