	$(function () {
		var urls =base_url+"service/get_all_transaction_details/get_all_transaction_details";
		jQuery.fn.DataTable.Api.register( 'buttons.exportData()', function ( options ) {
	        if ( this.context.length ) {
	        	var dataArr = [];
	            var jsonResult = $.ajax({
	                url: urls,
	                type:'POST',
	                data:{page:"ALL",csrf_trans_token : $('#csrf_trans_token').val(),cmb_scheme:'',cmb_vendor:'',cmb_installType:'',cmb_district:'',cmb_village:'',view_install:''},
	                success: function (result) {
	                    res = jQuery.parseJSON(result);
	                    $.each(res.aaData,function(i,arr){
	                    	var objArr = [i+1,arr.scheme_name,arr.sanction_order_no,arr.finance_source,arr.supplier_name,arr.instal_cls_name,arr.work_order,arr.date_of_installation,arr.power_plant,arr.India,arr.state_name,arr.district_name,arr.block_name,arr.gp_name,arr.village_name,arr.plot_no,arr.habitation,arr.landmark,arr.pincode,arr.census_code,arr.tr_gps_code,arr.dc_val,arr.mc_val,arr.scheduled_week,arr.consumer_id,arr.customer_name,arr.father_name,arr.cast_cat,arr.phone1,arr.mobile1,arr.mobile2,arr.cu_email,arr.gender,arr.aadhar_no,arr.aadhar_no,arr.acs,arr.parent_customer_name];
	                    	dataArr.push(objArr);
	                    });
	                },
	                async: false
	            });
	            return {body: dataArr, header: ['#','Scheme','Sanction Letter No','Finance Source','Vendor Name','Installation Class','Work Order/Purchase Order','Date of Installation','Power Plant','Country','State','District','CD Block','Gram Panchayat','Revenue Village','Plot No','Area','Landmark','Pincode','Census Code','GPS Code','District Cluster','Maintenance Cluster','Scheduled Week','Customer Id','Customer Name','Name of Father/Spouse','Caste/Category','Landline','Mobile1','Mobile2','Email','Gender','Aadhar Card No','Alternate Id No','ACS','Parent Customer']};
	        }
	    });
		var dataTableTransaction = $('#dataTableTransaction').dataTable({
			"processing": true, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"scrollY": 400,
		   	"scrollX": true,
			"responsive":false,
			"searching":true,
			"sDom":"<'row'<'col-xs-4'B><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row' <'col-xs-6'i>>><'col-xs-6'p>>",
			"buttons": [
				{
					text: '<i class="fa fa-lg fa-file-excel-o" style="color:green">  Excel</i>',
					extend: 'excel',
					filename:'Transaction List',
					header:true,
					title: 'Transaction List',
					extension: '.xlsx'
				}
			],
			// Load data for the table's content from an ajax source
			"ajax":{
				"url": urls,
				"type": "POST",
				"data": function (data){
			    	data.csrf_trans_token 	= $('#csrf_trans_token').val();
			    	data.cmb_scheme 		= "";
			    	data.cmb_vendor 		= "";
			    	data.cmb_installType 	= "";
			    	data.cmb_district 		= "";
			    	data.cmb_village 		= "";
			    	data.view_install 		= '';
			    	data.page 		        = "";
			    }
			},
			//Set column definition initialisation properties.
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "customer_name","sClass":"alignLeft"},
				{"sName": "consumer_id","sClass":"alignLeft"},
				{"sName": "customer_address","sClass":"alignLeft"},
				{"sName": "transaction_status_flag","sClass":"alignCenter"},
				{
					"sName": "button",data:null,"sWidth": "10%","sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-info btn-circle tooltipTable' align='center' onclick='btnTransView(event);' title='Transaction Details view' ><i class='fa fa-eye'></i></button>\
					<button type='button' class='btn bg-maroon btn-circle tooltipTable tooltipstered' align='center' onclick='btnTransactionReport(event);' title='Transaction Report' ><i class='fa fa-pie-chart'></i></button>"
		       	}
			],
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json){
		     	$('.tooltipTable').tooltipster({
			        theme: 'tooltipster-punk',
			      	animation: 'grow',
			        delay: 200, 
			        touchDevices: false,
			        trigger: 'hover'
		      	});          
		  	}
		});
	});
	function btnTransView(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		var trans_id = oTable.fnGetData(row)['id'];
		window.open(base_url+"installation-view-details/"+encodeURIComponent(btoa(trans_id)));
	}
	
	function btnTransactionReport(event){
		var oTable = $('#dataTableTransaction').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		window.open(base_url+"transaction-report/"+encodeURIComponent(btoa(oTable.fnGetData(row)['id'])));
	}