<!DOCTYPE html>
<html class="no-js">
    <head>
        <title>Orissa Renewable Energy Development Agency</title>
		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">      
        
	</head>
	<style>
		* {padding: 0;margin: 0;}
		body {font: 10pt Courier New;color:#000000;}

		.content img {display: inline;}
		#root{padding:20px;}
		
		.text-center{text-align:center;}
		.text-right{text-align:right;}
		.text-left{text-align:left;}
		
		h1, h2, h3{color: #000000;background: none;text-decoration: none;font-weight: bold; margin-bottom:10px;}

		h1 { font-size: 13pt; }
		h2 { font-size: 11pt; margin-top: 1em; }
		h3 { font-size: 9pt; margin-top: 1em; }

		.content {line-height: 14pt;margin-bottom: 1em;	overflow: auto; width:100%;}
		
		hr {height: 0;border-top:solid 1px #ccc; border-bottom:0; border-left:0;  border-right:0;margin:10px 0;}

		ol, ul {margin-left: 15pt}

		table{width: 100%;padding-left: 5%;padding-top: 5%;}
		td, th{padding:0 5px;}
		table.dashedBorder, .dashedBorder th, .dashedBorder td{border:solid 1px #999; border-collapse: collapse; padding:3px 10px; margin-bottom:20px;}
		strong{font-size:12pt;}
		address{font-size:10pt; line-height:10pt;text-align: justify;padding-top: 5px;font-family: Times New Roman;font-style: normal;}
		.small{font-size:8pt; line-height:10pt;}	
		
		
		@media all {
			.page-break	{ display: none; }
		}

		@media print {
			.page-break	{ display: block; page-break-before: always; }
			.noPrint{display:none;}
			thead{
				display:table-header-group;/*repeat table headers on each page*/
			}
			tbody{
				display:table-row-group;  
				
			}
		}
		
		footer {
            position: fixed; 
            bottom: 0cm; 
            left: 0cm; 
            right: 0cm;
            height: 2cm;
			width: 100%;
            /** Extra personal styles **/
            color: #000;
            text-align: center;
            line-height: 1.5cm;
        } 
	</style>
	<?php
		$current_year = date('Y');
		$next_year    = date('y')+1;
		$fy           = $current_year."-".$next_year;
	?>	
	<body id="root">
		<div class="content">
			<h1 class="text-center" style="padding-top: 2%;">Service Performance Measure of (Vendor) Fy  <?php echo $fy;?></h1>
			<table class="table dashedBorder">
  				<thead>
  					<th colspan="5" class="text-center">Scheduled Maintenance</th>
  					<th colspan="5" class="text-center">Corrective Maintenance</th>
  				</thead>
  				<tbody>
  					<tr>
  						<td>1</td>
  						<td>Net Score</td>
  						<td class="text-right"><?php echo $scheduler_maintenance_score['net_score'];?></td>
  						<td>Final Score</td>
  						<td class="text-right"><?php echo $scheduler_maintenance_score['final_score'];?></td>
  						
  						
  						<td>1</td>
  						<td>Net Up time</td>
  						<td class="text-right"><?php echo $corrective_maintenance_score['req_up_time'];?></td>
  						<td>Final Score</td>
  						<td class="text-right">
  							<?php 
  								$cms = ((($corrective_maintenance_score['req_up_time'])/($corrective_maintenance_score['fin_up_time']))*20);
  								echo $res_cms = round($cms,2);
  							?>
  						</td>
  					</tr>
  					<tr>
  						<td>2</td>
  						<td>Available Score</td>
  						<td class="text-right"><?php echo $scheduler_maintenance_score['available_score'];?></td>
  						<td>Full Score</td>
  						<td class="text-right">80</td>
  						
  						<td>2</td>
  						<td>Ideal Up time</td>
  						<td class="text-right"><?php echo $corrective_maintenance_score['fin_up_time'];?></td>
  						<td>Full Score</td>
  						<td class="text-right">20</td>
  					</tr>
  					<tr>
  						<td colspan="9" class="text-right" style="font-weight: bold;">Total Rewared Score</td>
  						<td class="text-right" style="font-weight: bold;"><?php echo round(($scheduler_maintenance_score['final_score']+$res_cms),2);?></td>
  					</tr>
  					<tr>
  						<td colspan="9" class="text-right" style="font-weight: bold;">Full score for R &M</td>
  						<td class="text-right" style="font-weight: bold;">100</td>
  					</tr>
  				</tbody>
      		</table>
			<footer>
				<address class="text-left" style="padding-left: 5%;">Date:    <?php echo date("d-m-Y h:m:i A");?></address>
	            <address class="text-right"><?php echo $this->session->userdata('user_display_name');?></address>
	        </footer>
		</div>
	</body>
</html>
	
