<!DOCTYPE html>
<html class="no-js">
    <head>
        <title>Orissa Renewable Energy Development Agency</title>
		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">      
        
	</head>
	
	<style>
		@page { margin: 5px; }
		body { padding:0px; border: 1px solid black; }

		.content img {display: inline;}
		#root{padding:15px;}
		
		.text-center{text-align:center;}
		.text-right{text-align:right;}
		.text-left{text-align:left;}
		.background-image{
			background: url(<?php echo base_url();?>public/upload/logo/oreda_logo.png) no-repeat center center;
		}
		
		h1, h2, h3{color: #000000;background: none;text-decoration: none;font-weight: bold; margin-bottom:10px;}

		h1 { font-size: 13pt; }
		h2 { font-size: 11pt; margin-top: 1em; }
		h3 { font-size: 9pt; margin-top: 1em; }

		.content {line-height: 12pt;margin-bottom: 1em;	overflow: auto; width:100%;}
		
		hr {height: 0;border-top:solid 1px #ccc; border-bottom:0; border-left:0;  border-right:0;margin:10px 0;}

		ol, ul {margin-left: 15pt}

		table{width:100%;}
		td, th{padding:0 5px;}
		table.dashedBorder, .dashedBorder th, .dashedBorder td{border:solid 1px #999; border-collapse: collapse; padding:3px 10px; margin-bottom:20px;}
		strong{font-size:12pt;}
		address{font-size:9pt; line-height:10pt;text-align: justify;padding-top: 5px;width: 80%;}
		.small{font-size:8pt; line-height:10pt;}	
		
		
		@media all {
			.page-break	{ display: none; }
		}

		@media print {
			.page-break	{ display: block; page-break-before: always; }
			.noPrint{display:none;}
			thead{
				display:table-header-group;/*repeat table headers on each page*/
			}
			tbody{
				display:table-row-group;  
				
			}
		}
		
		
		.tableedit {
		    border-spacing: 0;
			text-align: center;
		}
		 .dotted_underline {    
			border-bottom: 2px dotted #000;
			text-decoration: none;
		}
		table, th, td {
		  border: 1px solid black;
		  border-collapse: collapse;
		}
		.table{
			padding-top: 3%;
			width: 95%;
			padding-left: 5%;
		}

		
	</style>	
	<body id="root">
	<?php $date = date('m/d/Y h:i:s a', time());?>
		<div class="content">
		<img class="img-rounded img-thumbnail" src="public/upload/logo/oredalogo.jpg" alt="" width="100px">
			<h1 style="text-align: center;padding-top: 0%;">SM Ticket generation report</h1>
			<p>&nbsp;</p>
			<p>Ticket generated date/time: <?= $date; ?></p>
			<p>Ticket generated by: Admin</p>
			<p>Cohorts: &nbsp;</p>
			<table>
				<tbody>
					<tr>
						<td>
							<p>Total No installations in CRMS database </p>
						</td>
						<td >
							<p align="center"><strong><?= $cohorts['total_install'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>Total No of Schemes</p>
						</td>
						<td>
							<p align="center"><strong><?= $cohorts['total_scheme'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>Total No of vendors</p>
						</td>
						<td>
							<p align="center"><strong><?=$cohorts['total_vendor'];?></strong></p>
						</td>
					</tr>
				</tbody>
			</table>
			<p>Installations:</p>
			<table>
				<tbody>
					<tr>
						<td>
							<p>No of Installation for which tickets were generated</p>
						</td>
						<td>
							<p align="center"><strong><?=$total_installation_data['total'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>No. of installations against which tickets were not generated because of various reasons</p>
						</td>
						<td>
							<p align="center"><strong><?=$total_installation_data['total_excluded_tickets'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>TOTAL</p>
						</td>
						<td>
							<p align="center"><strong><?=$total_installation_data['tot_tkt'];?></strong></p>
						</td>
					</tr>
				</tbody>
			</table>
			<p>Total Tickets by types:</p>
			<table>
				<tbody>
					<tr>
						<td>
							<p>No of Quarterly tickets generated</p>
						</td>
						<td>
							<p align="center"><strong><?= $total_ticket_type['quaterly'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>No of Half yearly tickets generated</p>
						</td>
						<td>
							<p align="center"><strong><?= $total_ticket_type['half_yearly'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>No of Annual tickets generated</p>
						</td>
						<td>
							<p align="center"><strong><?= $total_ticket_type['yearly'];?></strong></p>
						</td>
					</tr>
					<tr>
						<td>
							<p>Total No of Tickets generated</p>
						</td>
						<td>
							<p align="center"><strong><?= $total_ticket_type['total'];?></strong></p>
						</td>
					</tr>
				</tbody>
			</table>
			<p style="page-break-after: always;">&nbsp;</p>
			<p><strong><strong>CRC Comments: </strong></strong></p>
			<table>
				<tbody>
					<tr>
						<td>
						<p>1.&nbsp;&nbsp;The Installation database in as-is condition used for generation of tickets for this month.</p>
						<p>2.&nbsp;&nbsp;As the vendors are unprepared with document, technicians and a plan for this kind of exercise, all installations are considered without any bias or validation with regard to many factors like availability of installation ID, working status and the likes.</p>
						<p>3.&nbsp;&nbsp;As the vendors were not fully prepared with their micro plans, the tickets instead of targeting the Scheduled Week has considered the full month to give operational freedom to iterate their routes and installation sequence.</p>
						<p>4.&nbsp;The same principle will also be adopted for the rest of the months in this quarter. But it&rsquo;s necessary that the vendors work with sincerity this and every next month so that they would have gathered enough experience to course correct when they will visit the same place on the first month in the next quarter.</p>
						<p>&nbsp;</p>
						</td>
					</tr>
				</tbody>
			</table>
			<p>&nbsp;</p>
			<p>&nbsp;</p>
			<p>The Vendor wise breakup of SM tickets is enclosed in the annexure. This detail is given for your information and necessary action.</p>
			<p >&nbsp;</p>
			<p>&nbsp;</p>
			<p>&nbsp;</p>
			<p style="page-break-after: always;">&nbsp;</p>
			<p><strong><u><strong>ANNEXURE</strong></u></strong></p>
			<p><strong><strong>&nbsp;</strong></strong></p>
			<table>
				<thead >
					<tr>
						<th >Vendor code</th>
						<th >
						Vendor Name
						</th>
						<th >
						SM Ticket Count
						</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach($total_vendor_data as $data):?>
            		<tr>
            			<td><?= $data['supplier_code'] ;?></td>
            			<td><?= $data['supplier_name'] ;?></td>
            			<td><?= $data['total'] ;?></td>
            		</tr>
            		<?php endforeach; ?>
				</tbody>
			</table>
			<p>&nbsp;</p>
			
			<p>Regards</p>
			<p>Team Leader</p>
			<p>OREDA, CRC</p>
			<p>1800-345-7135</p>
			<p>&nbsp;</p>
			<p>&nbsp;</p>
			<p><strong><strong>&nbsp;</strong></strong></p>
		</div>
	</body>
</html>
	
