<div class="content-wrapper" id="root">
	<section class="content-header">
      	<h1>Manage User</h1>
      	<ol class="breadcrumb">
        	<li><a href="#"><i class="fa fa-gears"></i> Setting</a></li>
        	<li class="active"><a href="#"><i class="fa fa-server"></i>Manage User</a></li>
        </ol>
	</section>
	<section class="content">
		<div class="row">
        	<div class="col-xs-12 col-sm-12 col-md-12">
        		<div class="box">
            		<div class="box-body">
						<div class="col-lg-12">
			              	<table id="user_table" class="table table-bordered table-hover">
			              		<input type="hidden" id="csrf_user_token" name="csrf_user_token" value="<?php echo generateToken('user_table'); ?>">
				                <thead>
					                <tr>
					                  	<th> # </th>
					                 	<th hidden>User Code</th>
					                 	<th>User Name</th>
					                 	<th>Display Name</th>
					                 	<th>Email Id</th>
					                 	<th>Contact No</th>
										<th hidden>Password</th>
										<th hidden>Profile Image</th>
										<th>Status</th>
										<th>Action</th>
					                </tr>
				                </thead>
				                <tbody>
					               
					           </tbody>
			              	</table>
            			</div>
            		</div>
            	</div>
          	</div>
          	<div class="modal fade" id="manage_user_modal" role="dialog" >
				<div class="modal-dialog">
			      	<div class="modal-content">
			      		<div class='modal-header'>
				          	<button type='button' class='close' data-dismiss='modal'>&times;</button>
				          	<h4 class='modal-title' style='text-align: center;'><span id="spanuser" >Add User</span></h4>
				        </div>
				        <?php echo form_open(null, array('id'=>'frm_user' ,'enctype'=>"multipart/form-data")); ?>
					        <div class='modal-body' style="height: auto">
		                     	<div class="box-body">
			            			<div id="errorlog" style="display: none; color: red; font-size: 9px;"></div>
				             		<input type="hidden" id="op_type" name="op_type" value="admin_user_create">
						            <input type="hidden" id="hiduser_code" name="hiduser_code">
						            <input type="hidden" name="csrf_add_user_token" value="<?php echo generateToken('frm_user'); ?>">
									<div class="row">
										<div class="col-md-12">
											<div class="form-group col-md-6">
												<label >User Name :</label>
												<input type="text" class="form-control" name="txtUserName" id="txtUserName" placeholder="User Name" value="" required="" autocomplete="off">
												<input type="hidden" id="hiduser_name" name="hiduser_name" value="">
											</div>
											<div class="form-group col-md-6">
												<label >Display Name :</label>
												<input type="text" class="form-control" name="txtDisplayName" id="txtDisplayName" placeholder="Display Name" value="" required="" autocomplete="off">
											</div>
										</div>
										<div class="col-md-12">
											<div class="form-group col-md-6">
												<label >Email Id :</label>
												<input type="text" class="form-control" name="txtEmailId" id="txtEmailId" placeholder="Email Id" value="" required="" autocomplete="off">
											</div>
											<div class="form-group col-md-6">
												<label >Contact Number :</label>
												<input type="text" class="form-control" name="txtPhoneNumber" id="txtPhoneNumber" placeholder="Mobile Number" value="" required="" autocomplete="off">
											</div>
										</div>
										<div class="col-md-12">
											<div class="form-group col-md-6">
												<label>Role Group </label><br>
												<select class="form-control" id="cmbRoleGroup" name="cmbRoleGroup">
													<option value="">select</option>
							            			<?php if (isset($get_role_group) && !empty($get_role_group)):
		                                    			foreach ($get_role_group as $row):
		                                    		?> 
	                                        			<option  value="<?php echo $row['role_group_code']; ?>"><?php echo $row['name'] ?></option>
					                                <?php
					                                    endforeach;
					                                endif;
					                                ?>
					            				</select>
											</div>
											<div class="form-group col-md-6">
												<label >Status:</label>
												<select class="form-control" id="user_status" name="user_status">
								                 	<option value="">select</option>
								                  	<?php foreach ($this->config->item('status') as $key=>$status): ?>
														<option value="<?php echo $key; ?>"><?php echo $status; ?></option>
													<?php endforeach; ?>
								                </select>
											</div>
										</div>
										<div class="box-footer with-border">
								          	<div class="box-tools pull-right">
								          		<button type="submit" class="btn bg-olive btn-flat" id="btn_submit"><i class='fa fa-paper-plane'></i> Add</button>
								          		<button type="button" class="btn btn-default" id="button_reset" onclick="form_reset();"><i class="fa fa-refresh"></i> Reset</button>
								          	</div>
								        </div>
									</div>
								</div>
					        </div>
				    	</form>  
			      	</div>
			    </div>
			</div>
      	</div>
	</section>
</div>
<script> base_url = "<?php echo base_url(); ?>"; </script>
<script type="text/javascript" language="javascript">
		/*
	 * Author: Debashish Jyotish
	 * Date: 24/01/2018
	 * Description : This is used for user creation (manage_user.php).
	 * 
	 **/
	var urls =base_url+"service/get_admin_user_data/get_admin_user_data";
		var user_table = $('#user_table').dataTable({
			"processing": false, //Feature control the processing indicator.
			"serverSide": true, //Feature control DataTables' server-side processing mode.
			"destroy": true,
			"paging":   true,
			"info":     true,
			"autoWidth": false,
			"responsive":false,
			"searching":true,
			// Load data for the table's content from an ajax source
			"ajax":
			{
				"url": urls,
				"type": "POST",
				"data": function (data){
		    		data.menu_role = $('#cmbMenuRole').val();
		    		data.csrf_user_token = $('#csrf_user_token').val();
		    	}
			},
			"sDom":"<'row'<'col-xs-4 btn_user_modal'><'col-xs-4'l><'col-xs-4'f>r>t<'row'<'col-xs-6' <'row'<'col-xs-5' i>>><'col-xs-6'p>>",
			"columns": [
				{"sName": "sl_no","sClass":"alignCenter"},
				{"sName": "user_code","bVisible":false,"sClass":"alignCenter"},
				{"sName": "user_name","sClass":"alignLeft"},
				{"sName": "display_name","sClass":"alignLeft"},
				{"sName": "email","sClass":"alignLeft"},
				{"sName": "phone_number","sClass":"alignCenter"},
				{"sName": "password","bVisible":false,"sClass":"alignCenter"},
				{"sName": "prof_img","bVisible":false,"sClass":"alignCenter",
					"mRender": function(data,type,full){
		       			return "<img src='"+base_url+data+"' width='30'>";
		       		}
		       	},
				{"sName": "status","sClass" : "alignCenter",
		            "mRender": function( data,type,full){
		                return '<img src="'+base_url+'public/custom/photos/'+data+'.png" />';
		            }  
		        },
		        {"sName": "button",data:null,"sClass" : "alignCenter","sDefaultContent":"<button type='button' class='btn btn-primary btn-circle tooltipTable' onclick='editUserSetup(event)' title='Edit'><i class='fa fa-pencil'></i></button>"}
		        
			],
			//"columnDefs": [{"targets": [ 5,7 ],"orderable": false}], 
			// to show tooltips in datatable
			"fnDrawCallback": function(oSettings, json) {
		     	$('.tooltipTable').tooltipster({
		         	theme: 'tooltipster-punk',
		      		animation: 'grow',
		        	delay: 200, 
		         	touchDevices: false,
		         	trigger: 'hover'
	      		});          
		  	}
		});
		$("div.btn_user_modal").html('<button class="btn btn-info tooltips btn-circle" title="Add" id="add_mng_user"><i class="fa fa-plus" aria-hidden="true"></i></button>');
		
		$('#frm_user').bootstrapValidator({
			message: 'This value is not valid',
		    feedbackIcons: 
		    {
		        valid: 'glyphicon glyphicon-ok',
		        invalid: 'glyphicon glyphicon-remove',
		        validating: 'glyphicon glyphicon-refresh'
		    },
			submitButtons: 'button[type="submit"]',
			
			submitHandler: function(validator, form, submitButton) 
			{
				$("#btn_submit").html('<i class="fa fa-gear fa-spin"></i> Loading...');
				txtUserName = $('#txtUserName').val();
				txtpassword = 'password';
				var encSaltSHAPass = encryptShaPassCode(txtUserName,txtpassword);
				var formData = new FormData(document.getElementById("frm_user"));
					formData.append('secreatecode', encSaltSHAPass);
				urls =base_url+"service/operation_userdata";
				$.ajax({
					url : urls,
					method : 'POST',
					data:formData,
					cache: false,
			        contentType: false,
			        processData: false,
					success : function(response){
						try {
			                var obj = JSON.parse(response);
			                if (obj.status == false) {
			                	$('#errorlog').html('');
			                	$('#errorlog').hide();
			                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
			                    sweetAlert("USER",obj.msg, "error");
			                }else if(obj.status === 'validationerror'){
			                	$('#errorlog').html(obj.msg);
			                	$('#errorlog').show();
			                	$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
			                } else {
			                	sweetAlert("USER",obj.msg, "success");
			                	$('#errorlog').html('');
			                	$('#errorlog').hide();
			            		user_table = $('#user_table').DataTable();
								user_table.draw();
								user_table.clear();
								$('#frm_user').data('bootstrapValidator').resetForm(true);//Reseting user form
								$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
								$("#spanuser").html("Add User");
								$('#hiduser_name').val('');
								$("#frm_user input[name='op_type']").val("add_user");
								$('#manage_user_modal').modal('hide'); 
			                }
			            } catch (e) {
			                sweetAlert("Sorry",'Unable to Save.Please Try Again !', "error");
			            }
					},error: function(err){
						toastr.error("unable to save");
					}
				});
			},
			//live: 'enabled',
		    fields:
		    {
		        txtUserName: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        },
		        txtDisplayName: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        },
		        txtEmailId: {							//form input type name
		            validators: {
		                emailAddress: {
		                    message: 'The value is not a valid email address'
		                }
		            }
		        },
		        txtPhoneNumber: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Mobile Number Required'
		                },
		                regexp: {
	                        regexp: /^[1-9][0-9]{0,9}$/,
	                        message: "Invalid Mobile Number"
	            		}
		            }
		        },
		        user_status: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        },
		        cmbRoleGroup: {							//form input type name
		            validators: {
		                notEmpty: {
		                    message: 'Required'
		                }
		            }
		        }
			}	
		});
	
	
	$("#add_mng_user").click(function(){
		$("#spanuser")[0].innerHTML ="Add User";
		$('#frm_user').data('bootstrapValidator').resetForm(true); //to reset the form
	    $('#manage_user_modal').modal('show');
	});
	
	
	function editUserSetup(event){//on edit click assign the value to text field
		$("#btn_submit")[0].innerHTML ="<i class='fa fa-edit'></i> Update";
		$("#spanuser")[0].innerHTML ="Edit User";
	    $("#frm_user input[name='op_type']").val("edit_user");
	    var oTable = $('#user_table').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
	    var user_code = oTable.fnGetData(row)['user_code'];
	    var user_name = oTable.fnGetData(row)['user_name'];           
	    var user_display_name = oTable.fnGetData(row)['user_display_name'];
	    var email = oTable.fnGetData(row)['email'];
	    var phone_number = oTable.fnGetData(row)['phone_number'];
	    var prof_img = oTable.fnGetData(row)['prof_img'];
	    var status = oTable.fnGetData(row)['record_status'];
	    $('#hiduser_code').val(user_code);
	    $('#txtUserName').val(user_name);
	    $('#hiduser_name').val(user_name);
	    $('#txtDisplayName').val(user_display_name);
	    $('#txtEmailId').val(email);
	    $('#txtPhoneNumber').val(phone_number);
	    $('#fileimage').val(prof_img);  
	    $('#user_status').val(status); 
	    $('#cmbRoleGroup').val(oTable.fnGetData(row)['role_group_code']); 
	    $('#txtUserName').attr('readonly', true);
	    $('#txtPhoneNumber').attr('readonly', true);
	    $("#cmbRoleGroup").prop("disabled", true);
	    $('#manage_user_modal').modal('show');
	}
	

	function resetpassword(event){
		$("#frm_user input[name='op_type']").val("sa_reset_password");
		var oTable = $('#user_table').dataTable();
	    var row;
	    if(event.target.tagName == "BUTTON")
			row = event.target.parentNode.parentNode;
		else if(event.target.tagName == "I")
			row = event.target.parentNode.parentNode.parentNode;
		
		var formData = new FormData(document.getElementById("frm_user"));
		txtpassword = 'password';
		
		var encSaltSHAPass = encryptShaPassCode(oTable.fnGetData(row)['user_name'],txtpassword);
		formData.append('secreatecode', encSaltSHAPass);
		formData.append('hiduser_code', oTable.fnGetData(row)['user_code']);
		formData.append('email',  oTable.fnGetData(row)['email']);
		formData.append('user_name',  oTable.fnGetData(row)['user_name']);
		formData.append('user_display_name', oTable.fnGetData(row)['user_display_name']);
		
		$('#btn_reset').html('<i class="fa fa-gear fa-spin"></i>');
	    $.ajax({
			url : base_url + "service/sa_reset_password",
			method : 'POST',
			data:formData,
			cache: false,
	        contentType: false,
	        processData: false,
	        success: function (response) {
	            try{
	                var obj = JSON.parse(response);
	                if (!obj.status) {
	                	$('#btn_reset').html('<i class="fa fa-undo"></i>');
	                    sweetAlert("USER",obj.msg, "error");
	                } else {
	                	$('#btn_reset').html('<i class="fa fa-undo"></i>');
	                	sweetAlert("USER",obj.msg, "success");
	                }
	            }catch(e){
	                sweetAlert("Sorry","We are unable to Process !", "error");
	            }
	        },error: function (err) {
	            toastr.error(err);
	        }
		});
	}

	//for form reset button click to reset the form
	function form_reset(){
		$('#hiduser_name').val('');
		$('#frm_user').data('bootstrapValidator').resetForm(true); //to reset the form
		$("#btn_submit").html("<i class='fa fa-paper-plane'></i> Add");
		$("#spanuser").html("Add User");
		$("#frm_user input[name='op_type']").val("edit_admin_user");
	}
</script>