<!DOCTYPE html>
<html class="no-js">
    <head>
        <title>Orissa Renewable Energy Development Agency</title>
		<meta charset="utf-8">
		<meta name = "format-detection" content = "telephone=no" />
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">      
        
	</head>
	<style>
		* {padding: 0;margin: 0;}
		body {font: 10pt Courier New;color:#000000;}

		.content img {display: inline;}
		#root{padding:15px;}
		
		.text-center{text-align:center;}
		.text-right{text-align:right;}
		.text-left{text-align:left;}
		.background-image:after {
		    content:'';
		    background: url(<?php echo base_url();?>public/upload/logo/ap-agri-logo.png) no-repeat center center;
		    background-size: 60% 100%;
		    position: absolute;
		    top:0px;
		    left: 0px;
		    width:100%;
		    height:100%;
		    z-index:-1;
		    opacity: 0.1; /* Here is your opacity */
		    
		}
		
		
		h1, h2, h3{color: #000000;background: none;text-decoration: none;font-weight: bold; margin-bottom:10px;}

		h1 { font-size: 13pt; }
		h2 { font-size: 11pt; margin-top: 1em; }
		h3 { font-size: 9pt; margin-top: 1em; }

		.content {line-height: 14pt;margin-bottom: 1em;	overflow: auto; width:100%;}
		
		hr {height: 0;border-top:solid 1px #ccc; border-bottom:0; border-left:0;  border-right:0;margin:10px 0;}

		ol, ul {margin-left: 15pt}

		table{width:100%;}
		td, th{padding:0 5px;}
		table.dashedBorder, .dashedBorder th, .dashedBorder td{border:solid 1px #999; border-collapse: collapse; padding:3px 10px; margin-bottom:20px;}
		strong{font-size:12pt;}
		address{font-size:9pt; line-height:10pt;text-align: justify;padding-top: 5px;width: 80%;}
		.small{font-size:8pt; line-height:10pt;}	
		
		
		@media all {
			.page-break	{ display: none; }
		}

		@media print {
			.page-break	{ display: block; page-break-before: always; }
			.noPrint{display:none;}
			thead{
				display:table-header-group;/*repeat table headers on each page*/
			}
			tbody{
				display:table-row-group;  
				
			}
		}
		p.ridge {border-style: ridge;height: 120px;width: 120px;}
		
		.tableedit {
		    border-spacing: 0;
			text-align: center;
		}
		 .dotted_underline {    
			border-bottom: 2px dotted #000;
			text-decoration: none;
		}
		table, th, td {
		  border: 1px solid black;
		  border-collapse: collapse;
		}
		.table{
			padding-top: 2%;
			width: 95%;
			padding-left: 5%;
		}
	</style>	
	<body id="root">
		<div class="content background-image">
			<div id="scheme_wise_view"><h1 style="text-align: center;padding-top: 3%;">Scheme wise view / Vendor (<?php echo $scheme_list['scheme_name'];?>)</h1></div>
           	<table id="dtabledashboardTwo" class="table table-bordered table-hover">
    			<thead>
    				<tr>
                        <th>Sl No</th>
                        <th>Vendor Name</th>
                        <th>No. of Installation</th>
                        <th>Open</th>
                       <!-- <th>Open (%)</th>-->
                        <th>Registration Frequency</th>
                        <!--<th>Open Average</th>
                        <th>Close Average</th>-->
                	</tr>
    			</thead>
    			<tbody id="vendor_scheme_list">	
    				<?php $sl_no=1; for($i =0 ; $i < sizeof($get_vendor); $i++){
    				$total_installation = $this->dashboard_model->get(array('pk_scheme_code'=>$scheme_list['pk_scheme_code'] ,'tr_supplier_id' =>$get_vendor[$i]['tr_supplier_id'] ),'get_tran_sup_count');
					$total_open = $this->dashboard_model->get(array('scheme_code'=>$scheme_list['scheme_code'] ,'tr_supplier_id' =>$get_vendor[$i]['tr_supplier_id'] ),'get_tran_sup_open');
					$no_day_open = $this->dashboard_model->get(array('scheme_code'=>$scheme_list['scheme_code'] ,'tr_supplier_id' =>$get_vendor[$i]['tr_supplier_id'] ),'no_of_days_open_scheme_sup');
					$no_day_close = $this->dashboard_model->get(array('scheme_code'=>$scheme_list['scheme_code'] ,'tr_supplier_id' =>$get_vendor[$i]['tr_supplier_id'] ),'no_of_days_close_scheme_sup');
					$total_close = $this->dashboard_model->get(array('scheme_code'=>$scheme_list['scheme_code'] ,'tr_supplier_id' =>$get_vendor[$i]['tr_supplier_id'] ),'get_tran_sup_close');
					$open_result = $total_installation['cnt'] ? round(($total_open['cnt'] / $total_installation['cnt']) * 100 , 2):0;
					
					$register_result = $total_installation['cnt'] ? (round(($total_open['cnt'] / $total_installation['cnt']) , 3)) : 0;
					$open_avg_result = $total_open['cnt'] ? round($no_day_open['cnt']/ $total_open['cnt'] ,2) : 0;
					$close_avg_result =  $total_close['cnt'] ? round($no_day_close['cnt']/ $total_close['cnt'] ,2) : 0;
					?>
    				<tr>
    					<td><?php echo $sl_no; ?></td>
    					<td><?php echo $get_vendor[$i]['supplier_name'];?></td>
    					<td><?php echo $total_installation['cnt']; ?></td>
    					<td><?php echo $total_open['cnt']; ?></td>
    					<!--<td><?php echo $open_result; ?></td>-->
    					<td><?php echo $register_result; ?></td>
    					<!--<td><?php echo $open_avg_result; ?></td>
    					<td><?php echo $close_avg_result; ?></td>-->
    				</tr>
    				<?php $sl_no++; } ?>
    			</tbody>
    			<tfoot id="total_result">
    			<?php
					$footer_open_percent = $footer_vendor['cnt'] ? round(($footer_open['cnt'] / $footer_vendor['cnt']) *100,2) :0;
					$footer_register = $footer_vendor['cnt'] ? round(($footer_open['cnt'] / $footer_vendor['cnt']) ,3) :0;
					$footer_open_avg = $footer_open['cnt'] ? round(($open_avg['cnt'] / $footer_open['cnt']) ,2) :0;
					$footer_close_avg = $footer_close['cnt'] ? round(($close_avg['cnt'] / $footer_close['cnt']) ,2) : 0;
    			?>
    				<tr>
	    				<td></td>
	    				<td>Total</td>
	    				<td><?php echo $footer_vendor['cnt'];?></td>
	    				<td><?php echo $footer_open['cnt'];?></td>
	    				<!--<td><?php echo $footer_open_percent; ?></td>-->
	    				<td><?php echo $footer_register; ?></td>
	    				<!--<td><?php echo $footer_open_avg; ?></td>
	    				<td><?php echo $footer_close_avg; ?></td>-->
	    			</tr>
    			</tfoot>
    		</table>
		</div>
		
	</body>
</html>
	
