<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Technician_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'get_all_component':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('component_name,short_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('id','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('id','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break; 
	            case 'get_component_view':
	            	$this->db->from('components');
	            	$this->db->select('component_name,short_name,description,id,created_by,created_at,updated_by,updated_at');
	            	$this->db->where('id',$data['id']);
	            	return $this->db->get()->row_array();
	            break;
	            case 'get_attribute':
	            	$this->db->from('components_details a');
	            	$this->db->select('a.attribute,b.value,a.created_by,a.created_at,a.updated_by,a.updated_at');
	            	$this->db->join('lookup_detail b','a.attribute = b.id','left');
	            	$this->db->where('b.lookup_name','attribute');
	            	$this->db->where('a.components_id',$data['components_id']);
	            	return $this->db->get()->result_array();
	            break;
	            case 'get_technician_details':
	        			$order = '';
		                $Ocolumn = '';
		                $Odir = '';
		                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
			            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
		                $page = $data['page'];
		                if($page ==  'ALL'){
		                	$this->db->from('technician_master a');
			                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
			                $this->db->join('supplier b', 'b.id = a.id','left');
			                if($data['cmb_vendor']!= ''){
								$this->db->where('a.supp_code',$data['cmb_vendor']);
							}
			                $this->db->order_by('id','DESC');
			               	$res = $this->db->get();
			                $query = $res->result_array();
		                }else{
			                $order = $this->input->post('order');
			                if ($order) {
			                    foreach ($order as $row) {
			                        $Ocolumn = $row['column'];
			                        $Odir = $row['dir'];
			                    }
			                    $this->db->order_by($Ocolumn, $Odir);
			                } else {
			                    $this->db->order_by(1, "ASC");
			                }
			                $search = $this->input->post('search');
			                $header = array('a.name','a.phone_no','a.mail_id','a.address');//search filter will work on this column
			                if ($search['value'] != '') {
			                    for ($i = 0; $i < count($header); $i++) {
			                        $this->db->or_like($header[$i], $search['value']);
			                    }
			                }
			                $this->db->limit($iDisplayLength, $iDisplayStart);
			                $this->db->from('technician_master a');
			                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
			                $this->db->join('supplier b', 'b.id = a.id','left');
			                if($data['cmb_vendor']!= ''){
								$this->db->where('a.supp_code',$data['cmb_vendor']);
							}
			                $this->db->order_by('a.updated_at','DESC');
			               	$res = $this->db->get();
			                $query = $res->result_array();
			                $output = array("aaData" => array());
							/*----FOR PAGINATION-----*/
			                if ($search['value'] != '') {
			                    for ($i = 0; $i < count($header); $i++) {
			                        $this->db->or_like($header[$i], $search['value']);
			                    }
			                }
			                $this->db->from('technician_master a');
			                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
			                $this->db->join('supplier b', 'b.id = a.id','left');
			                if($data['cmb_vendor']!= ''){
								$this->db->where('a.supp_code',$data['cmb_vendor']);
							}
			                $this->db->order_by('a.updated_at','DESC');
			                $res1 = $this->db->get();//echo $this->db->last_query();die();
			                
			                $output["draw"] = intval($this->input->post('draw'));
			                $output['iTotalRecords'] = $res1->num_rows();
			                $output['iTotalDisplayRecords'] = $res1->num_rows();
		               	}
		                $slno = $iDisplayStart+1;
		                foreach ($query as $aRow) {
		                    $row[0] = $slno;
		                    $row['sl_no'] = $slno;
		                    $i = 1;
		                    foreach ($aRow as $key => $value) {

		                        $row[$i] = $value;
		                        $row[$key] = $value;
		                        $i++;
		                    }
							$output['aaData'][] = $row;
		                    $slno++;
		                    unset($row);
		                }
		                return $output;
	        		break;
	            default :
	            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
				}
			}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'INSERT_TECHNICIAN_DATA':
        		    $this->db->trans_begin();
        			try{
						$insert_technician_data = array(
							"supp_code"			    => $this->security->xss_clean($data['cmb_vendor']),
							"name	"		        => $this->security->xss_clean($data['txtTechnicianName']),
							"phone_no"		        => $this->security->xss_clean($data['txtPhoneNo']),
							"mail_id"				=> $this->security->xss_clean($data['txtEmailId']),
							"address"				=> $this->security->xss_clean($data['txtAddress']),
							"created_at"			=> $date,
							"created_by"		    => $this->user_name,
							"updated_at"			=> $date,
							"updated_by"		    => $this->user_name,
							"status"				=> 1
				        );
						$result_technician_data = $this->db->insert('technician_master',$insert_technician_data);
						if($result_technician_data){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'data saved successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While Saving';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		break;
				case 'UPDATE_TECHNICIAN_DATA':
					$this->db->trans_begin();
					try{
						$update_technician_entry = array(
							"supp_code"			    => $this->security->xss_clean($data['cmb_vendor']),
							"name"		            => $this->security->xss_clean($data['txtTechnicianName']),
							"mail_id"				=> $this->security->xss_clean($data['txtEmailId']),
							"address"				=> $this->security->xss_clean($data['txtAddress']),
							"updated_at"		    => $date,
							"updated_by"		    => $this->user_name
				        );
						$this->db->where('phone_no',$this->security->xss_clean($data['txtPhoneNo']));
						$result_technician_entry= $this->db->update('technician_master',$update_technician_entry);
						if($result_technician_entry){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'data updated successfully';
					    }else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					}
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		 break;	
				case 'update_technician_status':
        		 	$this->db->trans_begin();
        		 	try{
						$id = $data['tech_id'];
						$status = $data['tech_status'];
						$set = '';
						if($status == 1){
							$set = 0;	
						}else{
							$set = 1;
						}
						$this->db->where('id',$id);
						$update_status = $this->db->update('technician_master',array('status'=>$set));
						if($update_status){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'Status updated successfully';
				    	}else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		break;
			default:
            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}