<?php
class User_model extends CI_model
{
	private $role;
	
	function __construct(){
        parent::__construct();

        if (ENVIRONMENT == 'production'){
		    $this->db->save_queries = FALSE;
		}
		date_default_timezone_set('Asia/Kolkata');
    }
	
	// make md5 hash
	private function getHash($string)
	{
		return md5($string);
	}


	/**
	*	Generate random password 
	*/
	public function rand_string( $length ) {
		$chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
		return substr(str_shuffle($chars),0,$length);
	}
	
	/**
	*	Forgot password 
	*/
	public function forgot_password()
	{
		$email = $this->input->post('email');
		$this->db->select('tbl_users.id');
		$this->db->from('tbl_users');
		$this->db->join('tbl_students', 'tbl_users.id = tbl_students.fk_user_id', 'left');
		$this->db->where('tbl_students.email', $email);	// for student
		$query = $this->db->get();
		
		if($query->num_rows == 1)
		{
			$result = $query->result_array()[0];
			$randomPassword = self::rand_string(8);;
			$data = array(
				'password'=>md5($randomPassword),
			);		
			
			$this->db->where('id', $result['id']);
			if( $this->db->update('tbl_users', $data) )
				return array('status'=>1, 'msg'=>$randomPassword);
			else
				return array('status'=>0, 'msg'=>'Your request can not be processed. Try again later');
		}
		else
		{
			return array('status'=>0, 'msg'=>"Please enter correct email id.");
		}
	}
	
	
	/*
	*	authenticate a user with username & password
	*/
	public function login(){
		//Storing values through POST method
		$data['non_xss']= array(
			'key'			=> $this->session->userdata('key'),
			'user_name' 	=> $this->input->post('txtUsername'),
			'user_password' => $this->input->post('txtPassword')
		);
		// Apply the xss_clean() of "security" library, which filtered data from passing through <script> tag.
		$data['xss_data'] = $this->security->xss_clean($data['non_xss']);
		
		$key 		= $data['xss_data']['key'];
		$this->session->unset_userdata('key');
		$UserName 	= $data['xss_data']['user_name'];
		$password 	= $data['xss_data']['user_password'];
		
		$this->db->from('user_role_group_map urg');
        $this->db->select('rgm.group_code,rgm.role_code,um.user_code,um.user_name,um.user_display_name,um.record_status,resom.resource_link,resom.is_maintenance,um.is_new_record,udm.user_logo,rm.role_name');						
        $this->db->join('role_group_mapping rgm', 'urg.role_group_code = rgm.role_group_code', 'inner');
        $this->db->join('group_master gm', 'rgm.group_code = gm.group_code', 'inner');
        $this->db->join('user_master um', 'urg.user_code = um.user_code', 'inner');
        $this->db->join('user_details_master udm', 'urg.user_code = udm.fk_user_code', 'inner');
        $this->db->join('role_master rm', 'rgm.role_code = rm.role_code', 'inner');
        $this->db->join('resource_master resom', 'rm.index_page_url = resom.resource_code', 'inner');
        $this->db->where('gm.record_status',1);
        $this->db->where('rm.record_status',1);
        $this->db->where('um.user_name',$this->db->escape_str($UserName));
        $this->db->where("SHA2(CONCAT(um.password,'#','$key'),512)",$password);
		$userRecord = $this->db->get();
		//print_r($this->db->last_query());die();
		$userDataArr = $userRecord->result_array();
		if($userRecord->num_rows() == 1){
			if($userDataArr[0]['record_status'] != 0){
				$this->session->set_userdata('logged_in', 'yes');
				$this->session->set_userdata('user_code', $userDataArr[0]['user_code']);
				$this->session->set_userdata('user_name', $userDataArr[0]['user_name']);
				$this->session->set_userdata('dept_code', $userDataArr[0]['dept_code']);
				$this->session->set_userdata('user_display_name', $userDataArr[0]['user_display_name']);
				$this->session->set_userdata('user_logo', $userDataArr[0]['user_logo']);
				//$this->session->set_userdata('last_login', $userDataArr[0]['last_login']);
				$this->session->set_userdata('role', $userDataArr[0]['role_code']);
				$this->session->set_userdata('role_name', $userDataArr[0]['role_name']);
				$this->session->set_userdata('group_code', $userDataArr[0]['group_code']);
				$this->session->set_userdata('sess_id', session_id());
				$insert_login_detail = array(
					'login_id'		=> $this->session->userdata('user_code'),
					'login_role'	=> $this->session->userdata('role'),
					'ip_address'	=> $this->input->ip_address(),
					'role_code'		=> $this->session->userdata('group_code'),
					'session_id'	=> $this->session->userdata('sess_id'),
					'created_by'	=> $this->session->userdata('user_name'),
					'created_on'	=> date('Y-m-d H:i:s', time()),
					'record_status'	=> 'ACTIVE'
				);
				$this->db->insert('login_detail', $insert_login_detail);
				if($userDataArr[0]['is_new_record'] != 0){
					$resource_link = $userDataArr[0]['resource_link'];
				}else{
					$resource_link = 'set-password';
				}
				if($userDataArr[0]['is_maintenance'] != 0){
					return array('status'=>true, 'msg'=>'Login success','index_page'=>$resource_link);
				}else{
					return array('status'=>false, 'msg'=>'Page is Under Maintenance');
				}
			}else{
				return array('status'=>false, 'msg'=>'Your account has been blocked please contact administrator','logoutopt'=>'NO');
			}
		}else{
			return array('status'=>false, 'msg'=>'Invalid username or password','logoutopt'=>'NO');
		}
	}
	
	public function logout(){
		$today = date('Y-m-d H:i:s', now());
		$login_log = array('record_status'=>'INACTIVE','updated_on'=>$today);
		$this->db->where('login_id',$this->session->userdata('user_code'));
		$this->db->where('record_status','ACTIVE');
		$result = $this->db->update('login_detail',$login_log);
		if($result){
			return array('status'=>true);
		}else{
			return array('status'=>false);
		}
	}
	

	/**
	*	purpose : Change password for the user 
	*/
	public function change_password(){
		$userID = $this->session->userdata('user_id');

		$this->db->where('id', $userID);
		$this->db->where('password', self::getHash($this->input->post('cur_password')));
		if($this->db->count_all_results('tbl_users') != 1)
		{
			return array('status'=>0, 'msg'=>'Invalid current password.');
		}

		$new_pass =  $this->getHash($this->input->post('new_password'));
		$this->db->where('id', $userID);
		$this->db->update('tbl_users', array('password'=>$new_pass));
		switch($this->db->affected_rows())
		{
			case 1:
				return array('status'=>true, 'msg'=>'Password changed successfully');
			break;
			default:
				return array('status'=>false, 'msg'=>'Sorry! Password could not be changed.');
		}
	}
}