<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
	require_once APPPATH."third_party/phpmailer/class.phpmailer.php";
   	class Schedule_model extends CI_Model{
  		function __construct(){
    		parent::__construct();
    		
    		# helper
    		$this->load->helper('date');
	        $this->load->helper('send_email');
	        
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
	        $this->user_code 	= $this->session->userdata('user_code');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
	            case 'get_all_generated_ticket':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('ticket_id','scheme_name','supplier_name','technician_id','district_name','block_name','address',);//search filter will work on this column
	                $filter_string="";
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
	                    }
	                    $filter_string=substr($filter_string,3);
	                    $filter_string='('.$filter_string.')';
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,concat (cu.name1,' ',cu.name2, ' ',cu.name3) as customer_name,b.id,tkt_type,week_id,tkt_status,");
			        $this->db->from('schedule_ticket a');
			        $this->db->join('supplier b', 'a.vendor_id=b.supplier_code', 'left');
			        $this->db->join('block_master c', 'a.block_code=c.block_code', 'left');
			        $this->db->join('scheme_header d', 'a.scheme_id=d.pk_scheme_code', 'left');
			        $this->db->join('district_master e', 'a.dist_code=e.district_code', 'left');
			        $this->db->join('transaction_header th', 'a.transaction_id=th.id', 'left');
			        $this->db->join('customer cu', 'th.tr_customer_id=cu.id', 'left');
			        $this->db->join('gen_code_desc gcd','gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
			        $this->db->where('a.tkt_status','OPEN');
			        $this->db->order_by('b.id' , 'DESC');
			        if($filter_string!=''){
						$this->db->where($filter_string);
					}
			        if($data['ticket_type'] != ''){
						$this->db->where('a.tkt_type',$data['ticket_type']);
					}
			        if($data['scheme_id'] != ''){
						$this->db->where('a.scheme_id',$data['scheme_id']);
					}
			        if($data['vendor_id'] != ''){
						$this->db->where('a.vendor_id',$data['vendor_id']);
					}
					if($this->role == 'VENDOR'){
						$this->db->where('b.fk_user_code',$this->user_code);
					}
					if($this->role == 'TECHNICIAN'){
						$this->db->where('a.technician_id',$this->user_name);
					}
	                $query = $this->db->get()->result_array();
	                //print_r($this->db->last_query());die();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                $this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,concat (cu.name1,' ',cu.name2, ' ',cu.name3) as customer_name,b.id,tkt_type,week_id,tkt_status,");
			        $this->db->from('schedule_ticket a');
			        $this->db->join('supplier b', 'a.vendor_id=b.supplier_code', 'left');
			        $this->db->join('block_master c', 'a.block_code=c.block_code', 'left');
			        $this->db->join('scheme_header d', 'a.scheme_id=d.pk_scheme_code', 'left');
			        $this->db->join('district_master e', 'a.dist_code=e.district_code', 'left');
			        $this->db->join('transaction_header th', 'a.transaction_id=th.id', 'left');
			        $this->db->join('customer cu', 'th.tr_customer_id=cu.id', 'left');
			        $this->db->join('gen_code_desc gcd','gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
			        $this->db->where('a.tkt_status','OPEN');
			        $this->db->order_by('b.id' , 'DESC');
			        if($filter_string!=''){
						$this->db->where($filter_string);
					}
			        if($data['ticket_type'] != ''){
						$this->db->where('a.tkt_type',$data['ticket_type']);
					}
			        if($data['scheme_id'] != ''){
						$this->db->where('a.scheme_id',$data['scheme_id']);
					}
			        if($data['vendor_id'] != ''){
						$this->db->where('a.vendor_id',$data['vendor_id']);
					}
					if($this->role == 'VENDOR'){
						$this->db->where('b.fk_user_code',$this->user_code);
					}
					if($this->role == 'TECHNICIAN'){
						$this->db->where('a.technician_id',$this->user_name);
					}
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_all_resolve_ticket':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                $output = array("aaData" => array());
	                if($data['page'] == "ALL"){
						$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where('a.tkt_status','RESOLVE');
				        $this->db->order_by('b.id' , 'DESC');
				        if($this->role == 'VENDOR'){
						$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
		                $query = $this->db->get()->result_array();
					}else{
						$order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('ticket_id','scheme_name','supplier_name','technician_id','district_name','block_name','address',);//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string='('.$filter_string.')';
		                }

		                $this->db->limit($iDisplayLength, $iDisplayStart);
		               	$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where('a.tkt_status','RESOLVE');
				        $this->db->order_by('b.id' , 'DESC');
				        if($filter_string!=''){
							$this->db->where($filter_string);
						}
						if($this->role == "VENDOR"){
							$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
		                $query = $this->db->get()->result_array();
		                //print_r($this->db->last_query());die();
		                
		                /*----FOR PAGINATION-----*/
		               	$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where('a.tkt_status','RESOLVE');
				        $this->db->order_by('b.id' , 'DESC');
				        if($filter_string!=''){
							$this->db->where($filter_string);
						}
						if($this->role == "VENDOR"){
							$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
		                $res1 = $this->db->get();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
					}
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_all_closed_ticket':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($data['page'] == "ALL"){
						$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where_in('a.tkt_status',array('CLOSED','REJECTED'));
				        $this->db->order_by('b.id' , 'DESC');
				        if($this->role == "VENDOR"){
							$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
		                $query = $this->db->get()->result_array();
					}else{
						$order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('ticket_id','scheme_name','supplier_name','technician_id','district_name','block_name','address',);//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string='('.$filter_string.')';
		                }

		                $this->db->limit($iDisplayLength, $iDisplayStart);
		               	$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where_in('a.tkt_status',array('CLOSED','REJECTED'));
				        if($this->role == "VENDOR"){
							$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
						$this->db->order_by('b.id' , 'DESC');
		                $query = $this->db->get()->result_array();
		                //print_r($this->db->last_query());die();
		                $output = array("aaData" => array());
		                /*----FOR PAGINATION-----*/
		               	$this->db->select("ticket_id,gcd.description,scheme_name,supplier_name,technician_id,district_name,block_name,address,mc,b.id,tkt_type,week_id,tkt_status");
				        $this->db->from('schedule_ticket a');
				        $this->db->join('supplier b', ' a.vendor_id=b.supplier_code ', 'left');
				        $this->db->join('block_master c ', ' a.block_code=c.block_code', 'left');
				        $this->db->join('scheme_header d ', 'a.scheme_id=d.pk_scheme_code', 'left');
				        $this->db->join('district_master e ', 'a.dist_code=e.district_code', 'left');
				        $this->db->join('gen_code_desc gcd', 'gcd.gen_code_group="MONTH" AND a.month_code=gcd.gen_code', 'left');
				        $this->db->where_in('a.tkt_status',array('CLOSED','REJECTED'));
				        $this->db->order_by('b.id' , 'DESC');
				        if($this->role == "VENDOR"){
							$this->db->where('b.fk_user_code',$this->user_code);
						}
				        if($data['ticket_type'] != ''){
							$this->db->where('a.tkt_type',$data['ticket_type']);
						}
				        if($data['scheme_id'] != ''){
							$this->db->where('a.scheme_id',$data['scheme_id']);
						}
				        if($data['vendor_id'] != ''){
							$this->db->where('a.vendor_id',$data['vendor_id']);
						}
						if($filter_string!=''){
							$this->db->where($filter_string);
						}
						$this->db->order_by('b.id' , 'DESC');
		                $res1 = $this->db->get();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
					}
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_ticket_details':
	            	$this->db->from('schedule_ticket st');
	               	$this->db->select('st.*,s.supplier_name,dm.district_name,bm.block_name,sh.scheme_name,tm.name ');
	               	$this->db->join('supplier s', 'st.vendor_id = s.supplier_code', 'left');
	               	$this->db->join('district_master dm', 'st.dist_code = dm.district_code', 'left');
	               	$this->db->join('block_master bm', 'st.block_code = bm.block_code', 'left');
	               	$this->db->join('scheme_header sh', 'st.scheme_id = sh.pk_scheme_code', 'left');
	               	$this->db->join('technician_master tm', 'st.technician_id = tm.phone_no', 'left');
	               	$this->db->where('ticket_id',$data['ticket_id']);
	               	return $this->db->get()->row_array();
	            break;
	            case 'get_ticket_data':
	            	$this->db->from('schedule_ticket');
	               	$this->db->select("description,visit_purpose,evidence_pic,witness_name,witness_no,remarks,tkt_status,closing_remarks");
	               	$this->db->join('gen_code_desc', 'visit_purpose = gen_code AND gen_code_group = "VISIT_PURPOSE"', 'left');
	               	//$this->db->where('gen_code_group','VISIT_PURPOSE');
	               	$this->db->where('ticket_id',$data['ticket_id']);
	               	return $this->db->get()->row_array();
	            break;
	            case 'get_cm_ticket_data':
	            	$sql = $this->db->query("SELECT gcd.description as description1,gc.description as description2,visit_purpose,nature_of_service,evidence_pic, witness_name, witness_no, resolve_remarks, ticket_status, remarks 
							FROM raise_ticket
							LEFT JOIN gen_code_desc gcd ON gcd.gen_code_group = 'VISIT_PURPOSE' AND gcd.gen_code = visit_purpose
							LEFT JOIN gen_code_desc gc ON gc.gen_code_group = 'SUB_VISIT_PURPOSE' AND gc.gen_code = nature_of_service
							WHERE ticket_id = '".$data['ticket_id']."'");
	               	return $sql->row_array();
	            break;
	            case 'get_cm_additional_data':
	            	$this->db->from('raise_ticket');
	               	$this->db->select("created_by,DATE_FORMAT(created_at,'%d-%m-%Y') AS created_at,updated_by,DATE_FORMAT(updated_at,'%d-%m-%Y') AS updated_at");
	               	$this->db->where('ticket_id',$data['ticket_id']);
	               	return $this->db->get()->row_array();
	            break;
	            case 'get_schedule_ticket_count':
					$sql = $this->db->query("SELECT IFNULL(gen_code,'Total') gen_code,SUM(IFNULL(tkt_cnt,0)) AS tkt_cnt FROM 
					( SELECT CAST(gen_code AS CHAR) gen_code FROM gen_code_desc WHERE gen_code_group='TKT_TYPE_POINT') a LEFT JOIN (SELECT COUNT(*) AS tkt_cnt ,t_type FROM 
					( SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,SUBSTRING(a.mc,3,1) AS mc_code,'Y' AS t_type 
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE a.month_id='".$data['month']."' AND is_yrly=1
					UNION ALL
					SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,SUBSTRING(a.mc,3,1) AS mc_code,'H' AS t_type 
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE a.month_id='".$data['month']."' AND is_half=1
					UNION ALL
					SELECT a.id,month_id,month_name,qtr_id,a.mc,dc,dist_code,block_code,'".$data['year']."' AS yr,SUBSTRING(a.mc,3,1) AS mc_code,'Q' AS t_type 
					FROM schedule_mth_qtr_mc a 
					LEFT JOIN schedule_mc_dc_block b ON a.mc=b.mc
					WHERE a.month_id='".$data['month']."' AND is_qtr=1
					ORDER BY id) a
					LEFT JOIN 
					(SELECT d.id AS sd,d.consumer_id,d.admin_dep,d.tr_scheme_id,d.tr_instal_id,e.supplier_code,f.block_code AS cd_block,gp,d.tr_customer_id 
					,d.tr_supplier_id,CONCAT(IF(IFNULL(d.landmark,'')='','',CONCAT(d.landmark,',')),IF(IFNULL(d.habitation,'')='','',CONCAT(d.habitation,',')),
					v.village_name) AS habitation,scheduled_week
					FROM transaction_header d LEFT JOIN supplier e ON d.tr_supplier_id=e.id LEFT JOIN block_master f ON d.cd_block=f.id 
					LEFT JOIN village_master v ON d.revenue_village=v.id LEFT JOIN gp_master g ON d.gp=g.id 
					WHERE transaction_status!='cancelled' ORDER BY `tr_supplier_id`,`district`,d.cd_block) b ON a.block_code=cd_block
					WHERE tr_instal_id NOT IN (SELECT installation_id FROM schedule_approval WHERE s_month='".$data['month']."' AND s_year='".$data['year']."') AND b.sd IS NOT NULL 
					GROUP BY t_type) b ON a.gen_code=b.t_type GROUP BY gen_code WITH ROLLUP");
				return $sql->result_array();
	            break;
	            case 'get_cohorts':
	            	$sql = $this->db->query("SELECT * FROM
					(SELECT COUNT(*) AS total_install FROM installation_class_header)a,
					(SELECT COUNT(*) AS total_vendor FROM supplier)b,
					(SELECT COUNT(*) AS total_scheme FROM scheme_header)c");
				return $sql->row_array();
				case 'get_total_ticket_type':
					$sql = $this->db->query("SELECT half_yearly, quaterly,yearly,(half_yearly+quaterly+yearly)AS total FROM
					(SELECT COUNT(*) AS half_yearly FROM schedule_ticket WHERE month_code='".$data['month']."' AND tkt_type ='H' )a,
					(SELECT COUNT(*) AS quaterly FROM schedule_ticket WHERE month_code='".$data['month']."' AND tkt_type ='Q')b,
					(SELECT COUNT(*) AS yearly FROM schedule_ticket WHERE month_code='".$data['month']."' AND tkt_type ='Y' )c");
				return $sql->row_array();
	            break;
	            case 'get_total_vendor_data':
					$sql = $this->db->query("SELECT b.supplier_code,b.supplier_name,COUNT(*) AS total FROM schedule_ticket a
					LEFT JOIN supplier b ON a.vendor_id = b.supplier_code
					WHERE month_code = '".$data['month']."'
					GROUP BY b.supplier_code,b.supplier_name
					ORDER BY b.supplier_code,b.supplier_name,total ASC");
				return $sql->result_array();
	            break;
	            case 'get_total_installation_data':
					$sql = $this->db->query("SELECT tot_tkt,total_excluded_tickets,(tot_tkt+total_excluded_tickets) AS total FROM 
					(SELECT ifnull(COUNT(*),0) AS tot_tkt FROM schedule_ticket WHERE month_code='".$data['month']."')a JOIN 
					(SELECT COALESCE(SUM(total_excluded_tickets), 0) as total_excluded_tickets FROM schedule_details WHERE s_month = '".$data['month']."')b");
				return $sql->row_array();
	            break;
		        default :
		            return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'MAP_TECHNICIAN':
					$this->db->trans_begin();
					try{
						$ticket_list =   $this->security->xss_clean($this->input->post('cmb_ticket_list'));
						for($i = 0; $i< sizeof($ticket_list); $i++){
							$ticket_details = array(
								"technician_id" => $this->security->xss_clean($data['cmb_technician']),
								"updated_by"	           => $this->user_name,
								"updated_on"	           => $date
							);
							$this->db->where('ticket_id',$ticket_list[$i]);
							$ticket_map_details = $this->db->update('schedule_ticket',$ticket_details);
						}
						if($ticket_map_details){
							$this->db->trans_commit();
							$dbstatus = TRUE;
		        			$dbmessage = 'Data Updated Successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'UPDATE_TICKET_STATUS':
					$this->db->trans_begin();
					try{
						$ticket =   $this->security->xss_clean($this->input->post('ticket'));
						$ticket_status_update = array(
							"tkt_status" => $this->security->xss_clean($data['cmb_status']),
							"closing_remarks" => $this->security->xss_clean($data['remarks']),
							"resolved_on"	           => $date,
							"closing_date"	           => $date
						);
						$this->db->where('ticket_id',$ticket);
						$ticket_status_update = $this->db->update('schedule_ticket',$ticket_status_update);
						if($ticket_status_update){
							$this->db->trans_commit();
							$dbstatus = TRUE;
		        			$dbmessage = 'Data Updated Successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'ADD_SCHEDULE_APPROVAL':
					$this->db->trans_begin();
					try{
						$month = $this->security->xss_clean($data['txtMonth']);
						$year = $this->security->xss_clean($data['txtYear']);
						$installation_class = $this->security->xss_clean($this->input->post('cmb_installation_class'));
						$get_month = date('m', strtotime($month));
		                for($j = 0 ; $j< sizeof($installation_class); $j++){
			                $insert_schedule_approval[] = array( 
			                    "s_month" => $get_month,
			                    "s_year" => $year,
			                    "vendor_id" => $this->security->xss_clean($data['cmb_vendor']),
			                    "scheme_id" => $this->security->xss_clean($data['cmb_schemes']),
			                    "installation_id" => $installation_class[$j],
			                    'created_by'=> $this->user_name,
			                    'created_at'=>$date
			                );
		                }
		                $res_schedule_approval = $this->db->insert_batch('schedule_approval',$insert_schedule_approval);
		                if($res_schedule_approval){
		                	$this->db->trans_commit();
							$dbstatus = TRUE;
		                	$dbmessage = 'Data saved successfully';
		                }else{
		                	$this->db->trans_rollback();
		                    $dbstatus = FALSE;
		                    $dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
                	return array('status'=>$dbstatus,'msg'=>$dbmessage,'month'=>$get_month,'year'=>$year);
				break;
				case 'ADD_TICKET_APPROVAL':
					$this->db->trans_begin();
					try{
						$month = $this->security->xss_clean($this->input->post('hidden_month'));
						$year = $this->security->xss_clean($this->input->post('hidden_year'));
						$time = $this->security->xss_clean($data['txtTicketTime']);    
			            $get_time =   date("H:i", strtotime($time));
			                $insert_schedule_details = array( 
			                    "s_month" => $month,
			                    "s_year" => $year,
			                    "s_date" => $this->security->xss_clean(date("Y-m-d", strtotime($data['txtTicketDate']))),
			                    "s_time" => $get_time,
			                    "comments" => $this->security->xss_clean($data['txtComments']),
			                    'created_by'=> $this->user_name,
			                    'created_at'=>$date
			                );
		                $res_schedule_details = $this->db->insert('schedule_details',$insert_schedule_details);
		                if($res_schedule_details){
		                	$this->db->trans_commit();
							$dbstatus = TRUE;
		                	$dbmessage = 'Data saved successfully';
		                }else{
		                	$this->db->trans_rollback();
		                    $dbstatus = FALSE;
		                    $dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
                	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'send_schedule_mail':
					ini_set('max_execution_time',600);//600seconds = 10 minutes
					$res_mail='';
					$this->db->from("supplier");
					$this->db->select("supplier_code,supplier_name,st_email,st_ph1,reg_contact_name,id");
					$this->db->where("st_email !=","");
					$res_sl = $this->db->get()->result_array();
					for($i=0;$i<sizeof($res_sl);$i++){
						$query_result = "";
					    $query_result .= "<table class='table table-bordered table-hover' style='border: 1px solid black;border-collapse: collapse;'>
									<thead>
									    <tr>
									       <th style='border: 1px solid black;'>Week</th>
									       <th style='border: 1px solid black;'>Ticket Id</th>
									       <th style='border: 1px solid black;'>Installation Id</th>
									       <th style='border: 1px solid black;'>Scheme Name</th>
									       <th style='border: 1px solid black;'>District</th>
									       <th style='border: 1px solid black;'>Block</th>
									       <th style='border: 1px solid black;'>GP</th>
									       <th style='border: 1px solid black;'>Village/Habitation</th>
									       <th style='border: 1px solid black;'>Technician Number</th>
									    </tr>
									</thead><tbody>";
						
						
						$query2 = $this->db->query("SELECT week_id, ticket_id, instal_id AS installation_id, scheme_name, district_name, block_name, gp_name, address, technician_id, supplier_name, st.vendor_id, letter_no, g.description AS m_name, st.c_year
							FROM schedule_ticket st
							LEFT JOIN district_master dm ON st.dist_code=dm.district_code
							LEFT JOIN supplier sr ON st.vendor_id = sr.supplier_code
							LEFT JOIN block_master bm ON st.block_code=bm.block_code
							LEFT JOIN gp_master gm ON st.gp_code = gm.pk_gp_code
							LEFT JOIN scheme_header sm ON st.scheme_id = sm.pk_scheme_code
							LEFT JOIN ticket_letter tl ON st.vendor_id= tl.vendor_id AND st.month_code=tl.month_id AND st.c_year=tl.c_year
							LEFT JOIN gen_code_desc g ON gen_code_group='MONTH' AND st.month_code=g.gen_code
							WHERE st.vendor_id = '".$res_sl[$i]['supplier_code']."' AND month_code = MONTH(NOW()+ INTERVAL 1 MONTH) ORDER BY st.vendor_id ASC");
						$res_st =  $query2->result_array();
					    for($j=0;$j < sizeof($res_st);$j++){
							$query_result .="<tr>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['week_id']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['ticket_id']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['installation_id']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['scheme_name']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['district_name']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['block_name']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['gp_name']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['address']."</td>
						    	<td style='border: 1px solid black;'>".$res_st[$j]['technician_id']."</td>
						    </tr>";
					    }
					    if(sizeof($res_st)){
						    $query_result.="</tbody></table>";
						    $img_path 	  = FCPATH.'assets/images/crc_logo.png';
							$toMail1=$res_sl[$i]['st_email'];
							$ccMail2='';
							$bccMail3='';
							$subject='Scheduled Maintenance list for the Month "'.$res_st[0]['m_name'].' '.$res_st[0]['c_year'].'" ';
							$body="<div style='width:100%;'>
					    			<div style='width:50%;float:left;'><img src='cid:my-attach' border='0'> </div>
					    			<div style='width:50%;float:right;'>
					    				<p style='text-align: right;'>".$res_st[0]['letter_no']."</p>
					    				<p style='text-align: right;'>Date: ".date('d-m-Y')."</p>
					    			</div>
				    			</div><br><br>
				    			<p>Dear ".$res_sl[$i]['supplier_name'].",</p><br>
								<p>Please find the list of Scheduled Maintenance Tickets to be complied with as per the Repair and Maintenance Guidelines of OREDA for the month of '".$res_st[0]['m_name']." ".$res_st[0]['c_year']."' .</p>
								<p>Part of the list relevant to the designated technician has been uploaded to his mobile App. Kindly follow it up with him to complete the task within the stipulated time.</p>
								<p>".$query_result."</p><br><br>
								<p>With regards</p>
								<p>Team Leader</p>
								<p>OREDA, CRC</p>
								<p>1800-345-7135</p>";
							$res_mail =sendEmail($toMail1,$ccMail2,$bccMail3,$subject,$body,$img_path );
							if($res_mail){
								$dbstatus = TRUE;
								$dbmessage = 'Message successfully sent.';
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Failed to mail.Please contact for support.';
							}
							
							$Mobile_number =$res_sl[$i]['st_ph1'];
							$message = "Dear Sir, your SM tickets for ".$res_st[0]['m_name']." ".$res_st[0]['c_year']." has been generated vide ".$res_st[0]['letter_no'].". Please take note of it.OREDA, CRC 1800-345-7135";
							//$new_sms_url = 'http://sandeshlive.in/API/WebSMS/Http/v1.0a/index.php?username=parameters1&password=Sf@01twh&sender=ORECRC&to=[mobileno]&message=[message]&reqid=1&format={json|text}&route_id=<route+id>&sendondate=28-07-2015T12:55:33</route+id>';
							$new_sms_url = 'http://sandeshlive.in/API/WebSMS/Http/v1.0a/index.php?username=parameters1&password=Sf@01twh&sender=ORECRC&to=[mobileno]&message=[message]&reqid=1&format={json|text}&route_id=<route+id>&sendondate=28-07-2015T12:55:33</route+id>';
							$findmobileNo = array("[mobileno]","[message]");
							//$replacemobileNo = array($Mobile_number,$content);
							$replacemobileNo = array($Mobile_number,urlencode($message));
							$smsURL = str_replace($findmobileNo,$replacemobileNo,$new_sms_url);
							//echo $smsURL;die();
							$result =  file_get_contents($smsURL);
							
							if($result){
								$dbstatus = TRUE;
								$dbmessage = 'Message successfully sent.';
								
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Failed to send.Please contact for support.';
							}
						}
					}
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'RESOLUTION_FORM':
					$this->db->trans_begin();
					try{
						$evidence_pic = "";
						$ticket = "";
						$ticket = $this->security->xss_clean($data['ticket_no']);
						$evidence_pic = $_FILES['evidence_pic']['name'];
							$allowed_mime_type_arr = array('image/jpg','image/png','image/jpeg','image/x-icon');
							$mime = get_mime_by_extension($evidence_pic);
							$dot_count 	= substr_count($evidence_pic,'.');
							$zero_count = substr_count($evidence_pic,"%0");
							if(in_array($mime, $allowed_mime_type_arr)){
								if($zero_count == 0 && $dot_count == 1){
									$file_move_path  = FCPATH.'public/upload/sm_evidence_photo';
									if(!is_dir($file_move_path))
		     							mkdir($file_move_path,0777,true);
		     						$evidence_photo_store_path  = 'public/upload/sm_evidence_photo/'.$evidence_pic ;
		     						$upload_evidence_photo = move_uploaded_file($_FILES['evidence_pic']['tmp_name'],$evidence_photo_store_path);
									if(!$upload_evidence_photo){
										$dbstatus = FALSE;
										$dbmessage = 'Evidence Photo Upload Falied';
									}
								}else{
									$dbstatus = FALSE;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0) 1';
								}
							}else{
								$dbstatus = FALSE;
								$dbmessage = 'Please select Image format.';
							}
							$chk = $data['chk_document_upload'];
							for($j = 0; $j< sizeof($chk);$j++ ){
								$insert_form_feedback = array(
									'ticket_id'             => $ticket,
									'question_id'           => $chk[$j],
									'created_by'			=>$this->user_name,
									'created_on' 			=> 	$date,
									'updated_by'			=>$this->user_name,
									'updated_on' 			=> 	$date
								);
								$ticket_form_feedback = $this->db->insert('feedback_qa',$insert_form_feedback);
							}
							if($ticket_form_feedback){
								$update_form = array(
									'visit_purpose' 		=>  $this->security->xss_clean($data['check_reason']),
									'evidence_pic' 			=>  $evidence_photo_store_path,
									'witness_name' 			=>  $this->security->xss_clean($data['txt_witness_name']),
									'witness_no' 		    =>  $this->security->xss_clean($data['txt_witness_number']),
									'remarks' 				=> 	$this->security->xss_clean($data['txt_remarks']),
									'resolved_on' 			=> 	$date,
									'tkt_status'			=>'RESOLVE'
									
									
								);
								$this->db->where('ticket_id',$ticket);
								$ticket_form_update = $this->db->update('schedule_ticket',$update_form);
								if($ticket_form_update){
									$this->db->trans_commit();
									$dbstatus = TRUE;
				        			$dbmessage = 'Data Updated Successfully';
								}else{
									$this->db->trans_rollback();
									$dbstatus = FALSE;
									$dbmessage = 'Error While Updating';
								}
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving';
							}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				default :
		            return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
  	}