<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Vendor_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
	        $this->user_code 	= $this->session->userdata('user_code');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'get_vendor_details':
        			$order = $this->input->post('order');
                	if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
                    	$this->db->order_by($Ocolumn, $Odir);
	                }else{
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('supplier_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	                $this->db->from('supplier');
	                $this->db->select('supplier_code,supplier_name,id');
	                $this->db->order_by('updated_at','DESC');
	                $query = $this->db->get()->result_array();
	                //print_r($this->db->last_query());die();
	            
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->from('supplier ');
	                $this->db->select('supplier_code,supplier_name,id');
	                $this->db->order_by('updated_at','DESC');
	                $res1 = $this->db->get();
	                
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {

	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }//print_r($row);
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
        		break;
        		case 'get_vendor_view_details':
					$this->db->from('supplier');
	                $this->db->select('supplier_code,supplier_name,reg_contact_name,reg_add1,reg_add2,reg_add3,reg_pin,
	                reg_www,reg_email,reg_ph1,reg_ph2,reg_ph3,st_contact_name,st_add1,st_add2,st_add3,st_pin,st_www,st_email,
	                st_ph1,st_ph2,st_ph3,id');
	                $this->db->where('supplier_code', $data['supplier_code']);
	                return $this->db->get()->row_array();
				break;
				case 'get_technician_no':
        			$this->db->from('technician_master');
        			$this->db->select('id,name,phone_no');
        			$this->db->where('supp_code',$data['vendor_id']);
        			return $this->db->get()->result_array();
        		break;
        		case 'get_transaction_list':
        			$this->db->from('transaction_header th');
        			$this->db->select("th.id,c.name1,c.name2,c.name3,
        			CONCAT(IF(th.habitation IS NULL,'',CONCAT(th.habitation,',')),
        			IF(vm.village_name IS NULL,'',CONCAT(vm.village_name,',')),
        			IF(gm.gp_name IS NULL,'',CONCAT(gm.gp_name,',')),
        			IF(bm.block_name IS NULL,'',CONCAT(bm.block_name,',')), 
        			IF(dm.district_name IS NULL,'',CONCAT(dm.district_name,'.'))) AS customer_address");
					$this->db->join('sup_tech_map stm','th.id = stm.transaction_header_id','left');
					$this->db->join('customer c','th.tr_customer_id = c.id','left');
					$this->db->join('village_master vm','th.revenue_village = vm.id','left');
					$this->db->join('block_master bm','th.cd_block = bm.block_code ','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('district_master dm','th.district=dm.district_code','left');
					$this->db->where('stm.transaction_header_id',NULL);
					$this->db->where('th.transaction_status','submitted');
					$this->db->where('th.tr_scheme_id',$data['scheme_id']);
					$this->db->where('th.tr_supplier_id',$data['vendor_id']);
					$this->db->order_by('th.id','DESC');
				 	return $this->db->get()->result_array();
    			break;
    			//The below case is used for fetching vendor technician mapped data
	            case "vendor_tech_mapped_data":
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('s.supplier_code','s.supplier_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	                $this->db->from('supplier s');
	                $this->db->select("s.supplier_code AS supplier_code,s.supplier_name,COUNT(tm.id) AS tech_cnt, IFNULL(cnt,0) AS cnt");
	                $this->db->join('technician_master tm ','s.supplier_code=tm.supp_code AND tm.status=1','left');
	                $this->db->join('(SELECT supplier_id,COUNT(transaction_header_id) AS cnt FROM sup_tech_map GROUP BY supplier_id) stm','s.supplier_code=stm.supplier_id','left');
	               	$this->db->group_by('s.supplier_code, s.supplier_name');
	                $this->db->order_by('s.id','ASC');
	                if($this->role =='VENDOR'){
						$this->db->where('s.fk_user_code',$this->user_code);
					}
	                $res = $this->db->get();
	               // print_r($this->db->last_query());die();
	                $query = $res->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->from('supplier s');
	                $this->db->select("s.supplier_code AS supplier_code,s.supplier_name,COUNT(tm.id) AS tech_cnt, IFNULL(cnt,0) AS cnt");
	                $this->db->join('technician_master tm ','s.supplier_code=tm.`supp_code` AND tm.status=1','left');
	                $this->db->join('(SELECT supplier_id,COUNT(transaction_header_id) AS cnt FROM sup_tech_map GROUP BY supplier_id) stm','s.supplier_code=stm.supplier_id','left');
	               	$this->db->group_by('s.supplier_code, s.supplier_name');
	                $this->db->order_by('s.id','ASC');
	                if($this->role =='VENDOR'){
						$this->db->where('s.fk_user_code',$this->user_code);
					}
	                $res1 = $this->db->get();
	                
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {

	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            
            	case 'village_against_vendor_data':
            		$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('s.scheme_name','sh.supplier_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
 					
 					$this->db->limit($iDisplayLength, $iDisplayStart);
 					$this->db->distinct();
 					$this->db->select('s.scheme_name,sh.supplier_name,sh.supplier_code,s.pk_scheme_code AS scheme_id');
 					$this->db->from('supplier sh');
 					$this->db->join('sup_village_detail ssd','sh.supplier_code=ssd.supplier_id','inner');
 					$this->db->join('scheme_header s','s.pk_scheme_code=ssd.scheme_id','inner');
 					if($this->role =='VENDOR'){
						$this->db->where('sh.fk_user_code',$this->user_code);
					}
	                $res = $this->db->get();
	                //print_r($this->db->last_query());die();
	                $query = $res->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->distinct();
 					$this->db->select('s.scheme_name,sh.supplier_name,sh.supplier_code,s.pk_scheme_code AS scheme_id');
 					$this->db->from('supplier sh');
 					$this->db->join('sup_village_detail ssd','sh.supplier_code=ssd.supplier_id','inner');
 					$this->db->join('scheme_header s','s.pk_scheme_code=ssd.scheme_id','inner');
 					if($this->role =='VENDOR'){
						$this->db->where('sh.fk_user_code',$this->user_code);
					}
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {

	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
				break;
	            //The below case is used for fetching technician details against the selected vendor
				case 'get_technician_against_vendor_data':
					$this->db->from('supplier s');
	            	$this->db->select('s.supplier_code AS supplier_code,s.supplier_name,tm.name,tm.phone_no AS technician_mobile_number, IFNULL(COUNT(transaction_header_id),0) AS cnt');
	            	$this->db->join('technician_master tm','s.supplier_code=tm.supp_code AND tm.status=1','left');
	            	$this->db->join('sup_tech_map stm','s.supplier_code=stm.supplier_id AND tm.phone_no=stm.technician_mobile_number','left');
	            	$this->db->where('s.supplier_code',$data['supplier_id']);
	            	$this->db->group_by('s.supplier_code,s.supplier_name,tm.name,tm.phone_no');
	            	return $this->db->get()->result_array();
				break;
				//The below case is used for fetching task details against technician
				case 'get_technician_task_data':
					//print_r($data);die();
					$this->db->from('sup_tech_map stm');
	            	$this->db->select("th.id,stm.id AS stmid,stm.technician_mobile_number,s.supplier_name,c.name1,c.name2,c.name3, CONCAT(IF(th.habitation IS NULL,'',CONCAT(th.habitation,',')), IF(vm.village_name IS NULL,'',CONCAT(vm.village_name,',')), IF(gm.gp_name IS NULL,'',CONCAT(gm.gp_name,',')), IF(bm.block_name IS NULL,'',CONCAT(bm.block_name,',')), IF(dm.district_name IS NULL,'',CONCAT(dm.district_name,'.'))) AS customer_address, CASE WHEN (th.id=stm.transaction_header_id) THEN '0' ELSE '1' END AS chck,stm.status,stm.transaction_header_id");
	            	$this->db->join('transaction_header th','stm.transaction_header_id = th.id','left');
	            	$this->db->join('customer c','th.tr_customer_id = c.id','left');
	            	$this->db->join('supplier s','stm.supplier_id = s.supplier_code','left');
	            	$this->db->join('village_master vm','th.revenue_village=vm.pk_village_code','left');
	            	$this->db->join('block_master bm','th.cd_block=bm.block_code','left');
	            	$this->db->join('gp_master gm','th.gp=gm.pk_gp_code','left');
	            	$this->db->join('district_master dm','th.district=dm.district_code','left');
	            	//$this->db->where('transaction_status','submitted');
	            	$this->db->where('stm.supplier_id',$data['supplier_id']);
	            	$this->db->where('stm.technician_mobile_number',$data['tech_mobile_no']);
	            	$this->db->order_by('chck','ASC');
	            	$this->db->order_by('th.id','DESC');
	            	return $this->db->get()->result_array();	
				break;
				case 'get_vendor_village_details':
					$this->db->select('svd.id svid,svd.scheme_id,svd.supplier_id,svd.villages,svd.work_order,svd.document_path,
						DATE_FORMAT(svd.created_at,"%d-%m-%y %h:%m:%s") AS created_at,svd.created_by,DATE_FORMAT(svd.created_at,"%d-%m-%y %h:%m:%s") AS created_at,
						svd.updated_by,DATE_FORMAT(svd.updated_at,"%d-%m-%y %h:%m:%s") AS updated_at,vm.pk_village_code,vm.village_name,vm.gp_code,
						sup.id sid, sup.supplier_name, gm.gp_name, bm.block_name, bm.block_code, dm.district_name, dm.district_code,DATE_FORMAT(svd.work_order_date,"%d-%m-%Y") AS work_order_date');
					$this->db->from("sup_village_detail svd");
					$this->db->join('village_master vm','vm.pk_village_code=svd.villages','left');
					$this->db->join('gp_master gm','vm.gp_code=gm.pk_gp_code','left');
					$this->db->join('block_master bm','gm.fk_block_code=bm.block_code','left');
					$this->db->join('district_master dm','bm.fk_district_code=dm.district_code','left');
					$this->db->join('supplier sup','sup.supplier_code=svd.supplier_id','left');
					$this->db->where('svd.supplier_id', $data['supplier_id']);
					$this->db->where('svd.scheme_id', $data['scheme_id']);
					return $this->db->get()->result_array();
				break;
				/**
				* 
				* Name: Siddhartha
				* Modified Date: 30-07-2019
				* Purpose: Work Order Retrival
				* 
				*/
				case 'get_vendor_village_data':
					$this->db->select('sh.scheme_name,sup.supplier_name,svd.work_order,DATE_FORMAT(svd.work_order_date,"%d-%m-%Y") AS work_order_date');
					$this->db->from("sup_village_detail svd");
					$this->db->join('scheme_header sh','svd.scheme_id=sh.pk_scheme_code','left');
					$this->db->join('supplier sup','sup.supplier_code=svd.supplier_id','left');
					$this->db->where('svd.supplier_id', $data['supplier_id']);
					$this->db->where('svd.scheme_id', $data['scheme_id']);
					return $this->db->get()->row_array();
				break;
	            default :
	            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'INSERT_VENDOR_DETAILS_DATA':
        			try{
						$insert_vendor_data = array(
							"supplier_code"			=> $this->security->xss_clean($data['txtVendorCode']),
							"supplier_name	"		=> $this->security->xss_clean($data['txtVendorName']),
							"reg_contact_name"		=> $this->security->xss_clean($data['txtContactName']),
							"reg_add1"				=> $this->security->xss_clean($data['txtAddressOne']),
							"reg_add2"				=> $this->security->xss_clean($data['txtAddressTwo']),
							"reg_add3"				=> $this->security->xss_clean($data['txtAddressThree']),
							"reg_pin"				=> $this->security->xss_clean($data['txtPinCode']),
							"reg_www"				=> $this->security->xss_clean($data['txtWww']),
							"reg_email"				=> $this->security->xss_clean($data['txtEmail']),
							"reg_ph1"				=> $this->security->xss_clean($data['txtPhoneOne']),
							"reg_ph2"				=> $this->security->xss_clean($data['txtPhoneTwo']),
							"reg_ph3"				=> $this->security->xss_clean($data['txtPhoneThree']),
							"st_contact_name"		=> $this->security->xss_clean($data['txtStateContactName']),
							"st_add1"				=> $this->security->xss_clean($data['txtStateAddressOne']),
							"st_add2"				=> $this->security->xss_clean($data['txtStateAddressTwo']),
							"st_add3"				=> $this->security->xss_clean($data['txtStateAddressThree']),
							"st_pin"				=> $this->security->xss_clean($data['txtStatePinCode']),
							"st_www"				=> $this->security->xss_clean($data['txtStateWww']),
							"st_email"				=> $this->security->xss_clean($data['txtStateEmail']),
							"st_ph1"				=> $this->security->xss_clean($data['txtStatePhoneOne']),
							"st_ph2"				=> $this->security->xss_clean($data['txtStatePhoneTwo']),
							"st_ph3"				=> $this->security->xss_clean($data['txtStatePhoneThree']),
							"created_at"			=> $date,
							"created_by"		    => $this->user_name,
							"updated_at"			=> $date,
							"updated_by"		    => $this->user_name
				        );
						$result_vendor_data = $this->db->insert('supplier',$insert_vendor_data);
							if($result_vendor_data){
								$this->db->trans_commit();
								$dbstatus 	= true;
								$dbmessage 	= 'data saved successfully';
							}else{
								$this->db->trans_rollback();
								$dbstatus 	= false;
								$dbmessage 	= 'Error While Saving3';
					        }
						}catch(Exception $e){
					      	$this->db->trans_rollback();
					      	$dbstatus = FALSE;
					      	$dbmessage = $e->getMessage();
					    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		break;
            	case 'UPDATE_VENDOR_DETAILS_DATA':
					$this->db->trans_begin();
					try{
						$id = $this->security->xss_clean($data['hid_vendor_id']);
						$update_vendor_data = array(
					        "supplier_code"			=> $this->security->xss_clean($data['txtVendorCode']),
							"supplier_name	"		=> $this->security->xss_clean($data['txtVendorName']),
							"reg_contact_name"		=> $this->security->xss_clean($data['txtContactName']),
							"reg_add1"				=> $this->security->xss_clean($data['txtAddressOne']),
							"reg_add2"				=> $this->security->xss_clean($data['txtAddressTwo']),
							"reg_add3"				=> $this->security->xss_clean($data['txtAddressThree']),
							"reg_pin"				=> $this->security->xss_clean($data['txtPinCode']),
							"reg_www"				=> $this->security->xss_clean($data['txtWww']),
							"reg_email"				=> $this->security->xss_clean($data['txtEmail']),
							"reg_ph1"				=> $this->security->xss_clean($data['txtPhoneOne']),
							"reg_ph2"				=> $this->security->xss_clean($data['txtPhoneTwo']),
							"reg_ph3"				=> $this->security->xss_clean($data['txtPhoneThree']),
							"st_contact_name"		=> $this->security->xss_clean($data['txtStateContactName']),
							"st_add1"				=> $this->security->xss_clean($data['txtStateAddressOne']),
							"st_add2"				=> $this->security->xss_clean($data['txtStateAddressTwo']),
							"st_add3"				=> $this->security->xss_clean($data['txtStateAddressThree']),
							"st_pin"				=> $this->security->xss_clean($data['txtStatePinCode']),
							"st_www"				=> $this->security->xss_clean($data['txtStateWww']),
							"st_email"				=> $this->security->xss_clean($data['txtStateEmail']),
							"st_ph1"				=> $this->security->xss_clean($data['txtStatePhoneOne']),
							"st_ph2"				=> $this->security->xss_clean($data['txtStatePhoneTwo']),
							"st_ph3"				=> $this->security->xss_clean($data['txtStatePhoneThree']),
							"updated_at"			=> $date,
							"updated_by"		    => $this->user_name
						);
						$this->db->where('id',$id);
						$result_vendor_data= $this->db->update('supplier',$update_vendor_data);
						if($result_vendor_data){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'Data Updated Successfully';
					    }else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				/* 
    			The below case is used for unmapping task against technician
    			Created By : Ashutosh Mishra
    			Created On : 15-05-2019
        		*/
        		case 'unmap_tech_data':
					$this->db->trans_begin();
					try{
						$unmap_data_array =  $data;
						for($i=0;$i<sizeof($unmap_data_array);$i++){
							$this->db->where('transaction_header_id',$unmap_data_array[$i]);
							$this->db->where('status','Open');
							$unmap_data = $this->db->delete('sup_tech_map');
						}
						if($unmap_data){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'Data unmapped successfully';
				    	}else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
				    return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				
				case 'ADD_VENDOR_TECH_MAP' :
					$this->db->trans_begin();
					try{
						for($i=0;$i<sizeof($data['cmb_transaction_tech']);$i++){
							$insert_mapping_data[] = array(
						        "supplier_id"				=> $this->security->xss_clean($data['cmb_vendor_tech']),
								"transaction_header_id"		=> $this->security->xss_clean($data['cmb_transaction_tech'][$i]),
								"technician_mobile_number"	=> $this->security->xss_clean($data['cmb_technician_tech']),
								"status"					=> "Open",
								"created_at"				=> $date,
								"created_by"		   		=> $this->user_name,
							);
						}
						$result_mapping_data= $this->db->insert_batch('sup_tech_map',$insert_mapping_data);
						if($result_mapping_data){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'Data Mapped successfully';
				    	}else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While Mapping';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
				    return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'ADD_LINK_VENDOR_VILLAGE':
					$this->db->trans_begin();
					try{
						$file_type      = 'pdf';
						$document_id 	= $data['cmb_scheme']."_".$data['cmb_vendor']."_".$data['txt_workOrder'];
						$file_name 		= $_FILES['file_document']['name'];
						$allowed_mime_type_arr = array('application/pdf');
						$mime = get_mime_by_extension($file_name);
						$dot_count 	= substr_count($file_name,'.');
						$zero_count = substr_count($file_name,"%0");
						if(in_array($mime, $allowed_mime_type_arr)){
							if($zero_count == 0 && $dot_count == 1){
								$file_move_path  = FCPATH.'public/upload/document/'.$document_id;
								if(!is_dir($file_move_path)){
									mkdir($file_move_path,0777,true);
								}
								$store_path  = 'public/upload/document/'.$document_id.'/'.$file_name ;
								$upload_work_order = move_uploaded_file($_FILES['file_document']['tmp_name'],$store_path);
			
								if($upload_work_order){
									$cmb_district = $this->security->xss_clean($this->input->post('cmb_district'));
									$cmb_block = $this->security->xss_clean($this->input->post('cmb_block'));
									$cmb_grampanchayat = $this->security->xss_clean($this->input->post('cmb_grampanchayat'));
									$cmb_village = $this->security->xss_clean($this->input->post('cmb_village'));
									$selected_vendor = $this->security->xss_clean($this->input->post('cmb_vendor'));
									$selected_scheme = $this->security->xss_clean($this->input->post('cmb_scheme'));
									$work_order_no = $this->security->xss_clean($this->input->post('txt_workOrder'));
									$txt_DateWorkOrder = $this->security->xss_clean(date("Y-m-d", strtotime($this->input->post('txt_DateWorkOrder'))));
									
									for($j = 0; $j< sizeof($cmb_district);$j++ ){
										$insert_vendor_village_details[] = array(
											"scheme_id" 	=> $selected_scheme,
											"supplier_id"   => $selected_vendor,
											"villages"      => $cmb_village[$j],
											"work_order"    => $work_order_no,
											"work_order_date"    => $txt_DateWorkOrder,
											"document_path" => $store_path,
											"created_at"	=>$date,
											"created_by"	=>$this->user_name
										);
									}
									
									$inserted_vendor_village_details = $this->db->insert_batch('sup_village_detail',$insert_vendor_village_details);
									if($inserted_vendor_village_details){
										$this->db->trans_commit();
										$dbstatus = TRUE;
					        			$dbmessage = 'data Save successfully';
									}else{
										$this->db->trans_rollback();
										$dbstatus = FALSE;
										$dbmessage = 'Error While Saving';
									}
								}else{
									
									$dbstatus = false;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
								}
							}else{
								$dbstatus = false;
								$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
							}
						}else{
							$dbstatus = false;
							$dbmessage = 'Please select only '.$file_type.' format.';
						}
						
						return array('status'=>$dbstatus,'msg'=>$dbmessage);
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
				break;
				case 'UPDATE_LINK_VENDOR_VILLAGE':
					$this->db->trans_begin();
					try{
						$file_type      = 'pdf';
						$document_id 	= $data['txt_workOrder'];
						$file_name 		= $_FILES['file_document']['name'];
						$allowed_mime_type_arr = array('application/pdf');
						$mime = get_mime_by_extension($file_name);
						$dot_count 	= substr_count($file_name,'.');
						$zero_count = substr_count($file_name,"%0");
						if(in_array($mime, $allowed_mime_type_arr)){
							if($zero_count == 0 && $dot_count == 1){
								$file_move_path  = FCPATH.'public/upload/document/'.$document_id;
								if(!is_dir($file_move_path)){
									mkdir($file_move_path,0777,true);
								}
								$store_path  = 'public/upload/document/'.$document_id.'/'.$file_name ;
								$upload_work_order = move_uploaded_file($_FILES['file_document']['tmp_name'],$store_path);
			
								if($upload_work_order){
									$work_order_no = $data['txt_workOrder'];
									$work_order_date = date("Y-m-d", strtotime($data['txt_DateWorkOrder']));
									$chk = $data['chk_document_upload'];
									for($j = 0; $j< sizeof($chk);$j++ ){
										$update_vendor_village_details[] = array(
											"work_order"    => $work_order_no,
											"work_order_date"    => $work_order_date,
											"document_path" => $store_path
										);
									$this->db->where('id',$chk[$j]);
									$result_data= $this->db->update('sup_village_detail',$update_vendor_village_details[$j]);
									}
									if($result_data){
										$this->db->trans_commit();
										$dbstatus = TRUE;
					        			$dbmessage = 'data Save successfully';
									}else{
										$this->db->trans_rollback();
										$dbstatus = FALSE;
										$dbmessage = 'Error While Saving';
									}
								}else{
									
									$dbstatus = false;
									$dbmessage = 'Invalid Image format.It should not contain multiple dot(.) or 0)';
								}
							}
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
					return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
			default:
            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}