<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
   	class Mis_model extends CI_Model{
  		function __construct(){
    		parent::__construct();
    		# helper
    		$this->load->helper('date');
	        
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
	        $this->user_code 	= $this->session->userdata('user_code');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'get_list_of_open_cases':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
	                	$this->db->from('raise_ticket a');
		               	$this->db->select('ad.dept_name,s.scheme_name,c.supplier_name,e.consumer_id,CONCAT(IF(e.landmark IS NULL OR e.landmark = " ", " ", CONCAT(e.landmark, ", ")),
								IF(e.habitation IS NULL OR e.habitation = "", "", CONCAT(e.habitation, ", ")),
								IF(vm.village_name IS NULL OR vm.village_name = "", "", CONCAT(vm.village_name, ", ")),
								IF(gm.gp_name IS NULL OR gm.gp_name= "", "", CONCAT(gm.gp_name, ", ")),
								IF(bm.block_name IS NULL OR bm.block_name = "", "", CONCAT(bm.block_name, ", ")),
								IF(dm.district_name IS NULL OR dm.district_name = "", "", CONCAT(dm.district_name, "."))) AS customer_address,
								DATE_FORMAT(a.actual_issue_date, "%d-%m-%Y") AS actual_issue_date,a.ticket_id,
								CASE WHEN a.ticket_status = "CLOSE" THEN DATEDIFF(a.close_date, a.actual_issue_date) ELSE DATEDIFF(NOW(),a.actual_issue_date) END AS no_of_days_open');
		               	$this->db->join('supplier c','a.req_for_to = c.supplier_code','left');
		               	$this->db->join('scheme_header s','a.req_sub_group = s.scheme_code','left');
		               	$this->db->join('transaction_header e','a.req_by = e.tr_customer_id','left');
		               	$this->db->join('village_master vm','e.revenue_village=vm.pk_village_code','left');
		               	$this->db->join('block_master bm','e.cd_block=bm.block_code','left');
		               	$this->db->join('gp_master gm','e.gp=gm.pk_gp_code','left');
		               	$this->db->join('district_master dm','e.district=dm.district_code','left');
		               	$this->db->join('admin_dept ad','ad.admin_dept_code = a.req_group','left');
		               	$this->db->where('a.req_by != "" AND e.transaction_status != "cancelled" ');
		               	$this->db->where_in('a.ticket_status',array('OPEN','REOPEN','RESOLVE'));
		               	if($data['dept_id'] != ""){
							$this->db->where('ad.pk_dept_code',$data['dept_id']);
						}
						if($data['scheme_id'] != ""){
							$this->db->where('a.req_sub_group',$data['scheme_id']);
						}
		              	$this->db->order_by('a.updated_at','DESC');
		               	$this->db->order_by('block_name','ASC');
		                $query = $this->db->get()->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('s.scheme_name,c.supplier_name,e.consumer_id','vm.village_name','gm.gp_name','bm.block_name','dm.district_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string='('.$filter_string.')';
		                }
		                $this->db->limit($iDisplayLength, $iDisplayStart);
		               	$this->db->from('raise_ticket a');
		               	$this->db->select('ad.dept_name,s.scheme_name,c.supplier_name,e.consumer_id,CONCAT(IF(e.landmark IS NULL OR e.landmark = " ", " ", CONCAT(e.landmark, ", ")),
								IF(e.habitation IS NULL OR e.habitation = "", "", CONCAT(e.habitation, ", ")),
								IF(vm.village_name IS NULL OR vm.village_name = "", "", CONCAT(vm.village_name, ", ")),
								IF(gm.gp_name IS NULL OR gm.gp_name= "", "", CONCAT(gm.gp_name, ", ")),
								IF(bm.block_name IS NULL OR bm.block_name = "", "", CONCAT(bm.block_name, ", ")),
								IF(dm.district_name IS NULL OR dm.district_name = "", "", CONCAT(dm.district_name, "."))) AS customer_address,
								DATE_FORMAT(a.actual_issue_date, "%d-%m-%Y") AS actual_issue_date,a.ticket_id,
								CASE WHEN a.ticket_status = "CLOSE" THEN DATEDIFF(a.close_date, a.actual_issue_date) ELSE DATEDIFF(NOW(),a.actual_issue_date) END AS no_of_days_open');
		               	$this->db->join('supplier c','a.req_for_to = c.supplier_code','left');
		               	$this->db->join('scheme_header s','a.req_sub_group = s.scheme_code','left');
		               	$this->db->join('transaction_header e','a.req_by = e.tr_customer_id','left');
		               	$this->db->join('village_master vm','e.revenue_village=vm.pk_village_code','left');
		               	$this->db->join('block_master bm','e.cd_block=bm.block_code','left');
		               	$this->db->join('gp_master gm','e.gp=gm.pk_gp_code','left');
		               	$this->db->join('district_master dm','e.district=dm.district_code','left');
		               	$this->db->join('admin_dept ad','ad.admin_dept_code = a.req_group','left');
		               	$this->db->where('a.req_by != "" AND e.transaction_status != "cancelled" ');
		               	$this->db->where_in('a.ticket_status',array('OPEN','REOPEN','RESOLVE'));
		               	if($data['dept_id'] != ""){
							$this->db->where('ad.pk_dept_code',$data['dept_id']);
						}
						if($data['scheme_id'] != ""){
							$this->db->where('a.req_sub_group',$data['scheme_id']);
						}
		               	if($filter_string!=''){
							$this->db->where($filter_string);
						}
		              	$this->db->order_by('a.updated_at','DESC');
		               	$this->db->order_by('block_name','ASC');
		                $query = $this->db->get()->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $this->db->from('raise_ticket a');
		               	$this->db->select('s.scheme_name,c.supplier_name,e.consumer_id,CONCAT(IF(e.landmark IS NULL OR e.landmark = " ", " ", CONCAT(e.landmark, ", ")),
								IF(e.habitation IS NULL OR e.habitation = "", "", CONCAT(e.habitation, ", ")),
								IF(vm.village_name IS NULL OR vm.village_name = "", "", CONCAT(vm.village_name, ", ")),
								IF(gm.gp_name IS NULL OR gm.gp_name= "", "", CONCAT(gm.gp_name, ", ")),
								IF(bm.block_name IS NULL OR bm.block_name = "", "", CONCAT(bm.block_name, ", ")),
								IF(dm.district_name IS NULL OR dm.district_name = "", "", CONCAT(dm.district_name, "."))) AS customer_address,
								DATE_FORMAT(a.actual_issue_date, "%d-%m-%Y") AS actual_issue_date,a.ticket_id,
								CASE WHEN a.ticket_status = "CLOSE" THEN DATEDIFF(a.close_date, a.actual_issue_date) ELSE DATEDIFF(NOW(),a.actual_issue_date) END AS no_of_days_open');
		               	$this->db->join('supplier c','a.req_for_to = c.supplier_code','left');
		               	$this->db->join('scheme_header s','a.req_sub_group = s.scheme_code','left');
		               	$this->db->join('transaction_header e','a.req_by = e.tr_customer_id','left');
		               	$this->db->join('village_master vm','e.revenue_village=vm.pk_village_code','left');
		               	$this->db->join('block_master bm','e.cd_block=bm.block_code','left');
		               	$this->db->join('gp_master gm','e.gp=gm.pk_gp_code','left');
		               	$this->db->join('district_master dm','e.district=dm.district_code','left');
		               	$this->db->join('admin_dept ad','ad.admin_dept_code = a.req_group','left');
		               	$this->db->where('a.req_by != "" AND e.transaction_status != "cancelled" ');
		               	$this->db->where_in('a.ticket_status',array('OPEN','REOPEN','RESOLVE'));
		               	if($data['dept_id'] != ""){
							$this->db->where('ad.pk_dept_code',$data['dept_id']);
						}
						if($data['scheme_id'] != ""){
							$this->db->where('a.req_sub_group',$data['scheme_id']);
						}
		               	if($filter_string!=''){
							$this->db->where($filter_string);
						}
		              	$this->db->order_by('a.updated_at','DESC');
		               	$this->db->order_by('block_name','ASC');
		                $res1 = $this->db->get();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_dist_abstract_open_data':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $dist_filter = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($data['dist_code'] !=""){
						$dist_filter = "AND e.district = '".$data['dist_code']."'";
					}
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT district_name,supplier_name,CASE WHEN supplier_name IS NULL AND req_sub_group IS NULL THEN 'TOTAL' ELSE req_sub_group END AS req_sub_group,open_case 
							FROM (SELECT dm.district_name,c.supplier_name,a.req_sub_group, COUNT(*) AS open_case
							FROM raise_ticket a
							LEFT JOIN supplier c ON a.req_for_to = c.supplier_code
							LEFT JOIN scheme_header s ON a.req_sub_group = s.scheme_code
							LEFT JOIN transaction_header e ON a.req_by = e.tr_customer_id
							LEFT JOIN admin_dept ad ON ad.admin_dept_code = a.req_group
							LEFT JOIN district_master dm ON dm.district_code = e.district 
							WHERE a.req_by != '' AND e.transaction_status != 'cancelled' 
							AND a.ticket_status IN('OPEN', 'REOPEN', 'RESOLVE') $dist_filter 
							GROUP BY dm.district_name,c.supplier_name,a.req_sub_group WITH ROLLUP
							)s  HAVING   req_sub_group IS NOT NULL AND district_name IS NOT NULL");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('dm.district_name','c.supplier_name','a.req_sub_group');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT district_name,supplier_name,CASE WHEN supplier_name IS NULL AND req_sub_group IS NULL THEN '<b>TOTAL</b>' ELSE req_sub_group END AS req_sub_group,open_case 
							FROM (SELECT dm.district_name,c.supplier_name,a.req_sub_group, COUNT(*) AS open_case
							FROM raise_ticket a
							LEFT JOIN supplier c ON a.req_for_to = c.supplier_code
							LEFT JOIN scheme_header s ON a.req_sub_group = s.scheme_code
							LEFT JOIN transaction_header e ON a.req_by = e.tr_customer_id
							LEFT JOIN admin_dept ad ON ad.admin_dept_code = a.req_group
							LEFT JOIN district_master dm ON dm.district_code = e.district 
							WHERE a.req_by != '' AND e.transaction_status != 'cancelled' 
							AND a.ticket_status IN('OPEN', 'REOPEN', 'RESOLVE') $dist_filter $filter_string
							GROUP BY dm.district_name,c.supplier_name,a.req_sub_group WITH ROLLUP
							)s  HAVING   req_sub_group IS NOT NULL AND district_name IS NOT NULL LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT district_name,supplier_name,CASE WHEN supplier_name IS NULL AND req_sub_group IS NULL THEN '<b>TOTAL</b>' ELSE req_sub_group END AS req_sub_group,open_case 
							FROM (SELECT dm.district_name,c.supplier_name,a.req_sub_group, COUNT(*) AS open_case
							FROM raise_ticket a
							LEFT JOIN supplier c ON a.req_for_to = c.supplier_code
							LEFT JOIN scheme_header s ON a.req_sub_group = s.scheme_code
							LEFT JOIN transaction_header e ON a.req_by = e.tr_customer_id
							LEFT JOIN admin_dept ad ON ad.admin_dept_code = a.req_group
							LEFT JOIN district_master dm ON dm.district_code = e.district 
							WHERE a.req_by != '' AND e.transaction_status != 'cancelled' 
							AND a.ticket_status IN('OPEN', 'REOPEN', 'RESOLVE') $dist_filter $filter_string
							GROUP BY dm.district_name,c.supplier_name,a.req_sub_group WITH ROLLUP
							)s  HAVING   req_sub_group IS NOT NULL AND district_name IS NOT NULL");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_supplier_analysis_data':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT tr_supplier_id,IF(tr_supplier_id IS NULL,'TOTAL',supplier_name) AS supplier_name,no_inst,ROUND((no_inst/tot)*100,2) AS p_ins FROM
								(SELECT COUNT(*)AS tot FROM transaction_header) c JOIN
								(SELECT tr_supplier_id,COUNT(*) AS no_inst FROM transaction_header a 
								WHERE consumer_id IS NOT NULL GROUP BY tr_supplier_id WITH ROLLUP)v
								LEFT JOIN supplier s  ON v.tr_supplier_id = s.supplier_code");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('supplier_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT tr_supplier_id,IF(tr_supplier_id IS NULL,'<b>TOTAL</b>',supplier_name) AS supplier_name,no_inst,ROUND((no_inst/tot)*100,2) AS p_ins FROM
								(SELECT COUNT(*)AS tot FROM transaction_header) c JOIN
								(SELECT tr_supplier_id,COUNT(*) AS no_inst FROM transaction_header a 
								WHERE consumer_id IS NOT NULL GROUP BY tr_supplier_id WITH ROLLUP)v
								LEFT JOIN supplier s  ON v.tr_supplier_id = s.supplier_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT tr_supplier_id,IF(tr_supplier_id IS NULL,'Total',supplier_name) AS supplier_name,no_inst,ROUND((no_inst/tot)*100,2) AS p_ins FROM
								(SELECT COUNT(*)AS tot FROM transaction_header) c JOIN
								(SELECT tr_supplier_id,COUNT(*) AS no_inst FROM transaction_header a 
								WHERE consumer_id IS NOT NULL GROUP BY tr_supplier_id WITH ROLLUP)v
								LEFT JOIN supplier s  ON v.tr_supplier_id = s.supplier_code $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_cm_scheme_performance_one':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $scheme_code = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($data['scheme_id'] !=""){
						$scheme_code = "where scheme_code = '".$data['scheme_id']."'";
					}
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT scheme_name,IFNULL(supplier_name,'TOTAL') AS supplier_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT scheme_code,IFNULL(tr_supplier_id,'TOTAL') AS tr_supplier_id,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.scheme_code,a.tr_supplier_id,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a LEFT JOIN scheme_header b 
							ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a LEFT JOIN
							(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM 
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to FROM raise_ticket 
							WHERE ticket_status='CLOSE' ) a GROUP BY req_sub_group,req_for_to) b ON a.req_sub_group=b.req_sub_group AND a.req_for_to=b.req_for_to) b
							ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a $scheme_code GROUP BY scheme_code,tr_supplier_id WITH ROLLUP) a 
							LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.scheme_code IS NOT NULL");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('scheme_name','supplier_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT scheme_name,IFNULL(supplier_name,'<b>TOTAL</b>') AS supplier_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT scheme_code,IFNULL(tr_supplier_id,'TOTAL') AS tr_supplier_id,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.scheme_code,a.tr_supplier_id,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a LEFT JOIN scheme_header b 
							ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a LEFT JOIN
							(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM 
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to FROM raise_ticket 
							WHERE ticket_status='CLOSE' ) a GROUP BY req_sub_group,req_for_to) b ON a.req_sub_group=b.req_sub_group AND a.req_for_to=b.req_for_to) b
							ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a $scheme_code GROUP BY scheme_code,tr_supplier_id WITH ROLLUP) a 
							LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.scheme_code IS NOT NULL $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT scheme_name,IFNULL(supplier_name,'TOTAL') AS supplier_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT scheme_code,IFNULL(tr_supplier_id,'TOTAL') AS tr_supplier_id,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.scheme_code,a.tr_supplier_id,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a LEFT JOIN scheme_header b 
							ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a LEFT JOIN
							(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM 
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to FROM raise_ticket 
							WHERE ticket_status='CLOSE' ) a GROUP BY req_sub_group,req_for_to) b ON a.req_sub_group=b.req_sub_group AND a.req_for_to=b.req_for_to) b
							ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a $scheme_code GROUP BY scheme_code,tr_supplier_id WITH ROLLUP) a 
							LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.scheme_code IS NOT NULL $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'cm_supplier_performance_two':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $supplier_id = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($data['supplier_id'] !=""){
						$supplier_id = "where tr_supplier_id = '".$data['supplier_id']."'";
					}
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT supplier_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT tr_supplier_id,IFNULL(scheme_code,'TOTAL') AS scheme_code,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.tr_supplier_id,a.scheme_code,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,
							ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a
							LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a 
							LEFT JOIN(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to
							FROM raise_ticket WHERE ticket_status='CLOSE' ) a GROUP BY req_for_to,req_sub_group) b ON a.req_sub_group=b.req_sub_group
							AND a.req_for_to=b.req_for_to ORDER BY a.req_for_to) b ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a
							$supplier_id GROUP BY tr_supplier_id,scheme_code
							WITH ROLLUP) a LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.tr_supplier_id IS NOT NULL");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('scheme_name','supplier_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT supplier_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT tr_supplier_id,IFNULL(scheme_code,'TOTAL') AS scheme_code,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.tr_supplier_id,a.scheme_code,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,
							ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a
							LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a 
							LEFT JOIN(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to
							FROM raise_ticket WHERE ticket_status='CLOSE' ) a GROUP BY req_for_to,req_sub_group) b ON a.req_sub_group=b.req_sub_group
							AND a.req_for_to=b.req_for_to ORDER BY a.req_for_to) b ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a
							$supplier_id GROUP BY tr_supplier_id,scheme_code
							WITH ROLLUP) a LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.tr_supplier_id IS NOT NULL $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT supplier_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,installation_count,tot_tkt,tkt_closed,d_diff,avg_cls,tkt_turn_over FROM 
							(SELECT tr_supplier_id,IFNULL(scheme_code,'TOTAL') AS scheme_code,SUM(IFNULL(installation_count,0)) AS installation_count,
							SUM(IFNULL(tot_tkt,0)) AS tot_tkt,SUM(IFNULL(tkt_closed,0)) AS tkt_closed,SUM(IFNULL(d_diff,0)) AS d_diff,SUM(IFNULL(avg_cls,0)) AS avg_cls,
							SUM(IFNULL(tkt_turn_over,0)) AS tkt_turn_over FROM 
							(SELECT a.tr_supplier_id,a.scheme_code,installation_count,tot_tkt,tkt_closed,d_diff,ROUND((d_diff/tkt_closed)) AS avg_cls,
							ROUND((tkt_closed/tot_tkt),2) AS tkt_turn_over FROM 
							(SELECT COUNT(a.id) AS installation_count,tr_supplier_id,tr_scheme_id,scheme_code FROM transaction_header a
							LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code WHERE consumer_id IS NOT NULL   GROUP BY tr_supplier_id,tr_scheme_id) a 
							LEFT JOIN (SELECT a.req_sub_group,a.req_for_to,tot_tkt,tkt_closed,d_diff FROM 
							(SELECT COUNT(ticket_id) AS tot_tkt, req_sub_group,req_for_to FROM raise_ticket GROUP BY req_sub_group,req_for_to)a 
							LEFT JOIN(SELECT req_sub_group,req_for_to,COUNT(ticket_id) AS tkt_closed,SUM(date_diff) AS d_diff FROM
							(SELECT ticket_id, DATEDIFF(close_date,actual_issue_date) AS date_diff,req_sub_group,req_for_to
							FROM raise_ticket WHERE ticket_status='CLOSE' ) a GROUP BY req_for_to,req_sub_group) b ON a.req_sub_group=b.req_sub_group
							AND a.req_for_to=b.req_for_to ORDER BY a.req_for_to) b ON a.scheme_code=b.req_sub_group AND a.tr_supplier_id=b.req_for_to) a
							$supplier_id GROUP BY tr_supplier_id,scheme_code
							WITH ROLLUP) a LEFT JOIN scheme_header sh ON a.scheme_code=sh.scheme_code 
							LEFT JOIN supplier s ON a.tr_supplier_id=s.supplier_code WHERE a.tr_supplier_id IS NOT NULL $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	             /**
				* 
				* Name: Siddhartha Mishra
				* Date:02-09-2019
				* Purpose: CM_Receipt_Redressal_Status
				* 
				*/
	            case 'get_cm_receipt_redressal_status':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $dept_filter = '';
	                $scheme_filter = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($data['dept_id'] !=""){
						$dept_filter = "AND sh.fk_dept_code = '".$data['dept_id']."'";
					}
					if($data['scheme_id'] !=""){
						$scheme_filter = "AND sh.pk_scheme_code = '".$data['scheme_id']."'";
					}
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT dept_name,scheme_name,supplier_name,IFNULL(reg_req_twk,'0') AS reg_req_twk,IFNULL(reg_req_dwk,'0') AS reg_req_dwk,IFNULL(reg_req_tot,'0') AS reg_req_tot,IFNULL(reg_open_twk,'0') AS reg_open_twk,IFNULL(reg_open_dwk,'0') AS reg_open_dwk,
		               	 IFNULL(reg_open_tot,'0') AS reg_open_tot ,IFNULL(reg_close_twk,'0') AS reg_close_twk,IFNULL(reg_close_dwk,'0') AS reg_close_dwk,
		               	 IFNULL(reg_close_tot,'0') AS reg_close_tot FROM
						(SELECT req_sub_group,IFNULL(supplier_name,'TOTAL') AS supplier_name,SUM(reg_req_tot) AS reg_req_tot,SUM(reg_req_dwk)AS reg_req_dwk,
						SUM(reg_req_twk) AS reg_req_twk,SUM(reg_open_tot) AS reg_open_tot,SUM(reg_open_dwk) AS reg_open_dwk,
						SUM(reg_open_twk) AS reg_open_twk,SUM(reg_close_tot) AS reg_close_tot,SUM(reg_close_dwk) AS reg_close_dwk,SUM(reg_close_twk) AS reg_close_twk FROM
						(SELECT a.req_sub_group,supplier_name,a.reg_total AS reg_req_tot,a.reg_during_week AS reg_req_dwk,a.reg_till_week AS reg_req_twk,
						b.reg_total AS reg_open_tot,b.reg_during_week AS reg_open_dwk,b.reg_till_week AS reg_open_twk,
						c.reg_total AS reg_close_tot,c.reg_during_week AS reg_close_dwk,c.reg_till_week AS reg_close_twk FROM

						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						) a
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						)b ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group)c
						ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						LEFT JOIN supplier s ON a.req_for_to=s.supplier_code 
						ORDER BY a.req_sub_group,a.req_for_to ASC) d  GROUP BY req_sub_group,supplier_name WITH ROLLUP) a
						LEFT JOIN scheme_header sh ON a.req_sub_group=sh.scheme_code
						LEFT JOIN admin_dept ad ON sh.fk_dept_code=ad.pk_dept_code WHERE a.req_sub_group IS NOT NULL $dept_filter $scheme_filter");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('supplier_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT dept_name,scheme_name,supplier_name,IFNULL(reg_req_twk,'0') AS reg_req_twk,IFNULL(reg_req_dwk,'0') AS reg_req_dwk,IFNULL(reg_req_tot,'0') AS reg_req_tot,IFNULL(reg_close_twk,'0') AS reg_close_twk,IFNULL(reg_close_dwk,'0') AS reg_close_dwk, IFNULL(reg_close_tot,'0') AS reg_close_tot,IFNULL(reg_open_twk,'0') AS reg_open_twk,IFNULL(reg_open_dwk,'0') AS reg_open_dwk,IFNULL(reg_open_tot,'0') AS reg_open_tot FROM
						(SELECT req_sub_group,IFNULL(supplier_name,'<b>TOTAL</b>') AS supplier_name,SUM(reg_req_tot) AS reg_req_tot,SUM(reg_req_dwk)AS reg_req_dwk,
						SUM(reg_req_twk) AS reg_req_twk,SUM(reg_open_tot) AS reg_open_tot,SUM(reg_open_dwk) AS reg_open_dwk,
						SUM(reg_open_twk) AS reg_open_twk,SUM(reg_close_tot) AS reg_close_tot,SUM(reg_close_dwk) AS reg_close_dwk,SUM(reg_close_twk) AS reg_close_twk FROM
						(SELECT a.req_sub_group,supplier_name,a.reg_total AS reg_req_tot,a.reg_during_week AS reg_req_dwk,a.reg_till_week AS reg_req_twk,
						b.reg_total AS reg_open_tot,b.reg_during_week AS reg_open_dwk,b.reg_till_week AS reg_open_twk,
						c.reg_total AS reg_close_tot,c.reg_during_week AS reg_close_dwk,c.reg_till_week AS reg_close_twk FROM

						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						) a
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						)b ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group)c
						ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						LEFT JOIN supplier s ON a.req_for_to=s.supplier_code 
						ORDER BY a.req_sub_group,a.req_for_to ASC) d GROUP BY req_sub_group,supplier_name WITH ROLLUP) a
						LEFT JOIN scheme_header sh ON a.req_sub_group=sh.scheme_code
						LEFT JOIN admin_dept ad ON sh.fk_dept_code=ad.pk_dept_code WHERE a.req_sub_group IS NOT NULL $dept_filter $scheme_filter  $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                //print_r($this->db->last_query());die();
		                $query = $qry_one->result_array();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT supplier_name,IFNULL(reg_req_twk,'0') AS reg_req_twk,IFNULL(reg_req_dwk,'0') AS reg_req_dwk,IFNULL(reg_req_tot,'0') AS reg_req_tot,IFNULL(reg_open_twk,'0') AS reg_open_twk,IFNULL(reg_open_dwk,'0') AS reg_open_dwk,IFNULL(reg_open_tot,'0') AS reg_open_tot,IFNULL(reg_close_twk,'0') AS reg_close_twk,IFNULL(reg_close_dwk,'0') AS reg_close_dwk, IFNULL(reg_close_tot,'0') AS reg_close_tot,dept_name,scheme_name FROM
						(SELECT req_sub_group,IFNULL(supplier_name,'TOTAL') AS supplier_name,SUM(reg_req_tot) AS reg_req_tot,SUM(reg_req_dwk)AS reg_req_dwk,
						SUM(reg_req_twk) AS reg_req_twk,SUM(reg_open_tot) AS reg_open_tot,SUM(reg_open_dwk) AS reg_open_dwk,
						SUM(reg_open_twk) AS reg_open_twk,SUM(reg_close_tot) AS reg_close_tot,SUM(reg_close_dwk) AS reg_close_dwk,SUM(reg_close_twk) AS reg_close_twk FROM
						(SELECT a.req_sub_group,supplier_name,a.reg_total AS reg_req_tot,a.reg_during_week AS reg_req_dwk,a.reg_till_week AS reg_req_twk,
						b.reg_total AS reg_open_tot,b.reg_during_week AS reg_open_dwk,b.reg_till_week AS reg_open_twk,
						c.reg_total AS reg_close_tot,c.reg_during_week AS reg_close_dwk,c.reg_till_week AS reg_close_twk FROM

						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						GROUP BY req_for_to,req_sub_group) c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						) a
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group) b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='OPEN'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						)b ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT a.req_for_to,a.req_sub_group,reg_total,reg_during_week,reg_till_week FROM
						(SELECT COUNT(*) AS reg_total ,req_for_to,req_sub_group FROM raise_ticket WHERE ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)a
						LEFT JOIN
						(SELECT COUNT(*) AS reg_during_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) >= DATE(SUBDATE(NOW(), WEEKDAY(NOW())))
						AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)b
						ON a.req_for_to=b.req_for_to AND a.req_sub_group=b.req_sub_group
						LEFT JOIN
						(SELECT COUNT(*) AS reg_till_week ,req_for_to,req_sub_group FROM raise_ticket
						WHERE DATE(created_at) <DATE(SUBDATE(NOW(), WEEKDAY(NOW()))) AND ticket_status='CLOSE'
						GROUP BY req_for_to,req_sub_group)c ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group)c
						ON a.req_for_to=c.req_for_to AND a.req_sub_group=c.req_sub_group
						LEFT JOIN supplier s ON a.req_for_to=s.supplier_code 
						ORDER BY a.req_sub_group,a.req_for_to ASC) d GROUP BY req_sub_group,supplier_name WITH ROLLUP) a
						LEFT JOIN scheme_header sh ON a.req_sub_group=sh.scheme_code
						LEFT JOIN admin_dept ad ON sh.fk_dept_code=ad.pk_dept_code WHERE a.req_sub_group IS NOT NULL $dept_filter $scheme_filter $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	             /**
				* 
				* Name: Siddhartha Mishra
				* Date:02-09-2019
				* Purpose: CM Frequency Received
				* 
				*/
	            case 'get_cm_frequency_received':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,tot_inst,a,b,c,d,e,f,g FROM 
						(SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id, COUNT(*) AS tot_inst  FROM transaction_header  WHERE consumer_id IS NOT NULL  GROUP BY tr_scheme_id WITH ROLLUP) t
						LEFT JOIN (SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id,SUM(CASE WHEN frq=0 THEN cnt ELSE 0 END) AS 'a', SUM(CASE WHEN frq=1 THEN cnt ELSE 0 END) AS 'b',
						SUM(CASE WHEN frq=2 THEN cnt ELSE 0 END) AS 'c',SUM(CASE WHEN frq=3 THEN cnt ELSE 0 END) AS 'd',
						SUM(CASE WHEN frq=4 THEN cnt ELSE 0 END) AS 'e',SUM(CASE WHEN frq=5 THEN cnt ELSE 0 END) AS 'f' ,
						SUM(CASE WHEN frq=6 THEN cnt ELSE 0 END) AS 'g' FROM 
						(SELECT tr_scheme_id,IFNULL(frq,0) AS frq,COUNT(*)AS cnt FROM 
						(SELECT tr_scheme_id,IF(cnt>5,6,cnt) AS frq FROM transaction_header a LEFT JOIN 
						(SELECT COUNT(ticket_id)AS cnt,req_by FROM raise_ticket GROUP BY req_by) b 
						ON a.consumer_id IS NOT NULL  AND a.tr_customer_id= b.req_by)s GROUP BY tr_scheme_id,frq)g 
						GROUP BY tr_scheme_id WITH ROLLUP)s ON t.tr_scheme_id=s.tr_scheme_id
						LEFT JOIN scheme_header a ON s.tr_scheme_id=a.pk_scheme_code
						LEFT JOIN admin_dept b ON a.fk_dept_code=b.pk_dept_code");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('dept_name','scheme_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,tot_inst,a,b,c,d,e,f,g FROM 
						(SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id, COUNT(*) AS tot_inst  FROM transaction_header  WHERE consumer_id IS NOT NULL  GROUP BY tr_scheme_id WITH ROLLUP) t
						LEFT JOIN (SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id,SUM(CASE WHEN frq=0 THEN cnt ELSE 0 END) AS 'a', SUM(CASE WHEN frq=1 THEN cnt ELSE 0 END) AS 'b',
						SUM(CASE WHEN frq=2 THEN cnt ELSE 0 END) AS 'c',SUM(CASE WHEN frq=3 THEN cnt ELSE 0 END) AS 'd',
						SUM(CASE WHEN frq=4 THEN cnt ELSE 0 END) AS 'e',SUM(CASE WHEN frq=5 THEN cnt ELSE 0 END) AS 'f' ,
						SUM(CASE WHEN frq=6 THEN cnt ELSE 0 END) AS 'g' FROM 
						(SELECT tr_scheme_id,IFNULL(frq,0) AS frq,COUNT(*)AS cnt FROM 
						(SELECT tr_scheme_id,IF(cnt>5,6,cnt) AS frq FROM transaction_header a LEFT JOIN 
						(SELECT COUNT(ticket_id)AS cnt,req_by FROM raise_ticket GROUP BY req_by) b 
						ON a.consumer_id IS NOT NULL  AND a.tr_customer_id= b.req_by)s GROUP BY tr_scheme_id,frq)g 
						GROUP BY tr_scheme_id WITH ROLLUP)s ON t.tr_scheme_id=s.tr_scheme_id
						LEFT JOIN scheme_header a ON s.tr_scheme_id=a.pk_scheme_code
						LEFT JOIN admin_dept b ON a.fk_dept_code=b.pk_dept_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                //print_r($this->db->last_query());die();
		                $query = $qry_one->result_array();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,tot_inst,a,b,c,d,e,f,g FROM 
						(SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id, COUNT(*) AS tot_inst  FROM transaction_header  WHERE consumer_id IS NOT NULL  GROUP BY tr_scheme_id WITH ROLLUP) t
						LEFT JOIN (SELECT IFNULL(tr_scheme_id,'TOTAL') AS tr_scheme_id,SUM(CASE WHEN frq=0 THEN cnt ELSE 0 END) AS 'a', SUM(CASE WHEN frq=1 THEN cnt ELSE 0 END) AS 'b',
						SUM(CASE WHEN frq=2 THEN cnt ELSE 0 END) AS 'c',SUM(CASE WHEN frq=3 THEN cnt ELSE 0 END) AS 'd',
						SUM(CASE WHEN frq=4 THEN cnt ELSE 0 END) AS 'e',SUM(CASE WHEN frq=5 THEN cnt ELSE 0 END) AS 'f' ,
						SUM(CASE WHEN frq=6 THEN cnt ELSE 0 END) AS 'g' FROM 
						(SELECT tr_scheme_id,IFNULL(frq,0) AS frq,COUNT(*)AS cnt FROM 
						(SELECT tr_scheme_id,IF(cnt>5,6,cnt) AS frq FROM transaction_header a LEFT JOIN 
						(SELECT COUNT(ticket_id)AS cnt,req_by FROM raise_ticket GROUP BY req_by) b 
						ON a.consumer_id IS NOT NULL  AND a.tr_customer_id= b.req_by)s GROUP BY tr_scheme_id,frq)g 
						GROUP BY tr_scheme_id WITH ROLLUP)s ON t.tr_scheme_id=s.tr_scheme_id
						LEFT JOIN scheme_header a ON s.tr_scheme_id=a.pk_scheme_code
						LEFT JOIN admin_dept b ON a.fk_dept_code=b.pk_dept_code $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	             /**
				* 
				* Name: Siddhartha Mishra
				* Date:02-09-2019
				* Purpose: SM Complaince Statement
				* 
				*/
	            case 'get_sm_complaince_statement':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $output = array("aaData" => array());
	                $page = $data['page'];
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
		               	$res = $this->db->query("SELECT supplier_name,tot_tkt,w1,ROUND((w1/tot_tkt)*100) AS w11 ,w2,ROUND((w2/tot_tkt)*100) AS w22,w3,ROUND((w3/tot_tkt)*100) AS w33,w4,
						ROUND((w4/tot_tkt)*100) AS w44,open_tkt,ROUND((open_tkt/tot_tkt)*100) AS percentage_open_tkt,a.vendor_id FROM 
						(SELECT COUNT(*) AS tot_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW())  GROUP BY `vendor_id`) a
						LEFT JOIN 
						(SELECT vendor_id, MAX(w1) AS w1, MAX(w2) AS w2, MAX(w3) AS w3, MAX(w4) AS w4 FROM (
						SELECT vendor_id,CASE WHEN wk=1 THEN COUNT(*)  ELSE 0 END AS w1 ,
						CASE WHEN wk=2 THEN COUNT(*)  ELSE 0 END AS w2 ,CASE WHEN wk=3 THEN COUNT(*)  ELSE 0 END AS w3 ,CASE WHEN wk=4 THEN COUNT(*)  ELSE 0 END AS w4  FROM
						(SELECT vendor_id,month_code,`c_year`,closing_date,CASE WHEN DAY(closing_date)>=1 AND DAY(closing_date)<8 THEN 1 
						WHEN DAY(closing_date)>=8 AND DAY(closing_date)<15 THEN 2 WHEN DAY(closing_date)>=15 AND DAY(closing_date)<22 THEN 3 WHEN DAY(closing_date)>=22  THEN 4 END AS wk
						FROM schedule_ticket WHERE tkt_status='CLOSED' AND month_code=MONTH(NOW())) a GROUP BY vendor_id,wk)b GROUP BY vendor_id) b 
						ON a.vendor_id=b.vendor_id
						LEFT JOIN (SELECT COUNT(*) AS open_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW()) AND tkt_status!='CLOSED'  GROUP BY `vendor_id`)c
						ON a.vendor_id=c.vendor_id LEFT JOIN supplier s ON   a.vendor_id=s.supplier_code");
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('supplier_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT supplier_name,tot_tkt,w1,ROUND((w1/tot_tkt)*100) AS w11 ,w2,ROUND((w2/tot_tkt)*100) AS w22,w3,ROUND((w3/tot_tkt)*100) AS w33,w4,
						ROUND((w4/tot_tkt)*100) AS w44,open_tkt,ROUND((open_tkt/tot_tkt)*100) AS percentage_open_tkt,a.vendor_id FROM 
						(SELECT COUNT(*) AS tot_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW())  GROUP BY `vendor_id`) a
						LEFT JOIN 
						(SELECT vendor_id, MAX(w1) AS w1, MAX(w2) AS w2, MAX(w3) AS w3, MAX(w4) AS w4 FROM (
						SELECT vendor_id,CASE WHEN wk=1 THEN COUNT(*)  ELSE 0 END AS w1 ,
						CASE WHEN wk=2 THEN COUNT(*)  ELSE 0 END AS w2 ,CASE WHEN wk=3 THEN COUNT(*)  ELSE 0 END AS w3 ,CASE WHEN wk=4 THEN COUNT(*)  ELSE 0 END AS w4  FROM
						(SELECT vendor_id,month_code,`c_year`,closing_date,CASE WHEN DAY(closing_date)>=1 AND DAY(closing_date)<8 THEN 1 
						WHEN DAY(closing_date)>=8 AND DAY(closing_date)<15 THEN 2 WHEN DAY(closing_date)>=15 AND DAY(closing_date)<22 THEN 3 WHEN DAY(closing_date)>=22  THEN 4 END AS wk
						FROM schedule_ticket WHERE tkt_status='CLOSED' AND month_code=MONTH(NOW())) a GROUP BY vendor_id,wk)b GROUP BY vendor_id) b 
						ON a.vendor_id=b.vendor_id
						LEFT JOIN (SELECT COUNT(*) AS open_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW()) AND tkt_status!='CLOSED'  GROUP BY `vendor_id`)c
						ON a.vendor_id=c.vendor_id LEFT JOIN supplier s ON   a.vendor_id=s.supplier_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                //print_r($this->db->last_query());die();
		                $query = $qry_one->result_array();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT supplier_name,tot_tkt,w1,ROUND((w1/tot_tkt)*100) AS w11 ,w2,ROUND((w2/tot_tkt)*100) AS w22,w3,ROUND((w3/tot_tkt)*100) AS w33,w4,
						ROUND((w4/tot_tkt)*100) AS w44,open_tkt,ROUND((open_tkt/tot_tkt)*100) AS percentage_open_tkt,a.vendor_id FROM 
						(SELECT COUNT(*) AS tot_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW())  GROUP BY `vendor_id`) a
						LEFT JOIN 
						(SELECT vendor_id, MAX(w1) AS w1, MAX(w2) AS w2, MAX(w3) AS w3, MAX(w4) AS w4 FROM (
						SELECT vendor_id,CASE WHEN wk=1 THEN COUNT(*)  ELSE 0 END AS w1 ,
						CASE WHEN wk=2 THEN COUNT(*)  ELSE 0 END AS w2 ,CASE WHEN wk=3 THEN COUNT(*)  ELSE 0 END AS w3 ,CASE WHEN wk=4 THEN COUNT(*)  ELSE 0 END AS w4  FROM
						(SELECT vendor_id,month_code,`c_year`,closing_date,CASE WHEN DAY(closing_date)>=1 AND DAY(closing_date)<8 THEN 1 
						WHEN DAY(closing_date)>=8 AND DAY(closing_date)<15 THEN 2 WHEN DAY(closing_date)>=15 AND DAY(closing_date)<22 THEN 3 WHEN DAY(closing_date)>=22  THEN 4 END AS wk
						FROM schedule_ticket WHERE tkt_status='CLOSED' AND month_code=MONTH(NOW())) a GROUP BY vendor_id,wk)b GROUP BY vendor_id) b 
						ON a.vendor_id=b.vendor_id
						LEFT JOIN (SELECT COUNT(*) AS open_tkt,vendor_id FROM `schedule_ticket` WHERE month_code=MONTH(NOW()) AND tkt_status!='CLOSED'  GROUP BY `vendor_id`)c
						ON a.vendor_id=c.vendor_id LEFT JOIN supplier s ON   a.vendor_id=s.supplier_code $filter_string");
		                $res1 = $qry_two->result_array();
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $qry_two->num_rows();
		                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		            }
	                $slno = $iDisplayStart+1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            case 'get_age_analysis_open_case_list':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $page = $data['page'];
	                $output = array("aaData" => array());
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
		            if($page ==  'ALL'){
		            	$res = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,tot_inst,tot_complaint,tot_close,tot_open,less7,less17,more18 FROM 
							(SELECT scheme_code,SUM(tot_inst) AS tot_inst,SUM(IFNULL(tot_complaint,0)) AS tot_complaint,SUM(IFNULL(tot_close,0)) AS tot_close ,
							SUM(IFNULL(tkt,0)) AS tot_open,SUM(IFNULL(tkt7,0)) AS less7,SUM(IFNULL(tkt17,0)) AS less17,SUM(IFNULL(tkt18,0)) AS more18 FROM
							(SELECT scheme_code,COUNT(*) AS tot_inst FROM `transaction_header`a LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code
							WHERE consumer_id IS NOT NULL
							GROUP BY scheme_code)a LEFT JOIN 
							(SELECT req_sub_group,COUNT(*) AS tot_complaint FROM raise_ticket 
							GROUP BY req_sub_group) b ON a.scheme_code=b.req_sub_group LEFT JOIN 
							(SELECT req_sub_group,COUNT(*)AS tot_close FROM raise_ticket
							WHERE ticket_status = 'CLOSE'
							GROUP BY req_sub_group) c ON a.scheme_code=c.req_sub_group LEFT JOIN
							(SELECT s.req_sub_group,tkt,tkt7,tkt17,tkt18 FROM
							(SELECT req_sub_group,COUNT(*) AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') GROUP BY req_sub_group) s INNER JOIN 
							(SELECT req_sub_group,MAX(tkt7) AS tkt7,MAX(tkt17) AS tkt17,MAX(tkt18) AS tkt18 FROM (
							SELECT req_sub_group,CASE WHEN tkt='a' THEN COUNT(tkt) ELSE 0 END AS tkt7,CASE WHEN tkt='b' THEN COUNT(tkt) ELSE 0 END AS tkt17,
							CASE WHEN tkt='c' THEN COUNT(tkt) ELSE 0 END AS tkt18
							FROM 
							(SELECT req_sub_group ,CASE WHEN DATEDIFF(NOW(),actual_issue_date)<8 THEN 'a'  WHEN DATEDIFF(NOW(),actual_issue_date)>=8 AND DATEDIFF(NOW(),actual_issue_date)<18 THEN 'b'
							WHEN DATEDIFF(NOW(),actual_issue_date)>=18  THEN 'c' END AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') ) s 
							GROUP BY req_sub_group,tkt ) d GROUP BY req_sub_group)t ON s.req_sub_group=t.req_sub_group)d ON a.scheme_code=d.req_sub_group
							GROUP BY scheme_code WITH ROLLUP ) a LEFT JOIN scheme_header s ON a.scheme_code=s.scheme_code
							LEFT JOIN `admin_dept` ad ON s.fk_dept_code=ad.pk_dept_code");
		                $query = $res->result_array();
		            }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('dept_name','scheme_name');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' and ('.$filter_string.')';
		                }
		                $qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,tot_inst,tot_complaint,tot_close,tot_open,less7,less17,more18 FROM 
							(SELECT scheme_code,SUM(tot_inst) AS tot_inst,SUM(IFNULL(tot_complaint,0)) AS tot_complaint,SUM(IFNULL(tot_close,0)) AS tot_close ,
							SUM(IFNULL(tkt,0)) AS tot_open,SUM(IFNULL(tkt7,0)) AS less7,SUM(IFNULL(tkt17,0)) AS less17,SUM(IFNULL(tkt18,0)) AS more18 FROM
							(SELECT scheme_code,COUNT(*) AS tot_inst FROM `transaction_header`a LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code
							WHERE consumer_id IS NOT NULL
							GROUP BY scheme_code)a LEFT JOIN 
							(SELECT req_sub_group,COUNT(*) AS tot_complaint FROM `raise_ticket` 
							GROUP BY req_sub_group) b ON a.scheme_code=b.req_sub_group LEFT JOIN 
							(SELECT req_sub_group,COUNT(*)AS tot_close FROM raise_ticket
							WHERE ticket_status = 'CLOSE'
							GROUP BY req_sub_group) c ON a.scheme_code=c.req_sub_group LEFT JOIN
							(SELECT s.req_sub_group,tkt,tkt7,tkt17,tkt18 FROM
							(SELECT req_sub_group,COUNT(*) AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') GROUP BY req_sub_group) s INNER JOIN 
							(SELECT req_sub_group,MAX(tkt7) AS tkt7,MAX(tkt17) AS tkt17,MAX(tkt18) AS tkt18 FROM (
							SELECT req_sub_group,CASE WHEN tkt='a' THEN COUNT(tkt) ELSE 0 END AS tkt7,CASE WHEN tkt='b' THEN COUNT(tkt) ELSE 0 END AS tkt17,
							CASE WHEN tkt='c' THEN COUNT(tkt) ELSE 0 END AS tkt18
							FROM 
							(SELECT req_sub_group ,CASE WHEN DATEDIFF(NOW(),actual_issue_date)<8 THEN 'a'  WHEN DATEDIFF(NOW(),actual_issue_date)>=8 AND DATEDIFF(NOW(),actual_issue_date)<18 THEN 'b'
							WHEN DATEDIFF(NOW(),actual_issue_date)>=18  THEN 'c' END AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') ) s 
							GROUP BY req_sub_group,tkt ) d GROUP BY req_sub_group)t ON s.req_sub_group=t.req_sub_group)d ON a.scheme_code=d.req_sub_group
							GROUP BY scheme_code WITH ROLLUP ) a LEFT JOIN 
							scheme_header s ON a.scheme_code=s.scheme_code
							LEFT JOIN `admin_dept` ad ON s.fk_dept_code=ad.pk_dept_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'Total') AS scheme_name,tot_inst,tot_complaint,tot_close,tot_open,less7,less17,more18 FROM 
							(SELECT scheme_code,SUM(tot_inst) AS tot_inst,SUM(IFNULL(tot_complaint,0)) AS tot_complaint,SUM(IFNULL(tot_close,0)) AS tot_close ,
							SUM(IFNULL(tkt,0)) AS tot_open,SUM(IFNULL(tkt7,0)) AS less7,SUM(IFNULL(tkt17,0)) AS less17,SUM(IFNULL(tkt18,0)) AS more18 FROM
							(SELECT scheme_code,COUNT(*) AS tot_inst FROM `transaction_header`a LEFT JOIN scheme_header b ON a.tr_scheme_id=b.pk_scheme_code
							WHERE consumer_id IS NOT NULL
							GROUP BY scheme_code)a LEFT JOIN 
							(SELECT req_sub_group,COUNT(*) AS tot_complaint FROM `raise_ticket` 
							GROUP BY req_sub_group) b ON a.scheme_code=b.req_sub_group LEFT JOIN 
							(SELECT req_sub_group,COUNT(*)AS tot_close FROM raise_ticket
							WHERE ticket_status = 'CLOSE'
							GROUP BY req_sub_group) c ON a.scheme_code=c.req_sub_group LEFT JOIN
							(SELECT s.req_sub_group,tkt,tkt7,tkt17,tkt18 FROM
							(SELECT req_sub_group,COUNT(*) AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') GROUP BY req_sub_group) s INNER JOIN 
							(SELECT req_sub_group,MAX(tkt7) AS tkt7,MAX(tkt17) AS tkt17,MAX(tkt18) AS tkt18 FROM (
							SELECT req_sub_group,CASE WHEN tkt='a' THEN COUNT(tkt) ELSE 0 END AS tkt7,CASE WHEN tkt='b' THEN COUNT(tkt) ELSE 0 END AS tkt17,
							CASE WHEN tkt='c' THEN COUNT(tkt) ELSE 0 END AS tkt18
							FROM 
							(SELECT req_sub_group ,CASE WHEN DATEDIFF(NOW(),actual_issue_date)<8 THEN 'a'  WHEN DATEDIFF(NOW(),actual_issue_date)>=8 AND DATEDIFF(NOW(),actual_issue_date)<18 THEN 'b'
							WHEN DATEDIFF(NOW(),actual_issue_date)>=18  THEN 'c' END AS tkt FROM raise_ticket WHERE ticket_status IN ('OPEN','REOPEN') ) s 
							GROUP BY req_sub_group,tkt ) d GROUP BY req_sub_group)t ON s.req_sub_group=t.req_sub_group)d ON a.scheme_code=d.req_sub_group
							GROUP BY scheme_code WITH ROLLUP ) a LEFT JOIN 
							scheme_header s ON a.scheme_code=s.scheme_code
							LEFT JOIN `admin_dept` ad ON s.fk_dept_code=ad.pk_dept_code $filter_string");
			                $res1 = $qry_two->result_array();
			                $output["draw"] = intval($this->input->post('draw'));
			                $output['iTotalRecords'] = $qry_two->num_rows();
			                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
			            }
		                $slno = $iDisplayStart+1;
		                foreach ($query as $aRow) {
		                    $row[0] = $slno;
		                    $row['sl_no'] = $slno;
		                    $i = 1;
		                    foreach ($aRow as $key => $value) {
		                        $row[$i] = $value;
		                        $row[$key] = $value;
		                        $i++;
		                    }
		                    $output['aaData'][] = $row;
		                    $slno++;
		                    unset($row);
	                	}
	                return $output;
	            break;
	            /**
				* Name : Subhashree Jena
				* Date :03-09-2019
				* Purpose : Get Trend CM Request
				*/
				case 'get_trend_cm_list':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $page = $data['page'];
	                $output = array("aaData" => array());
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
	                	$qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,req_sub_group,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
						(SELECT req_sub_group, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
						SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM (SELECT req_sub_group,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
						CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
						CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
						CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
						CASE WHEN actual_issue_date<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
						FROM raise_ticket ) a  GROUP BY req_sub_group WITH ROLLUP)a LEFT JOIN scheme_header s ON a.req_sub_group=s.scheme_code
						LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code");
	                $query = $qry_one->result_array();	
	               	}else{
	                	$order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('dept_name','scheme_name','req_sub_group');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3);
		                    $filter_string=' where '.$filter_string ;
		                }
		                $qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,req_sub_group,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
							(SELECT req_sub_group, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
							SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM ( SELECT req_sub_group,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
							CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
							CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
							CASE WHEN actual_issue_date<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
							FROM raise_ticket ) a  GROUP BY req_sub_group WITH ROLLUP)a LEFT JOIN scheme_header s ON a.req_sub_group=s.scheme_code
							LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,req_sub_group,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
							(SELECT req_sub_group, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
							SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM (SELECT req_sub_group,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
							CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
							CASE WHEN actual_issue_date<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
							CASE WHEN actual_issue_date< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
							CASE WHEN actual_issue_date<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
							FROM raise_ticket ) a  GROUP BY req_sub_group WITH ROLLUP)a LEFT JOIN scheme_header s ON a.req_sub_group=s.scheme_code
							LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code $filter_string");
			                $res1 = $qry_two->result_array();
			                $output["draw"] = intval($this->input->post('draw'));
			                $output['iTotalRecords'] = $qry_two->num_rows();
			                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		                }
		                $slno = $iDisplayStart+1;
		                foreach ($query as $aRow) {
		                    $row[0] = $slno;
		                    $row['sl_no'] = $slno;
		                    $i = 1;
		                    foreach ($aRow as $key => $value) {
		                        $row[$i] = $value;
		                        $row[$key] = $value;
		                        $i++;
		                    }
		                    $output['aaData'][] = $row;
		                    $slno++;
		                    unset($row);
	                	}
	                return $output;
	            break;
	            /**
				* Name : Subhashree Jena
				* Date :03-09-2019
				* Purpose : Get Trend new Customer Registration
				*/
				case 'get_trend_new_cm_list':
	            	$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $page = $data['page'];
	                $output = array("aaData" => array());
	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		            $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)
	                if($page ==  'ALL'){
	                	$qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'TOTAL') AS scheme_name,scheme_code,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
							(SELECT tr_scheme_id, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
							SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM (SELECT tr_scheme_id,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
							CASE WHEN date_of_installation<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
							FROM transaction_header WHERE consumer_id IS NOT NULL ) a  GROUP BY tr_scheme_id WITH ROLLUP)a 
							LEFT JOIN scheme_header s ON a.tr_scheme_id=s.pk_scheme_code
							LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code");
	                	$query = $qry_one->result_array();	
	               	}else{
	                	$order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('dept_name','scheme_name','scheme_code');//search filter will work on this column
		                $filter_string="";
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                       $filter_string.=' or '.$header[$i]." LIKE '%".$search['value']."%'";
		                    }
		                    $filter_string=substr($filter_string,3); 
		                    $filter_string=' where '.$filter_string;
		                }
		                $qry_one = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,scheme_code,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
							(SELECT tr_scheme_id, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
							SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM (
							SELECT tr_scheme_id,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
							CASE WHEN date_of_installation<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
							FROM transaction_header WHERE consumer_id IS NOT NULL ) a  GROUP BY tr_scheme_id WITH ROLLUP)a 
							LEFT JOIN scheme_header s ON a.tr_scheme_id=s.pk_scheme_code
							LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code $filter_string LIMIT $iDisplayLength OFFSET $iDisplayStart");
		                $query = $qry_one->result_array();
		                //print_r($this->db->last_query());die();
		                /*----FOR PAGINATION-----*/
		                $qry_two = $this->db->query("SELECT dept_name,IFNULL(scheme_name,'<b>TOTAL</b>') AS scheme_name,scheme_code,b1,b2,b3,b4,c1,c2,c3,c4,t1,t2,t3,t4 FROM
							(SELECT tr_scheme_id, SUM(b1) AS b1 ,SUM(b2) b2,SUM(b3) b3,SUM(b4) b4,SUM(c1) c1,SUM(c2) c2,
							SUM(c3) c3,SUM(c4) c4,SUM(t1) t1,SUM(t2) t2,SUM(t3) t3,SUM(t4)t4 FROM(SELECT tr_scheme_id,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-8')) THEN 1 ELSE 0 END AS b1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-15')) THEN 1 ELSE 0 END AS b2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 2 MONTH)),'-22')) THEN 1 ELSE 0 END AS b3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 2 MONTH)) THEN 1 ELSE 0 END AS b4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-8')) THEN 1 ELSE 0 END AS c1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-15')) THEN 1 ELSE 0 END AS c2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-',MONTH(DATE_SUB(NOW(),INTERVAL 1 MONTH)),'-22')) THEN 1 ELSE 0 END AS c3,
							CASE WHEN date_of_installation<  LAST_DAY(DATE_SUB(NOW(),INTERVAL 1 MONTH)) THEN 1 ELSE 0 END AS c4,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-8')) THEN 1 ELSE 0 END AS t1,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-15')) THEN 1 ELSE 0 END AS t2,
							CASE WHEN date_of_installation< DATE(CONCAT(YEAR(NOW()),'-',MONTH(NOW()),'-22')) THEN 1 ELSE 0 END AS t3,
							CASE WHEN date_of_installation<  LAST_DAY(NOW()) THEN 1 ELSE 0 END AS t4
							FROM transaction_header WHERE consumer_id IS NOT NULL ) a  GROUP BY tr_scheme_id WITH ROLLUP)a 
							LEFT JOIN scheme_header s ON a.tr_scheme_id=s.pk_scheme_code
							LEFT JOIN admin_dept ad ON s.fk_dept_code=ad.pk_dept_code $filter_string");
			                $res1 = $qry_two->result_array();
			                $output["draw"] = intval($this->input->post('draw'));
			                $output['iTotalRecords'] = $qry_two->num_rows();
			                $output['iTotalDisplayRecords'] = $qry_two->num_rows();
		                }
		                $slno = $iDisplayStart+1;
		                foreach ($query as $aRow) {
		                    $row[0] = $slno;
		                    $row['sl_no'] = $slno;
		                    $i = 1;
		                    foreach ($aRow as $key => $value) {
		                        $row[$i] = $value;
		                        $row[$key] = $value;
		                        $i++;
		                    }
		                    $output['aaData'][] = $row;
		                    $slno++;
		                    unset($row);
	                	}
	                return $output;
	            break;
		        default :
		            return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
			}
		}
  	}