<?php
	class Getter_model extends CI_model{
		function __construct(){
        	parent::__construct();
        	if (ENVIRONMENT == 'production'){
		    	$this->db->save_queries = FALSE;
			}
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
        	$this->role 		= $this->session->userdata('role');
        	$this->user_name 	= $this->session->userdata('user_name');
        	$this->user_code 	= $this->session->userdata('user_code');
        	$this->sess_id 	= $this->session->userdata('sess_id');
    	}
    	
		public function get($data, $op){
			$status_flag =   $this->config->item('status_flag');
			switch ($op){
				case 'logout_all_system':
					$this->db->select('user_code');
					$this->db->where('user_name',$this->input->post('txtUserName'));
					$this->db->where('record_status',1);
					$res = $this->db->get('user_master');
					$result = $res->result_array()[0];
					if($result){
						$this->db->where('login_id',$result['user_code']);
						$this->db->where('record_status','ACTIVE');		
						$output = $this->db->update('login_detail',array('record_status'=>'INACTIVE'));
						return $output;
					}
				break;
				case 'get_user_check':
					$num_rows=0;
					$this->db->select('*');
					$this->db->from('login_detail');
					$this->db->where('login_id',$this->user_code);
					$this->db->where('session_id',$this->sess_id);
					$this->db->where('record_status','ACTIVE');
					$get_result=$this->db->get();
					$num_rows=$get_result->num_rows();
					return $num_rows;
				break;			
				case 'get_title':
					$this->db->from('title_setup');
					$this->db->select('title_name,title_desc,title_image');
					$this->db->where('status',1);
					$result = $this->db->get();
					return $result->result_array()[0];
				break;
				case 'get_sidebar':
					$this->db->select('mm.*,rm.resource_link,rm.is_maintenance');
					$this->db->from('menu_master as mm');
					$this->db->join('resource_master as rm','mm.resource_code = rm.resource_code  AND rm.record_status = 1','left');
					$this->db->where('mm.role_code',$this->role);
					$this->db->where('mm.record_status',1);
					$this->db->order_by('mm.sl_no','asc');
					$result = $this->db->get();
					return $result->result_array();
				break;
				case'get_county_name' :
	                $this->db->select('country_code,country_name');
	                $this->db->from('country_master');
	                $this->db->order_by('country_name','asc');
	                $country_res = $this->db->get();
	                return $country_res->result_array();
	            break;
	            case'get_state_name' :
	            	$this->db->from('state_master');
	                $this->db->select('state_code,state_name');
	                $this->db->where('country_code',$data['country_code']);
	                $this->db->order_by('state_name','asc');
	                $state_res = $this->db->get();
	                return $state_res->result_array();
	            break;
	            case'get_dist_name' :
	            	$this->db->from('district_master');
	                $this->db->select('district_code,district_name,dist_census_code');
	                $this->db->where('state_code',$data['state_code']);
	                $this->db->order_by('district_code','asc');
	                $dist_res = $this->db->get();
	                return $dist_res->result_array();
	            break;
	            case'get_block_name' :
	            	$this->db->from('block_master');
	                $this->db->select('block_code,block_name');
	                $this->db->where('fk_district_code',$data['dist_code']);
	                $this->db->order_by('block_name','asc');
	                $block_res = $this->db->get();
	                return $block_res->result_array();
	            break;
	            case'get_gp_name' :
	            	$this->db->from('gp_master');
	                $this->db->select('pk_gp_code,gp_name');
	                $this->db->where('fk_block_code',$data['block_code']);
	                $this->db->order_by('gp_name','asc');
	                $gp_res = $this->db->get();
	                return $gp_res->result_array();
	            break;
	            case'get_village_dropdown' :
	            	if($data['gp_code'] != ''){
						$this->db->where('gp_code',$data['gp_code']);
					}else{
						$this->db->where('1=1');
					}
	            	$this->db->from('village_master');
	                $this->db->select('pk_village_code,village_name');
	                $this->db->order_by('village_name','asc');
	                $village_res = $this->db->get();
	                return $village_res->result_array();
	            break;
	            case'get_village_cnt' :
	            	
	            	$this->db->from('sup_village_detail');
	                $this->db->distinct();
	                $this->db->select('villages');
	                $this->db->where('villages!=',"");
	                $village_res = $this->db->get();
	                return $village_res->result_array();
	            break;
	            
	            // The below case is used for checking duplicate datas at the time of selecting village
	            
	            case 'get_duplicate_data_status' : 
	            	$this->db->from('sup_village_detail');
	                $this->db->select('scheme_id,supplier_id');
	                $this->db->where('villages',$data['selected_village_code_value']);
	                $this->db->where('scheme_id',$data['selected_scheme']);
	                $this->db->where('supplier_id',$data['selected_vendor_code']);
	                $sup_village_detail_result = $this->db->get();
	                return $sup_village_detail_result->result_array();
	            break;
	            
	            // Ends here
	            case 'get_gencode_desc':
	            	$this->db->from('gen_code_desc');
	                $this->db->select('gen_code,description');
	                $this->db->where('gen_code_group',$data['gen_code_group']);
	                $this->db->where('status',1);
	                $this->db->order_by('description','ASC');
	                $res = $this->db->get();
	                return $res->result_array();
	            break;
	            case 'get_action_list':
	            	$this->db->from('gen_code_desc');
	                $this->db->select('gen_code,description,sl_no');
	                $this->db->where('gen_code_group',$data['gen_code_group']);
	                $this->db->where('status',1);
	                $this->db->order_by('sl_no','ASC');
	                $res = $this->db->get();
	                return $res->result_array();
	            break;
	            case 'form_type_mapping':
	            	$this->db->from('gen_code_desc');
	                $this->db->select('description');
	                $this->db->where('gen_code_group','FORM_APPLICANT');
	                $this->db->where('gen_code',$data['form_type_code']);
	                $this->db->where('status',1);
	                $form_res = $this->db->get();
	                return $form_res->result_array();
	            break;
	            case 'get_supplier_list':
        			$this->db->from('supplier');
        			$this->db->select('id,supplier_code,supplier_name');
        			$this->db->order_by('supplier_name','asc');
        			if($this->role == 'VENDOR'){
						$this->db->where('fk_user_code',$this->user_code);
					}
					if($this->role == 'TECHNICIAN'){
						$this->db->where('supplier_code IN (SELECT supp_code FROM technician_master WHERE fk_user_code="'.$this->user_code.'")');
					}
        			return $this->db->get()->result_array();
        		break;
        		case 'get_all_scheme_list':
        			if($data['dept_code'] != ''){
						$this->db->where('fk_dept_code',$data['dept_code']);
					}
        			$this->db->from('scheme_header');
        			$this->db->select('id,pk_scheme_code,scheme_name,scheme_code');
        			$this->db->order_by('scheme_name','asc');
        			return $this->db->get()->result_array();
        		break;
        		case 'get_scheme':
				$this->db->distinct();
				$this->db->from('sup_vendor_mapping');
				$this->db->select('s.supplier_code,sh.scheme_name,sh.pk_scheme_code');
				$this->db->join('supplier s ','supplier_code = supplier_id','left');
				$this->db->join('scheme_header sh','pk_scheme_code = scheme_id','left');
				if($this->role == 'VENDOR'){
				$this->db->where('fk_user_code',$this->user_code);
				}
				return $this->db->get()->result_array();
				break;
				case 'get_technician_list':
				$this->db->from('user_master um');
				$this->db->select('um.user_code,s.supplier_code,tm.name,tm.phone_no');
				$this->db->join('supplier s ','fk_user_code = um.user_code','left');
				$this->db->join('technician_master tm','supp_code = s.supplier_code','left');
				$this->db->order_by('tm.name','asc');
				if($this->role == 'VENDOR'){
					$this->db->where('um.user_code',$this->user_code);
				}
				return $this->db->get()->result_array();
        		break;
        		case 'get_sanction_data':
        			$this->db->where('scheme_header_id',$data['scheme_id']);
        			return $this->db->get('scheme_upload')->result_array();
        		break;
        		case 'get_vendor_data':
					$this->db->select('a.supplier_code,a.supplier_name');
					$this->db->join('sup_village_detail b','b.supplier_id = a.supplier_code','left');
					$this->db->where('b.scheme_id',$data['scheme_id']);
					if($this->role == 'VENDOR'){
						$this->db->where('fk_user_code',$this->user_code);
					}
					$this->db->order_by('a.supplier_name','asc');
					$this->db->group_by('a.supplier_code,a.supplier_name');
					$res = $this->db->get('supplier a');
					return $res->result_array();
				break;
				case 'get_vendor_map_list':
        			$this->db->select('a.supplier_code,a.supplier_name');
        			$this->db->join('sup_village_detail b','b.supplier_id = a.supplier_code','left');
        			if($this->role == 'VENDOR'){
						$this->db->where('fk_user_code',$this->user_code);
					}
        			$this->db->order_by('a.supplier_name','asc');
        			$this->db->group_by('a.supplier_code,a.supplier_name');
        			$res = $this->db->get('supplier a');
        			return $res->result_array();
        		break;
        		case 'get_vendor_against_supplier':
					$this->db->from('supplier s');
	            	$this->db->select('s.supplier_name');
					$this->db->where('s.supplier_code',$data);
					$this->db->order_by('s.supplier_name','asc');
					return $this->db->get()->row_array();
				break;
        		case 'get_all_installation_class':
	            	$this->db->from('installation_class_header');
	            	$this->db->select('id,instal_cls_name');
	            	$this->db->order_by('id','DESC');
	            	return $this->db->get()->result_array();
	            break;
        		case 'get_install_data':
        			$this->db->distinct();
        			$this->db->where('b.scheme_header_id',$data['scheme_id']);
        			$this->db->select('a.id,a.instal_cls_name,a.short_name,b.scheme_header_id');
        			$this->db->join('scheme_details b','a.id = b.installation_class_id','inner');
        			return $this->db->get('installation_class_header a')->result_array();
        		break;
        		case 'get_component_list':
	            	$this->db->from("components");
	            	$this->db->select("id,component_name");
	            	$this->db->order_by('id','ASC');
	            	return $this->db->get()->result_array();
	            break;
	            case 'get_all_admin_department':
	            	$this->db->from('admin_dept');
	            	$this->db->select('pk_dept_code,admin_dept_code,dept_name');
	            	$this->db->where('admin_status',1);
	            	$this->db->order_by('id','ASC');
	            	return $this->db->get()->result_array();
	            break;
	            case 'GET_CUSTOMER_COUNT':
	            	$this->db->where('consumer_id !=""');
	            	return $this->db->get('transaction_header')->num_rows();
	            break;
	            case 'get_email':
            		$this->db->select('reg_email,st_email');
        			$this->db->where('supplier_code',$data['supplier_code']);
        			return $this->db->get('supplier')->result_array();
        		break;
        		//The below case is used for fetching technician data against selected vendor
				case 'fetch_technician_data':
					$this->db->from('technician_master t');
					$this->db->distinct();
	            	$this->db->select('t.id ,t.name,t.phone_no');
					$this->db->where('t.supp_code',$data);
					return $this->db->get()->result_array();
				break;
				case 'fetch_transaction_data':
					$this->db->distinct();
					$this->db->from('transaction_header th');
	            	$this->db->select("th.id, c.name1, c.name2, c.name3, CONCAT(if(th.habitation is null,'',concat(th.habitation,',')),if(vm.village_name is null,'',concat(vm.village_name,',')),if(gm.gp_name is null,'',concat(gm.gp_name,',')),if(bm.block_name is null,'',concat(bm.block_name,',')),if(dm.district_name is null,'',concat(dm.district_name,'.')))AS customer_address");
					$this->db->join('sup_tech_map stm','th.id = stm.transaction_header_id','left');
					$this->db->join('customer c','th.tr_customer_id = c.id','left');
					$this->db->join('village_master vm','th.revenue_village = vm.pk_village_code','left');
					$this->db->join('block_master bm','th.cd_block=bm.block_code','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('district_master dm','th.district=dm.district_code','left');
					$this->db->where('stm.transaction_header_id',null);
					$this->db->where('transaction_status','install' );
					$this->db->where('th.tr_supplier_id',$data['selectedVendor'] );
					$this->db->where('th.tr_scheme_id',$data['selectedScheme'] );
					$this->db->order_by('th.id','DESC');
					return $this->db->get()->result_array();
				break;
	            // Author: Siddhartha Mishra Date:18:05:19  Purpose: get technician detail	
        		case 'get_technician_data':
        			$this->db->from('technician_master');
        			$this->db->select('id,name,phone_no');
        			$this->db->where('supp_code',$data['vendor_id']);
        			$this->db->order_by('name','asc');
        			$this->db->group_by('name,phone_no');
        			return $this->db->get()->result_array();
        		break;
        		// Author: Siddhartha Mishra Date:18:05:19  Purpose: get Ticket List
        		case 'get_ticket_list':
        			$this->db->from('schedule_ticket');
        			$this->db->select('ticket_id');
					$this->db->where('vendor_id',$data['vendor_id']);
					$this->db->where('tkt_status','OPEN');
					if($data['scheme_id']!=""){
						$this->db->where('scheme_id',$data['scheme_id']);
					}
        			$this->db->group_by('ticket_id');
        			return $this->db->get()->result_array();
        		break;
        		case 'get_vendor_against_scheme':
        			if($data['supplier_id']== "All"){
        				$this->db->distinct();
        				$this->db->select('a.pk_scheme_code,a.scheme_name,a.scheme_code');
	        			$this->db->from('scheme_header a');
	        			$this->db->join('sup_village_detail b','a.pk_scheme_code = b.scheme_id','left');
	        			$this->db->order_by('a.scheme_name','asc');
					}else{
						$this->db->distinct();
        				$this->db->select('a.pk_scheme_code,a.scheme_name,a.scheme_code');
	        			$this->db->from('scheme_header a');
	        			$this->db->join('sup_village_detail b','a.pk_scheme_code = b.scheme_id','left');
						$this->db->where('b.supplier_id',$data['supplier_id']);
						$this->db->order_by('a.scheme_name','asc');
					}
					return $this->db->get()->result_array();
				break;
				case 'get_work_order':
					$this->db->distinct();
					$this->db->from('sup_village_detail');
					$this->db->select('work_order');
					$this->db->where('scheme_id',$data['scheme_id']);
					$this->db->where('supplier_id',$data['vendor_id']);
					$this->db->where('villages',$data['village_code']);
					return $this->db->get()->row_array();
				break;
				case 'get_installation_list':
					$this->db->from('installation_class_header ich');
					$this->db->select('ich.id,ich.instal_cls_name');
					$this->db->join('transaction_header th ', ' ich.id = tr_instal_id ', 'left');
					$this->db->group_by('ich.id,ich.instal_cls_name');
					if($data['vendor'] != "All"){
						$this->db->where('th.tr_supplier_id', $data['vendor']);
					}
					if($data['scheme'] != 0){
						$this->db->where('th.tr_scheme_id', $data['scheme']);
					}
					return $this->db->get()->result();
				break;
				case 'get_dist_vendorwise':
        			$dist_data = $this->db->query("SELECT district_code,district_name FROM district_master  WHERE dist_census_code IN (
						SELECT DISTINCT c.fk_district_census_code FROM sup_village_detail a  
						INNER JOIN village_master b ON a.supplier_id='".$data['vendor_id']."' AND a.scheme_id='".$data['scheme_id']."' AND a.villages=b.pk_village_code
						INNER JOIN gp_master c ON b.gp_code=c.pk_gp_code
						WHERE b.status=1 AND c.status=1)
						ORDER BY district_name ASC");
        			return $dist_data->result_array();
        		break;
        		case 'get_block_vendorwise':
        			$block_data = $this->db->query("SELECT block_code,block_name FROM block_master  WHERE block_code IN (
						SELECT DISTINCT bm.block_code FROM sup_village_detail a  
						INNER JOIN village_master b ON a.supplier_id='".$data['vendor_id']."' AND a.scheme_id='".$data['scheme_id']."' AND a.villages=b.pk_village_code
						INNER JOIN gp_master c ON b.gp_code=c.pk_gp_code
						INNER JOIN block_master bm ON bm.block_code=c.fk_block_code AND bm.fk_district_code = '".$data['dist_code']."'
						WHERE b.status=1 AND c.status=1 AND bm.record_status=1)
						ORDER BY block_name ASC");
        			return $block_data->result_array();
        		break;
        		case 'get_gp_vendorwise':
        			$gp_data = $this->db->query("SELECT pk_gp_code,gp_name FROM gp_master  WHERE pk_gp_code IN (
						SELECT DISTINCT b.gp_code FROM sup_village_detail a  
						INNER JOIN village_master b ON a.supplier_id='".$data['vendor_id']."' AND a.scheme_id='".$data['scheme_id']."' AND a.villages=b.pk_village_code
						INNER JOIN gp_master c ON b.gp_code=c.pk_gp_code AND c.fk_block_code ='".$data['block_code']."'
						WHERE b.status=1 AND c.status=1)
						ORDER BY gp_name ASC");
        			return $gp_data->result_array();
        		break;
        		case 'get_village_vendorwise':
        			$village_data = $this->db->query("SELECT pk_village_code,village_name FROM village_master  WHERE pk_village_code IN (
						SELECT DISTINCT b.pk_village_code FROM sup_village_detail a  
						INNER JOIN village_master b ON a.supplier_id='".$data['vendor_id']."' AND a.scheme_id='".$data['scheme_id']."' AND a.villages=b.pk_village_code AND b.gp_code='".$data['gp_code']."'
						WHERE b.status=1)
						ORDER BY village_name ASC");
        			return $village_data->result_array();
        		break;
        		/*case 'get_data_chart1':
					$chart1_component_data = $this->db->query("SELECT complete_system,not_complete_system,(complete_system+not_complete_system) AS total FROM (SELECT SUM(y_id) AS complete_system,SUM(n_id) AS not_complete_system FROM
					(SELECT scheme_header_id,SUM(installation) AS installation FROM  scheme_upload GROUP BY scheme_header_id) a
					LEFT JOIN (SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
					SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(SELECT  tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a 
					GROUP BY  tr_scheme_id,c_id) b GROUP BY tr_scheme_id)  b ON a.scheme_header_id=b.tr_scheme_id WHERE (installation>y_id) OR y_id>0)a ");
        			return $chart1_component_data->result_array();
        		break;	*/
        		case 'get_data_chart1':
					$chart1_component_data = $this->db->query("SELECT SUM(y_id) AS complete_system,SUM(n_id) AS not_complete_system,(SUM(y_id)+ SUM(n_id)) AS total  FROM
					(SELECT scheme_header_id,installation,IFNULL(y_id,0) AS y_id,IFNULL(n_id,0) AS n_id FROM 
					(SELECT scheme_header_id,SUM(installation) AS installation FROM scheme_upload GROUP BY scheme_header_id) a
					LEFT JOIN (SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
					SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(
					SELECT tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a GROUP BY tr_scheme_id,c_id) b GROUP BY tr_scheme_id
					) b ON a.scheme_header_id=b.tr_scheme_id )a WHERE (installation>y_id) OR n_id>0");
        			return $chart1_component_data->result_array();
        		break;	
        		case 'get_data_totalchart':
					$totalchart_data = $this->db->query("SELECT SUM(tot_vendor) AS no_of_wip_vendor,SUM(installation)AS total_system FROM
					(SELECT scheme_header_id,SUM(installation) AS installation FROM  scheme_upload GROUP BY scheme_header_id) a
					LEFT JOIN (SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id 
					FROM(SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(SELECT  tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a 
					GROUP BY  tr_scheme_id,c_id) b GROUP BY tr_scheme_id)  b ON a.scheme_header_id=b.tr_scheme_id
					INNER JOIN (SELECT scheme_id,COUNT(DISTINCT supplier_id)AS tot_vendor FROM sup_village_detail GROUP BY scheme_id)c
					ON a.scheme_header_id=c.scheme_id WHERE (installation>y_id) OR n_id>0");
        			return $totalchart_data->result_array();
        		break;	
        		case 'get_data_projectsdata':
					$totalprojects_data = $this->db->query("SELECT COUNT(a.scheme_header_id) AS no_of_wip_project FROM
					(SELECT scheme_header_id,installation,IFNULL(y_id,0) AS y_id,IFNULL(n_id,0) AS n_id FROM  (SELECT scheme_header_id,SUM(installation) AS installation FROM  scheme_upload GROUP BY scheme_header_id) a
					LEFT JOIN (SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
					SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(SELECT  tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a GROUP BY  tr_scheme_id,c_id) b 
					GROUP BY tr_scheme_id)  b ON a.scheme_header_id=b.tr_scheme_id )a WHERE (installation>y_id) OR n_id>0");
        			return $totalprojects_data->result_array();
        		break;
        		case 'get_data_chart2':
					$chart2_component_data = $this->db->query("SELECT working,lapsed_cnt,(working+lapsed_cnt) AS total FROM 
						( SELECT IFNULL((closed+working+opened+suspended+abandoned),0) AS working,lapsed_cnt 
						FROM (SELECT MAX(CASE WHEN tr_status ='CLOSE' THEN cnt  ELSE 0 END) AS closed,
						MAX(CASE WHEN tr_status ='OPEN' THEN cnt  ELSE 0 END) AS opened,
						MAX(CASE WHEN tr_status ='WORKING' THEN cnt  ELSE 0 END) AS working,
						MAX(CASE WHEN tr_status ='SUSPEND' THEN cnt  ELSE 0 END) AS suspended,
						MAX(CASE WHEN tr_status = 'ABANDONED' THEN cnt ELSE 0 END) AS abandoned 
						FROM(SELECT COUNT(*) AS cnt,tr_status  FROM transaction_header WHERE transaction_status ='approved' AND consumer_id IS NOT NULL 
						AND id NOT IN (SELECT id FROM transaction_header WHERE transaction_status ='approved' AND consumer_id IS NOT NULL AND valid_till<DATE(NOW()))
						GROUP BY tr_status )a ) b JOIN (SELECT COUNT(*) AS lapsed_cnt FROM transaction_header 
						WHERE transaction_status ='approved' AND consumer_id IS NOT NULL AND valid_till<DATE(NOW()))c) a");
        			return $chart2_component_data->result_array();
        		break;	
        		case 'get_vendor_chart2':
					$chart2_vendor_data = $this->db->query("SELECT COUNT(DISTINCT tr_supplier_id) AS no_of_vendor FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE')");
        			return $chart2_vendor_data->result_array();
        		break;
        		case 'get_projects_chart2':
					$chart2_projects_data = $this->db->query("SELECT COUNT(DISTINCT tr_scheme_id ) AS no_of_completed_project FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE')");
        			return $chart2_projects_data->result_array();
        		break;	
        		case 'get_data_chart4':
					$chart4_data = $this->db->query("SELECT tot_tkt,honored,defaulted 
					FROM (SELECT COUNT(*) AS tot_tkt FROM schedule_ticket)a 
					JOIN (SELECT COUNT(*) AS honored FROM schedule_ticket WHERE tkt_status='CLOSED')b 
					JOIN (SELECT COUNT(*) AS defaulted FROM schedule_ticket WHERE tkt_status NOT IN ('CLOSED','OPEN'))c");
        			return $chart4_data->result_array();
        		break;	
        		case 'get_data_chart3':
					$chart3_data = $this->db->query("SELECT tot_tkt,(tot_tkt-suspend_tkt-opened) AS resolved,opened,ROUND((d_cnt/opened),2) AS avg_d_cnt ,suspend_tkt FROM
						(SELECT COUNT(*) AS tot_tkt FROM transaction_header WHERE consumer_id IS NOT NULL 
						AND transaction_status ='approved' AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND tr_status IN ('WORKING','CLOSE','OPEN','SUSPEND','ABANDONED'))a
						JOIN
						(SELECT COUNT(*) AS opened FROM raise_ticket WHERE ticket_status='OPEN' ) b
						JOIN
						(SELECT SUM(DATEDIFF(NOW(),actual_issue_date)) AS d_cnt FROM raise_ticket WHERE ticket_status='OPEN')c
						JOIN 
						(SELECT COUNT(*) AS suspend_tkt FROM transaction_header WHERE consumer_id IS NOT NULL 
						AND transaction_status ='approved' AND DATE(IFNULL(valid_till,NOW()))>=DATE(NOW()) AND tr_status IN ('SUSPEND','ABANDONED'))d");
        			return $chart3_data->result_array();
        		break;
        		case 'get_ticket_component':
					$component_data = $this->db->query("SELECT question_id,id,installation, component,task_desc FROM 
					(SELECT question_id,b.id,c.`description`AS installation ,d.`description` AS component,task_desc,CASE WHEN tkt_type='Y' THEN annual  WHEN tkt_type='H' THEN semi_annual  WHEN tkt_type='Q' THEN quarterly END AS qsn
					FROM schedule_ticket a LEFT JOIN schedule_question b ON a.instal_id=b.installation_class_id
					LEFT JOIN gen_code_desc c ON c.`gen_code_group`='S_INSTALLATION' AND b.`s_installation_id`=c.gen_code
					LEFT JOIN gen_code_desc d ON d.`gen_code_group`='S_COMPONENT' AND b.`s_component_id`=d.gen_code
					LEFT JOIN feedback_qa f ON b.id = f.question_id AND f.ticket_id = '".$data['ticket_id']."' 
					WHERE a.`ticket_id`= '".$data['ticket_id']."'  ORDER BY c.sl_no,d.sl_no ASC) a WHERE qsn=1");
					return $component_data->result_array();
				break;
				/**
				* Name : Subhashree Jena
				* Date :17-09-19
				* Purpose : Get User Role
				*/
        		case 'get_role_code':
        			$this->db->select('role_code,role_name');
        			$this->db->from('role_master');
        			$this->db->where_in('role_name',array('VENDOR','TECHNICIAN'));
        			return $this->db->get()->result_array();
        		break;
        			case 'get_user_role':
        			$this->db->select('user_code,user_name,primary_role,user_display_name');
        			$this->db->from('user_master');
        			$this->db->where_in('primary_role',$data['role']);
        			return $this->db->get()->result_array();
        		break;		
				case 'get_checked_question':
					$checked_data = $this->db->query("SELECT question_id FROM feedback_qa WHERE ticket_id='".$data['ticket_id']."'");
        			return $checked_data->result_array();
        		break;		
				default:
					return array('status'=>false, 'msg'=>'NO_OPERATION');
			}
		}
	}