<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

   	class Crc_model extends CI_Model{
  		function __construct(){
    		// Call the Model constructor
    		parent::__construct();
    		
    		$this->load->helper('date');
	        if (ENVIRONMENT == 'production') {
	            $this->db->save_queries = FALSE;
	        }
	        date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
	        
	        $this->role 		= $this->session->userdata('role');
	        $this->user_name 	= $this->session->userdata('user_name');
 	 	}
 	 	public function get($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
	            case 'get_scheme_type':
	                $this->db->from('lookup_detail');
	                $this->db->select('lookup_id,value');
	                $this->db->where('lookup_name','scheme_type');
	                $this->db->where('status', 'a');
					$this->db->order_by('attr4');
				   return $this->db->get()->result_array();  
	            break;
	            
	            case 'get_installation':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('a.instal_cls_name,a.short_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->from('installation_class_header a');
	               	$this->db->select('a.instal_cls_name,a.short_name,a.type,a.id,a.description,b.installation_header_id,b.component_id');
	               	$this->db->join('installation_class_detail b','a.id = b.installation_header_id','left');
	               	
	               	$this->db->order_by('id','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	               	$this->db->from('installation_class_header a');
	               	$this->db->select('a.instal_cls_name,a.short_name,a.type,a.id,a.description,b.installation_header_id,b.component_id');
	               	$this->db->join('installation_class_detail b','a.id = b.installation_header_id','left');
	               	
	               	$this->db->order_by('id','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = 1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break;
	            
	            case 'get_component_edit':
	            	$this->db->from('installation_class_detail a');
	            	$this->db->select('b.component_name,a.component_id,a.created_by,a.created_at,a.updated_by,a.updated_at');
	            	$this->db->join('components b','b.id = a.component_id','left');
	            	$this->db->where('a.installation_header_id',$data);
	            	return $this->db->get()->result_array();
	            break;
	            case 'get_all_component':
					$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $order = $this->input->post('order');
	                if ($order) {
	                    foreach ($order as $row) {
	                        $Ocolumn = $row['column'];
	                        $Odir = $row['dir'];
	                    }
	                    $this->db->order_by($Ocolumn, $Odir);
	                } else {
	                    $this->db->order_by(1, "ASC");
	                }
	                $search = $this->input->post('search');
	                $header = array('component_name,short_name');//search filter will work on this column
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }

	                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
	                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

	                $this->db->limit($iDisplayLength, $iDisplayStart);
	               	$this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('id','DESC');
	                $query = $this->db->get()->result_array();
	                $output = array("aaData" => array());
	                /*----FOR PAGINATION-----*/
	                if ($search['value'] != '') {
	                    for ($i = 0; $i < count($header); $i++) {
	                        $this->db->or_like($header[$i], $search['value']);
	                    }
	                }
	                $this->db->from('components');
	               	$this->db->select('component_name,short_name,description,id');
	               	$this->db->order_by('id','DESC');
	                $res1 = $this->db->get();
	                $output["draw"] = intval($this->input->post('draw'));
	                $output['iTotalRecords'] = $res1->num_rows();
	                $output['iTotalDisplayRecords'] = $res1->num_rows();
	                $slno = 1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {
	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
	                    $output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
	            break; 
        		
				case 'get_technician_details':
        			$order = '';
	                $Ocolumn = '';
	                $Odir = '';
	                $page = $data['page'];
	                if($page ==  'ALL'){
	                	$this->db->from('technician_master a');
		                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
		                $this->db->join('supplier b', 'b.id = a.id','left');
		                if($data['cmb_vendor']!= ''){
							$this->db->where('a.supp_code',$data['cmb_vendor']);
						}
		                $this->db->order_by('id','DESC');
		               	$res = $this->db->get();
		                $query = $res->result_array();
	                }else{
		                $order = $this->input->post('order');
		                if ($order) {
		                    foreach ($order as $row) {
		                        $Ocolumn = $row['column'];
		                        $Odir = $row['dir'];
		                    }
		                    $this->db->order_by($Ocolumn, $Odir);
		                } else {
		                    $this->db->order_by(1, "ASC");
		                }
		                $search = $this->input->post('search');
		                $header = array('a.name','a.phone_no','a.mail_id','a.address');//search filter will work on this column
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                        $this->db->or_like($header[$i], $search['value']);
		                    }
		                }

		                $iDisplayLength = $this->input->post('length');//to shw number of record to be shown
		                $iDisplayStart = $this->input->post('start');//to start from that position (ex: offset)

		                $this->db->limit($iDisplayLength, $iDisplayStart);
		                $this->db->from('technician_master a');
		                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
		                $this->db->join('supplier b', 'b.id = a.id','left');
		                if($data['cmb_vendor']!= ''){
							$this->db->where('a.supp_code',$data['cmb_vendor']);
						}
		                $this->db->order_by('id','DESC');
		               	$res = $this->db->get();
		                $query = $res->result_array();
		                $output = array("aaData" => array());
						/*----FOR PAGINATION-----*/
		                if ($search['value'] != '') {
		                    for ($i = 0; $i < count($header); $i++) {
		                        $this->db->or_like($header[$i], $search['value']);
		                    }
		                }
		                $this->db->from('technician_master a');
		                $this->db->select('a.name,a.phone_no,a.mail_id,a.address,a.status,a.id,a.supp_code');
		                $this->db->join('supplier b', 'b.id = a.id','left');
		                if($data['cmb_vendor']!= ''){
							$this->db->where('a.supp_code',$data['cmb_vendor']);
						}
		                $this->db->order_by('id','DESC');
		                $res1 = $this->db->get();//echo $this->db->last_query();die();
		                
		                $output["draw"] = intval($this->input->post('draw'));
		                $output['iTotalRecords'] = $res1->num_rows();
		                $output['iTotalDisplayRecords'] = $res1->num_rows();
	               	}
	                $slno = 1;
	                foreach ($query as $aRow) {
	                    $row[0] = $slno;
	                    $row['sl_no'] = $slno;
	                    $i = 1;
	                    foreach ($aRow as $key => $value) {

	                        $row[$i] = $value;
	                        $row[$key] = $value;
	                        $i++;
	                    }
						$output['aaData'][] = $row;
	                    $slno++;
	                    unset($row);
	                }
	                return $output;
        		break;
        		case 'get_supplier_list':
        			$this->db->from('supplier');
        			$this->db->select('id,supplier_code,supplier_name');
        			return $this->db->get()->result_array();
        		break;
        		case 'get_technician_status':
        			$this->db->from('technician_master');
        			$this->db->where('id',$data);
        			return $this->db->get()->row_array();
        		break;
        		
        		case 'get_technician_no':
        			$this->db->from('technician_master');
        			$this->db->select('id,name,phone_no');
        			$this->db->where('id',$data['vendor_id']);
        			return $this->db->get()->result_array();
        		break;
        		case 'get_dist_vendorwise':
        			$dist_data = $this->db->query("SELECT district_code,district_name FROM district_master  WHERE dist_census_code IN (
						SELECT DISTINCT c.fk_district_census_code FROM sup_vendor_mapping a  
						INNER JOIN village_master b ON a.supplier_id='".$data['vendor_id']."' AND a.scheme_id='".$data['scheme_id']."' AND a.fk_village_code=b.pk_village_code
						INNER JOIN gp_master c ON b.gp_code=c.pk_gp_code
						WHERE b.status=1 AND c.status=1)
						ORDER BY district_name ASC");
        			return $dist_data->result_array();
        		break;
        		
        		 /* 
					The below case is used for fetching all scheme data
					Created By : Ashutosh Mishra
					Created On : 27-05-2019
				*/
					
	            case 'get_scheme_details':
	            	$this->db->from('scheme_header');
	            	$this->db->select('id,scheme_code,scheme_name');
	            	return $this->db->get()->result_array();
	            break;
	            /* 
					The below case is used for fetching all Vendor data
					Created By : Ashutosh Mishra
					Created On : 27-05-2019
				*/
				
				
				case 'get_vendor_details_data':
					$this->db->select('supplier_code,supplier_name');
					$this->db->from("supplier");
					return $this->db->get()->result_array();
				
				break;
				
				/* 
					The below case is used for fetching vendor village details
					Created On : 24-05-2019
					Created By : Ashutosh Mishra
				*/
				
				case 'get_vendor_village_details':
				
					$supplier_id = $data['supplier_id'];
					$scheme_id   = $data['scheme_id'];
					
					$this->db->select('svd.*,svd.id svid,vm.*,sup.id sid,sup.supplier_name,gm.gp_name,bm.block_name,bm.block_code,dm.district_name,dm.district_code');
					$this->db->from("sup_village_detail svd");
					$this->db->join('village_master vm','vm.pk_village_code=svd.villages','left');
					$this->db->join('gp_master gm','vm.gp_code=gm.pk_gp_code','left');
					$this->db->join('block_master bm','gm.fk_block_code=bm.block_code','left');
					$this->db->join('district_master dm','bm.fk_district_code=dm.district_code','left');
					$this->db->join('supplier sup','sup.supplier_code=svd.supplier_id','left');
					$this->db->where('svd.supplier_id', $supplier_id);
					$this->db->where('svd.scheme_id', $scheme_id);
					return $this->db->get()->result_array();
					
				break;
				
				// Ends here
        		
        		
        		
        		
	            default :
	            	return array('status' => FALSE, 'msg' =>'Unable to load.Contact Support');
				}
			}
 	 	public function post($data ,$op){
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
			switch($op){
				case 'ADD_INSTALLATION_CLASS':
					$this->db->trans_begin();
					try{
						$insert_installation = array(
							"instal_cls_name"  => $this->security->xss_clean($data['txtClassName']),
							"description" 	 => $this->security->xss_clean($data['txtDescription']),
							"short_name"  	=> 	$this->security->xss_clean($data['txtShortName']),
							"type"  		=> 	$this->security->xss_clean($data['cmbType']),
							"created_by"	=>	$this->user_name,
							"created_at"	=>	$date
						);
						$installation_class = $this->db->insert('installation_class_header',$insert_installation);
						$installation_id = $this->db->insert_id();
						if($installation_class){
							$component =   $this->security->xss_clean($this->input->post('cmb_component'));
							//print_r($component);die();
							for($i = 0; $i< sizeof($component); $i++){
								$installation_details[] = array(
								"installation_header_id" => $installation_id,
								"component_id"			 =>$component[$i],
								"created_by"	=>	$this->user_name,
								"created_at"	=>	$date
							);
							}
							$installation_class_details = $this->db->insert_batch('installation_class_detail',$installation_details);
							if($installation_class_details){
								$this->db->trans_commit();
								$dbstatus = TRUE;
			        			$dbmessage = 'data save successfully';
							}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving';
							}
						}else{
								$this->db->trans_rollback();
								$dbstatus = FALSE;
								$dbmessage = 'Error While Saving1';
							}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				case 'UPDATE_INSTALLATION_CLASS':
				$this->db->trans_begin();
					$id = $this->security->xss_clean($data['hid_id']);
					try{
						$update_installation = array(
							"instal_cls_name"  => $this->security->xss_clean($data['txtClassName']),
							"description" 	 => $this->security->xss_clean($data['txtDescription']),
							"short_name"  	=> 	$this->security->xss_clean($data['txtShortName']),
							"type"  		=> 	$this->security->xss_clean($data['cmbType']),
							"updated_by"	=>	$this->user_name,
							"updated_at"	=>	$date
						);
						//print_r($update_installation);die();
						$this->db->where('id',$id);
						$installation_class = $this->db->update('installation_class_header',$update_installation);
						//$installation_id = $this->db->insert_id();
						if($installation_class){
							$this->db->trans_commit();
							$dbstatus = TRUE;
		        			$dbmessage = 'data Update successfully';
						}else{
							$this->db->trans_rollback();
							$dbstatus = FALSE;
							$dbmessage = 'Error While Saving';
						}
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
			    	}
			    	return array('status'=>$dbstatus,'msg'=>$dbmessage);
				break;
				
				case 'INSERT_TECHNICIAN_DATA':
        		    $this->db->trans_begin();
        		    date_default_timezone_set('Asia/Kolkata');
			        $date = date('Y-m-d H:i:s', time());
        				try{
						$insert_technician_data = array(
								"supp_code"			    => $this->security->xss_clean($data['cmb_vendor']),
								"name	"		        => $this->security->xss_clean($data['txtTechnicianName']),
								"phone_no"		        => $this->security->xss_clean($data['txtPhoneNo']),
								"mail_id"				=> $this->security->xss_clean($data['txtEmailId']),
								"address"				=> $this->security->xss_clean($data['txtAddress']),
								"created_at"			=> $date,
								"created_by"		    => $this->user_name,
								"status"				=> 1
					        );
					        //print_r($insert_technician_data);die();
						 $result_technician_data = $this->db->insert('technician_master',$insert_technician_data);
							if($result_technician_data){
								$this->db->trans_commit();
								$dbstatus 	= true;
								$dbmessage 	= 'data saved successfully';
							}else{
								$this->db->trans_rollback();
								$dbstatus 	= false;
								$dbmessage 	= 'Error While Saving3';
					        }
						}catch(Exception $e){
					      	$this->db->trans_rollback();
					      	$dbstatus = FALSE;
					      	$dbmessage = $e->getMessage();
					    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		break;
        		case 'UPDATE_TECHNICIAN_DATA':
				$this->db->trans_begin();
				 date_default_timezone_set('Asia/Kolkata');
	             $date = date('Y-m-d H:i:s', time());
	             $id = $this->security->xss_clean($this->input->post('hid_technician_code'));
				try{
					$update_technician_entry = array(
						"supp_code"			    => $this->security->xss_clean($data['cmb_vendor']),
						"name"		            => $this->security->xss_clean($data['txtTechnicianName']),
						"phone_no"		        => $this->security->xss_clean($data['txtPhoneNo']),
						"mail_id"				=> $this->security->xss_clean($data['txtEmailId']),
						"address"				=> $this->security->xss_clean($data['txtAddress']),
						"updated_at"		    => $date,
						"updated_by"		    => $this->user_name
			        );
					$this->db->where('id',$id);
					$result_technician_entry= $this->db->update('technician_master',$update_technician_entry);
					if($result_technician_entry){
						$this->db->trans_commit();
						$dbstatus 	= true;
						$dbmessage 	= 'data updated successfully';
				    }else{
						$this->db->trans_rollback();
						$dbstatus 	= false;
						$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
					    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		 break;	
        		 case 'update_technician_status':
        		 	$this->db->trans_begin();
        		 	try{
						$id = $data['tech_id'];
						$status = $data['tech_status'];
						$set = '';
						if($status == 1){
							$set = 0;	
						}else{
							$set = 1;
						}
						$this->db->where('id',$id);
						$update_status = $this->db->update('technician_master',array('status'=>$set));
						if($update_status){
							$this->db->trans_commit();
							$dbstatus 	= true;
							$dbmessage 	= 'Status updated successfully';
				    	}else{
							$this->db->trans_rollback();
							$dbstatus 	= false;
							$dbmessage 	= 'Error While updating';
				        }
					}catch(Exception $e){
				      	$this->db->trans_rollback();
				      	$dbstatus = FALSE;
				      	$dbmessage = $e->getMessage();
				    }
        			return array('status'=>$dbstatus,'msg'=>$dbmessage);
        		break;	
			default:
            	return array('status' => false, 'msg' =>'Unable to load.Contact Support');	
			}
		}
  	}