<?php
	class Dashboard_model extends CI_model{
		function __construct(){
        	parent::__construct();
        	if (ENVIRONMENT == 'production'){
		    	$this->db->save_queries = FALSE;
			}
			date_default_timezone_set('Asia/Kolkata');
			$date = date('Y-m-d H:i:s', time());
        	$this->role 		= $this->session->userdata('role');
        	$this->user_name 	= $this->session->userdata('user_name');
        	$this->user_code 	= $this->session->userdata('user_code');
        	$this->sess_id 		= $this->session->userdata('sess_id');
    	}
    	
		public function get($data, $op){
			switch ($op){
				case 'GET_ROLEWISE_USER':
	                $this->db->select('b.role_name,COUNT(a.user_code) as cnt');
	                $this->db->join('role_master b','a.primary_role=b.role_code','INNER');
					$this->db->where('a.record_status','1');
					$this->db->group_by('b.role_name');
	                $res = $this->db->get('user_master a');
	                return $res->result_array();
				break;
				case 'GET_LOGIN_CURRENT_DATE':
	                $this->db->select('b.user_display_name,DATE_FORMAT(a.created_on,"%d-%m-%Y %h:%i:%s") AS created_on');
	                $this->db->join('user_master b','a.login_id=b.user_code','INNER');
					$this->db->where('b.record_status','1');
					$this->db->where('DATE(a.created_on)',date('Y-m-d'));
					$res = $this->db->get('login_detail a');
	                return $res->result_array();
				break;
				case 'get_scheme_list':
					$this->db->distinct();
					$this->db->select('s.id,s.scheme_name,s.scheme_code,a.dept_name,s.pk_scheme_code');
					$this->db->from('scheme_header s');
					$this->db->join('admin_dept a','s.fk_dept_code=a.pk_dept_code','left');
					$this->db->join('sup_village_detail b','s.pk_scheme_code = b.scheme_id','left');
					$this->db->join('supplier c','c.supplier_code=b.supplier_id','left');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->result_array();
				break;
				case 'get_installation_count':
					$this->db->select('COUNT(1) AS cnt');
					$this->db->from('transaction_header s');
					$this->db->where('s.tr_scheme_id',$data['id']);
					$this->db->where('s.transaction_status != ','cancelled');
					$this->db->join('supplier c','c.supplier_code=s.tr_supplier_id ','left');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_scheme_wise_transacation_details':
					$this->db->select('scheme_name ,COUNT(s.id)AS cnt');
					$this->db->from('transaction_header s');
					$this->db->join('supplier c','c.supplier_code=s.tr_supplier_id','left');
					$this->db->join('scheme_header d','d.pk_scheme_code=s.tr_scheme_id ','left');
					$this->db->where('s.transaction_status != ','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					$this->db->group_by('scheme_name');
					return $this->db->get()->result_array();
				break;
				case 'get_transactioncount':
					$this->db->select('COUNT(*) AS cnt' );
					$this->db->from('transaction_header s');
					//$this->db->join('sup_village_detail b','s.tr_scheme_id = b.scheme_id ','left');
					$this->db->join('supplier c','c.supplier_code=s.tr_supplier_id ','left');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					$this->db->where('s.transaction_status !=', 'cancelled');
					return $this->db->get()->row_array();
				break;
				case 'get_open_cases' :
					$or_condition = "(ticket_status = 'OPEN' OR ticket_status = 'SUSPEND')";
					$this->db->select('COUNT(1) AS cnt');
					$this->db->from('raise_ticket rt');
					$this->db->join('transaction_header th','rt.req_by = th.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=th.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('th.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_cases' :
					$this->db->select('COUNT(1) AS cnt');
					$this->db->from('raise_ticket rt');
					$this->db->join('transaction_header th','rt.req_by = th.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=th.tr_supplier_id ','left');
					$this->db->where('th.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'no_of_days_open':
					$this->db->select('SUM(DATEDIFF(NOW(),STR_TO_DATE(rt.actual_issue_date, "%d-%m-%Y"))) AS cnt');
					$this->db->from('raise_ticket rt');
					$this->db->join('transaction_header th','rt.req_by = th.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=th.tr_supplier_id ','left');
					$this->db->where('rt.ticket_status', 'OPEN');
					$this->db->or_where('rt.ticket_status','SUSPEND');
					$this->db->where('th.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'no_of_days_close' :
					$this->db->select('SUM(DATEDIFF(rt.updated_at,STR_TO_DATE(rt.actual_issue_date, "%d-%m-%Y"))) AS cnt');
					$this->db->from('raise_ticket rt');
					$this->db->join('transaction_header th','rt.req_by = th.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=th.tr_supplier_id ','left');
					$this->db->where('rt.ticket_status', 'CLOSE');
					$this->db->where('th.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_ticket_cases' :
					$this->db->select('count(1) as cnt');
					$this->db->from('raise_ticket rt');
					$this->db->join('transaction_header th','rt.req_by = th.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=th.tr_supplier_id ','left');
					$this->db->where('rt.ticket_status', $data['ticket_status']);
					$this->db->where('th.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_transaction_count_open':
					$or_condition = "(ticket_status = 'OPEN' OR ticket_status = 'SUSPEND')";
					$this->db->select('count(1) as cnt');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_no_of_days_open_scheme':
					$or_condition = "(ticket_status = 'OPEN' OR ticket_status = 'SUSPEND')";
					$this->db->select('SUM(DATEDIFF(NOW(),STR_TO_DATE(actual_issue_date, "%d-%m-%Y"))) AS cnt ');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_ticket_status_scheme' :
					$this->db->select('COUNT(1) AS cnt');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where('a.ticket_status', $data['ticket_status']);
					$this->db->where('a.req_sub_group', $data['scheme_code']);
					$this->db->where('b.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_no_of_days_close_scheme':
					$this->db->select('SUM(DATEDIFF(a.updated_at,STR_TO_DATE(a.actual_issue_date, "%d-%m-%Y"))) AS cnt ');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where('ticket_status','CLOSE');
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_supplier_count':
					$this->db->distinct();
					$this->db->select('a.tr_supplier_id,b.supplier_code,b.supplier_name');
					$this->db->from('transaction_header a');
					$this->db->join('supplier b','a.tr_supplier_id = b.supplier_code','left');
					$this->db->where('a.tr_scheme_id',$data['pk_scheme_code']);
					$this->db->where('a.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('b.fk_user_code',$this->user_code);
					}
					return $this->db->get()->result_array();
				break;
				case 'get_scheme_details' :
					$this->db->select('id,scheme_name,scheme_code,pk_scheme_code');
					$this->db->from('scheme_header');
					$this->db->where('pk_scheme_code',$data['pk_scheme_code']);
					return $this->db->get()->row_array();
				break;
				case 'get_tran_sup_count' :
					$this->db->select('COUNT(1) AS cnt');
					$this->db->from('transaction_header b');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where('b.tr_supplier_id', $data['tr_supplier_id']);
					$this->db->where('b.tr_scheme_id', $data['pk_scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_tran_sup_open':
					$or_condition = "(a.ticket_status = 'OPEN' OR a.ticket_status = 'SUSPEND')";
					$this->db->select('count(1) as cnt');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id ','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('a.req_for_to',$data['tr_supplier_id']);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'no_of_days_open_scheme_sup':
					$or_condition = "(ticket_status = 'OPEN' OR ticket_status = 'SUSPEND')";
					$this->db->select('SUM(DATEDIFF(NOW(),STR_TO_DATE(actual_issue_date, "%d-%m-%Y"))) AS cnt ');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('a.req_for_to',$data['tr_supplier_id']);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_tran_sup_close':
					$this->db->select('count(1) as cnt');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where('a.req_for_to',$data['tr_supplier_id']);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('a.ticket_status', 'CLOSE');
					$this->db->where('b.transaction_status !=','cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'no_of_days_close_scheme_sup':
					$this->db->select('SUM(DATEDIFF(a.updated_at,STR_TO_DATE(a.actual_issue_date, "%d-%m-%Y"))) AS cnt ');
					$this->db->from('raise_ticket a');
					$this->db->join('transaction_header b','a.req_by = b.tr_customer_id','left');
					$this->db->join('supplier c','c.supplier_code=b.tr_supplier_id ','left');
					$this->db->where('a.ticket_status','CLOSE');
					$this->db->where('a.req_for_to',$data['tr_supplier_id']);
					$this->db->where('a.req_sub_group',$data['scheme_code']);
					$this->db->where('b.transaction_status !=', 'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('c.fk_user_code',$this->user_code);
					}
					return $this->db->get()->row_array();
				break;
				case 'get_raise_ticket_cases':
					$or_condition = "(ticket_status = 'OPEN' OR ticket_status = 'SUSPEND')";
					$this->db->select('rt.ticket_id,th.habitation,vm.village_name,gm.gp_name,bm.block_name,dm.district_name,rt.actual_issue_date,
						DATEDIFF(NOW(),rt.actual_issue_date) AS ageing ');
					$this->db->from('raise_ticket rt');
					$this->db->join('customer c','rt.req_by = c.id ','left');
					$this->db->join('transaction_header th','c.id = th.tr_customer_id','left');
					$this->db->join('district_master dm','th.district = dm.district_code','left');
					$this->db->join('block_master bm','th.cd_block = bm.block_code','left');
					$this->db->join('gp_master gm','th.gp = gm.pk_gp_code','left');
					$this->db->join('village_master vm','th.revenue_village = vm.pk_village_code','left');
					$this->db->join('supplier sup','sup.supplier_code=th.tr_supplier_id ','left');
					$this->db->where($or_condition);
					$this->db->where('rt.req_for_to',$data['supplier_code']);
					$this->db->where('rt.req_sub_group',$data['scheme_code']);
					$this->db->where('th.transaction_status !=' ,'cancelled');
					if($this->role =='VENDOR'){
						$this->db->where('sup.fk_user_code',$this->user_code);
					}
					return $this->db->get()->result_array();
				break;
				case 'get_sm_data':
					$query = $this->db->query("SELECT d.c_year,d.month_code,month_yr,tot_tkt, CONCAT(open_tkt,'(',ROUND(((open_tkt/tot_tkt)*100),1),'%)') AS h_tkt,
									CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS d_tkt ,rewards, penalty FROM 
									( SELECT c_year,month_code,CONCAT(month_name,'-',c_year) AS month_yr,MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS open_tkt,
									MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS closed_tkt,SUM(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE 0 END) AS penalty,
									SUM(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE 0 END) AS rewards 
									FROM (
									SELECT a.c_year,a.month_code,b.month_name ,COUNT(*)AS tkts,tkt_status,SUM(tkt_score)AS tkt_score
									FROM (SELECT * FROM schedule_ticket WHERE tkt_status IN ('REJECTED','CLOSED')) a 
									LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id GROUP BY c_year,month_code,tkt_status 
									ORDER BY c_year,month_code DESC) a GROUP BY c_year,month_code
									)d LEFT JOIN 
									(SELECT c_year,month_code,COUNT(*) AS tot_tkt FROM schedule_ticket GROUP BY c_year,month_code)e 
									ON d.c_year=e.c_year AND d.month_code=e.month_code");
					return $query->result_array();		
				break;
				case 'get_sm_vendor_data':
					$query = $this->db->query("SELECT c_year,month_code,month_yr,vendor_id,supplier_name,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,vendor_id,supplier_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,vendor_id,supplier_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."'
						GROUP BY c_year,month_code,vendor_id,supplier_name,tkt_status 
						ORDER BY supplier_name ASC) a GROUP BY c_year,month_code,supplier_name,vendor_id)d");
					return $query->result_array();		
				break;
				case 'get_sm_vendor_scheme_data':
					$query = $this->db->query("SELECT c_year,month_code,month_yr,supplier_name,scheme_name,scheme_id,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,supplier_name,scheme_id,scheme_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,supplier_name,scheme_id,scheme_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code 
						LEFT JOIN scheme_header d ON a.scheme_id =d.pk_scheme_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."' AND vendor_id='".$data['vendor_id']."'
						GROUP BY c_year,month_code,supplier_name,scheme_id,scheme_name,tkt_status 
						ORDER BY scheme_name ASC) a GROUP BY c_year,month_code,supplier_name,scheme_name,scheme_id)d");
					return $query->result_array();		
				break;
				case 'get_sm_scheme_data':
					$query = $this->db->query("SELECT c_year,month_code,month_yr,supplier_name,scheme_name,scheme_id,tot_tkt,IF(month_code=MONTH(NOW()),'OPEN','CLOSE') AS t_status,CONCAT(closed_tkt,'(',ROUND(((closed_tkt/tot_tkt)*100),1),'%)') AS h_tkt, CONCAT(reject_tkt,'(',ROUND(((reject_tkt/tot_tkt)*100),1),'%)') AS d_tkt, IF(closed_tkt_score,closed_tkt_score,0) AS rewards,IF(reject_tkt_score,reject_tkt_score,0) AS penalty FROM 
						(SELECT c_year,month_code,supplier_name,scheme_id,scheme_name,CONCAT(month_name,'-',c_year) AS month_yr,SUM(tkts) AS tot_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkts ELSE 0 END) AS reject_tkt,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkts ELSE 0 END) AS closed_tkt,MAX(CASE WHEN tkt_status='REJECTED' THEN tkt_score ELSE '' END) AS reject_tkt_score,
						MAX(CASE WHEN tkt_status='CLOSED' THEN tkt_score ELSE '' END) AS closed_tkt_score FROM (
						SELECT a.c_year,a.month_code,b.month_name,supplier_name,scheme_id,scheme_name ,COUNT(*) AS tkts,tkt_status,SUM(tkt_score) AS tkt_score
						FROM  schedule_ticket a 
						LEFT JOIN schedule_mth_qtr_mc b ON a.month_code=b.month_id
						LEFT JOIN supplier c ON a.vendor_id =c.supplier_code
						LEFT JOIN scheme_header d ON a.scheme_id =d.pk_scheme_code 
						WHERE c_year='".$data['year']."' AND month_code='".$data['month']."' 
						GROUP BY c_year,month_code,supplier_name,scheme_id,scheme_name,tkt_status 
						ORDER BY scheme_name ASC) a GROUP BY c_year,month_code,supplier_name,scheme_name,scheme_id)d");
					return $query->result_array();		
				break;
				case 'get_status_projects':
					$status_query = $this->db->query("SELECT k.scheme_header_id,scheme_name,sanction_cnt,order_cnt,location_cnt,vendor_cnt,id_generated,detail_uploaded,installation_completed FROM 
						(SELECT a.scheme_header_id FROM
						(SELECT scheme_header_id,SUM(installation) AS installation FROM scheme_upload GROUP BY scheme_header_id) a
						LEFT JOIN (
						SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
						SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(
						SELECT tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a GROUP BY tr_scheme_id,c_id) b GROUP BY tr_scheme_id
						) b ON a.scheme_header_id=b.tr_scheme_id
						WHERE (installation>y_id) OR n_id>0)k
						LEFT JOIN 
						(SELECT COUNT(sanction_order_no) AS sanction_cnt,scheme_header_id FROM scheme_upload GROUP BY scheme_header_id)a
						ON k.scheme_header_id=a.scheme_header_id INNER JOIN
						(SELECT COUNT(work_order) AS order_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)b ON k.scheme_header_id=b.scheme_id
						INNER JOIN 
						(SELECT COUNT(villages) AS location_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)c ON k.scheme_header_id=c.scheme_id
						INNER JOIN 
						(SELECT COUNT(DISTINCT supplier_id) AS vendor_cnt,scheme_id FROM sup_village_detail GROUP BY scheme_id)d ON k.scheme_header_id=d.scheme_id
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id FROM transaction_header WHERE consumer_id IS NOT NULL GROUP BY tr_scheme_id)e ON k.scheme_header_id=e.tr_scheme_id
						INNER JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id FROM transaction_header WHERE transaction_status IN ('approved','submitted') 
						GROUP BY tr_scheme_id)f ON k.scheme_header_id=f.tr_scheme_id
						INNER JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id FROM transaction_header WHERE transaction_status IN ('install','approved','submitted') GROUP BY tr_scheme_id)g
						ON k.scheme_header_id=g.tr_scheme_id
						INNER JOIN scheme_header i ON k.scheme_header_id=i.pk_scheme_code");
					return $status_query->result_array();	
				break;
				case "get_vendor_status_list":
					$query = $this->db->query("SELECT supplier_name,sanction_cnt,order_cnt,location_cnt,id_generated,detail_uploaded,installation_completed,supplier_code,k.scheme_header_id FROM 
						(SELECT a.scheme_header_id FROM
						(SELECT scheme_header_id,SUM(installation) AS installation FROM scheme_upload GROUP BY scheme_header_id) a
						LEFT JOIN (
						SELECT tr_scheme_id,IFNULL(MAX(CASE WHEN c_id=0 THEN c_cnt END),0) AS n_id,IFNULL(MAX(CASE WHEN c_id=1 THEN c_cnt END),0) AS y_id FROM( 
						SELECT tr_scheme_id,c_id, COUNT(c_id)AS c_cnt FROM(
						SELECT tr_scheme_id,IF(consumer_id IS NULL,0,1)AS c_id FROM transaction_header ) a GROUP BY tr_scheme_id,c_id) b GROUP BY tr_scheme_id
						) b ON a.scheme_header_id=b.tr_scheme_id
						WHERE (installation>y_id) OR n_id>0 )k INNER JOIN
						(SELECT COUNT(sanction_order_no) AS sanction_cnt,scheme_header_id FROM scheme_upload GROUP BY scheme_header_id)a
						ON k.scheme_header_id=a.scheme_header_id INNER JOIN
						(SELECT COUNT(work_order) AS order_cnt,supplier_id,scheme_id FROM sup_village_detail GROUP BY scheme_id,supplier_id)b ON k.scheme_header_id=b.scheme_id
						INNER JOIN 
						(SELECT COUNT(villages) AS location_cnt,supplier_id,scheme_id FROM sup_village_detail GROUP BY scheme_id,supplier_id)c ON k.scheme_header_id=c.scheme_id AND b.supplier_id=c.supplier_id
						left JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE consumer_id IS NOT NULL GROUP BY tr_scheme_id,tr_supplier_id)e 
						ON k.scheme_header_id=e.tr_scheme_id AND b.supplier_id=e.tr_supplier_id
						left JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('approved','submitted') 
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.scheme_header_id=f.tr_scheme_id AND b.supplier_id=f.tr_supplier_id
						left JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('install','approved','submitted') GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.scheme_header_id=g.tr_scheme_id AND b.supplier_id=g.tr_supplier_id
						INNER JOIN supplier i ON b.supplier_id=i.supplier_code
						WHERE k.scheme_header_id='".$data['scheme_id']."' ");
					return $query->result_array();
				break;
				case 'get_vendor_wise_status_list':
					$query = $this->db->query("SELECT consumer_id,district_name,village_name,block_name,gp_name,created_at,id_generated,detail_uploaded,installation_completed,date_of_installation FROM 
						(SELECT consumer_id,work_order,tr_scheme_id,tr_supplier_id,district_name,village_name,block_name,gp_name,a.revenue_village,date_of_installation FROM transaction_header a
						LEFT JOIN district_master d ON a.district=d.district_code
						LEFT JOIN block_master b ON a.cd_block=b.block_code
						LEFT JOIN gp_master g ON a.gp=g.pk_gp_code
						LEFT JOIN village_master v ON a.revenue_village=v.pk_village_code
						WHERE tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."')k 
						LEFT JOIN

						(SELECT work_order ,villages,supplier_id,scheme_id,DATE(created_at) AS created_at FROM sup_village_detail WHERE scheme_id='".$data['scheme_id']."' AND supplier_id='".$data['supplier_code']."')b 
						ON k.tr_scheme_id=b.scheme_id AND k.tr_supplier_id=b.supplier_id AND k.work_order=b.work_order AND k.revenue_village=b.villages
						LEFT JOIN 
						(SELECT COUNT(*) AS id_generated,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."')e 
						ON k.tr_scheme_id=e.tr_scheme_id AND b.supplier_id=e.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS detail_uploaded,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('approved','submitted') AND tr_scheme_id='".$data['scheme_id']."' AND tr_supplier_id='".$data['supplier_code']."'
						GROUP BY tr_scheme_id,tr_supplier_id)f ON k.tr_scheme_id=f.tr_scheme_id AND b.supplier_id=f.tr_supplier_id
						LEFT JOIN
						(SELECT COUNT(*) AS installation_completed,tr_scheme_id,tr_supplier_id FROM transaction_header WHERE transaction_status IN ('install','approved','submitted') AND tr_scheme_id='".$data['scheme_id']."'
						AND tr_supplier_id='".$data['supplier_code']."' GROUP BY tr_scheme_id,tr_supplier_id)g
						ON k.tr_scheme_id=g.tr_scheme_id AND b.supplier_id=g.tr_supplier_id");
					return $query->result_array();
				break;
				case 'project_asset_status':
					$asset_data = $this->db->query("SELECT vendor_cnt,scheme_cnt,installation FROM 
					(SELECT COUNT(DISTINCT tr_supplier_id) AS vendor_cnt FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE'))a
					INNER JOIN (SELECT COUNT(DISTINCT tr_scheme_id ) AS scheme_cnt FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE')) b
					INNER JOIN (SELECT COUNT(*) AS installation FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE'))c");
        			return $asset_data->row_array();
        		break;
        		case 'projectwise_asset_status':
	                $this->db->select('tr_scheme_id,b.scheme_name,COUNT(a.id) AS installation,COUNT(DISTINCT tr_supplier_id) AS vendor');
	                $this->db->from('scheme_header b');
	                $this->db->join('transaction_header a','a.tr_scheme_id=b.pk_scheme_code','LEFT');
					$this->db->where('consumer_id !=','');
					$this->db->where_in('tr_status',array("WORKING","CLOSE"));
					$this->db->group_by('tr_scheme_id,b.scheme_name');
	                $res = $this->db->get();
	                return $res->result_array();
				break;	
				case 'schemewise_asset_status':
	                $this->db->select("th.consumer_id, CONCAT(IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')),
					IF(IFNULL(vm.village_name, '')='', '', CONCAT(vm.village_name, ', ')), 
					IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), 
					IF(IFNULL(bm.block_name, '')='', '', CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address,sh.supplier_name");
	                $this->db->from('transaction_header th');
	                $this->db->join('village_master vm','th.revenue_village=vm.pk_village_code','LEFT');
	                $this->db->join('block_master bm','th.cd_block=bm.block_code','LEFT');
	                $this->db->join('gp_master gm','th.gp=gm.pk_gp_code','LEFT');
	                $this->db->join('district_master dm','th.district=dm.district_code','LEFT');
	                $this->db->join('supplier sh','sh.supplier_code = th.tr_supplier_id','LEFT');
					$this->db->where('transaction_status !=','cancelled');
					$this->db->where('th.consumer_id !=','');
					$this->db->where('th.tr_scheme_id=',$data['scheme_id']);
					$this->db->order_by('th.id');
	                $res = $this->db->get();
	                return $res->result_array();
				break;
				case 'get_asset_vendor_count':
					$query = $this->db->query("SELECT vendor_cnt,scheme_cnt,installation FROM 
					(SELECT COUNT(DISTINCT tr_supplier_id) AS vendor_cnt FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE'))a
					INNER JOIN
					(SELECT COUNT(DISTINCT tr_scheme_id ) AS scheme_cnt FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE')) b
					INNER JOIN
					(SELECT COUNT(*) AS installation FROM transaction_header WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE'))c");
				return $query->row_array();
				break;
				case 'get_vendor_asset_project_list':
				$query = $this->db->query("SELECT sh.scheme_code,th.consumer_id, CONCAT(IF(IFNULL(th.habitation, '')='', '', CONCAT(th.habitation, ', ')),
					IF(IFNULL(vm.village_name, '')='', '', CONCAT(vm.village_name, ', ')), 
					IF(IFNULL(gm.gp_name, '')='', '', CONCAT(gm.gp_name, ', ')), 
					IF(IFNULL(bm.block_name, '')='', '', CONCAT(bm.block_name, ', ')), dm.district_name) AS customer_address
					FROM transaction_header th
					LEFT JOIN village_master vm ON th.revenue_village=vm.pk_village_code
					LEFT JOIN block_master bm ON th.cd_block=bm.block_code
					LEFT JOIN gp_master gm ON th.gp=gm.pk_gp_code
					LEFT JOIN district_master dm ON th.district=dm.district_code
					LEFT JOIN scheme_header sh ON sh.pk_scheme_code = th.tr_scheme_id
					WHERE transaction_status != 'cancelled'
					AND th.consumer_id !='' AND th.tr_supplier_id='".$data['supplier_code']."'
					ORDER BY th.id DESC");
				return $query->result_array();
				break;
				case "get_vendor_asset_status_list":
					$query = $this->db->query("SELECT tr_supplier_id,supplier_name,COUNT(a.id) AS installation,COUNT(DISTINCT tr_scheme_id) AS scheme 
						FROM transaction_header a 
						LEFT JOIN supplier b ON a.tr_supplier_id=b.supplier_code
						WHERE consumer_id IS NOT NULL AND tr_status IN ('WORKING','CLOSE')
						GROUP BY tr_supplier_id");
					return $query->result_array();
				break;
				/**
				* Name : Subhashree jena
				* Date :09-08-2019
				* Purpose: Technician ticket count
				* @var 
				* 
				*/
				case 'get_tech_installation_count':
					$query = $this->db->query("SELECT open_inst,closed FROM
						(SELECT COUNT(*)AS open_inst FROM `sup_tech_map` WHERE STATUS = 'open' AND `technician_mobile_number` = '".$this->user_name."')a JOIN 
						(SELECT COUNT(*) AS closed FROM `sup_tech_map` WHERE STATUS = 'Closed' AND `technician_mobile_number` = '".$this->user_name."' )b ");
					return $query->row_array();
				break;
				case 'get_tech_schedule_ticket_count':
					$query = $this->db->query("SELECT open_tkt,close_tkt FROM 
						(SELECT COUNT(*) AS open_tkt FROM `schedule_ticket` WHERE technician_id='".$this->user_name."' AND tkt_status='OPEN') a JOIN
						(SELECT COUNT(*) AS close_tkt FROM `schedule_ticket` WHERE technician_id='".$this->user_name."' AND tkt_status IN('RESOLVE','CLOSED')) b ");
					return $query->row_array();
				break;
				case 'get_tech_corrective_ticket_count':
					$query = $this->db->query("SELECT open_tkt,close_tkt FROM
						(SELECT COUNT(*) AS open_tkt FROM raise_ticket WHERE technician_id = '".$this->user_name."' AND ticket_status IN ('OPEN','REOPEN')) a JOIN
						(SELECT COUNT(*) AS close_tkt FROM raise_ticket WHERE technician_id = '".$this->user_name."' AND ticket_status  ='CLOSE') b ");
					return $query->row_array();
				break;
				default:
					return array('status'=>false, 'msg'=>NO_OPERATION);
			}
		}
	}